<?php
/**
 * @package     JLex Lookup
 * @version     1.0.0
 * @copyright   Copyright (C) 2013-2019 JLexArt Team (https://www.jlexart.com). All rights reserved.
 * @license     GNU General Public License version 2 or later
 * @author      JLexArt (support@jlexart.com)
 */

defined ( '_JEXEC' ) or die;

class JLexLookupModelTable extends JModelLegacy
{
    public $id = 0;

    public $offset = 0;

    public $limit = 20;

    public $total = 0;

    public $q = '';

    public $href = 0;

    public function getStructure()
    {
        $query = $this->_db->getQuery(true);
        $query->select('*')
              ->from('#__jlexlookup')
              ->where('id='.$this->_db->quote($this->id));

        $row = $this->_db->setQuery($query)->loadObject();

        if(!$row) return null;

        $params = new JRegistry();
        $params->loadString($row->params);
        $row->params = $params;

        $query->clear()
              ->select('*')
              ->from('#__jlexlookup_table t')
              ->where('t.table_id='.$this->_db->quote($this->id))
              ->order('t.ordering ASC');

        $row->columns = $this->_db->setQuery($query)->loadObjectList();

        if(!$row->columns) return null;

        //if(!preg_match('/^\s*$/', $this->q) || $this->href>0)
        {
            $query->clear()
                  ->select('SQL_CALC_FOUND_ROWS *')
                  ->from($this->_db->quoteName('#__jlexlookup_t_'.$row->table_name));

            if($this->href>0)
            {
                $query->where('id='.$this->_db->quote($this->href));
            } elseif(!preg_match('/^\s*$/', $this->q)) {
                $method = $row->params->get('method', 'absolute');

                $safe = $method=='relative'?$this->_db->quote('%'.$this->q.'%'):$this->_db->quote($this->q);
                $orClauses = array();

                foreach($row->columns as $column)
                {
                    if($column->search_input=='1')
                        $orClauses[]=$this->_db->quoteName('c'.$column->column_index).($method=='relative'?' LIKE ':'=').$safe;
                }

                if(empty($orClauses)){
                    $query->where('id=1');
                } else {
                    $query->where('('.implode(' OR ', $orClauses).')');
                }
            }

            $row->results = $this->_db->setQuery($query, $this->offset, $this->limit)->loadObjectList();

            $this->total = intval($this->_db->setQuery("SELECT FOUND_ROWS()")->loadResult());
        }

        return $row;
    }

    public function getPagination()
    {
        jimport ( 'joomla.html.pagination' );
        return new JPagination($this->total, $this->offset, $this->limit);
    }
}