function jgb($, loaders, config)
{
	var o=this,
		urlObj = window.URL||window.webkitURL;

	// language
	this.lang = {
		data:{},
		load:function(langs)
		{
			o.lang.data = langs;
		},
		get :function()
		{
			if(!arguments.length) return '';

			if(o.lang.data.hasOwnProperty(arguments[0]))
			{
				if(arguments.length==1)
				{
					return o.lang.data[arguments[0]];
				} else {
					var str = o.lang.data[arguments[0]];
					for(var i=1; i<=arguments.length; i++) {
						str = str.replace(/(\%s)/, arguments[i]);
					}
					return str;
				}
			}
			return arguments[0];
		}
	};

	// import language
	if(config.hasOwnProperty('lang')) o.lang.load(config.lang);

	this.dialog = function(options)
	{
		var _dialog = this,
			settings = 
			{
				caption 	: o.lang.get('dialog'),
				submitLabel : o.lang.get('submit'),
				cancelLabel : o.lang.get('cancel'),
				content 	: '',
				loadfn 		: null,
				submitfn 	: null,
				cancelfn 	: null
			};

		if (typeof options=='object') $.extend (settings, options);

		_dialog.init = function()
		{
			var html = '<div class="jgb-overlay">';
					html+= '<div class="jgb-dialog">';
						html+= '<div class="jgb-dg-caption">'+settings.caption+'</div>';
						html+= '<div class="jgb-dg-error"></div>';
						html+= '<div class="jgb-dg-content">'+settings.content+'</div>';
						html+= '<div class="jgb-dg-footer">';
							if (settings.submitLabel!==false)
							{
								html+= '<button class="jgb-dg-submit">'+settings.submitLabel+'</button>';
							}
							html+= '<button class="jgb-dg-cancel">'+settings.cancelLabel+'</button>';
						html+= '</div>';
					html+= '</div>';
				html+= '</div>';
			_dialog.el = $(html);
			_dialog.el.appendTo('body');

			// events
			if (typeof settings.loadfn=='function')
				settings.loadfn(_dialog);

			_dialog.el.on('click', '.jgb-dg-submit', function(){
				if(typeof settings.submitfn=='function')
					settings.submitfn(_dialog);
			});

			_dialog.el.on('click', '.jgb-dg-cancel', function(){
				if(typeof settings.cancelfn=='function')
				{
					var rn = settings.cancelfn(_dialog);
					if(rn!==false)
					{
						_dialog.off();
					}
				} else {
					_dialog.off();
				}
			});

			var resizeEvent = function()
			{
				if(!$('.jgb-dialog').length) return false;

				var widthOfScreen = $(window).width(),
					heightOfScreen = $(window).width();

				if (widthOfScreen<=450)
				{
					_dialog.el.find('.jgb-dialog')
								.removeClass('wide touch')
								.removeAttr('style')
								.addClass('touch');

					$('html,body').addClass('disableScroll');
				} else {
					_dialog.el.find('.jgb-dialog')
								.removeClass('wide touch')
								.removeAttr('style')
								.addClass('wide');

					var widthOfdialog = widthOfScreen > 650 ? 600 : (widthOfScreen-40),
						left = (widthOfScreen - widthOfdialog) / 2,
						maxHeight = heightOfScreen - 50 - 30; // 30 is top possition.

					_dialog.el.find('.jgb-dialog').css ({
						width: widthOfdialog + 'px',
						left : left + 'px',
						'max-height' : maxHeight + 'px'
					});

					$('html,body').removeClass('disableScroll');
				}
			}

			resizeEvent();
			$(window).resize (function(){
				resizeEvent ();
			});
		};

		_dialog.off = function ()
		{
			_dialog.el.off();
			_dialog.el.fadeOut('fast', function(){
				$(this).remove();
				$('html,body').removeClass('disableScroll');
			});
		};

		_dialog.setError = function(msg)
		{
			_dialog.el.find('.jgb-dg-error')
				.addClass('active').html(msg);
		};

		_dialog.clearError = function()
		{
			_dialog.el.find('.jgb-dg-error')
				.removeClass('active').html('');
		};

		_dialog.overlay = function()
		{
			if(!_dialog.el.find('.jgb-dg-overlay').length)
			{
				_dialog.el.find('.jgb-dg-content').append('<div class="jgb-dg-overlay"></div>');
				_dialog.el.find('button').attr('disabled', 'disabled');
			}
		};

		_dialog.unOverlay = function ()
		{
			_dialog.el.find('.jgb-dg-overlay').remove();
			_dialog.el.find('button').removeAttr('disabled');
		};

		_dialog.init();
	};

	this.login = function(){
		var nextUrl=encodeURIComponent(window.location.href)
		window.location=config.loginUrl+(/\?/.test(config.loginUrl)?'&':'?')+'next='+nextUrl;
	};

	this.flex = function(el){
		if(!$(el).length) return;
		
		var wd = $(el).width()<$(window).width()?$(el).width():$(window).width();

		if(wd>450){
			$(el).removeClass("jgb-xs");
		} else {
			$(el).addClass("jgb-xs");
		}

		$(window).resize(function(){
			o.flex(el);
		});
	};

	this.form = function(){
		// build form
		if(!$('#jgb-form').length) return;
		o.flex('#jgb-form');

		// library
		!function(a){a.fn.caret=function(a){var b=this[0],c=b&&"true"===b.contentEditable;if(0!=arguments.length){if(b){if(a==-1&&(a=this[c?"text":"val"]().length),window.getSelection)c?(b.focus(),window.getSelection().collapse(b.firstChild,a)):b.setSelectionRange(a,a);else if(document.body.createTextRange)if(c){var f=document.body.createTextRange();f.moveToElementText(b),f.moveStart("character",a),f.collapse(!0),f.select()}else{var f=b.createTextRange();f.move("character",a),f.select()}c||b.focus()}return this}if(b){if(window.getSelection){if(c){b.focus();var d=window.getSelection().getRangeAt(0),e=d.cloneRange();return e.selectNodeContents(b),e.setEnd(d.endContainer,d.endOffset),e.toString().length}return b.selectionStart}if(document.selection){if(b.focus(),c){var d=document.selection.createRange(),e=document.body.createTextRange();return e.moveToElementText(b),e.setEndPoint("EndToEnd",d),e.text.length}var a=0,f=b.createTextRange(),e=document.selection.createRange().duplicate(),g=e.getBookmark();for(f.moveToBookmark(g);0!==f.moveStart("character",-1);)a++;return a}if(b.selectionStart)return b.selectionStart}}}(jQuery);

		var f = $('#jgb-form form'),
			setMsg=function(msg, type, cb){
				f.find('.jgb-msg')
					.removeClass('err notice')
					.empty();

				if(type=='error') f.find('.jgb-msg').addClass('err');
				if(type=='notice') f.find('.jgb-msg').addClass('notice');

				f.find('.jgb-msg').text(msg);

				if(typeof cb=='function') cb();
			},
			data=config.hasOwnProperty('data')?config.data:{},
			mBusy=false;

		// form event
		var showfile=function(file, status)
		{
			var status=typeof status=='undefined'?'file_process':status,
				getExtension=function(name)
				{
					var result = name.match(/\.([A-z0-9]+)$/);
					if(result== null) return 'unknown';
					return result[1];
				},
				formatSize=function(size)
				{
					if(size>1000*1000*1000){
						size=parseInt(size/(1000*1000*1000)) + ' Gb';
					}else if(size>1000*1000){
						size=parseInt(size/(1000*1000)) + ' Mb';
					}else{
						size=parseInt(size/1000)+' Kb';
					}
					return size;
				},
				pv='<div class="jgb-media-preview" data-status="'+status+'">';
					pv+='<span class="jgb-hint">';
						if(file.hasOwnProperty('thumb'))
						{
							pv+='<img src="'+file.thumb+'">';
						} else {
							pv+='<span class="jgb-ext">'+(file.hasOwnProperty('name')?getExtension(file.name):file.ext)+'</span>';
						}
					pv+='</span>';
					pv+='<div class="jgb-info">';
						pv+='<div class="err"></div>';
						pv+='<div class="msg"></div>';

						// process box
						if(file.hasOwnProperty('name'))
						{
							pv+='<div class="jgb-process">';
								pv+='<span class="fn">'+file.name+'</span>';
								pv+=' - '+formatSize(file.size);
								pv+='<div class="a">';
									pv+= '<div class="b"></div>';
								pv+='</div>';
								pv+='<span class="c"><span class="d">0</span>/100%</span>';
							pv+='</div>';
						}

						pv+='<textarea disabled>'+(file.hasOwnProperty('name')?file.name:file.caption)+'</textarea>';
						// list task button
						pv+='<div class="btns">';
							pv+='<button type="button" data-cmd="stop">'+o.lang.get('stop')+'</button>';
							pv+='<button data-cmd="edit" type="button">'+o.lang.get('edit')+'</button>';
							pv+='<button data-cmd="rm" type="button">'+o.lang.get('remove')+'</button>';
							pv+='<button type="button" data-cmd="save">'+o.lang.get('save')+'</button>';
							pv+='<button type="button" data-cmd="cancel">'+o.lang.get('cancel')+'</button>';
						pv+='</div>';
					pv+='</div>';
					pv+='<input type="hidden" class="fileId" name="media_cid[]" value="'+(file.hasOwnProperty('id')?file.id:'')+'">';
				pv+='</div>';

			var $pv=$(pv); // convert to DOM
			$pv.on('click', '[data-cmd="rm"]', function(){
				$pv.off();
				$pv.remove();

				if(!f.find('.jgb-media-preview').length)
					f.find('.filebox').remove();
			})
			.on('click', '[data-cmd="edit"]', function (){
				$pv.find('textarea').removeAttr('disabled');
				$pv.find('textarea').focus();
				$pv.attr('data-status', 'editing');
			})
			.on('click', '[data-cmd="save"]', function(){
				$pv.find('.err, .msg').empty();

				var $c=$pv.find('textarea');
				if(/^(\s|\n|\t)*$/.test($c.val()))
				{
					$pv.find('.err').text(o.lang.get('caption_field_is_required'));
					$c.focus();
					return;
				}
				
				$.post(config.url, {option:'com_jlexguestbook', task:'media.update', caption:$c.val(), id:$pv.find('.fileId').val()}, function(d){
					if(d.status==400) $pv.find('.err').text(d.error);
					if(d.status==200)
					{
						$pv.find('.msg').text(d.msg);
						$pv.attr('data-status', 'done');
						$c.attr('disabled', 'disabled');

						setTimeout(function(){
							$pv.find('.msg,.err').empty();
						}, 5000);
					}
				}, 'json');
			})
			.on ('click', '[data-cmd="cancel"]', function(){
				$pv.find('textarea').attr('disabled', 'disabled');
				$pv.attr('data-status', 'done');
			});

			if(!f.find('.filebox').length)
			{
				f.find('.tools-open').append('<div class="fileboxCon"><div class="cap-mod">'+o.lang.get('post_list_file')+'</div><div class="filebox"></div></div>');
			}

			$pv.appendTo(f.find('.filebox'));

			return $pv;
		};

		var showCover=function(url, id)
		{
			var $h='<div class="cover">';
					$h+='<div class="cap-mod">'+o.lang.get('post_cover')+'</div>';
					$h+='<div class="covershow jgb-center" style="background-image:url('+url+')">';
						$h+='<div class="inn">';
							$h+='<div class="jgb-process">';
								$h+='<div class="a">';
									$h+= '<div class="b"></div>';
								$h+='</div>';
							$h+='</div>';
							$h+='<button type="button" data-cmd="rm">'+o.lang.get('remove')+'</button>';
							$h+='<button type="button" data-cmd="cancel">'+o.lang.get('cancel')+'</button>';
						$h+='</div>';
					$h+='</div>';
					$h+='<input type="hidden" name="cover" '+(typeof id!='undefined'?('value="'+id+'"'):'')+'>';
				$h+='</div>';

			$h=$($h);
			$h.on('click', '[data-cmd=rm]', function(){
				$h.fadeOut('fast', function(){
					$h.remove();
				});
			});

			$h.appendTo(f.find('.tools-open'));

			return $h;
		};

		f.on('click', '.btn-cover', function(){
			var $el = $('<input type="file">');

			$el.change(function(evt){
				if(!evt.target.files.length) return;

				var photo=evt.target.files[0],
					dt=new FormData();

				if(typeof FormData=='undefined'){
					// not support HTML 5
					return;
				}

				if($.inArray(photo.type, ['image/jpeg', 'image/png', 'image/jpg'])==-1){
					alert(o.lang.get('file_not_image'));
					return;
				}

				dt.append('file', photo);

				if(f.find('.cover').length)
				{
					var rs=confirm(o.lang.get('confirm_replace_cover'));
					if(!rs) return;
				}

				f.find('.cover').remove();

				var $h=showCover(urlObj.createObjectURL(photo));

				var xhr = $.ajax({
					url: config.url+'?option=com_jlexguestbook&task=media.upload',
					data: dt,
					processData: false,
					contentType: false,
					dataType: 'json',
					xhr: function() {
						var xhrobj = $.ajaxSettings.xhr();
						if(xhrobj.upload){
					        $h.attr('data-status', 'uploading');

					        xhrobj.upload.addEventListener('progress', function(event) {
					            var percent = 0;
					            var position = event.loaded || event.position;
					            var total = event.total;
					            if (event.lengthComputable) {
					                percent = Math.ceil(position / total * 100);
					            }

					            //progress
					            $h.find('.jgb-process .b').css('width',percent+'%');
					            $h.find('.jgb-process .d').text(percent);
					        }, false);
					    }
						return xhrobj;
					},
					type: 'POST',
					success: function(d){
						if (d.status==200) {
							$h.attr('data-status', 'done');
							$h.find('[name=cover]').val(d.id);
						} else {
							$h.attr('data-status', 'error');
							$h.find('[name=cover]').text(d.error);
						}
					}
				});

				$h.on('click','[data-cmd="cancel"]', function(){
					if (typeof xhr!='undefined') xhr.abort();
					$h.fadeOut('fast', function(){
						$(this).remove();
					});
				});
			});
			
			$el.trigger('click');
		})
		.on('click', '.btn-media', function(){
			var $el = $('<input type="file" multiple>');

			$el.change(function(evt){
				if(!evt.target.files.length) return;

				$.each(evt.target.files, function(k, file){
					var dt=new FormData(),
						params={
							name:file.name,
							size:file.size
						};

					if(typeof FormData=='undefined')
						return false;

					if($.inArray(file.type, ['image/jpeg', 'image/png', 'image/jpg'])!=-1){
						params.thumb = urlObj.createObjectURL(file);
					}
					
					var $pv=showfile(params);
					dt.append('file', file);

					var $xhr=null,
						$w=setInterval(function(){
							if(mBusy) return;
							mBusy=true;

							$xhr=$.ajax({
								url: config.url+'?option=com_jlexguestbook&task=media.upload',
								data: dt,
								processData: false,
								contentType: false,
								dataType: 'json',
								xhr: function() {
									var xhrobj = $.ajaxSettings.xhr();
									if(xhrobj.upload){
								        $pv.attr('data-status', 'uploading');

								        xhrobj.upload.addEventListener('progress', function(event) {
								            var percent = 0;
								            var position = event.loaded || event.position;
								            var total = event.total;
								            if (event.lengthComputable) {
								                percent = Math.ceil(position / total * 100);
								            }

								            //progress
								            $pv.find('.jgb-process .b').css('width',percent+'%');
								            $pv.find('.jgb-process .d').text(percent);
								        }, false);
								    }
									return xhrobj;
								},
								type: 'POST',
								success: function(d){
									if (d.status==200) {
										$pv.attr('data-status', 'done');
										$pv.find('.fileId').val(d.id);
									} else {
										$pv.attr('data-status', 'error');
										$pv.find('.err').text(d.error);
									}

									clearInterval($w);
									mBusy=false;
								}
							});
						}, 100);

					$pv.on('click','[data-cmd="stop"]', function(){
						if (typeof $xhr!=null) $xhr.abort();
						$pv.fadeOut('fast', function(){
							$(this).remove();
						});
					});
				});
			});
			
			$el.trigger('click');
		})
		.on('click', '.btn-poll', function(e, caption, options){
			if(!f.find('.poll-tab').length){
				var $h='<div class="poll-tab">';
						$h+='<div class="cap-mod">'+o.lang.get('post_poll')+'</div>';
						$h+='<input type="text" name="poll_caption" placeholder="'+o.lang.get('poll_caption')+'" '+(typeof caption!='undefined'?'value="'+caption+'"':'')+' style="font-weight:bold">';
						$h+='<div class="poll-cases"></div>';
						$h+='<button class="ins" type="button">'+o.lang.get('add_poll_option')+'</button>';
					$h+='</div>';

				$h=$($h);
				$h.on('click', '.ins', function(e, val){
					var $o='<div class="poll-item">';
							$o+='<input type="text" name="poll_items[]" '+(typeof val!='undefined'?'value="'+val+'"':'')+'>';
							$o+='<button type="button" class="rm"><i class="fas fa-minus"></i></button>';
						$o+='</div>';

					$h.find('.poll-cases').append($o);
					$h.find('.poll-cases input[type=text]:last').focus();
				})
				.on('click', '.rm', function(){
					$(this).parents('.poll-item').fadeOut('fast', function(){
						$(this).remove();
					});
				});

				$h.appendTo(f.find('.tools-open'));
				f.find('[name=inc_poll]').val('1');

				if(typeof options!='undefined')
				{
					$.each(options, function(k1, v1){
						$h.find('.ins').trigger('click', [v1.value]);
					});
				}
			} else {
				if(f.find('.poll-tab').hasClass('hide')){
					f.find('.poll-tab').find('input,button').removeAttr('disabled');
					f.find('[name=inc_poll]').val('1');
				} else {
					f.find('.poll-tab').find('input,button').attr('disabled','disabled');
					f.find('[name=inc_poll]').val('0');
				}
				f.find('.poll-tab').toggleClass('hide');
			}
		})
		.on('click', '.btn-cancel', function(){
			var returnUrl = config.url;
			if(!$.isEmptyObject(data) && data.hasOwnProperty('url'))
			{
				returnUrl = data.url;
			}

			window.location=returnUrl;
		})
		.on('click', '.jgb-terms', function(e){
			e.preventDefault();
			new o.dialog({
				caption : o.lang.get('terms'),
				content : o.lang.get('please_wait'),
				submitLabel: false,
				cancelLabel: 'Ok',
				loadfn: function(dialog){
					$.get(config.url, {option:'com_jlexguestbook', task:'user.terms'}, function(d){
						dialog.el.find('.jgb-dg-content').empty().append(d.content);
					}, 'json');
				}
			});
		});

		// format checkbox
		f.find('[type="checkbox"]').each(function(){
			var el = $(this),
				cOn = 'fa-check-square',
				cOff = 'fa-square',
				dEl = $('<i class="fck far '+(el.is(':checked')?cOn:cOff)+'"></i>');

				el.change(function(){
					if(el.is(':checked')) {
						dEl.addClass(cOn).removeClass(cOff);
					} else {
						dEl.addClass(cOff).removeClass(cOn);
					}
				});

				dEl.insertAfter(el);
				el.hide();
		});

		// textarea input
		var textbox=f.find('#jgb-desc');
		if(typeof textbox[0].contentEditable=='undefined')
		{
			// upgrade client browser
			alert(o.lang.get('upgrade_your_browser_msg'));
			return;
		}

		// focus textbox
		textbox.on('focus', function(){
			f.find('.textbox .jgb-hint').removeClass('active');
			$('#jgb-form').addClass('active');
		})
		.on('blur', function(){
			if($(this).html()=='')
			{
				f.find('.textbox .jgb-hint').addClass('active');
			}
		});

		f.on('click', '.jgb-hint', function(){
			textbox.trigger('focus');
		});

		var __pasteHtml = function(html){
		    var sel, range;
		    if (window.getSelection) {
		        // IE9 and non-IE
		        sel = window.getSelection();
		        if (sel.getRangeAt && sel.rangeCount) {
		            range = sel.getRangeAt(0);
		            range.deleteContents();

		            var el = document.createElement("div");
		            el.innerHTML = html;
		            var frag = document.createDocumentFragment(), node, lastNode;
		            while ( (node = el.firstChild) ) {
		                lastNode = frag.appendChild(node);
		            }
		            range.insertNode(frag);

		            // Preserve the selection
		            if (lastNode) {
		                range = range.cloneRange();
		                range.setStartAfter(lastNode);
		                range.collapse(true);
		                sel.removeAllRanges();
		                sel.addRange(range);
		            }
		        }
		    } else if (document.selection && document.selection.type != "Control") {
		        // IE < 9
		        document.selection.createRange().pasteHTML(html);
		    }
		},
		__lastChr = 0;

		textbox.on('paste', function(e){
			if (typeof window.clipboardData=='undefined')
			{
				e.stopPropagation();
				e.preventDefault();

				document.execCommand('insertHTML', false, e.originalEvent.clipboardData.getData('text').replace(/&/g, "&amp;")
					.replace(/</g, "&lt;")
					.replace(/>/g, "&gt;")
					.replace(/"/g, "&quot;")
					.replace(/'/g, "&#039;")
					.replace(/(?:\r\n|\r|\n)/g, '<br>')
					.replace(/\t/g, '&nbsp;&nbsp;&nbsp;&nbsp;'));
			} else {
				// ie disable access to clipboard
				var _content  = '',
					_input 	  = $(this),
					_textarea = document.createElement('textarea'),
					_caretPos = _input.caret();

				$(_textarea).attr("style", "width:1px;height:1px;overflow:hidden;opacity:0");
				$(_textarea).appendTo(form);
				$(_textarea).focus();

				window.setTimeout(function(){
					_content = $(_textarea).val();
					_content = _content.replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + '<br>' + '$2');
					$(_textarea).remove();

					_input.focus();
					if(_caretPos>0)
						_input.caret(_caretPos);
					
					__pasteHtml(_content);
				},100);
			}
		});

		var $tools=f.find('.jgb-text-fm'),
			editorFocus=false,
			getSelectedNode=function(){
				if(document.selection)
			        return document.selection.createRange().parentElement();
				
				var selection = window.getSelection();
		        if(selection.rangeCount>0)
		            return selection.getRangeAt(0).startContainer.parentNode;
			};

		textbox.on('focus blur', function(e){
			editorFocus=e.type=='focus';
		});

		window.setInterval(function(){
			if(!editorFocus) return;

			var $el=$(getSelectedNode());
			if(window.getSelection().toString()!=''){
				$tools.find('[data-tag=code],[data-tag=quote]')
					.removeAttr('disabled');
			} else {
				$tools.find('[data-tag=code],[data-tag=quote]')
					.attr('disabled', 'disabled');
			}

			// status
			var listCmd=['bold','italic','underline','strikeThrough'];
			$.each(listCmd, function(k,cmd){
				if(document.queryCommandState(cmd)){
					$tools.find('[data-tag='+cmd+']').addClass('active');
				} else {
					$tools.find('[data-tag='+cmd+']').removeClass('active');
				}
			});
		}, 500);

		$tools.on('click', '[data-tag]', function(e){
			e.preventDefault();
			var tag=$(this).attr('data-tag');
			switch(tag)
			{
				case 'quote':
				case 'code':
					document.execCommand("insertHTML", false, '<div data-tag="'+tag+'">'+document.getSelection().toString().replace(/&/g, "&amp;")
					.replace(/</g, "&lt;")
					.replace(/>/g, "&gt;")
					.replace(/"/g, "&quot;")
					.replace(/'/g, "&#039;")
					.replace(/\t/g, '&nbsp;&nbsp;&nbsp;&nbsp;')+'</div>');
					break;

				case 'img':
					var h='<div class="row">';
							h+='<div class="col-sm-8">';
								h+='<input type="text" data-name="url" placeholder="'+o.lang.get('img_url')+'">';
							h+='</div>';

							h+='<div class="col-sm-4">';
								h+='<span>'+o.lang.get('or')+'</span>';
								h+='<button>'+o.lang.get('upload')+'</button>';
							h+='</div>';
						h+='</div>';
						h+='<input type="text" data-name="caption" placeholder="'+o.lang.get('caption')+'">';

					new o.dialog({
						caption : o.lang.get('img'),
						content : h,
						submitLabel: o.lang.get('insert'),
						loadfn: function(dialog){
							dialog.el.find('[data-name=url]').focus();
						},
						submitfn: function(dialog){
							textbox.focus();
							pasteHtmlAtCaret('<b>HELLO</b>');
						}
					});
					break;

				default:
					document.execCommand(tag, false, null);
					if(window.getSelection().toString()=='')
						textbox.focus();
					break;
			}
		});
		// END - textarea

		// tags input
		if($('select[name="tags[]"]').length)
		{
			$('select[name="tags[]"]').select2({
				tags: true,
				minimumInputLength: 3,
				placeholder: o.lang.get('add_some_tag'),
				tokenSeparators: [',', ' '],
				ajax:{
					url:config.url+'?option=com_jlexguestbook&task=item.tags',
					dataType: 'json',
				},
				width:'100%'
			});
		}

		f.submit(function(e){
			e.preventDefault();
			var plainText=textbox.html()
					.replace(/(<([^>]+)>)/ig, "")
					.replace(/&nbsp;/g, "");
			f.find('[name=description]').val(textbox.html());

			if(f.find('[name=__term]').length && !f.find('[name=__term]:checked').length)
			{
				setMsg(o.lang.get('terms_err'), 'error');
				return false;
			}

			// validate
			if(/^(\s|\n|\t)*$/.test(plainText)){
				textbox.focus();
				setMsg(o.lang.get('fill_some_words'), 'error');
				return false;
			}

			// poll
			var n_polls = {caption:"", options:[]};

			if(f.find('.poll-tab:not(.hide)').length){
				if(/^\s*$/.test(f.find('[name=poll_caption]').val())){
					f.find('[name=poll_caption]').focus();
					setMsg(o.lang.get('poll_caption_is_missing'), 'error');
					return false;
				}

				n_polls.caption = f.find('[name=poll_caption]').val();

				if(f.find('[name="poll_items[]"]').length<2)
				{
					setMsg(o.lang.get('poll_add_option_msg'), 'error');
					return false;
				}

				var poll_err=false;
				f.find('[name="poll_items[]"]').each(function(){
					if(/^\s*$/.test($(this).val())) {
						$(this).focus();
						setMsg(o.lang.get('poll_option_content_is_missing'), 'error');
						poll_err=true;
						return false;
					}

					n_polls.options.push($(this).val());
				});

				if(poll_err) return false;
			}

			// compare polls old & new
			if(data.hasOwnProperty('polls'))
			{
				var o_polls = {
						caption:data.poll_caption,
						options:[]
					},
					poll_change = 0;

				$.each(data.polls.options, function(k1, v1){
					o_polls.options.push(v1.value);
				});

				if(o_polls.caption!==n_polls.caption || o_polls.options.length!=n_polls.options.length) poll_change=1;

				if(!poll_change)
				{
					$.each(n_polls.options, function(k1, v1){
						if($.inArray(v1, o_polls.options)==-1) poll_change=1;
					});
				}

				f.find('[name=poll_change]').val(poll_change);
			}

			// media & cover
			if(f.find('[data-status=uploading]').length){
				setMsg(o.lang.get('media_are_uploading'), 'error');
				return false;
			}
			
			var dataString = $(this).serialize();

			f.find('.jgb-overlay').show();
			f.find('.btn-submit i').removeClass('fa-check')
						.addClass('fa-spinner fa-spin');
			f.find('.btn-submit, .btn-cancel').attr('disabled', 'disabled');

			$.post(config.url, dataString, function(d){
				f.find('.jgb-overlay').hide();
				f.find('.btn-submit i')
						.removeClass('fa-spinner fa-spin')
						.addClass('fa-check');

				if(d.status==400){
					f.find('.btn-submit, .btn-cancel').removeAttr('disabled');
					setMsg(d.error, 'error');
				} else {
					setMsg(o.lang.get('item_saved'), 'msg', function(){
						setTimeout(function(){
							window.location=d.url;
						}, 2000);
					});
				}
			}, 'json');
		});

		if(!$.isEmptyObject(data))
		{
			// edit item
			var listInput=['id', 'guest_name', 'guest_email'];
			$.each(listInput, function(k,v){
				f.find('[name='+v+']').val(data[v]);
			});

			f.addClass('edit');
			textbox.html(data.description);
			textbox.focus();

			if(data.draft==1)
			{
				f.find('[name=draft]')
					.prop('checked', true)
					.trigger('change');
			}

			if(data.cover>0)
			{
				showCover(data.cover_url, data.cover);
			}

			if(data.inc_poll==1)
			{
				f.find('.btn-poll').trigger('click', [data.poll_caption, data.polls.options]);
			}

			if(data.inc_media==1)
			{
				if(data.media.images.length>0)
				{
					$.each(data.media.images, function(k,file){
						showfile(file, 'done');
					});
				}

				if(data.media.files.length>0)
				{
					$.each(data.media.files, function(k,file){
						showfile(file, 'done');
					});
				}
			}

			if(data.inc_tag==1 && $('select[name="tags[]"]').length)
			{
				$.each(data.tags, function(t1, v1){
					$('select[name="tags[]"]').append('<option value="'+v1.name+'" selected>'+v1.name+'</option>');
				});

				$('select[name="tags[]"]').trigger('change');
			}
		}

		// social login
		f.on('click', '.jgb-social-btn', function(){
			var type 	= $(this).attr('data-type'),
				url 	= config.url+'?option=com_jlexguestbook&task=user.oauth&type='+type,
				name 	= 'jgb_socl_'+type;

			switch(type)
			{
				case 'fb':
				case 'google':
				case 'twitter':
					url+='&popup=1';
					break;
			}

			window.open(url, name, "width=500, height=350");
		});

		// captcha
		if($('#jgb-form .g-recaptcha').length)
		{
			$.getScript('https://www.google.com/recaptcha/api.js?onload=jgbCaptcha&render=explicit&hl=en-GB');
			
			window.jgbCaptcha=function($f){
				if(typeof grecaptcha=='undefined') return;
				let $c=$('#jgb-form .g-recaptcha');

				grecaptcha.render($c[0], {"sitekey":$c.attr("data-sitekey"), "theme":$c.attr("data-theme")});
			};
		}
	};

	this.list = function(){
		if(!$('#jgb-timeline .__ls').length) return;

		// plugin
		$.fn.isInViewport = function() {
		    var eTop=$(this).offset().top,
		    	eBottom=eTop+$(this).outerHeight(),
				vpTop=$(window).scrollTop(),
		    	vpBottom=vpTop+$(window).height();

		    return eBottom>vpTop && eTop<vpBottom;
		};

		var $b=$('#jgb-timeline'),
			offset=0, more=false, bs=false, mustload=0, tx=config.t;

		var	ls=function(callback, hl)
		{
			if(bs) return;
			bs = true;

			var f=$.isEmptyObject(config.filter)?{}:config.filter;

			f.option='com_jlexguestbook';
			f.task='list.load';
			f.t=tx;
			f.offset=offset;

			$b.find('.__status').removeClass('hide');

			$.post(config.url, f, function(r){
				bs=false;

				if(offset==0)
					$b.find('.__ls').empty();

				if(r.status==200){
					if(offset==0 && r[config.j].more==true)
					{
						$b.find('.__page button.more').removeClass('hide');
					}

					$b.find('.__ls').append(r[config.j].html);
					offset=r[config.j].offset;
					more=r[config.j].more;

					if(!more)
					{
						bs=true;
						$b.find('.__page button.more').addClass('hide');
					}
				}

				$b.find('.__status').addClass('hide');
				if(typeof callback=='function')
					callback();

				if(typeof hl=='string' && /^item-[1-9][0-9]*$/.test(hl) && $b.find('.jgb-item').length<mustload)
				{
					if($('#'+hl).length){
						$("html, body").animate({scrollTop:$('#'+hl).offset().top}, 500);
					} else {
						ls(callback, hl);
					}
				}
			}, 'json');
		}

		o.flex('#jgb-timeline');

		$b.on('click', '.__page button.more', function(){
			if(!more) return;

			var $btn=$(this);
				$btn.attr('disabled', 'disabled');

			$btn.find('i')
				.removeClass('fa-arrow-down')
				.addClass('fa-spinner fa-spin');

			ls(function(){
				$btn.removeAttr('disabled');
				$btn.find('i')
					.addClass('fa-arrow-down')
					.removeClass('fa-spinner fa-spin');
			});
		});

		setInterval(function(){
			if(!$('.jgb-poll-json').length) return;
			$('.jgb-poll-json').each(function(){
				try {
					var js=JSON.parse($(this).html()), h='',
						__t=0;
					
					h='<div class="jgb-ipoll jgb-cell">';
						h+='<div class="jgb-strong">'+js.caption+'</div>';
						$.each(js.options, function(k,v){
							__t+=v.count*1;
						});
						h+='<div class="jgb-table" style="max-width:350px;">';
						$.each(js.options, function(k1,v1){
							var __pc=__t>0?(v1.count*100/__t):0;
							h+='<div class="jgb-table-row jgb-ipoll-o">';
								h+='<div class="jgb-table-cell a">'+v1.value+'</div>';
								h+='<div class="jgb-table-cell"><div class="b">';
									h+='<div class="c" style="width:'+__pc+'%"></div>';
								h+='</div></div>';
							h+='</div>';
						});
						h+='</div>';
					h+='</div>';

					$(this).replaceWith(h);
				} catch(err){}
			});
		}, 500);

		// load more when scroll to end
		$(document).scroll(function(){
			$('.jgb-item-cover.__move').not('.__animate').each(function(){
				if($(this).isInViewport())
				{
					var tm=10*$(this).attr('data-ratio')/100;
					$(this)
						.css('animation-duration', tm+'s')
						.addClass('__animate');
				}
			});

			if($('.jgb-item').length && $('.jgb-item:last').isInViewport())
			{
				ls();
			}
		});

		// assign tag for tag page
		if(config.hasOwnProperty('filter'))
		{
			if(config.filter.hasOwnProperty('tag_alias') && typeof $.fn.select2=='function')
			{
				$('select[name="tags[]"]').append('<option value="'+config.filter.tag_alias+'" selected>'+config.filter.tag_alias+'</option>');
				$('select[name="tags[]"]').trigger('change');
			}
		}

		$b.find('.__ls').on('click', '.jgb-item', function(e){
			window.location.hash=[config.t, $(this).attr('id'), $b.find('.__ls .jgb-item').index($(this))].join('|');
		});

		// check hash
		var state = window.location.hash.replace('#','').split('|'),
			loaded = false;
		if(state.length==3 && /^[1-9][0-9]+$/.test(state[0]) && /^[0-9]+$/.test(state[2]) && state[2]<200)
		{
			tx = state[0];
			mustload = state[2]+5;
			ls(null, state[1]);
			loaded = true;
		}

		if(!loaded) ls();

		// findbox
		if($b.find('.__findbox').length)
		{
			var $fbox=$b.find('.__findbox form'),
				ps=window.location.search.substr(1).split('&');
			$.each(ps, function(k2, v2){
				var psAttr=v2.split('=');
				if(psAttr.length!=2) return;

				if(psAttr[0]!='q'){
					$fbox.append('<input type="hidden" name="'+psAttr[0]+'" value="'+psAttr[1]+'">');
				}
			});
		}

		// follow tag
		$b.find('.jgb-tag-follow-btn').each(function(){
			var $el=$(this),
				_uid=$el.attr('data-uid')*1,
				_id=$el.attr('data-id')*1,
				_s=$el.attr('data-status')*1,
				_tm=null;

			var $btn = $('<button class="jgbTagFollowBtn '+(_s>0?'on':'')+'">'+o.lang.get(_s>0?'unfollow':'follow')+'</button>');
			
			$btn.click(function(){
				if(!_uid){
					alert(o.lang.get('login_required_msg'));
					return;
				}

				_s=_s>0?0:1;
				$btn.text(o.lang.get(_s>0?'unfollow':'follow'));
				$btn.toggleClass('on');

				if(_tm!=null) clearTimeout(_tm);
				_tm=setTimeout(function(){
					$.post(config.url, {option:'com_jlexguestbook', task:'alert.followTag', id:_id, s:_s}, function(d){
						if(d.status==400){
							alert(d.error);
						}

						if(d.status==403){
							alert(o.lang.get('login_required_msg'));
						}
					}, 'json');
				}, 500);
			});

			$el.replaceWith($btn);
		});
	};

	this.item = function(){
		if($(".jgb-item-slider").length && typeof lightGallery!="undefined")
		{
			lightGallery($(".jgb-item-slider")[0], {
			    subHtmlSelectorRelative: true
			});  
		}

		if($(".jgb-item-tags>li").length>3)
		{
			var $tagEl=$('<li class=""><span class="more-tag"><i class="fas fa-plus-circle"></i></span></li>');
			$tagEl.appendTo($(".jgb-item-tags"));
			
			var $tags = $(".jgb-item-tags>li").not($tagEl).slice(3);
			$tags.hide();

			$tagEl.click(function(){
				if(!$(this).hasClass('active')){
					$(this).find('i')
						.removeClass('fa-plus-circle')
						.addClass('fa-minus-circle');

					$tags.show();
				} else {
					$(this).find('i')
						.removeClass('fa-minus-circle')
						.addClass('fa-plus-circle');

					$tags.hide();
				}

				$(this).toggleClass('active');
			});
		}

		if($(".jgb-item-polls").length)
		{
			var $p=$(".jgb-item-polls"),
				sl=$p.attr("data-self"),
				show=function(){
					var total=0;
					$p.find('.jpoll').each(function(){
						total+=parseInt($(this).attr('data-count'));
					});

					if(total>0)
					{
						$p.find('.jpoll').each(function(){
							var count=parseInt($(this).attr('data-count')),
								pc=count*100/total;

							$(this).find('.c').css('width', pc+'%');
							$(this).find('.r').text(count+' ('+pc.toFixed(1)+'%)');
						});
					}
					
					$p.find('.jpoll .r').removeClass('hide');
					if(/^[1-9][0-9]*$/.test(sl))
					{
						$p.find('.jpoll[data-id='+sl+']').addClass('active');
					}
				};

			if(/^[1-9][0-9]*$/.test(sl))
			{
				// just show result
				show();
			} else {
				// allow vote
				var canVote=true;
				if($p.find('.a').hasClass('jgb-login-act') || $p.find('.a').is(':disabled') )
				{
					canVote=false;
				}
				
				$p.on('click', '.jpoll', function(){
					if(!canVote) return;
					$p.find('.jpoll').not($(this)).removeClass('active');
					$(this).toggleClass('active');

					if($(this).hasClass('active')){
						$p.find('.a').removeAttr('disabled');
					} else {
						$p.find('.a').attr('disabled', 'disabled');
					}
				});

				$p.on('click', '.a', function(){
					var $c=$p.find('.jpoll.active');
					if(!$c.length) return;

					sl=$c.attr('data-id');
					$c.attr('data-count', $c.attr('data-count')+1);
					$(this).attr('disabled', 'disabled');
					canVote=false;
					show();

					$.post(config.url, {option:'com_jlexguestbook', task:'item.poll', id:config.item_id, s:sl}, function(d){
						if(d.status==400){
							alert(d.error);
						}
					}, 'json');
				});
			}

			if(!$p.find('.a').hasClass('jgb-login-act'))
				$p.find('.a').attr('disabled', 'disabled');

			$p.on('click', 'button.b', function(){
				show();
			});
		}

		if($(".fwl").length)
		{
			var $el=$(".fwl"),
				$act=null;

			var wlShow=function(){
				var c=$el.attr("data-count")*1,
					m=$el.attr("data-self")==1?1:0,
					tx="";

				if(m>0){
					$el.addClass("active");
					c-=1;
					tx=o.lang.get('you');
					if(c>0) tx+="+"+c;
				} else {
					if(c>0) tx=c;
				}

				$el.find("span").text(tx);
			};

			$el.click(function(e){
				e.preventDefault();
				var isOn=1;

				$el.toggleClass("active");
				isOn=$el.hasClass("active")?1:0;

				$el.attr("data-count", $el.attr("data-count")*1+(isOn?1:-1));
				$el.attr("data-self", isOn);

				wlShow();
				
				if($act!=null) clearTimeout($act);
				$act=setTimeout(function(){
					$.post(config.url, {option:'com_jlexguestbook', task:'item.wishlist', id:config.item_id, on:isOn}, function(d){
						if(d.status==400){
							alert(d.error);
						}
					}, 'json');
				}, 500);
			});

			wlShow();
		}

		// Off draft version
		$(".draftOff").click(function(e){
			e.preventDefault();
			var $el=$(this);
			if($el.hasClass("disabled")) return;

			$el.addClass("disabled");
			$el.text(o.lang.get("please_wait"));

			$.post(config.url, {option:'com_jlexguestbook', task:'item.draftOff', id:config.item_id}, function(d){
				if(d.status==400){
					alert(d.error);
				} else {
					location.reload();
				}
			}, 'json');
		});

		// report
		$(".frp").click(function(e){
			e.preventDefault();
			var $el=$(this),
				opts=['content_incorrect', 'content_contain_inappr_word', 'content_duplicate', 'spam', 'other'];
				
			var	$h='<div id="jgb-report-form">';
					$.each(opts, function(k,v){
						$h+='<label>';
							$h+='<input type="radio" name="report" value="'+(k+1)+'">';
							$h+='<span>'+o.lang.get(v)+'</span>';
						$h+='</label>';
					});

					$h+='<textarea class="hide"></textarea>';
				$h+='</div>';

			// show dialog
			o.dialog({
				caption:o.lang.get('report_board'),
				submitLabel:o.lang.get('report'),
				cancelLabel:o.lang.get('cancel'),
				content:$h,
				loadfn: function(dialog)
				{
					dialog.el.on('change', 'input[type=radio]', function(){
						if($(this).val()=='5')
						{
							dialog.el.find('textarea')
								.removeClass('hide')
								.focus();
						} else {
							dialog.el.find('textarea').addClass('hide');
						}
					})
					.on('click', 'a.off-report', function(e){
						e.preventDefault();
						dialog.overlay();
						$.post(config.url, {option:'com_jlexguestbook', task:'report.ignore', id:config.item_id}, function(d){
							dialog.unOverlay();
							dialog.off();
							$('.frp').removeClass('active');
						}, 'json');
					});

					dialog.overlay();
					dialog.el.find('.jgb-dg-submit').hide();

					$.post(config.url, {option:'com_jlexguestbook', task:'report.check', id:config.item_id}, function(d){
						if(d.status==400){
							dialog.off();
							alert(d.error);
						} else {
							dialog.unOverlay();
							if(d.is_report==1)
							{
								dialog.el.find('[name=report][value='+d.data.opt_id+']').prop('checked', true);
								if(d.data.opt_id==5)
								{
									dialog.el.find('textarea')
											.val(d.data.message)
											.removeClass('hide')
											.focus();
								}

								dialog.el.find('#jgb-report-form').append('<div style="margin-top:5px">'+o.lang.get('confirm_to_cancel_report', '<a class="off-report" href="#">', '</a>')+'</div>');
								dialog.el.find('input, textarea').attr('disabled', 'disabled');
								dialog.el.find('.jgb-dg-submit').remove();
								dialog.el.find('.jgb-dg-cancel').text('Ok');
							} else {
								dialog.el.find('.jgb-dg-submit').show();
							}
						}
					}, 'json');
				},
				submitfn: function(dialog){
					if(!dialog.el.find('input[type=radio]:checked').length)
					{
						dialog.setError(o.lang.get('must_choose_report_opt'));
						return;
					}

					var $s=dialog.el.find('input[type=radio]:checked');
					if($s.val()=='5' && /^\s*$/.test(dialog.el.find('textarea').val()))
					{
						dialog.el.find('textarea').focus();
						return;
					}

					dialog.overlay();
					$.post(config.url, {option:'com_jlexguestbook', task:'report.add', id:config.item_id, opt:$s.val(), msg:dialog.el.find('textarea').val()}, function(d){
						dialog.unOverlay();
						if(d.status==400){
							dialog.setError(d.error);
						} else {
							dialog.el.find('.jgb-dg-content').empty().append('<p>'+d.msg+'</p>');
							dialog.el.find('.jgb-dg-submit').remove();
							dialog.el.find('.jgb-dg-cancel').text('Ok');
							$('.frp').addClass('active');
						}
					}, 'json');
				}
			});
		});

		// delete an item
		$(".fdl").click(function(e){
			e.preventDefault();
			o.dialog({
				caption: '<i class="fas fa-exclamation-circle"></i> '+o.lang.get('warning'),
				submitLabel: o.lang.get('delete'),
				cancelLabel: o.lang.get('cancel'),
				content: '<div class="jgb-confirm-text">'+o.lang.get('warning_delete_article_msg')+'</div>',
				submitfn: function(dialog)
				{
					dialog.overlay();
					$.post(config.url, {option:'com_jlexguestbook', task:'item.delete', id:config.item_id}, function(d){
						dialog.unOverlay();
						
						if(d.status==400){
							dialog.setError(d.error);
							return;
						} else {
							dialog.el.find('.jgb-dg-content').empty().append('<p>'+d.msg+'</p>');
							dialog.el.find('.jgb-dg-submit').remove();
							dialog.el.find('.jgb-dg-cancel').text('Ok');

							setTimeout(function(){
								window.location=config.url.replace(/index\.php$/, '');
							}, 3000);
						}
					}, 'json');
				}
			});
		});

		// load comment
		if(config.loadCm)
		{
			var cmVars = {
					option:'com_jlexguestbook',
					task:'cm.load',
					uid:0,
					id:config.item_id,
					offset:0,
					sort:'',
					t:config.t,
				};

			window.jgbCmCaptcha=function($f){
				if(typeof grecaptcha=='undefined') return;
				if(typeof $f=='undefined') $f=$('#jgbCmForm .g-recaptcha');
				if(!$f.length) return;

				grecaptcha.render($f[0], {"sitekey":$f.attr("data-sitekey"), "theme":$f.attr("data-theme")});
			};

			var cmFn = function(){
				$('#jgbCmForm').find('[name=item_id]').val(config.item_id);

				$('#jgbComment').on('click', 'a[data-cmd]', function(e){
					e.preventDefault();

					var $el=$(this),
						cmid=$el.attr('data-id'),
						cmd=$el.attr('data-cmd'),
						cmbox=$('#jgbComment #cm-'+cmid);

					switch(cmd)
					{
						case 'reply':
							if(cmbox.find('.f').length)
							{
								cmbox.find('.f').toggle();
							} else {
								var nf=$('#jgbCmForm').clone();
								nf.find('[name=parent_id]').val(cmid);
								nf.removeAttr('id');
								nf.appendTo(cmbox.find('.jgb-cm-body'));
								nf.find('[name=comment]').val('').focus();

								if(nf.find('.g-recaptcha').length)
								{
									nf.find('.g-recaptcha').empty();
									jgbCmCaptcha(nf.find('.g-recaptcha'));
								}
							}
							break;

						case 'edit':
							if($el.hasClass('disabled')) return;
							if($el.hasClass('active'))
							{
								cmbox.find('.f').remove();
								return;
							}

							$el.addClass('disabled');
							cmbox.find('.f').remove();

							$.post(config.url, {option:'com_jlexguestbook', task:'cm.loadCm', id:cmid, 'o':1, t:new Date().getTime()}, function(d){
								if(d.status==400)
								{
									$el.removeClass('disabled');
									alert(d.error);
									return;
								}

								$el.addClass('active');
								var nf=$('#jgbCmForm').clone();
								nf.find('[name=parent_id]').val(cmid);
								nf.removeAttr('id');
								nf.appendTo(cmbox.find('.jgb-cm-body'));

								var cms={
									guest_name:d.data.screen_name,
									guest_email:d.data.screen_email,
									parent_id:d.data.pid,
									id:d.data.id,
									comment:d.data.comment
								};
								
								$.each(cms, function(k2, v2){
									nf.find('[name='+k2+']').val(v2).focus();
								});

								if(nf.find('.g-recaptcha').length)
								{
									nf.find('.g-recaptcha').empty();
									jgbCmCaptcha(nf.find('.g-recaptcha'));
								}
							}, 'json');
							break;

						case 'share':
							var cmUrl=window.location.href.replace(location.hash, '');
								cmUrl+='#cm-'+cmid;

							o.dialog({
								caption: o.lang.get('share'),
								content: '<p class="jgb-large">'+o.lang.get('copy_link_to_share')+'</p><input type="text" onclick="this.select()" value="'+cmUrl+'">',
								submitLabel: false,
								cancelLabel: 'Ok'
							});
							break;

						case 'see':
							if($el.hasClass('disabled')) return;

							$el.addClass('disabled');
							$.get(config.url, {option:'com_jlexguestbook', task:'cm.loadCm', id:cmid, t:config.t}, function(d){
								if(d.status==400)
								{
									alert(d.error);
									return;
								}

								var h='<div class="jgb-see-cm">';
										h+='<div class="__m">';
											h+='<span class="__a">'+d.data.screen_name+'</span>';
											h+='<span class="__d">'+d.data.created_time+'</span>';
										h+='</div>';
										h+='<div class="__c">';
											if(d.data.pid>0)
											{
												h+='<a data-cmd="see" data-id="'+d.data.pid+'">@'+d.data.p_screen_name+'</a>' ;
											}
											h+=d.data.comment;
										h+='</div>';
									h+='</div>';

								$(h).insertBefore($el);
							}, 'json');
							break;

						case 'delete':
							o.dialog({
								caption: o.lang.get('warning'),
								content: '<p class="jgb-large">'+o.lang.get('confirm_rm_comment')+'</p>',
								submitLabel: o.lang.get('delete'),
								cancelLabel: o.lang.get('cancel'),
								submitfn: function(dialog){
									dialog.overlay();
									$.post(config.url, {option:'com_jlexguestbook', task:'cm.remove', id:cmid}, function(d){
										dialog.unOverlay();
										switch(d.status)
										{
											case 400:
												dialog.setError(d.error);
												break;

											case 200:
												dialog.el.find('.jgb-dg-content').empty().append('<span>'+d.msg+'</span>');
												dialog.el.find('.jgb-dg-submit').remove();
												dialog.el.find('.jgb-dg-cancel').text('Ok');

												$('#cm-'+cmid).remove();
												break;

										}
									}, 'json');
								}
							});
							break;
					}
				})
				.on('submit', '.f form', function(e){
					e.preventDefault();
					var $fCm=$(this),
						cmId=$fCm.find('[name=id]').val();
						pCmid=$fCm.find('[name=parent_id]').val();
					$fCm.find('.jgb-form-overlay').show();
					
					$.post(config.url, $fCm.serialize(), function(d){
						$fCm.find('.jgb-form-overlay').hide();
						if(d.status==400)
						{
							alert(d.error);
							if(typeof grecaptcha!='undefined')
								grecaptcha.reset();
							return;
						}

						if(/^[1-9][0-9]*$/.test(pCmid)){
							$fCm.parents('.f').remove();
						} else {
							$fCm.find('[name=comment]').val('');
						}

						if(/^[1-9][0-9]*$/.test(cmId)){
							// edit
							$('#cm-'+cmId).remove();
						}

						$('#jgbComment .ls').prepend(d.html);
						$("html, body").animate({scrollTop:$('#cm-'+d.id).offset().top}, 500);

						if(typeof grecaptcha!='undefined')
							grecaptcha.reset();
					}, 'json');
				});

				// captcha
				if($('#jgbCmForm .g-recaptcha').length)
				{
					$.getScript('https://www.google.com/recaptcha/api.js?onload=jgbCmCaptcha&render=explicit&hl=en-GB');
				}
			};

			var	ls=function(cb)
			{
				$.post(config.url, cmVars, function(r){
					if(r.status!=200)
					{
						alert(r.error);
						return;
					}

					if(cmVars.offset==0)
					{
						$('.jgb-item-comments').append(r.data.html);
						cmFn();
					} else {
						$('#jgbComment .ls').append(r.data.html);
					}

					cmVars.offset=r.data.offset;
					if(r.data.more)
					{
						$('#jgbComment .mr').removeClass('hide');
					} else {
						$('#jgbComment .mr').addClass('hide');
					}

					if(typeof cb=='function') cb();
				}, 'json');
			}

			// hl
			var cmHash=location.hash;
			if(/^\#cm-([1-9][0-9]*)$/.test(location.hash))
			{
				cmVars['hl']=location.hash.replace('#cm-', '');
			}

			ls(function(){
				$('#jgbComment .mr').click(function(e){
					e.preventDefault();
					$(this).attr('disabled', 'disabled');

					ls(function(){
						$('#jgbComment .mr').removeAttr('disabled');
					});
				});

				if(cmVars.hasOwnProperty('hl'))
				{
					if($('#cm-'+cmVars.hl).length)
					{
						$('#cm-'+cmVars.hl).addClass('hl');
						$("html, body").animate({scrollTop:$('#cm-'+cmVars.hl).offset().top}, 500);

						setTimeout(function(){
							$('#jgbComment .cm.hl').removeClass('hl');
						}, 3000);
					}

					delete cmVars.hl;
				}
			});
		}
	};

	this.user = function(){
		if(!config.hasOwnProperty('isOwner')) return;
		var $th = $('#jgb-timeline .__obj.__user a.tb'),
			$at = $('<span class="jgb-center"><i class="fas fa-user-edit"></i></span>');

		$at.click(function(e){
			e.preventDefault();

			if(!$th.parent().find('.thumb-act').length){
				var $act='<ul class="thumb-act">';
						$act+='<li><a class="a1">'+o.lang.get('change_thumb')+'</a></li>';
						$act+='<li class="rm"><a class="a2">'+o.lang.get('rm_thumb')+'</a></li>';
						$act+='<li><a class="a3">'+o.lang.get('cancel')+'</a></li>';
					$act+='</ul>';

				$act=$($act);

				$act
				.on('click', '.a1', function(e){
					e.preventDefault();

					var $el = $('<input type="file">');

					$el.on('change', function(){
						var cropData = {};
						var f=$(this)[0].files[0];
 						var imgTypes = ['image/png','image/jpeg','image/jpg','image/gif'];

						if($.inArray(f.type, imgTypes)==-1)
						{
							alert(o.lang.get('file_not_image'));
							return;
						}

						// assign file.
						var imgSrc=urlObj.createObjectURL(f);

						o.dialog({
							caption:o.lang.get('user_thumb_edit'),
							submitLabel:o.lang.get('save'),
							cancelLabel:o.lang.get('cancel'),
							content:'<p>'+o.lang.get('crop_img_msg')+'</p><img class="__thumb" src="'+imgSrc+'">',
							loadfn:function(dialog){
								dialog.el.find('img.__thumb').cropper({
										aspectRatio: 1,
										rotatable: false,
										scalable: false,
										minCropBoxWidth : 200,
										minCropBoxHeight : 200,
									crop: function(e) {
										cropData.x = e.x;
										cropData.y = e.y;
										cropData.w = e.width;
										cropData.h = e.height;
									}
								});
							},
							submitfn:function(dialog){
								var iDt = new FormData();
								
								iDt.append('option', 'com_jlexguestbook');
								iDt.append('task', 'user.thumb');
								iDt.append('action', 'upload');

								iDt.append('file', f);
								iDt.append('x', cropData.x);
								iDt.append('y', cropData.y);
								iDt.append('w', cropData.w);
								iDt.append('h', cropData.h);

								dialog.overlay();

								$.ajax({
									url:config.url,
									type: "POST",
									dataType: "json",
									data: iDt,
									xhr: function() {
										var xhrobj = $.ajaxSettings.xhr();
										return xhrobj;
									},
									success: function(r) {
										dialog.unOverlay();
										switch(r.status)
										{
											case 403:
												location.reload();
												break;

											case 200:
												dialog.off();
												window.location.reload();
												break;

											case 400:
												dialog.setError(r.error);
												break;
										}
									},
									error: function (xhr, ajaxOptions, thrownError) {
										dialog.unOverlay();
								    },
									cache: false,
									contentType: false,
									processData: false
								});
							}
						});
					});

					$el.trigger('click');
				})
				.on('click', '.a2', function(e){
					o.dialog({
						caption: o.lang.get('notice'),
						content: '<p class="jgb-large">'+o.lang.get('confirm_rm_user_thumb')+'</p>',
						submitLabel: o.lang.get('delete'),
						cancelLabel: o.lang.get('cancel'),
						submitfn: function(dialog){
							dialog.overlay();
							$.post(config.url, {option:'com_jlexguestbook', task:'user.thumb', action:'remove'}, function(d){
								switch(d.status)
								{
									case 400:
									dialog.unOverlay();
									dialog.setError(d.error);
										window.location.reload();
										break;

									case 200:
									case 403:
										window.location.reload();
										break;

								}
							}, 'json');
						}
					});
				})
				.on('click', '.a3', function(e){
					e.preventDefault();
					$act.addClass('hide');
				});

				$act.appendTo($th.parent());
			} else {
				$th.parent().find('.thumb-act').toggleClass('hide');
			}
		});

		$th.removeAttr("href");
		$at.appendTo($th);
	};

	$.each(loaders, function(k, loader){
		if(o.hasOwnProperty(loader))
			o[loader]();
	});

	// basic
	if(loaders.length)
	{
		if(typeof $.fn.tooltip=='function')
		{
			setInterval(function(){
				if(!$('.jgb-tooltip').not('.x1').length) return;
				$('.jgb-tooltip')
					.not('.x1').addClass('x1')
					.tooltip();
			}, 500);
		};

		$(document).on('click', '.jgb-login-act', function(e){
			e.preventDefault();
			o.login();
		});
	}

	// notifications
	if(config.uid>0 && config.alert==1)
	{
		$.post(config.url, {option:'com_jlexguestbook', task:'alert.checkin', t:new Date().getTime()}, function(d){
			if(d.status==200 && d.alert==1){
				$('.jgb-alert-icon')
					.addClass('on');
			}
		}, 'json');

		$(document).on('click', '.jgb-alert-icon', function(e){
			e.preventDefault();

			var $h='<div id="jgb-alert">';
					$h+='<ul class="__a">';
						$h+='<li><a href="#" data-value="other">'+o.lang.get('alert_cm_reply_part')+'</a></li>';
						$h+='<li><a href="#" data-value="tag">'+o.lang.get('alert_tag_part')+'</a></li>';
					$h+='</ul>';

					$h+='<div class="__c">';
						$h+='<div data-id="other"></div>';
						$h+='<div data-id="tag"></div>';
					$h+='</div>';
				$h+='</div>';

			var __a={other:{o:0, b:0}, tag:{o:0, b:0}};
			var __t={rep_cm:'alert_reply_cm', cm:'alert_cm_item', tag:'alert_item_tag'};
			var __l=function(tag, $d)
			{
				if(__a[tag].b) return;
				if(__a[tag].o==0) $d.empty().append('<span>'+o.lang.get('please_wait')+'</span>');

				__a[tag].b=1;
				$.post(config.url, {option:'com_jlexguestbook', task:'alert.ls', type:tag, offset:__a[tag].o, t:new Date().getTime()}, function(d){
					if(d.status==403)
					{
						alert(o.lang.get('login_required_msg'));
						return;
					}

					if(d.data==null)
					{
						if(__a[tag].o==0)
						{
							$d.empty().append('<span>'+o.lang.get('no_notification')+'</span>');
						}

						__a[tag].b=1;
						return;
					}

					var $h='';
					if(__a[tag].o==0){
						$h+='<div class="c">';
					}

					$.each(d.data.rows, function(k,v){
						$h+='<a class="alert-item" href="'+v.object_link+'" target="_blank">';
							$h+='<span class="cn">'+(v.type=='tag'?v.type_value:v.count_msg)+'</span>';
							$h+='<span>'+o.lang.get(__t[v.type])+'</span>';
							$h+='<span class="co">'+v.object+'</span>';
							$h+='<span class="cd">'+v.date+'</span>';
						$h+='</a>';
					});

					if(__a[tag].o==0){
						$h+='</div>';
						$h+='<button class="more-btn hide">'+o.lang.get('more')+'</button>';
					}

					if(__a[tag].o==0){
						$d.empty().append($h);
					} else {
						$d.find('.c').append($h);
					}

					// pagination status
					if(d.data.offset+d.data.limit>=d.data.total){
						$d.find('.more-btn').addClass('hide');
					} else {
						$d.find('.more-btn').removeClass('hide');
					}

					__a[tag].b=0;
					__a[tag].o=d.data.offset+d.data.limit;
				}, 'json');

				$d.on('click', '.more-btn', function(){
					__l(tag, $d);
				});
			};

			var __jo=0;
			var jcm=function($d){
				var __jb=0,
				__jh = function(items)
				{
					var h='';
					$.each(items, function(k,v){
						h+= '<li class="'+(v.unread==1?'unread':'')+'">';
							h+= '<a href="'+v.url+'">';
								h+= '<span class="_msg">'+v.caption+'</span>';
								h+= '<span class="jcm-dg-bullet">&middot;</span>';
								h+= '<span class="_date">'+v.created_time+'</span>';
								h+= '<span class="jcm-dg-bullet">&middot;</span>';
								h+= '<b>'+v.object_name+'</b>';
								h+= '<span class="_comment">'+v.comment+'</span>';
							h+= '</a>';
						h+= '</li>';
					});

					return h;
				},
				__jl=function()
				{
					if(__jb) return;
					__jb=1;
					if(__jo==0) $d.append('<span>'+o.lang.get('please_wait')+'</span>');
					
					$.get(config.url, {option:'com_jlexcomment', task:'user.list_notification', offset:__jo, timestamp:new Date().getTime()}, function(d){
						if(__jo==0)
						{
							var h='<div class="jcm-box">';
							if(d.total>0)
							{
								h+='<ul class="jcm-list-notifications"></ul>';
							} else {
								h+=o.lang.get('no_notification');
							}
							h+='</div>';

							$d.empty().append(h);
						}

						if(d.notifications.length)
						{
							$d.find('.jcm-list-notifications').append(__jh(d.notifications));
						}
						
						__jo=d.offset+d.limit;
						__jb=0;
					}, 'json');
				};

				__jl();
			};

			o.dialog({
				caption:o.lang.get('notifications'),
				submitLabel:false,
				cancelLabel:o.lang.get('Ok'),
				content:$h,
				loadfn: function(dl)
				{
					dl.el.find('.__a a').click(function(e){
						e.preventDefault();
						var $el=$(this),
							$tag=$el.attr('data-value');

						if($el.hasClass('active')) return;

						$el.addClass('active');
						dl.el.find('[data-id='+$tag+']').addClass('active');

						dl.el.find('.__a a').not($el).removeClass('active');
						dl.el.find('.__c [data-id]').not('[data-id='+$tag+']').removeClass('active');

						if($tag=='other' && config.alert_jcm)
						{
							if(__jo==0) jcm(dl.el.find('[data-id=other]'));
							return;
						}

						if(__a[$tag].o==0)
							__l($tag, dl.el.find('[data-id='+$tag+']'));
					});

					dl.el.find('.__a a:eq(0)').trigger('click');
				}
			});
		});
	}
}