<?php
/**
 * @package     JLex Lookup
 * @version     1.0.0
 * @copyright   Copyright (C) 2013-2019 JLexArt Team (https://www.jlexart.com). All rights reserved.
 * @license     GNU General Public License version 2 or later
 * @author      JLexArt (support@jlexart.com)
 */

defined ( '_JEXEC' ) or die;
?>
<div id="jlexlookup">
	<?php if($this->params && $this->params->get('show_page_heading','1')=='1' && !preg_match('/^\s*$/', $this->params->get('page_heading', ''))):?>
	<div class="page-header">
		<h1><?php echo $this->params->get('page_heading'); ?></h1>
	</div>
	<?php endif;?>

	<?php if(!$this->params || $this->params->get('title','1')=='1'):?>
	<div class="page-header">
		<h2><?php echo $this->table->title; ?></h2>
	</div>
	<?php endif;?>

	<div class="jlk-description">
	<?php echo $this->table->description; ?>
	</div>

	<form id="jlk-form" action="<?php echo JUri::root(true).'/index.php' ?>" method="post" autocomplete="off" data-suggest="<?php echo $this->table->params->get('suggest', 0) ?>">
		<div class="btn-toolbar">
			<div class="btn-group pull-left">
				<input type="text" class="inputbox" name="q" required value="<?php echo $this->q ?>" placeholder="<?php echo $this->params?$this->params->get('boxtext',''):'' ?>">
			</div>
			<?php if(!$this->params || $this->params->get('button','1')=='1'):?>
			<div class="btn-group pull-left">
				<button class="btn btn-primary" type="submit"><?php echo ($this->params && !preg_match('/^\s*$/',$this->params->get('buttontext','')))?$this->params->get('buttontext'):jtext::_('JLK_FIND') ?></button>
			</div>
			<?php endif;?>
		</div>
		<div class="clearfix"></div>
		
		<input type="hidden" name="view" value="table">
		<input type="hidden" name="option" value="com_jlexlookup">
		<input type="hidden" name="id" value="<?php echo $this->table->id ?>">
		<input type="hidden" name="Itemid" value="<?php echo JFactory::getApplication()->input->getInt('Itemid', 0) ?>">

		<div class="suggests"></div>
	</form>

	<?php if(isset($this->rows)):?>
	<div class="jlk-results">
		<?php if(empty($this->rows)):?>
			<?php echo jtext::_('JLK_NO_ROWS_FOUND'); ?>
		<?php else:?>
			<table class="table">
				<thead>
					<tr>
						<?php foreach($this->table->columns as $column):?>
							<?php if($column->show_result):?>
								<th>
									<?php echo $column->caption; ?>
								</th>
							<?php endif;?>
						<?php endforeach;?>
					</tr>
				</thead>

				<tbody>
				<?php foreach($this->rows as $k=>$row):?>
					<tr>
						<?php
							foreach($this->table->columns as $col):
							$colName='c'.$col->column_index;
								if($col->show_result):
									$text=$row->$colName;
									if($col->istext) $text=nl2br($text);
									if($col->prepare_content) $text=JHtml::_('content.prepare', $text);
							?>
								<td><?php echo $text ?></td>
							<?php
								endif;
							endforeach;
						?>
					</tr>
				<?php endforeach;?>
				</tbody>
			</table>
		<?php endif;?>

		<!-- pagination -->
		<?php
			if(!empty($this->pagination)) echo $this->pagination->getPagesLinks();
		?>
	</div>
	<?php endif;?>
</div>