<?php
/**
 * @name		JShopping - JLex Review
 * @version		1.3.0
 * @package		JLex Review extension
 * @copyright	Copyright (C) 2014 JLexArt.com - All rights reserved.
 * @license		GNU/GPL or later
 * @author		JLEX team
 */

// no direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );
class plgHikashopJLexReview extends JPlugin {
	var $apc1 = 0;
	var $apc2 = 0;
	function plgHikashopJLexReview(&$subject, $config) {
		$loader = JPATH_ROOT . '/components/com_jlexreview/load.php';
		if (! file_exists ( $loader )) {
			return;
		}
		if (! class_exists ( 'JLexReviewLoad' )) {
			require_once $loader;
		}
		parent::__construct ( $subject, $config );
	}
	// Call a trigger, in this example: onBeforeOrderCreate
	function onHikashopBeforeDisplayView(&$view) {
		$app = JFactory::getApplication();
		if ($app->isAdmin()) return;
		
		$view->type = isset($view->type) ? $view->type : null;
		
		// for view product
		if ($this->params->get ( 'ministarproduct', 1 )) {
			if ($view->type == 'main' && $view->ctrl == 'product' && isset ( $view->element->product_id ) && ! $this->apc1) {
				$id = $view->element->product_parent_id>0 ? $view->element->product_parent_id:$view->element->product_id;
				$view->element->extraData->rightBegin [] = JLexReviewLoad::quick_init ( 'hikashop', $id );
				$this->apc1 ++;
			}
		}
		
		// listing products
		if ($this->params->get ( 'ministarproductlist', 1 )) {
			if ($view->type == 'main' && $view->ctrl == 'product') {
				if (isset ( $view->rows ) && is_array($view->rows) && count ( $view->rows )) {
					foreach ( $view->rows as $k => &$row ) {
						$id = $row->product_parent_id>0 ? $row->product_parent_id:$row->product_id;
						$row->extraData->afterProductName [] = JLexReviewLoad::quick_init ( 'hikashop', $id );
					}
				}
			}
		}
		
		// Actions to do when my trigger is called
		if ($view->type == 'main' && $view->ctrl == 'product' && isset ( $view->element->product_id ) && ! $this->apc2) {
			$id = $view->element->product_parent_id>0 ? $view->element->product_parent_id:$view->element->product_id;
			$view->element->extraData->bottomEnd [] = JLexReviewLoad::init ( strip_tags($view->element->product_name), 'hikashop', $id, $view->element->category_id );
			$this->apc2 ++;
		}
	}
	function onHikashopAfterDisplayView(&$view) {
		// Actions to do when my trigger is called
		/*if ($view->type == 'main' && $view->ctrl == 'product' && isset ( $view->element->product_id ) && ! $this->apc2) {
			$id = $view->element->product_parent_id>0 ? $view->element->product_parent_id:$view->element->product_id;
			$view->element->extraData->bottomEnd [] = JLexReviewLoad::init ( strip_tags($view->element->product_name), 'hikashop', $id, $view->element->category_id );
			$this->apc2 ++;
		}*/
	}
}