<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
JHtml::_('formbehavior.chosen', '.dg-select select');
$x = explode(',', $this->settings->extensions);
$accept = '.'.implode(', .', $x);
?>
<div class="dg-ui dg-select">
  <h3 class="dg-page-title">
    <?php echo JText::_("COM_DATSOGALLERY_UPLOAD_STEP_ONE");?>
  </h3>
  <?php echo JHtml::_('datsogallery.search'); ?>
  <form id="upForm" name="upForm" method="post">
     <div class="dg-steps"></div>
     <section>
        <div id="header">
           <div class="dg-alert upload-process dg-alert-warning" style="display:none">
               <p><?php echo JText::_("COM_DATSOGALLERY_PROCESSING_WAIT_MSG");?></p>
            </div>
        </div>
        <div class="dg-alert" style="display:none">
           <div class="dg-alert-close dg-close"></div>
           <p></p>
        </div>
        <div>
           <input class="dg-hiddenFile" name="imagefile[]" id="imagefile" accept="<?= $accept ?>" type="file" multiple>
        </div>
     </section>
     <div class="dg-steps"></div>
     <section>
        <div id="tmpimgs"></div>
     </section>
     <?php if ($this->settings->show_terms) : ?>
     <div class="dg-steps"></div>
     <section>
        <h3 class="dg-title"><?php echo JText::_("COM_DATSOGALLERY_UPLOAD_STEP_THREE");?></h3>
        <div class="dg-alert terms" style="display:none">
           <div class="dg-alert-close dg-close"></div>
           <p></p>
        </div>
        <p><iframe src="<?php echo JUri::root(); ?>index.php?option=com_content&view=article&id=<?php echo (int) $this->settings->terms_id; ?>&tmpl=component" class="dg-iframe"></iframe></p>
     </section>
     <?php endif; ?>
     <input type="hidden" name="option" value="com_datsogallery" />
     <input type="hidden" name="task" value="upload.save" />
     <?php echo JHtml::_('form.token'); ?>
  </form>
  <div class="dg-loading">
    <div class="dg-loading-wheel"></div>
    <div class="wait-msg">
      <?php echo JText::sprintf("COM_DATSOGALLERY_PROCESSING_WAIT_MSG", '<span id="refresh-page" title="'.JText::_('COM_DATSOGALLERY_REFRESH_PAGE').'">', '</span>'); ?>
    </div>
  </div>
<?php if ($this->settings->backlink) { ?>
  <div class="backlink">
    <?= dg::backlink() ?>
  </div>
<?php } ?>
</div>
<?php
$exten = json_encode(array_unique(explode(",", strtolower($this->settings->extensions))));
?>
<script>
function alldone(element, position) {
    var allfinished = true;
    for (var i = 0, l = element.uploadList.length; i < l; i++) {
        if (element.uploadList[i].status != 'finished' && element.uploadList[i].status != 'canceled' && element.uploadList[i].status != 'rejected' && element.uploadList[i].status != 'failed') {
            allfinished = false;
        }
    }
    if (allfinished) {
      jQuery('.dg-alert.upload-process').slideUp(function() {
         jQuery("#upForm .actions a[href='#next']").show();
      });
      jQuery("#upForm .actions a[href='#next']").show();
    }
}
window.onload = function() {
    var uploadSettings = {
        'text': '<?php echo JText::_("COM_DATSOGALLERY_UPLOAD_BUTTON_TEXT"); ?>',
        'action': ajax_url + '&task=upload.process',
        'maxFiles': dguplim,
        'callbackSuccess': alldone,
        'maxWidth': <?php echo $this->settings->upload_max_width; ?>,
        'maxHeight': <?php echo $this->settings->upload_max_height; ?>,
        'maxFileSize': <?php echo dg::mb2kb($this->settings->max_filesize, $this->settings->max_filesize_format); ?>,
        'sliceSize': <?php echo $this->settings->upload_slice_size; ?>
    };
    var uploader = document.getElementById('imagefile');
    var uploadForm = new RealTimeUpload(uploadSettings, uploader);
};
jQuery(function($) {
    var form = $("#upForm");
    form.steps({
        headerTag: "div.dg-steps",
        bodyTag: "section",
        labels: {
          next: "<?php echo JText::_("COM_DATSOGALLERY_STEPS_NEXT"); ?>",
          previous: "<?php echo JText::_("COM_DATSOGALLERY_STEPS_PREVIOUS"); ?>",
          finish: "<?php echo JText::_("COM_DATSOGALLERY_STEPS_FINISH"); ?>"
        },
        transitionEffect: "slideLeft",
        onInit: function(event, currentIndex) {
            $(".actions").prepend('<ul class="dg-allowed-ext"><li><i class="dgi-info"></i></li><li><?php echo JText::_("COM_DATSOGALLERY_ALLOWED_EXTENSIONS");?></li><li><?= strtoupper(implode(', ', json_decode($exten))) ?></li></ul>');
            $("#upForm .actions a[href='#next']").hide();
        },
        onStepChanging: function(event, currentIndex, newIndex) {
            if (currentIndex > newIndex) {
                return true;
            }
            if (currentIndex < newIndex) {
                form.find(".body:eq(" + newIndex + ") label.error").remove();
                form.find(".body:eq(" + newIndex + ") .error").removeClass("error");
            }
            form.validate().settings.ignore = ":disabled,:hidden";
            return form.valid();
        },
        onStepChanged: function(event, currentIndex, priorIndex) {
            if (currentIndex === 1) {
                showtmp();
            }
            if (currentIndex === 0) {
                $(".actions").prepend('<ul class="dg-allowed-ext"><li><i class="dgi-info"></i></li><li><?php echo JText::_("COM_DATSOGALLERY_ALLOWED_EXTENSIONS");?></li><li><?= strtoupper(implode(', ', json_decode($exten))) ?></li></ul>');
            }
            if (currentIndex > 0) {
                $(".dg-allowed-ext").remove();
            }
            if (currentIndex === 2) {
                $(".actions").prepend('<div class="dg-toogle-terms"><label class="checkbox"><input type="checkbox" name="terms" id="terms" /><i></i><?php echo JText::_("COM_DATSOGALLERY_AGREE_TERMS"); ?></label></div>');
            }
            if (currentIndex < 2) {
                $(".dg-toogle-terms").remove();
            }
        },
        onFinishing: function(event, currentIndex) {
            form.validate().settings.ignore = ":disabled";
            return form.valid();
        },
        onFinished: function(event, currentIndex) {
            var form = $('#upForm');
            form.submit();
        }
    }).validate({
        focusInvalid: false,
        invalidHandler: function(form, validator) {

            if (!validator.numberOfInvalids())
                return;

            $('html, body').animate({
                scrollTop: parseInt($('#generic-catid').offset().top - 63)
            }, 1000);

        },
        errorPlacement: function errorPlacement(error, element) {
            error.insertAfter(element.parent());
        },
				highlight: function (element, errorClass, validClass) {
					$(element).addClass("has-error");
				},
        rules: {
            gcatid: {
                required: function() {
                    return $("select.catid").val() == '';
                }
            },
            'generic-title': {
                required: function() {
                    return $("#generic-all").val() == 1 ? true : false
                }
            },
            terms: {
                required: true
            }
        },
        messages: {
            gcatid: {
                required: '<?php echo JText::_("COM_DATSOGALLERY_REQUIRED_CATEGORY_MSG"); ?>'
            },
            'generic-title': {
                required: '<?php echo JText::_("COM_DATSOGALLERY_REQUIRED_GENERIC_TITLE_MSG"); ?>'
            },
            terms: {
                required: '<?php echo JText::_("COM_DATSOGALLERY_AGREE_TERMS_MSG"); ?>'
            }
        }
    });
});
jQuery(document).on('change', '.toggle input#accept-terms:checkbox', function($) {
    if ($(this).prop('checked')) {
        $(this).attr('checked', false);
    } else {
        $(this).attr('checked', true);
    }
});
jQuery(document).on('click', '#refresh-page', function() {
    location.reload();
});
function showtmp() {
   jQuery.ajax({
    url: ajax_url + '&task=upload.tmpimg',
    beforeSend: function(){
      jQuery(".dg-loading").fadeIn();
      jQuery(".wizard > .actions").fadeOut();
    },
    success: function(data) {
      jQuery('#tmpimgs').html(data);
    },
    complete: function(data){
      jQuery(".dg-loading").fadeOut();
      jQuery(".wizard > .actions").fadeIn();
    }
  });
}
</script>