<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewSearch extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $params;
  protected $settings;

  public function display($tpl = null)
  {
    $app                  = JFactory::getApplication();
    $this->items          = $this->get('Items');
    $this->pagination     = $this->get('Pagination');
    $menu                 = $app->getMenu();
    $members_ids          = $menu->getItems('link', 'index.php?option=com_datsogallery&view=members');
    $this->members_itemid = isset($members_ids[0]) ? '&Itemid=' . $members_ids[0]->id : '';
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $this->params   = $app->getParams('com_datsogallery');
    $this->settings = dg::getConfig();
    $this->_prepareDocument();
    $pathway = $app->getPathway();
    $pathway->addItem(JText::_('COM_DATSOGALLERY_SEARCH_RESULTS'));
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app   = JFactory::getApplication();
    $doc   = JFactory::getDocument();
    $menus = $app->getMenu();
    $title = null;
    $menu  = $menus->getActive();
    if ($menu) {
      $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
    } else {
      $this->params->def('page_heading', JText::_('COM_DATSOGALLERY_DEFAULT_PAGE_TITLE'));
    }
    $searchword = $app->input->getString('searchword');
    $title      = JText::sprintf('COM_DATSOGALLERY_SEARCH_FOR', $searchword);
    $this->document->setTitle($title);
  }
}
