<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewMembers extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $state;
  protected $params;

  public function display($tpl = null)
  {
    $app              = JFactory::getApplication();
    $this->state      = $this->get('State');
    $this->items      = $this->get('Items');
    $this->pagination = $this->get('Pagination');
    $this->params     = $app->getParams('com_datsogallery');
    $this->settings   = dg::getConfig();
    if (count($errors = $this->get('Errors'))) {
      ;
      throw new Exception(implode("\n", $errors));
    }
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app   = JFactory::getApplication();
    $menus = $app->getMenu();
    $title = null;
    $menu  = $menus->getActive();
    if ($menu) {
      $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
    } else {
      $this->params->def('page_heading', JText::_('com_datsogallery_DEFAULT_PAGE_TITLE'));
    }
    $title = $this->params->get('page_title', '');
    if (empty($title)) {
      $title = $app->getCfg('sitename');
    } elseif ($app->getCfg('sitename_pagetitles', 0) == 1) {
      $title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
    } elseif ($app->getCfg('sitename_pagetitles', 0) == 2) {
      $title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
    }
    $this->document->setTitle($title);
    if ($this->params->get('menu-meta_description')) {
      $this->document->setDescription($this->params->get('menu-meta_description'));
    }
    if ($this->params->get('menu-meta_keywords')) {
      $this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
    }
    if ($this->params->get('robots')) {
      $this->document->setMetadata('robots', $this->params->get('robots'));
    }
  }
}
