<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewMember extends JViewLegacy
{
  protected $member;
  protected $items;
  protected $pagination;
  protected $state;
  protected $params;
  protected $form;

  public function display($tpl = null)
  {
    $app              = JFactory::getApplication();
    $this->state      = $this->get('State');
    $this->member     = $this->get('Member');
    $this->items      = $this->get('Items');
    $this->form       = $this->get('Form');
    $this->pagination = $this->get('Pagination');
    $this->settings   = dg::getConfig();
    $this->params     = $app->getParams('com_datsogallery');
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app       = JFactory::getApplication();
    $id        = $app->input->getInt('id');
    $user      = JFactory::getUser();
    $user_name = JFactory::getUser($id)->name;
    $app->getPathway()->addItem($user_name, '');
    $title = $user->id != $id ? JText::sprintf('COM_DATSOGALLERY_MEMBER_IMAGES_BY', $user_name) : JText::_('COM_DATSOGALLERY_MEMBER_MY_IMAGES');
    $this->document->setTitle($title);
    $this->document->addScript(Juri::root(true) . '/components/com_datsogallery/assets/js/upload.min.js');
    $this->document->addScript(Juri::root(true) . '/components/com_datsogallery/assets/js/apexcharts.min.js');
  }
}
