<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/images.php');
$app = JFactory::getApplication();
$user = JFactory::getUser();
$userid = $app->input->getInt('id');
$id = isset($userid) ? $userid : $user->id;
$user_name = JFactory::getUser($id)->name;
$items = count($this->items);
$do_grid = $items > 0 ? 'dg-grid' : 'dg-nogrid';
?>
<h3 class="dg-page-title" style="display:flex;justify-content:space-between">
  <?= $user->id != $id ? JText::sprintf('COM_DATSOGALLERY_MEMBER_IMAGES_BY', $user_name) : JText::_('COM_DATSOGALLERY_MEMBER_MY_IMAGES') ?>
  <span><?= JText::sprintf('COM_DATSOGALLERY_MEMBER_TOTAL_IMAGES', dg::totalimages($id)) ?></span>
</h3>
<?= JHtml::_('datsogallery.search'); ?>
<div id="dg-member" class="<?= $do_grid ?>"
       data-container-breakpoints="<?= $this->settings->category_container_breakpoints ?>"
       data-breakpoint-xl="<?= $this->settings->category_breakpoint_xl ?>"
       data-breakpoint-l="<?= $this->settings->category_breakpoint_l ?>"
       data-breakpoint-m="<?= $this->settings->category_breakpoint_m ?>"
       data-breakpoint-s="<?= $this->settings->category_breakpoint_s ?>"
       data-margin-y="<?= ($this->settings->category_details ? 0 : $this->settings->category_margin_y) ?>"
       data-margin-x="<?= $this->settings->category_margin_x ?>">
  <?php
    if ($items > 0) {
    foreach ($this->items as $item) {
    $grayscaled = !$item->approved ? ' class="dg-grayscaled"' : '';
    $image_link = JRoute::_('index.php?option=com_datsogallery&view=image&catid='.$item->catid.'&id='.$item->id.dg::menuid($item->catid));
    ?>
  <div id="<?=$item->id ?>" class="dg-grid-item">
    <div class="image-block dg-image">
      <div class="dg-spiner"></div>
      <a id="<?= $item->id ?>" href="<?= $image_link ?>">
        <img<?= $grayscaled ?> src="<?=JHtml::_('datsogallery.image', $item->original, $item->id, $item->catid, 'category') ?>" alt="<?=$item->title ?>" <?=dg::is_anim($item->original, $item->catid) ?> <?=get_width_height($item->original, $this->settings->category_image_width, $this->settings->category_image_height, $item->catid, $this->settings->category_image_aspect_ratio);?> />
      </a>
      <?php
        echo JHtml::_('datsogallery.management', $item->id, $item->catid, $item->created_by, $item->notify);
        echo JHtml::_('datsogallery.details', $item->id, $item->created_by, $item->title, $item->user_name, $item->created, $image_link, 'category', $item->catid);
        echo JHtml::_('datsogallery.stats', $item->id, null, $item->created_by, $item->user_name, $item->original, $item->featured, $item->hits, $item->downloads, $image_link, $item->title, $item->created, 'category');
        if (!$item->approved) {
        ?>
      <div class="position-center hint--top" style="text-align:center" data-hint="<?= JText::_('COM_DATSOGALLERY_UNAPROVED') ?>">
        <i class="dgi-time">
        </i>
      </div>
      <?php } ?>
    </div>
    <?php if ($this->settings->category_details) { ?>
      <div class="image-card">
        <?php if ($this->settings->category_title && $this->settings->category_title_position == 0) { ?>
        <h4 class="image-title"><a href="<?= $image_link ?>"><?= $item->title ?></a></h4>
        <?php } ?>
        <?php if ($this->settings->category_image_description) { ?>
        <p class="image-desc"><?= strip_tags($item->description) ?></p>
        <?php } ?>
      </div>
      <?php } ?>
  </div>
  <?php
  }
} else { ?>
  <div class="dg-message-info">
    <p><?= JText::_('COM_DATSOGALLERY_NO_ITEMS') ?></p>
  </div>
  <?php
}
?>
</div>
  <div class="ias-conteiner"></div>
  <?php if ($this->pagination->limit < $this->pagination->total) {?>
  <div class="dg-pagination"<?=$this->settings->category_pagination_type ? ' style="display:none"' : '';?>>
  <?php if (!$this->settings->category_pagination_type) {?>
  <p class="counter pull-right">
    <?=$this->pagination->getPagesCounter();?>
  </p>
  <?php
    }
      echo $this->pagination->getPagesLinks();
    ?>
  </div>
  <?php } ?>
<?php
  $doc    = JFactory::getDocument();
  $doc->addScriptDeclaration('var dgrid = ".dg-grid";');
  if ($this->settings->category_pagination_type) {
    $ias = ($this->pagination->limit >= $this->pagination->total) ? 'true' : 'false';
    $doc->addScriptDeclaration('var iasdestroy = ' . $ias . ';');
    $doc->addScriptDeclaration('var dgoffset = ' . (int) $this->settings->pagination_offset . ';');
} else {
  $doc->addScriptDeclaration('var iasdestroy = true;');
}