<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

$app = JFactory::getApplication();
$user = JFactory::getUser();
$id = $app->input->getInt('id');
$user_name = JFactory::getUser($id)->name;
$comments = dg::usercommentsactivities($id);
$categories = dg::usercategoriesactivities($id);
$images = dg::useruploadactivities($id);
$likes = dg::userlikesactivities($id);
$tags = dg::usertagsactivities($id);
?>

<div class="dg-ui">

<ul id="<?= $id ?>" class="member-container">
  <li style="flex-basis:60%">
    <ul style="display:flex:flex-direction:column">
      <li>
        <ul style="display: flex;flex-flow: row nowrap;">
          <li class="member_avatar dg-image<?= ($user->id == $id ? ' hint--right hint--medium':'') ?>"<?= ($user->id == $id ? ' data-hint="'.JText::_('COM_DATSOGALLERY_UPLOAD_AVATAR_HINT').'"':'') ?> style="position:relative;" method="post">
            <?= dg::avatar($id, null, true, true); ?>
            <div class="zed">
            <svg class="round" height="90" width="90"><circle cx="45" cy="45" r="44" stroke="#bde5b3" stroke-width="2" fill="transparent" /></svg>
            </div>
            <i id="dg-update-avatar" class="dgi-no-avatar"><input class="dg-hiddenFile" name="avatarfile" id="avatarfile" accept="image/gif, image/jpeg, image/png" type="file"></i>
          </li>
          <li style="flex:1;">
            <ul style="display: flex;flex-flow: column nowrap;margin: 0 -5px;">
              <li style="margin: 0 5px;">
                <ul style="display: flex;flex-flow: row nowrap;">
                  <li class="member-name"><?= $user_name ?></li>
                  <?php if ($user->id == $id) { ?>
                  <li style="flex: 1;align-self: center;">
                    <ul class="member-actions">
                      <li><a href="<?= JRoute::_('index.php?option=com_datsogallery&view=member&id='.$id.'&layout=edit') ?>"><i id="dg-edit-profile" class="dgi-edit"></i></a></li>
                      <li class="hint--bottom-left hint--medium" data-hint="<?= JText::_("COM_DATSOGALLERY_COMMENT_NOTIFICATIONS_ALL"); ?>"><i id="cbnotify" class="dgi-notifications"></i></li>
                    </ul>
                  </li>
                  <?php } ?>
                </ul>
              </li>
              <li>
                <ul class="member-data">
                  <li class="member-location">
                    <ul class="member-data">
                      <li>
                        <i class="dgi-home"></i>
                      </li>
                      <li>
                        <?= (isset($this->member['location']) && !empty($this->member['location']) ? $this->member['location'] : '<span class="not-provided">'.JText::_('COM_DATSOGALLERY_LOCATION_NOT_PROVIDED').'</span>') ?>
                      </li>
                    </ul>
                  </li>
                  <li class="member-url">
                    <ul class="member-data">
                      <li>
                        <i class="dgi-link"></i>
                      </li>
                      <li>
                        <?= (isset($this->member['website']) && !empty($this->member['website']) ? '<a href="https://'.$this->member['website'].'" rel="nofollow" target="_blank">'.$this->member['website'].'</a>' : '<span class="not-provided">'.JText::_('COM_DATSOGALLERY_URL_NOT_PROVIDED').'</span>') ?>
                      </li>
                    </ul>
                  </li>
                </ul>
              </li>
            </ul>
          </li>
        </ul>
      </li>
      <li class="member-bio">
        <?= (isset($this->member['about']) && !empty($this->member['about']) ? nl2br($this->member['about']) : '<span class="not-provided">'.JText::_('COM_DATSOGALLERY_BIO_NOT_PROVIDED').'</span>') ?>
      </li>
    </ul>
  </li>
  <!--<li style="margin-bottom:20px"></li>-->
  <li style="flex:1">
    <ul>
      <!--<li>Stats</li>-->
      <li>
        <ul class="member-stats">
          <li>
            <ul>
              <li><?= dg::userimageslikes($id) ?></li>
              <li class="ellipsis"><?= JText::_('COM_DATSOGALLERY_LIKES') ?></li>
            </ul>
          </li>
          <li>
            <ul>
              <li><?= dg::userimagescomments($id) ?></li>
              <li class="ellipsis"><?= JText::_('COM_DATSOGALLERY_COMMENTS') ?></li>
            </ul>
          </li>
          <li>
            <ul>
              <li><?= dg::userimagesdownloads($id) ?></li>
              <li class="ellipsis"><?= JText::_('COM_DATSOGALLERY_DOWNLOADS') ?></li>
            </ul>
          </li>
          <li>
            <ul>
              <li><?= dg::userimagesviews($id) ?></li>
              <li class="ellipsis"><?= JText::_('COM_DATSOGALLERY_VIEWS') ?></li>
            </ul>
          </li>
        </ul>
      </li>
    </ul>
    <ul>
      <!--<li>Activities last year</li>-->
      <li id="useractivities"></li>
      <li><?= JText::_('COM_DATSOGALLERY_ACTIVITY') ?></li>
    </ul>
  </li>
</ul>

<?php
  if($this->items) {
    echo $this->loadTemplate('images');
  } else {
    echo '<h5>'.JText::_('COM_DATSOGALLERY_NO_UPLOADS').'</h5>';
  }
if ($this->settings->backlink) { ?>
  <div class="backlink">
    <?= dg::backlink() ?>
  </div>
  <?php } ?>
</div>

<script>
jQuery(window)
.on("load", function () {
var e = "#ccb2d9",
    t = "#bde5b3",
    a = "#fdce7c",
    o = "#96cdf4",
    r = "#fbb1a4",
    s = {
      chart: {
        width: "100%",
        height: 150,
        type: "area",
        toolbar: {
          show: false
        },
        sparkline: {
          enabled: true
        }
      },
      colors: [e,t,a,o,r],
      stroke: {
        curve: "smooth",
        width: 2
      },
      fill: {
        type: "gradient",
        gradient: {
          shadeIntensity: .9,
          opacityFrom: .7,
          opacityTo: .5,
          stops: [0, 80, 100]
        }
      },
      xaxis: {
        categories: <?= dg::months() ?>,
        tickPlacement: 'on',
        axisBorder: {
            show: true,
            color: '#78909C',
            height: 1,
            width: '100%',
            offsetX: 0,
            offsetY: 0
        },
        axisTicks: {
            show: true,
            borderType: 'solid',
            color: '#78909C',
            height: 6,
            offsetX: 0,
            offsetY: 0
        },
      },
      series: [
      {
        name: "<?= JText::_('COM_DATSOGALLERY_CATEGORIES') ?>",
        data: <?= dg::combomonths($categories) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_IMAGES') ?>",
        data: <?= dg::combomonths($images) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_COMMENTS') ?>",
        data: <?= dg::combomonths($comments) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_LIKES') ?>",
        data: <?= dg::combomonths($likes) ?>
      },
      {
        name: "<?= JText::_('COM_DATSOGALLERY_TAGS') ?>",
        data: <?= dg::combomonths($tags) ?>
      }
      ],
      tooltip: {
        style: {
          fontSize: '12px',
          fontFamily: 'inherit'
        }
      }
};
new ApexCharts(document.querySelector("#useractivities"), s)
.render();
});
</script>
<?php
if ($this->settings->allow_avatar && ($this->settings->avatar_service == 1) && $user->id == $id) {
  dg::jslang('upload.min.js');
?>
<script>
function uploaded() {
  jQuery.get(ajax_url + '&task=member.updateavatar', function (data) {
    jQuery('.zed').hide();
    dgsound('cork');
    jQuery('.member_avatar img')
      .attr('src', data + '?dt=' + (+new Date())).addClass('dg-uploaded')
                  .delay(1000)
                  .queue(function () {
                    jQuery(this).removeClass('dg-uploaded').dequeue();
      })
  });
}

function failed(u, p, e) {
  jQuery('.zed')
    .show();
  jQuery('.round')
    .find('circle')
    .attr('stroke', '#D36F6F');
  jQuery('.member_avatar .dg-alert')
    .addClass('dg-alert-danger')
    .show();
  jQuery('.member_avatar .dg-alert p')
    .append('<div class="avr-msg">' + e + '</div>');
  setTimeout(function () {
    jQuery('.member_avatar .dg-alert')
      .removeClass('dg-alert-danger')
      .fadeOut('fast', function () {
        jQuery(".avr-msg, .dg-uploadItem")
          .remove();
      });
  }, 3000);
}

jQuery(window).load(function () {
  var uploadSettings = {
    'method': 'post',
    'action': ajax_url + '&task=member.avatarupload',
    'avatar': true,
    'encoding': false,
    'extension': ['png', 'jpg', 'jpeg', 'gif'],
    'callbackSuccess': uploaded,
    'callbackError': failed,
    'maxWidth': 8000,
    'maxHeight': 8000,
    'maxFileSize': '<?= dg::maxuploadsize() ?>',
    'autoUpload': true,
  };
  var uploader = document.getElementById('avatarfile');
  var uploadForm = new RealTimeUpload(uploadSettings, uploader);
});
</script>
<?php
}