<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewImage extends JViewLegacy
{
  protected $state;
  protected $item;
  protected $form;
  protected $params;
  protected $pagination;
  protected $comments;
  protected $parentcomments;

  public function display($tpl = null)
  {
    $app                  = JFactory::getApplication();
    $user                 = JFactory::getUser();
    $this->state          = $this->get('State');
    $this->item           = $this->get('Item');
    $this->owner          = $this->get('Owner');
    $this->tags           = $this->get('Tags');
    $this->colors         = $this->get('Colors');
    $this->category       = $this->get('Category');
    $this->dislikes       = $this->get('Dislikes');
    $this->likes          = $this->get('Likes');
    $this->rateall        = $this->get('Rateall');
    $this->likecount      = $this->get('Likecount');
    $this->dislikecount   = $this->get('Dislikecount');
    $this->blocked        = $this->get('Blocked');
    $this->comments       = $this->get('Comments');
    $this->parentcomments = $this->get('Parentcomments');
    $this->pagination     = $this->get('Pagination');
    $this->related        = $this->get('Related');
    $this->params         = $app->getParams('com_datsogallery');
    $this->form           = $this->get('Form');
    $this->settings       = dg::getConfig();
    $menu                 = $app->getMenu();
    $members_ids          = $menu->getItems('link', 'index.php?option=com_datsogallery&view=members');
    $this->members_itemid = isset($members_ids[0]) ? '&Itemid=' . $members_ids[0]->id : '';
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $groups = $user->getAuthorisedViewLevels();
    if (!in_array($this->item->access, $groups)) {
      $app->enqueueMessage(JText::_('COM_DATSOGALLERY_NO_ACCESS_IMAGE'), 'error');
      $app->setHeader('status', 403, true);
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories' . dg::itemId(), false));
    } elseif (!in_array($this->item->category_access, $groups)) {
      $app->enqueueMessage(JText::_('COM_DATSOGALLERY_NO_ACCESS_CATEGORY'), 'error');
      $app->setHeader('status', 403, true);
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories' . dg::itemId(), false));
    }
    if ($this->_layout == 'edit') {
      if ($this->settings->users_categories && !$this->settings->members_category) {
        $app->enqueueMessage(JText::_('COM_DATSOGALLERY_MEMBERS_CATEGORIES_MSG'), 'warning');
        $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $user->id . dg::itemId(), false));
      }
      if (!$this->settings->users_categories && !$this->settings->allowed_categories) {
        $app->enqueueMessage(JText::_('COM_DATSOGALLERY_ALLOWED_CATEGORIES_MSG'), 'warning');
        $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $user->id . dg::itemId(), false));
      }
      $canEdit    = $user->authorise('core.edit', 'com_datsogallery.image.' . $this->item->id);
      $canEditOwn = $user->authorise('core.edit.own', 'com_datsogallery.image.' . $this->item->id);
      if ($canEdit || $canEditOwn) {
        $canEdit = $user->id == $this->item->created_by;
      }
      if ($canEdit !== true) {
        $app->enqueueMessage(JText::_('COM_DATSOGALLERY_NO_AUTHORIZED_TO_EDIT'), 'error');
        $app->setHeader('status', 403, true);
        $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $this->item->catid . '&id=' . $this->item->id . dg::itemId(), false));
      }
    }
    $model = $this->getModel();
    $model->hit();
    if ($this->settings->meta_generator) {
      $model->addMeta();
    }
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app  = JFactory::getApplication();
    $lang = JFactory::getLanguage();
    $lang->load('com_datsogallery', JPATH_ADMINISTRATOR);
    $config = JFactory::getConfig();
    $menus  = $app->getMenu();
    $title  = null;
    $lng    = substr($this->document->language, 0, 2);
    if ($this->settings->allow_geotagging) {
      if ($this->settings->gm_api_key != '') {
        $this->document->addScript('//maps.googleapis.com/maps/api/js?key=' . $this->settings->gm_api_key . '&amp;libraries=places&amp;language=' . $lng);
      } else {
        $this->document->addScript('//maps.googleapis.com/maps/api/js?libraries=places&amp;language=' . $lng);
      }
    }
    // Prepare variables
    $juri        = JUri::getInstance()->toString(['scheme', 'host', 'port']);
    $title       = $this->item->title;
    $description = JHtml::_('string.truncate', $this->item->description, 160, true, false);
    $meta        = !empty($this->item->metadesc) ? $this->item->metadesc : (!empty($description) ? $description : '');
    $image       = $juri . resize($this->item->original,
      $this->settings->image_width_details,
      $this->settings->image_height_details,
      $this->settings->image_resize_method_details,
      $this->settings->image_aspect_ratio_details,
      $this->settings->image_watermark,
      $this->item->catid,
      '',
      $this->settings->image_quality_details,
      false,
      $this->settings->image_watermark_position);
    $itemURL    = JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $this->item->catid . '&id=' . $this->item->id . dg::itemId());
    $url        = $juri . $itemURL;
    $cached_img = getCacheFile($this->item->original, $this->settings->image_width_details, $this->settings->image_height_details, $this->item->catid, $this->settings->image_aspect_ratio_details);
    $img_info   = getimagesize($cached_img);

    // Add Canonical
    $this->document->addHeadLink($url, 'canonical', 'rel');

    // Twitter Card metadata
    $this->document->setMetaData('twitter:card', 'summary_large_image');
    $this->document->setMetaData('twitter:site', $juri);
    $this->document->setMetaData('twitter:title', $title);
    $this->document->setMetaData('twitter:description', $meta);
    $this->document->setMetaData('twitter:image', $image);
    $this->document->setMetaData('twitter:image:alt', $title);

    // OpenGraph metadata
    $this->document->setMetaData('og:locale', JFactory::getLanguage()->getTag(), 'property');
    $this->document->setMetaData('og:type', 'article', 'property');
    $this->document->setMetaData('og:title', $title, 'property');
    $this->document->setMetaData('og:description', $meta, 'property');
    $this->document->setMetaData('og:url', $url, 'property');
    $this->document->setMetaData('og:site_name', $config->get('sitename'), 'property');
    if ($this->tags) {
      foreach ($this->tags as $tag) {
        $this->document->addCustomTag('<meta property="article:tag" content="' . $tag->tag . '" />');
      }
    }
    $this->document->setMetaData('article:section', $this->category->title, 'property');
    $this->document->setMetaData('article:published_time', date(DATE_W3C, strtotime($this->item->created)), 'property');
    $this->document->setMetaData('article:modified_time', date(DATE_W3C, strtotime($this->item->modified)), 'property');
    $this->document->setMetaData('og:updated_time', date(DATE_W3C, strtotime($this->item->modified)), 'property');
    $this->document->setMetaData('og:image', $image, 'property');
    $this->document->setMetaData('og:image:secure_url', $image, 'property');
    $this->document->setMetaData('og:image:type', $img_info['mime'], 'property');
    $this->document->setMetaData('og:image:width', $img_info[0], 'property');
    $this->document->setMetaData('og:image:height', $img_info[1], 'property');
    $this->document->setMetaData('og:image:alt', $title, 'property');

    // Set meta
    $title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));

    $this->document->setTitle($title);

    if ($this->item->metadesc) {
      $this->document->setDescription($this->item->metadesc);
    } elseif ($this->params->get('menu-meta_description')) {
      $this->document->setDescription($this->params->get('menu-meta_description'));
    }

    if ($this->params->get('robots')) {
      $this->document->setMetadata('robots', $this->params->get('robots'));
    }

    $mdata = $this->item->metadata->toArray();

    foreach ($mdata as $k => $v) {
      if ($v) {
        $this->document->setMetadata($k, $v);
      }
    }

    $pathway = JFactory::getApplication()->getPathway();
    if ($path = $this->get('Path')) {
      foreach ($path as $item) {
        $pathway->addItem($item->title, $item->link);
      }
    }
    $pathway->addItem($this->item->title, '');
  }
}
