<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
$user = JFactory::getUser();
$params = new JRegistry();
$params->loadString($this->item->params);
$lang = JFactory::getLanguage();
$icon_dir = $lang->get('rtl') ? 'prepend' : 'append';
$tip_align = $lang->get('rtl') ? 'left' : 'right';
JHtml::_('formbehavior.chosen', '.dg-select select');
$languages = JLanguage::getKnownLanguages();
?>
<div class="dg-ui dg-select">

  <h3 class="dg-page-title">
    <?= JText::_('COM_DATSOGALLERY_EDIT_ITEM').' '.$this->item->title; ?>
  </h3>
    <div id="dg-edit-page" class="dg-row">
      <div class="dg-col dg-col-4">
        <div style="display:flex; flex-direction:column">
        <div class="member_avatar dg-image" style="position:relative">
          <img class="dgimg" src="<?php echo resize($this->item->original, 400, 500, 0, '1:1', 0, $this->item->catid);?>" alt="" />
          <?php if ($this->settings->image_edit_change_original) : ?>
          <div id="dg-update-avatar" class="hint--bottom hint--medium" data-hint="<?php echo JText::_("COM_DATSOGALLERY_CHANGE_ORIGINAL"); ?>">
            <input class="dg-hiddenFile" name="originalfile" id="originalfile" accept="image/gif, image/jpeg, image/png" type="file">
          </div>
          <?php endif; ?>
        </div>
        <div class="dg-message" style="display:none;margin-top:10px;border-width:1px;border-style:solid;border-radius:20px;padding:10px 15px"></div>
        </div>
      </div>
      <div class="dg-col dg-col-8" style="border-left: none !important">
        <form action="<?php echo JRoute::_('index.php?option=com_datsogallery&task=image.save'); ?>" method="post" id="adminForm" class="form-validate" enctype="multipart/form-data">
          <div>
            <div class="input">
              <i class="dg-icon-<?php echo $icon_dir; ?> dgi-image"></i>
              <input type="text" name="jform[title]" id="jform_title" value="<?php echo $this->item->title ?>"  placeholder="<?php echo JText::_('COM_DATSOGALLERY_IMAGE_TITLE_HINT');?>" />
              <b class="tooltip tooltip-top-<?php echo $tip_align; ?>"><?php echo JText::_('COM_DATSOGALLERY_IMAGE_TITLE_HINT'); ?></b>
            </div>
            <div class="select">
              <div class="dg-icon-<?php echo $icon_dir; ?>"></div>
              <?php echo dg::getOptions($this->item->catid, 'jform[catid]', 'id="catnames" onchange="userCat(this.value);" required="required"'); ?>
              <i></i>
            </div>
          </div>
          <?php if ($this->settings->image_edit_author) : ?>
          <div class="input">
            <i class="dg-icon-<?php echo $icon_dir; ?> dgi-user"></i>
            <input type="text" name="jform[author]" id="jform_author" value="<?= $this->item->author ?>" placeholder="<?php echo JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_PLACEHOLDER');?>" />
            <b class="tooltip tooltip-top-<?php echo $tip_align; ?>"><?php echo JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_HINT');?></b>
          </div>
          <?php endif; ?>
          <?php if ($this->settings->image_edit_author_url) : ?>
          <div class="input">
            <i class="dg-icon-<?php echo $icon_dir; ?> dgi-link"></i>
            <input type="text" name="jform[author_url]" id="jform_author_url" value="<?= $this->item->author_url ?>" placeholder="<?php echo JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_URL_PLACEHOLDER');?>" />
            <b class="tooltip tooltip-top-<?php echo $tip_align; ?>"><?php echo JText::_('COM_DATSOGALLERY_IMAGE_AUTHOR_URL_HINT');?></b>
          </div>
          <?php endif; ?>
          <?php if ($this->settings->image_edit_description) : ?>
          <div>
            <?php
            $config = JFactory::getConfig();
            if ($this->settings->image_edit_editor && $config->get('editor') != 'none') :
              $editor = JEditor::getInstance($config->get('editor'));
              $params = array();
              echo '<div class="dg-editor">'.$editor->display('jform[description]', trim($this->item->description), '100%', '100', '', '', false, null, null, null, $params).'</div>';
            else :
              $description = $this->settings->image_description_html ? $this->item->description : nl2br(trim(strip_tags($this->item->description)));
            ?>
            <div class="textarea textarea-expandable">
              <i class="dg-icon-<?php echo $icon_dir; ?> dgi-image-description"></i>
              <textarea type="textarea" rows="3" name="jform[description]" id="jform_description" placeholder="<?php echo JText::_('COM_DATSOGALLERY_IMAGE_DESCRIPTION_PLACEHOLDER');?>"><?php echo $description; ?></textarea>
              <b class="tooltip tooltip-top-<?php echo $tip_align; ?>"><?php echo JText::_('COM_DATSOGALLERY_FORM_DESC_IMAGE_DESCRIPTION'); ?></b>
            </div>
            <?php endif; ?>
          </div>
          <?php endif; ?>
          <?php if ($this->settings->image_edit_language && JLanguageMultilang::isEnabled() && !dg::falang_involved()) : ?>
          <div class="select">
           <div class="dg-icon-<?php echo $icon_dir; ?>"></div>
           <select id="jform_language" name="jform[language]">
            	<option value="*"><?= JText::_('JFIELD_LANGUAGE_LABEL') ?> - <?= JText::_('JALL'); ?></option>
            	<?= JHtml::_('select.options', $languages, 'tag', 'name', $this->item->language) ?>
           </select>
           <i></i>
          </div>
          <?php endif; ?>
          <?php if ($this->settings->image_edit_geo) : ?>
          <div class="input">
            <i class="dg-icon-<?php echo $icon_dir; ?> dgi-add-location"></i>
            <input id="geocomplete" type="text" placeholder="<?php echo JText::_('COM_DATSOGALLERY_GENERIC_GEO'); ?>" />
            <b class="tooltip tooltip-top-<?php echo $tip_align; ?>"><?php echo JText::_('COM_DATSOGALLERY_GENERIC_GEO_HINT'); ?></b>
          </div>
          <div style="margin-bottom:10px">
            <div class="map_edit"></div>
          </div>
          <div>
            <input name="jform[lat]" id="jform_lat" type="hidden" value="<?php echo $this->item->lat; ?>" />
            <input name="jform[lng]" id="jform_lng" type="hidden" value="<?php echo $this->item->lng; ?>" />
          </div>
          <?php endif; ?>
          <?php
          if ($this->settings->image_edit_tags) {
            foreach ($this->tags as $t) {
              $tags[] = $t->tag;
            }
          ?>
          <div>
            <div class="input tagsarea">
              <i class="dg-icon-<?php echo $icon_dir; ?> dgi-tag"></i>
              <input
                class="tags"
                id="dgtags"
                type="text"
                name="jform[tag]"
                value="<?= implode(',', $tags);?>"
                >
            </div>
          </div>
          <?php } ?>
          <?php if ($this->settings->image_edit_notify) : ?>
          <div class="dg-row">
            <div class="dg-col dg-col-6">
              <div>
                <label class="toggle"><span class="hint--bottom-right hint--medium" data-hint="<?php echo JText::_("COM_DATSOGALLERY_COMMENT_NOTIFICATION_DESC"); ?>"><?php echo JText::_("COM_DATSOGALLERY_COMMENT_NOTIFICATION_LABEL"); ?></span>
                <input type="checkbox" value="<?php echo $this->item->notify; ?>"<?php echo ($this->item->notify == 1 ? ' checked' : ''); ?>>
                <i></i>
                <input type="hidden" name="jform[notify]" id="jform_notify" value="<?php echo $this->item->notify; ?>">
                </label>
              </div>
              <div style="clear:both"></div>
            </div>
            <div class="dg-col dg-col-6">
              <div style="clear:both"></div>
            </div>
          </div>
          <?php endif; ?>
          <div style="display:flex;margin:10px 0">
          <button type="submit" class="btn validate" style="margin-right:10px"><?php echo JText::_('JSUBMIT'); ?></button>
          <a class="btn" href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=image.cancel'); ?>" title="<?php echo JText::_('JCANCEL'); ?>"><?php echo JText::_('JCANCEL'); ?></a>
          </div>
          <input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
          <input type="hidden" name="jform[original]" id="jform_original_hidden" value="<?php echo $this->item->original ?>" />
          <input type="hidden" name="option" value="com_datsogallery" />
          <input type="hidden" name="task" value="image.save" />
          <?php echo JHtml::_('form.token');?>
        </form>
      </div>
    </div>
<?php if ($this->settings->backlink) { ?>
  <div class="backlink">
    <?= dg::backlink() ?>
  </div>
<?php } ?>
</div>
<script>
<?php if ($this->settings->image_edit_geo) : ?>
<?php
$this->item->lat = $this->item->lat ? $this->item->lat : 0;
$this->item->lng = $this->item->lng ? $this->item->lng : 0;
$arr = array($this->item->lat, $this->item->lng);
?>
jQuery(document).ready(function() {
    var colwidth = jQuery("#adminForm").width();
    jQuery('.map_edit').css('width:'+colwidth+'px');
    if (jQuery("input#jform_lat").val('') && jQuery("input#jform_lng").val('')) {
      jQuery('.map_edit').addClass('fb');
    } else {
      jQuery('.map_edit').removeClass('fb');
    }
});
(function($) {
    $(document).ready(function() {
        $("input#jform_lat").val(<?php echo $this->item->lat; ?>);
        $("input#jform_lng").val(<?php echo $this->item->lng; ?>);
        var options = {
            map: ".map_edit",
            location: [<?php echo implode(',',$arr); ?>],
            mapOptions: {
                scrollwheel: true,
                zoom: 10
            },
            markerOptions: {
                draggable: true
            }
        };

        $("#geocomplete").geocomplete(options).on("geocode:result", function(event, result) {
            $("input#jform_lat").val(result.geometry.location.lat());
            $("input#jform_lng").val(result.geometry.location.lng());
        }).on("geocode:dragged", function(event, latLng) {
            $("input#jform_lat").val(latLng.lat());
            $("input#jform_lng").val(latLng.lng());
            $("#geocomplete").geocomplete("find", latLng.toString());
        });

    });
})(jQuery);
<?php endif; ?>
<?php if ($this->settings->image_edit_tags) : ?>
jQuery(document).ready(function() {
    jQuery('#dgtags').tagsInput({
        'defaultText': '<?php echo JText::_("COM_DATSOGALLERY_ADD_TAG");?>',
        'removeWithBackspace': true,
        'minChars': <?= $this->settings->min_tag_chars ?>
    });
});
<?php endif; ?>
jQuery(function(){
   jQuery('.toggle input:checkbox').each(function(){
      jQuery(this).click(function(){
        if (jQuery(this).next().next().val() == '1') {
          jQuery(this).prop('checked', false);
          jQuery(this).next().next().val('0');
        } else {
          jQuery(this).prop('checked', true);
          jQuery(this).next().next().val('1');
        }
      });
   });
});
</script>
<?php
if ($user->id && $this->settings->image_edit_change_original) {
  $doc = JFactory::getDocument();
  $doc->addScript(JUri::base(true).'/components/com_datsogallery/assets/js/upload.min.js');
  dg::jslang('upload.min.js');
?>
<script>
function uploaded(e, p) {
    var newfile = e.uploadList[p].name;
    jQuery.post(ajax_url + '&task=image.updateoriginal', {
        id: '<?php echo $this->item->id; ?>',
        catid: '<?php echo $this->item->catid; ?>',
        original: '<?php echo $this->item->original; ?>',
        newfile: newfile
      }, function(data) {
      jQuery('.member_avatar img').attr('src', data + '?dt=' + (+new Date()));
      jQuery('#jform_original_hidden').prop('disabled', true);
      jQuery('#dg-edit-page .dg-message').addClass('dg-success').show();
      jQuery('#dg-edit-page .dg-message').text('<?= JText::_('COM_DATSOGALLERY_ITEM_SAVED_SUCCESSFULLY') ?>');
      setTimeout(function(){
          jQuery('#dg-edit-page .dg-message').removeClass('dg-success').fadeOut('fast', function() {
            jQuery(".avr-msg, .dg-uploadItem").remove();
          });
      }, 3000);
    });
}
function failed(u, p, e) {
  jQuery('#dg-edit-page .dg-message').addClass('dg-danger').show();
  jQuery('#dg-edit-page .dg-message').text(e);
  setTimeout(function(){
      jQuery('#dg-edit-page .dg-message').removeClass('dg-danger').fadeOut('fast', function() {
          jQuery(".avr-msg, .dg-uploadItem").remove();
       });
  }, 3000);
}
window.onload = function() {
  var uploadSettings = {
    'text': '<?= JText::_("Upload a file") ?>',
    'method': 'POST',
    'action': ajax_url + '&task=image.originalupload&id=<?= $this->item->id ?>',
    'avatar': true,
    'encoding': false,
    'extension': <?= json_encode(array_unique(explode(',', strtolower($this->settings->extensions)))) ?>,
    'callbackSuccess': uploaded,
    'callbackError': failed,
    'maxWidth': <?= $this->settings->upload_max_width ?>,
    'maxHeight': <?= $this->settings->upload_max_height ?>,
    'maxFileSize': '<?= dg::maxuploadsize() ?>',
  };
  var uploader = document.getElementById('originalfile');
  var uploadForm = new RealTimeUpload(uploadSettings, uploader);
}
</script>
<?php
}