<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$doc  = JFactory::getDocument();
$user = JFactory::getUser();
$lang = JFactory::getLanguage();
$lang->load('com_datsogallery', JPATH_ADMINISTRATOR);
$is_rtl  = $lang->get('rtl');
$groups  = $user->getAuthorisedViewLevels();
$canEdit = $user->authorise('core.edit', 'com_datsogallery.image.' . $this->item->id);
if ($canEdit || $user->authorise('core.edit.own', 'com_datsogallery.image.' . $this->item->id)) {
  $canEdit = $user->id == $this->item->created_by;
}
$canDelete = $user->authorise('core.delete', 'com_datsogallery.image.' . $this->item->id);
if ($canDelete || $user->authorise('core.delete.own', 'com_datsogallery.image.' . $this->item->id)) {
  $canDelete = $user->id == $this->item->created_by;
}
if ($this->item):
  $dgcaptch  = ($this->settings->comments_captcha && !$user->id) ? 'true' : 'false';
  $dgcaptchr = ($this->settings->report_captcha && !$user->id) ? 'true' : 'false';
  $gps       = dg::read_gps_location($this->item->original);
  $geo       = ($this->item->lat && $this->item->lng) ? 1 : (!empty($gps) ? 1 : 0);
  $lat       = $this->item->lat ? $this->item->lat : (!empty($gps) && $gps['lat'] ? $gps['lat'] : 0);
  $lng       = $this->item->lng ? $this->item->lng : (!empty($gps) && $gps['lng'] ? $gps['lng'] : 0);
  $js        = "var geo = " . $geo . ";\n";
  $js .= "var dgcaptch = " . $dgcaptch . ";\n";
  $js .= "var dgcaptchr = " . $dgcaptchr . ";\n";
  $js .= "var image_lat = " . $lat . ";\n";
  $js .= "var image_lng = " . $lng . ";";
  $doc->addScriptDeclaration($js);
  if (!empty($this->item->description) && $this->settings->image_description_triggering) {
    JPluginHelper::importPlugin('content');
    $this->item->description = JHtml::_('content.prepare', $this->item->description);
  } else {
    $this->item->description = preg_replace('/[\[{\(].*[\]}\)]/U', '', $this->item->description);
  }
?>
	<div id="image" class="dg-ui">

	   <div style="margin-bottom:10px"><?php echo JHtml::_('datsogallery.search'); ?></div>

	<div>
	  <div id="dg-nav" class="dg-inline">
	      <div class="dg-spiner"></div>
	      <img src="<?=JHtml::_('datsogallery.image', $this->item->original, $this->item->id, $this->item->catid, 'image');?>" alt="<?=$this->item->title;?>"<?=dg::is_anim($this->item->original, $this->item->catid);?> <?=get_width_height($this->item->original, $this->settings->image_width_details, $this->settings->image_height_details, $this->item->catid, $this->settings->image_aspect_ratio_details);?> />
	<div class="position-cover hover-load">
	<?php echo dg::dgpagenav($this->item->id); ?>
	</div>
	</div>

	<div class="dg-image-data">
	  <ul class="dg-first-column">
	    <li>
	      <?php if ($this->settings->image_title) {?>
	        <h1 class="dg-h3" itemprop="name">
	          <?=$this->item->title;?>
	        </h1>
	        <?php }?>
	        <ul class="owner-rating">
	        <?php if ($this->settings->allow_avatar && $this->settings->image_avatar) {?>
	        <li>
	          <?=dg::avatar($this->item->created_by, null, false, true, false, 'comments');?>
	        </li>
	        <?php }?>
<?php if ($this->settings->image_owner || $this->settings->image_date) {?>
	        <li>
	          <meta itemprop="datePublished" content="<?=$this->item->created;?>">
	          <ul class="owner-name">
	            <?php if ($this->settings->image_owner) {?>
	            <li>
	              <?=JText::_('COM_DATSOGALLERY_BY');?>
	              <?=$this->owner->name;?>
	            </li>
	            <?php
              } if ($this->settings->image_date) {?>
	            <li>
	              <?=dg::timelapse($this->item->created, $this->settings->image_date_format);?>
	            </li>
	            <?php }?>
	          </ul>
	        </li>
	        <?php }?>
	        <li>
	          <i class="dgi-bell-on gray"></i>
	        </li>
	        </ul>
	      <?php if ($this->settings->image_description && !empty($this->item->description)) {?>
	      <div class="dg-image-page-description dg-more" itemprop="description">
	        <?=!$this->settings->image_description_html ? $this->item->description : nl2br(trim(strip_tags($this->item->description)));?>
	      </div>
	      <?php }?>
	    </li>
	    <?php if ($this->settings->allow_comments && $this->settings->image_comments) {?>
	    <li>
	      <?=$this->loadTemplate('comments');?>
	    </li>
	    <?php }?>
	  </ul>
	  <ul class="dg-second-column">
	    <li>
	    <?=JHtml::_('datsogallery.actions', $this->item->id, $geo, $this->item->created_by, $this->likes);?>
<?php if ($this->settings->image_tags && in_array($this->settings->tags_access, $groups) && count($this->tags) > 0) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li class="dg-tags"><i class="dgi-tag"></i></li>
	      <li><?=$this->loadTemplate('tags');?></li>
	    </ul>
	    <?php
          }
        if ($this->settings->extract_color && count($this->colors)) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap dg-image-colors">
	      <li><i class="dgi-palette"></i></li>
	      <li>
	        <ul>
	          <?php foreach (dg::sort_hex_colors($this->colors) as $hex) {?>
	          <li style="width:calc(100% / <?=count($this->colors);?>);background-color:#<?=$hex;?>" class="hint--top" data-hint="#<?=$hex;?>">
	             <a href="<?=JRoute::_('index.php?option=com_datsogallery&amp;view=colors&amp;hex=' . $hex . dg::itemId());?>"></a>
	          </li>
	          <?php }?>
	        </ul>
	      </li>
	    </ul>
	    <?php }?>

	    <?php if ($this->settings->allow_rating && in_array($this->settings->rating_access, $groups)) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li><i class="dgi-likes"></i></li>
	      <li><?=JText::sprintf('COM_DATSOGALLERY_DETAILS_LIKES', '<span id="numlikes">' . dg::numlikes($this->item->id) . '</span>');?></li>
	    </ul>
	    <?php
          }
        if ($this->settings->image_hits) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li><i class="dgi-visibility"></i></li>
	      <li><?=JText::sprintf('COM_DATSOGALLERY_DETAILS_VIEWS', '<span id="numhits">' . dg::human_number($this->item->hits) . '</span>');?></li>
	    </ul>
	    <?php
          }
        if ($this->settings->allow_downloads && $this->settings->image_downloads) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li><i class="dgi-download"></i></li>
	      <li><?=JText::sprintf('COM_DATSOGALLERY_DETAILS_DOWNLOADS', '<span id="numdownloads">' . dg::human_number($this->item->downloads) . '</span>');?></li>
	    </ul>
	    <?php
          }
        if ($this->settings->allow_comments && $this->settings->image_comments) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li><i class="dgi-comments"></i></li>
	      <li><?=JText::sprintf('COM_DATSOGALLERY_DETAILS_COMMENTS', '<span id="numcomments">' . dg::numcomments($this->item->id) . '</span>');?></li>
	    </ul>
	    <?php } ?>

      <?php if ($this->settings->image_info && in_array(1, array($this->settings->image_file_size,$this->settings->image_dimensions,$this->settings->image_file_type))) { ?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li><i class="dgi-image"></i></li>
	      <li><span id="imagedata"><?=dg::image_data($this->item->original);?></span></li>
	    </ul>
      <?php } ?>
      
	    <?php if ($this->settings->image_copyrights && !empty($this->item->author)) {?>
	    <ul class="dg-flex-margin-5 dg-flex-nowrap">
	      <li><i class="dgi-copyright"></i></li>
	      <li>
	        <?php
              $copyright = ($this->item->author && $this->item->author_url) ? '<a rel="nofollow" href="' . dg::addhttp($this->item->author_url) . '" itemprop="author" target="_blank">' . $this->item->author . '</a>' : ($this->item->author ? '<span itemprop="author">' . $this->item->author . '</span>' : '');
                echo '<span class="hint--top" data-hint="' . JText::_("COM_DATSOGALLERY_IMAGE_DATA_AUTHOR") . '">' . $copyright . '</span>';
              ?>
	      </li>
	    </ul>
	    <?php
          }
        if ($this->settings->image_exif && dg::exif_data($this->item->original)) {?>
	    <h4 class="dg-h4 dg-separator"><?=JText::_("Exif");?></h4>
	    <?=dg::exif_data($this->item->original);?>
      <?php } ?>
	    </li>
	    <li>
	      <?php
            if ($this->settings->image_related) {
              echo $this->loadTemplate('related');
            }
          ?>
	    </li>
	  </ul>
	</div>
	<?php
    endif;
  ?>
</div>
<?php if ($this->settings->backlink): ?>
<div class="backlink">
  <?= dg::backlink() ?>
</div>
<?php
endif;
echo JHtml::_(
    'bootstrap.renderModal',
    'modalMap',
    array(
      'title' => JText::_("COM_DATSOGALLERY_MAP"),
      'footer' => $this->loadTemplate('map_footer')
    ),
    $this->loadTemplate('map')
);
echo JHtml::_(
    'bootstrap.renderModal',
    'modalShare',
    array(
      'title' => JText::_("COM_DATSOGALLERY_SHARE"),
      'footer' => $this->loadTemplate('share_footer')
    ),
    $this->loadTemplate('share')
);
echo JHtml::_(
    'bootstrap.renderModal',
    'modalReport',
    array(
      'title' => JText::_("COM_DATSOGALLERY_REPORT_IMAGE"),
      'footer' => $this->loadTemplate('report_footer'),
    ),
    $this->loadTemplate('report')
); ?>
</div>
<script>
jQuery(document).ready(function() {
  jQuery('body').addClass('dg-image-page');
});
</script>
