<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewFavorites extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $state;
  protected $params;

  public function display($tpl = null)
  {
    $app              = JFactory::getApplication();
    $user             = JFactory::getUser();
    $groups           = $user->getAuthorisedViewLevels();
    $this->state      = $this->get('State');
    $this->items      = $this->get('Items');
    $this->pagination = $this->get('Pagination');
    $menu             = $app->getMenu();
    $access           = $menu->getActive()->access;
    if (!in_array($access, $groups) || !$user->id) {
      $app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'warning');
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories' . dg::itemId(true), false));
    }
    $members_ids          = $menu->getItems('link', 'index.php?option=com_datsogallery&view=members');
    $this->members_itemid = isset($members_ids[0]) ? '&Itemid=' . $members_ids[0]->id : '';
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $this->params   = $app->getParams('com_datsogallery');
    $this->settings = dg::getConfig();
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app   = JFactory::getApplication();
    $menus = $app->getMenu();
    $menu  = $menus->getActive();
    if ($menu->query['view'] == 'favorites') {
      $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
      $this->document->setTitle($menu->title);
    } else {
      $this->params->def('page_heading', JText::_('COM_DATSOGALLERY_FAVORITES'));
      $this->document->setTitle(JText::_('COM_DATSOGALLERY_FAVORITES'));
    }
    if ($this->params->get('robots')) {
      $this->document->setMetadata('robots', $this->params->get('robots'));
    }
    if ($menu->query['view'] != 'favorites') {
      $pathway = $app->getPathway();
      $pathway->addItem(JText::_('COM_DATSOGALLERY_FAVORITES'), '');
    }
  }
}
