<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewColors extends JViewLegacy
{
  protected $items;
  protected $pagination;
  protected $state;
  protected $params;

  public function display($tpl = null)
  {
    $app              = JFactory::getApplication();
    $this->settings   = dg::getConfig();
    $this->state      = $this->get('State');
    $this->items      = $this->get('Items');
    $this->allcolors  = $this->get('AllColors');
    $this->pagination = $this->get('Pagination');
    if (!$this->settings->extract_color) {
      $app->enqueueMessage(JText::_('JERROR_ALERTNOAUTHOR'), 'error');
      $app->setHeader('status', 403, true);
      $app->redirect(JRoute::_('index.php?option=com_datsogallery&view=categories' . dg::itemId(), false));
    }
    $menu                 = $app->getMenu();
    $members_ids          = $menu->getItems('link', 'index.php?option=com_datsogallery&view=members');
    $this->members_itemid = isset($members_ids[0]) ? '&Itemid=' . $members_ids[0]->id : '';
    $model                = $this->getModel();
    $model->hit();
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    $this->params = $app->getParams('com_datsogallery');
    $this->_prepareDocument();
    parent::display($tpl);
  }

  protected function _prepareDocument()
  {
    $app   = JFactory::getApplication();
    $menus = $app->getMenu();
    $title = null;
    $menu  = $menus->getActive();
    if ($menu) {
      $this->params->def('page_heading', $this->params->get('page_title', $menu->title));
    } else {
      $this->params->def('page_heading', JText::_('COM_DATSOGALLERY_DEFAULT_PAGE_TITLE'));
    }
    $pathway = $app->getPathway();
    $pathway->addItem(JText::_('COM_DATSOGALLERY_COLORS'), '');
    $title = JText::sprintf('COM_DATSOGALLERY_MATCHES_FOR_COLOR', '#' . $this->items[0]->hex);
    $this->document->setTitle($title);
  }
}
