<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$items = count($this->items);
$do_grid = $items > 0 ? 'dg-grid' : 'dg-nogrid';
if ($this->settings->category_description) {
  $description = dg::checkdesc($this->category->description);
  if (!empty($description) && $this->settings->category_description_triggering) {
    JPluginHelper::importPlugin('content');
    $this->category->description = JHtml::_('content.prepare', $this->category->description);
  } else {
    $this->category->description = dg::removetags($this->category->description);
  }
}
$html = '<div class="dg-ui">';
$html .= '<h3 class="dg-page-title">';
$html .= $this->params->get('page_heading') ? $this->params->get('page_heading') : $this->category->title;
$html .= '</h3>';
if ($this->settings->category_description && !empty($description)) {
$html .= '<div class="dg-description dg-more">';
$html .= $this->category->description;
$html .= '</div>';
}
$html .= JHtml::_('datsogallery.search');
$html .= '<div id="dg-category" class="'.$do_grid.'"';
$html .= ' data-container-breakpoints="' . $this->settings->category_container_breakpoints . '"';
$html .= ' data-breakpoint-xl="' . $this->settings->category_breakpoint_xl . '"';
$html .= ' data-breakpoint-l="' . $this->settings->category_breakpoint_l . '"';
$html .= ' data-breakpoint-m="' . $this->settings->category_breakpoint_m . '"';
$html .= ' data-breakpoint-s="' . $this->settings->category_breakpoint_s . '"';
$html .= ' data-margin-y="' . ($this->settings->category_details ? 0 : $this->settings->category_margin_y) . '"';
$html .= ' data-margin-x="' . $this->settings->category_margin_x . '">';
if (count($this->items) > 0) {
  foreach ($this->items as $item) {
    $covers  = dg::catcover($item->id);
    $parents = dg::getparents($item->id);
    $html .= '<div id="image-' . $item->id . '" class="dg-grid-item">';
    if (strpos($item->view, 'category') !== false) {
      $category_image = dg::category_image($item->image_id);
      $html .= '<div class="image-block dg-album">';
      $html .= '<a href="' . $item->href . '">';
      if ($item->image_id) {
        $html .= '<img class="dgimg" src="' . JHtml::_('datsogallery.image', $category_image, $item->id, 0, 'categories') . '" alt="' . $item->title . '" />';
      } else if ($this->settings->categories_view_type == 1) {
        $inc = (4 - count($covers));
        if ($inc != 0) {
          for ($x = 1; $x <= $inc; $x++) {
            array_push($covers, $x);
          }
        }
        $html .= '<ul class="dg-cover-foursquare">';
        foreach ($covers as $cover) {
          $html .= '<li><img class="'.(isset($cover->original) && dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" class="dgimg" src="' . JHtml::_('datsogallery.image', (isset($cover->original) ? $cover->original : 'no_image.png'), $item->id, 0, 'categories', 1, '1:1') . '" alt="' . $item->title . '" /></li>';
        }
        $html .= '</ul>';
      } else if ($this->settings->categories_view_type == 2) {
      $inc = (3 - count($covers));
      if ($inc != 0) {
        for ($x = 1; $x <= $inc; $x++) {
          array_push($covers, $x);
        }
      }
      $html .= '<ul class="dg-cover-trio">';
      $i = 1;
      foreach ($covers as $cover) {
          if ($i == 1) {
            $html .= '<li class="dg-cover-leading dg-cover-pos">';
            $html .= '<img class="'.(isset($cover->original) && dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" src="' . JHtml::_('datsogallery.image', (isset($cover->original) ? $cover->original : 'no_image.png'), $item->id, 0, 'categories', 1, '3:2', true) . '" alt="' . $item->title . '" />';
            $html .= '</li>';
          }
          if (in_array($i, array(2,3))) {
            $html .= $i == 2 ? '<ul class="dg-cover-column">' : '';
            $html .= '<li class="dg-cover-grow dg-cover-pos">';
            $html .= '<img class="'.(isset($cover->original) && dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" src="' . JHtml::_('datsogallery.image', (isset($cover->original) ? $cover->original : 'no_image.png'), $item->id, 0, 'categories', 1, '1:1') . '" alt="' . $item->title . '" />';
            $html .= '</li>';
            $html .= $i == 3 ? '</ul>' : '';
          }
$html .= '</li>';
        $i++;
      }
      $html .= '</ul>';
      } else {
        if (count($covers)) {
          foreach ($covers as $cover) {
            $html .= '<img class="'.(dg::is_alpha_png($cover->original) ? 'dgimg dg-has-alpha' : 'dgimg').'" src="' . JHtml::_('datsogallery.image', $cover->original, $item->id, 0, 'categories') . '" alt="' . $item->title . '" />';
          }
        } else {
          $html .= '<img class="dgimg" src="' . JHtml::_('datsogallery.image', 'no_image.png', $item->id, 0, 'categories') . '" alt="no_image" />';
        }
      }
      $html .= '</a>';
      $html .= JHtml::_('datsogallery.details', $item->id, $item->pc_user_id, $item->title, $item->pc_user_name, $item->created_time, $item->href, 'categories');
      $html .= JHtml::_('datsogallery.stats', $item->id, $parents, 0, 0, '', 0, 0, 0, '', '', '', 'categories');
      $html .= '</div>';
      if ($this->settings->categories_details) {
        $html .= '<div class="image-card">';
        if ($this->settings->categories_title && !$this->settings->categories_title_position) {
          $html .= '<h4 class="image-title"><a href="' . $item->href . '">' . $item->title . '</a></h4>';
        }
        if ($this->settings->categories_description) {
          $html .= '<p class="image-desc">' . strip_tags($item->description) . '</p>';
        }
        $html .= '</div>';
      }
    }
    if (strpos($item->view, 'image') !== false) {
      $buttons = array('zoom' => $this->settings->fancybox_buttons_zoom,
        'slideShow' => $this->settings->fancybox_buttons_slideshow,
        'fullScreen' => $this->settings->fancybox_buttons_fullscreen,
        'close' => $this->settings->fancybox_buttons_close
      );
      $html .= '<div class="image-block' . (strpos($item->view, 'category') !== false ? ' dg-album' : ' dg-image') . '">';
      $html .= '<div class="dg-spiner"></div>';
      $html .= '<a id="' . $item->id . '" href="' . $item->href . '">';
      $html .= '<img src="' . JHtml::_('datsogallery.image', $item->original, $item->id, $item->catid, 'category') . '" alt="' . $item->title . '" ' . dg::is_anim($item->original, $item->catid) . ' ' . get_width_height($item->original, $this->settings->category_image_width, $this->settings->category_image_height, $item->catid, $this->settings->category_image_aspect_ratio) . ' /></a>';
      if ($this->settings->allow_fancybox && $this->settings->category_fancybox) {
        $html .= '<div id="' . $item->id . '"';
        $html .= ' class="dg-fb dg-fb-icon"';
        $html .= ' data-buttons=\'' . json_encode(array_keys(array_filter($buttons))) . '\'';
        $html .= ' data-animationeffect="' . $this->settings->fancybox_animationeffect . '"';
        $html .= ' data-animationduration="' . $this->settings->fancybox_animationduration . '"';
        $html .= ' data-transitioneffect="' . $this->settings->fancybox_transition . '"';
        $html .= ' data-transitionduration="' . $this->settings->fancybox_transitionduration . '"';
        $html .= ' data-autostart="' . $this->settings->fancybox_autostart . '"';
        $html .= ' data-speed="' . $this->settings->fancybox_autostart_speed . '"';
        $html .= ' title="' . JText::_("COM_DATSOGALLERY_ENLARGE_SB") . '">';
        $html .= '</div>';
      }
      $html .= JHtml::_('datsogallery.details', $item->id, $item->user_id, $item->title, $item->user_name, $item->created, $item->href, 'category', $item->catid);
      $html .= JHtml::_('datsogallery.stats', $item->id, null, $item->user_id, $item->user_name, $item->original, $item->featured, $item->hits, $item->downloads, $item->href, $item->title, $item->created, 'category');
      $html .= '</div>';
      if ($this->settings->category_details) {
        $html .= '<div class="image-card">';
        if ($this->settings->category_title && $this->settings->category_title_position == 0) {
          $html .= '<h4 class="image-title"><a href="' . $item->href . '">' . $item->title . '</a></h4>';
        }
        if ($this->settings->category_image_description) {
          $html .= '<p class="image-desc">' . strip_tags($item->description) . '</p>';
        }
        $html .= '</div>';
      }
    }
    $html .= '</div>';
  }
} else {
  $html .= '<div class="dg-message-info">';
  $html .= '<p>' . JText::_('COM_DATSOGALLERY_NO_ITEMS') . '</p>';
  $html .= '</div>';
}
$html .= '</div>';
$html .= '<div class="ias-conteiner"></div>';
if ($this->pagination->limit < $this->pagination->total) {
  $html .= '<div class="dg-pagination' . ($this->settings->category_pagination_type ? ' dg-hidden' : '') . '">';
  if (!$this->settings->category_pagination_type) {
    $html .= '<p class="counter pull-right">';
    $html .= $this->pagination->getPagesCounter();
    $html .= '</p>';
  }
  $html .= $this->pagination->getPagesLinks();
  $html .= '</div>';
}
if ($this->settings->backlink) {
  $html .= '<div class="backlink">';
  $html .= dg::backlink();
  $html .= '</div>';
}
$html .= '</div>';
echo $html;
$doc = JFactory::getDocument();
$doc->addScriptDeclaration('var dgrid = ".dg-grid";');
if ($this->settings->category_pagination_type) {
  $ias = ($this->pagination->limit >= $this->pagination->total) ? 'true' : 'false';
  $doc->addScriptDeclaration('var iasdestroy = ' . $ias . ';');
  $doc->addScriptDeclaration('var dgoffset = ' . (int) $this->settings->pagination_offset . ';');
} else {
  $doc->addScriptDeclaration('var iasdestroy = true;');
}