<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_COMPONENT_ADMINISTRATOR . '/models/image.php';

class DatsogalleryModelUpload extends DatsogalleryModelImage
{

  public function add_member_album()
  {
    $app      = JFactory::getApplication();
    $access   = $app->get('access');
    $settings = dg::getConfig();
    $user     = JFactory::getUser();
    $date     = JFactory::getDate();
    if (!dg::is_root() && $settings->users_categories) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('id');
      $query->from('#__datsogallery_categories');
      $query->where('parent_id = ' . (int) $settings->members_category);
      $query->where('created_by = ' . $user->id);
      $db->setQuery($query);
      $result = $db->loadResult();
      if (!$result) {
        $table            = JTable::getInstance('Category', 'DatsogalleryTable');
        $mc               = new stdClass();
        $mc->title        = $user->name;
        $mc->alias        = dg::sanitize($user->name);
        $mc->description  = JText::sprintf('COM_DATSOGALLERY_NEW_ALBUM_DESC', $user->name);
        $mc->published    = 1;
        $mc->approved     = (($settings->users_categories && !$settings->category_approval) || $isroot) ? 1 : 0;
        $mc->access       = $access;
        $mc->created_by   = $user->id;
        $mc->created_time = $date->toSql();
        $mc->language     = '*';
        $mc->parent_id    = (int) $settings->members_category;
        $mc->ordering     = $table->getNextOrder('parent_id = ' . (int) $settings->members_category);
        $result           = $db->insertObject('#__datsogallery_categories', $mc);
        if ($result) {
          if (!$table->rebuild($table->id, $table->lft, $table->level, $table->path)) {
            $this->setError($table->getError());
            return false;
          }
        }
        return true;
      }
    }
  }
}
