<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.modellist');

class DatsogalleryModelTags extends JModelList
{

  public function __construct($config = array())
  {
    parent::__construct($config);
  }

  protected function populateState($ordering = null, $direction = null)
  {
    $app      = JFactory::getApplication();
    $settings = dg::getConfig();
    $params   = JComponentHelper::getParams('com_datsogallery');
    $tag      = urldecode($app->input->getString('tag', ''));
    $tag      = JString::strtolower($tag);
    $tag      = trim($tag);
    $this->setState('list.tag', $tag);
    $limit = $app->input->get('limit', $settings->category_per_page, 'uint');
    $this->setState('list.limit', $limit);
    $limitstart = $app->input->get('limitstart', 0, 'uint');
    $this->setState('list.start', $limitstart);
    $this->setState('filter.language', JLanguageMultilang::isEnabled());
    $this->setState('params', $params);
  }

  protected function getListQuery()
  {
    $user     = JFactory::getUser();
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    $current_lang = JFactory::getLanguage()->getTag();
    $default_lang = JComponentHelper::getParams('com_languages')->get('site');
    $db       = $this->getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $query    = $db->getQuery(true);
    $query->select($this->getState('list.select', 'a.id, a.catid, a.title, a.description, a.original, a.featured, a.hits, a.downloads, a.created_by, a.created, u.id AS user_id, u.name AS user_name, u.email AS user_email, t.tag'));
    $query->from($db->qn('#__datsogallery_images', 'a'));
    $query->where($db->qn('a.access') . ' IN (' . $groups . ')');
    $query->where($db->qn('a.state') . ' = 1');
    $query->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    $query->select(array('u.id AS user_id', 'u.name AS user_name', 'u.email AS user_email'));
    $query->join('LEFT', $db->qn('#__users', 'u') . ' ON u.id = a.created_by');
    $query->select(array('c.title AS ca_title', 'c.path AS ca_path', 'c.created_by AS ca_created_by', 'c.created_time AS ca_created_time'));
    $query->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON c.id = a.catid');
    $query->where($db->qn('c.access') . ' IN (' . $groups . ')');
    $query->where($db->qn('c.published') . ' = 1');
    $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    $query->join('LEFT', $db->qn('#__datsogallery_tags', 't') . ' ON t.image_id = a.id');
    if (dg::falang_involved() && $current_lang != $default_lang) {
      $query->join('LEFT', $db->qn('#__falang_content', 'f') . ' ON f.reference_id = t.id');
      $query->where($db->qn('f.reference_field') . ' = ' . $db->q('tag'));
      $query->where($db->qn('f.value') . ' LIKE ' . $db->q('%' . $db->escape($this->getState('list.tag'), true) . '%', false));
    } else {
      $query->where($db->qn('t.tag') . ' LIKE ' . $db->q('%' . $db->escape($this->getState('list.tag'), true) . '%', false));
    }
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q($current_lang) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q($current_lang) . ',' . $db->q('*') . ')');
    }
    $query->group('a.id');
    $query->order('t.tag DESC');
    return $query;
  }

  public function getItems()
  {
    return parent::getItems();
  }

  public function hit()
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->update($db->qn('#__datsogallery_tags'))
      ->set($db->qn('count') . '= count + 1')
      ->where($db->qn('tag') . ' = ' . $db->q($this->getState('list.tag')));
    $db->setQuery($query);
    return $db->execute();
  }
}
