<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class DatsogalleryModelSearch extends JModelList
{

  public function __construct()
  {
    parent::__construct();
  }

  protected function populateState($ordering = null, $direction = null)
  {
    $app      = JFactory::getApplication();
    $params   = JComponentHelper::getParams('com_datsogallery');
    $settings = dg::getConfig();
    $search   = $this->getUserStateFromRequest('com_datsogallery.filter.search', 'searchword');
    $this->setState('filter.search', $search);
    $limit = $app->input->get('limit', $settings->category_per_page, 'uint');
    $this->setState('list.limit', $limit);
    $limitstart = $app->input->get('limitstart', 0, 'uint');
    $this->setState('list.start', $limitstart);
    $orderCol = $app->input->get('filter_order', 'ordering');
    if (!in_array($orderCol, $this->filter_fields)) {
      $orderCol = 'a.id';
    }
    $this->setState('list.ordering', $orderCol);
    $listOrder = $app->input->get('filter_order_Dir', 'ASC');
    if (!in_array(strtoupper($listOrder), array('ASC', 'DESC', ''))) {
      $listOrder = 'DESC';
    }
    $this->setState('list.direction', $listOrder);
    $user = JFactory::getUser();
    $this->setState('filter.language', JLanguageMultilang::isEnabled());
    $this->setState('params', $params);
  }

  protected function getListQuery()
  {
    $user     = JFactory::getUser();
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    $current_lang = JFactory::getLanguage()->getTag();
    $default_lang = JComponentHelper::getParams('com_languages')->get('site');
    $db       = $this->getDbo();
    $nullDate = $db->quote($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->quote($date->toSql());
    $query    = $db->getQuery(true);
    $query->select($this->getState('list.select', 'a.id, a.catid, a.title, a.description, a.original, a.featured, a.hits, a.downloads, a.created_by, a.created, u.id AS user_id, u.name AS user_name, u.email AS user_email'));
    $query->from($db->qn('#__datsogallery_images', 'a'));
    $query->where($db->qn('a.access') . ' IN (' . $groups . ')');
    $query->where($db->qn('a.state') . ' = 1');
    $query->where($db->qn('a.approved') . ' = 1');
    $query->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    $query->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON ' . $db->qn('a.catid') . ' = ' . $db->qn('c.id'));
    $query->where($db->qn('c.access') . ' IN (' . $groups . ')');
    $query->where($db->qn('c.published') . ' = 1');
    $query->where($db->qn('c.approved') . ' = 1');
    $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    $query->join('LEFT', $db->qn('#__users', 'u') . ' ON ' . $db->qn('a.created_by') . ' = ' . $db->qn('u.id'));
    $query->join('LEFT', $db->qn('#__users', 'uc') . ' ON ' . $db->qn('c.created_by') . ' = ' . $db->qn('uc.id'));
    $search = $this->getState('filter.search');
    if (!empty($search)) {
      $search = $db->q('%' . $db->escape($search, true) . '%');
      if (dg::falang_involved() && $current_lang != $default_lang) {
        $query->join('LEFT', $db->qn('#__falang_content', 'f') . ' ON f.reference_id = a.id');
        $query->where($db->qn('f.reference_field') . ' IN (' . $db->q('title') . ',' . $db->q('description') . ',' . $db->q('metadesc') . ')');
        $query->where($db->qn('f.value') . ' LIKE ' . $search);
      } else {
        $query->where('( a.title LIKE ' . $search . '  OR  a.description LIKE ' . $search . '  OR  a.metadesc LIKE ' . $search . ' )');
      }
    }
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q($current_lang) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q($current_lang) . ',' . $db->q('*') . ')');
    }
    $query->group('a.id');
    $query->order('a.id DESC');
    return $query;
  }

  public function getItems()
  {
    $results = array();
    $user    = JFactory::getUser();
    $groups  = implode(',', $user->getAuthorisedViewLevels());
    $current_lang = JFactory::getLanguage()->getTag();
    $default_lang = JComponentHelper::getParams('com_languages')->get('site');
    $app     = JFactory::getApplication();
    $jinput  = $app->input;
    $search  = $this->getState('filter.search');
    if (!empty($search)) {
      $limit      = $this->getState('list.limit');
      $limitstart = $jinput->get('limitstart', 0, 'int');
      $db         = $this->getDbo();
      $nullDate   = $db->quote($db->getNullDate());
      $date       = JFactory::getDate();
      $nowDate    = $db->quote($date->toSql());
      $query      = $db->getQuery(true);
      if ($limit > 0) {
        $query->select($this->getState('list.select', 'c.*, u.id AS pc_user_id, u.name AS pc_user_name'));
        $query->from($db->qn('#__datsogallery_categories', 'c'));
        $query->join('LEFT', $db->qn('#__users', 'u') . ' ON ' . $db->qn('c.created_by') . ' = ' . $db->qn('u.id'));
        $query->where($db->qn('c.parent_id') . ' > 0');
        $query->where($db->qn('c.access') . ' IN (' . $groups . ')');
        $query->where($db->qn('c.published') . ' = 1');
        $query->where($db->qn('c.approved') . ' = 1');
        $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
        $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
        $search = $db->q('%' . $db->escape($search, true) . '%');
        if (dg::falang_involved() && $current_lang != $default_lang) {
          $query->join('LEFT', $db->qn('#__falang_content', 'f') . ' ON f.reference_id = c.id');
          $query->where($db->qn('f.reference_field') . ' IN (' . $db->q('title') . ',' . $db->q('description') . ',' . $db->q('metadesc') . ')');
          $query->where($db->qn('f.value') . ' LIKE ' . $search);
        } else {
          $query->where('( c.title LIKE ' . $search . '  OR  c.description LIKE ' . $search . '  OR  c.metadesc LIKE ' . $search . ' )');
        }
        if (JLanguageMultilang::isEnabled()) {
          $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
        }
        $query->group('c.id');
        $query->order('c.id ASC LIMIT ' . $limitstart . ', ' . $limit);
        $db->setQuery($query);
        $nitems = $db->loadObjectList();
        $limit -= count($nitems);
        $rows = array();
        if (count($nitems) > 0) {
          foreach ($nitems as $key => $item) {
            $nitems[$key]->view = "category";
            $nitems[$key]->href = JRoute::_("index.php?option=com_datsogallery&amp;view=category&amp;catid=" . $item->id . dg::menuid($item->id));
          }
        }
        $rows[] = $nitems;
      }
      if ($limit > 0) {
        $items = parent::getItems();
        $limit -= count($items);
        if (count($items) > 0) {
          foreach ($items as $key => $item) {
            $items[$key]->view = "image";
            $items[$key]->href = JRoute::_('index.php?option=com_datsogallery&view=image&id=' . $item->id . '&catid=' . $item->catid . dg::menuid($item->catid));
          }
        }
        $rows[] = $items;
      }
      if (count($rows)) {
        foreach ($rows as $row) {
          $new_row = array();
          foreach ($row as $key => $title) {
            $new_row[] = $title;
          }
          $results = array_merge($results, (array) $new_row);
        }
      }
    } else {
      $results = array();
    }
    return $results;
  }
}
