<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class DatsogalleryModelMembers extends JModelList {

  public function __construct($config = array()) {
    parent::__construct($config);
  }

  protected function populateState($ordering = null, $direction = null) {
    $app = JFactory::getApplication();
    $settings = dg::getConfig();
    $limit = $app->input->get('limit', $settings->category_per_page, 'uint');
    $this->setState('list.limit', $limit);
    $limitstart = $app->input->get('limitstart', 0, 'uint');
    $this->setState('list.start', $limitstart);
    if (empty($ordering)) {
      $ordering = 'u.id';
    }
  }

  protected function getListQuery() {
    $db = $this->getDbo();
    $query = $db->getQuery(true);
    $query->select('u.*, count(i.id) AS max');
    $query->from('#__users AS u');
    $query->join('LEFT', '#__datsogallery_images AS i ON i.created_by = u.id');
    $query->where('i.id != 0');
    $query->group('u.id');
    $query->order('max desc');
    return $query;
  }

  public function getItems() {
    return parent::getItems();
  }

}
