<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class DatsogalleryModelMember extends JModelList
{
  public $_item = null;

  public function __construct($config = array())
  {
    parent::__construct($config);
  }

  protected function populateState($ordering = null, $direction = null)
  {
    $app  = JFactory::getApplication('site');
    $user = JFactory::getUser();
    $id   = $app->input->getInt('id');
    $id   = $id ? $id : (int) $user->id;
    $this->setState('member.id', $id);
    $limit = $app->input->get('limit', $app->get('list_limit', 0), 'uint');
    $this->setState('list.limit', $limit);
    $limitstart = $app->input->get('limitstart', 0, 'uint');
    $this->setState('list.start', $limitstart);
    $orderCol = $app->input->get('filter_order', 'ordering');
    if (!in_array($orderCol, $this->filter_fields)) {
      $orderCol = 'a.ordering';
    }
    $this->setState('list.ordering', $orderCol);
    $listOrder = $app->input->get('filter_order_Dir', 'DESC');
    if (!in_array(strtoupper($listOrder), array('ASC', 'DESC', ''))) {
      $listOrder = 'ASC';
    }
    $this->setState('list.direction', $listOrder);
  }

  public function save($data)
  {
    $app        = JFactory::getApplication();
    $profile_id = $this->getState('member.id');
    $user       = JFactory::getUser();
    $userId     = $user->id;
    if ($userId && $userId == $profile_id && isset($data) && (count($data))) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->delete($db->qn('#__datsogallery_members'));
      $query->where($db->qn('user_id') . ' = ' . (int) $userId);
      $db->setQuery($query);
      $db->execute();
      $tuples = array();
      $order  = 1;
      foreach ($data as $k => $v) {
        if (empty(trim($v)) || $v == 1) {
          continue;
        }

        $v        = preg_replace('#^https?://#', '', $v);
        $tuples[] = '(' . $userId . ', ' . $db->q($k) . ', ' . $db->q($v) . ', ' . ($order++) . ')';
      }
      $db->setQuery('INSERT INTO #__datsogallery_members VALUES ' . implode(', ', $tuples))->execute();
    }
  }

  public function notify($data)
  {
    $app        = JFactory::getApplication();
    $user       = JFactory::getUser();
    $profile_id = $this->getState('member.id');
    if ($user->id && $profile_id == $user->id) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->update($db->qn('#__datsogallery_images'));
      $query->set($db->qn('notify') . ' = ' . (int) $data);
      $query->where($db->qn('created_by') . ' = ' . (int) $user->id);
      $db->setQuery($query);
      return $db->execute();
    }
  }

  public function notifysingle($image_id, $state)
  {
    $app        = JFactory::getApplication();
    $user       = JFactory::getUser();
    $profile_id = $this->getState('member.id');
    if ($user->id && $profile_id == $user->id) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->update($db->qn('#__datsogallery_images'));
      $query->set($db->qn('notify') . ' = ' . (int) $state);
      $query->where($db->qn('created_by') . ' = ' . (int) $user->id);
      $query->where($db->qn('id') . ' = ' . (int) $image_id);
      $db->setQuery($query);
      return $db->execute();
    }
  }

  public function getMember()
  {
    $user   = JFactory::getUser();
    $userId = $this->getState('member.id');
    if ($userId) {
      $db    = $this->getDbo();
      $query = $db->getQuery(true);
      $query->select(array('member_key', 'member_value'));
      $query->from($db->qn('#__datsogallery_members'));
      $query->where($db->qn('user_id') . ' = ' . $userId);
      $query->order('ordering');
      $db->setQuery($query);
      try {
        $results = $db->loadRowList();
      } catch (RuntimeException $e) {
        $this->_subject->setError($e->getMessage());
        return false;
      }
      if (!is_object(@$data)) {
        $data = new stdClass;
      }
      $data = array();
      foreach ($results as $v) {
        $k        = $v[0];
        $data[$k] = json_decode($v[1], true);
        if ($data[$k] === null) {
          $data[$k] = $v[1];
        }
      }
      foreach ($data as $k => $v) {
        $data[$k] = $v;
      }
    }
    return $data;
  }

  protected function getListQuery()
  {
    $input  = JFactory::getApplication()->input;
    $id     = $this->getState('member.id');
    $user   = JFactory::getUser();
    $groups = implode(',', $user->getAuthorisedViewLevels());
    $db     = $this->getDbo();
    $query  = $db->getQuery(true);
    $query->select($this->getState('list.select', 'a.*'));
    $query->from('#__datsogallery_images AS a');
    $query->where('a.access IN (' . $groups . ')');
    $query->select('c.title AS ca_title');
    $query->join('LEFT', '#__datsogallery_categories AS c ON c.id = a.catid');
    $query->where('c.access IN (' . $groups . ')');
    if ((!$user->id) || ($user->id != $id)) {
      $query->where($db->qn('a.state') . ' = 1');
      $query->where($db->qn('a.approved') . ' = 1');
      $query->where($db->qn('c.published') . ' = 1');
      $query->where($db->qn('c.approved') . ' = 1');
    }
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $query->select('u.name AS user_name');
    $query->join('LEFT', '#__users AS u ON u.id = a.created_by');
    $query->where('a.created_by = ' . $id);
    $query->order($db->escape($this->getState('list.ordering', 'a.ordering')) . ' ' . $db->escape($this->getState('list.direction', 'ASC')));
    return $query;
  }
}
