<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryModelFavorites extends JModelList {

	public function __construct($config = array()) {
		parent::__construct($config);
	}

	protected function populateState($ordering = null, $direction = null) {
		$app = JFactory::getApplication();
		$settings = dg::getConfig();
		$params = JComponentHelper::getParams('com_datsogallery');
		$limit = $app->input->get('limit', $settings->category_per_page, 'uint');
		$this->setState('list.limit', $limit);
		$limitstart = $app->input->get('limitstart', 0, 'uint');
		$this->setState('list.start', $limitstart);
		$this->setState('params', $params);
	}

	protected function getListQuery() {
		$user = JFactory::getUser();
		$groups = implode(',', $user->getAuthorisedViewLevels());
		$db = $this->getDbo();
		$nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
		$query = $db->getQuery(true);
		$query->select($this->getState('list.select', 'a.id, a.catid, a.title, a.description, a.original, a.featured, a.hits, a.downloads, a.created_by, a.created, u.id AS user_id, u.name AS user_name, u.email AS user_email'));
		$query->from($db->qn('#__datsogallery_images', 'a'));
		$query->where($db->qn('a.access').' IN ('.$groups.')');
		$query->where($db->qn('a.state').' = 1');
    $query->where($db->qn('a.approved').' = 1');
		$query->where('('.$db->qn('a.publish_up').' = '.$nullDate.' OR '.$db->qn('a.publish_up').' <= '.$nowDate.')');
		$query->where('('.$db->qn('a.publish_down').' = '.$nullDate.' OR '.$db->qn('a.publish_down').' >= '.$nowDate.')');
    $query->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON ' . $db->qn('a.catid') . ' = ' . $db->qn('c.id'));
		$query->where($db->qn('c.access').' IN ('.$groups.')');
		$query->where($db->qn('c.published').' = 1');
    $query->where($db->qn('c.approved').' = 1');
    $query->where('('.$db->qn('c.publish_up').' = '.$nullDate.' OR '.$db->qn('c.publish_up').' <= '.$nowDate.')');
		$query->where('('.$db->qn('c.publish_down').' = '.$nullDate.' OR '.$db->qn('c.publish_down').' >= '.$nowDate.')');
    $query->join('LEFT', $db->qn('#__users', 'u') . ' ON ' . $db->qn('a.created_by') . ' = ' . $db->qn('u.id'));
    $query->join('LEFT', $db->qn('#__datsogallery_favorites', 'f') . ' ON ' . $db->qn('a.id') . ' = ' . $db->qn('f.image_id'));
		$query->where($db->qn('f.user_id').' = '.$user->id);
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
		$query->order('f.favorited_time DESC');
    //var_dump((string) $query->__toString());
		return $query;
	}

	public function getItems() {
		return parent::getItems();
	}

}
