<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2019 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class DatsogalleryModelCategories extends JModelList {

  public $_context = 'com_datsogallery.categories';

  protected function populateState($ordering = null, $direction = null) {
    $app          = JFactory::getApplication();
    $settings     = dg::getConfig();
    $order_method = $settings->categories_order;
    switch ($order_method) {
      case 'id':
        $orderby = 'a.id';
        break;

      case 'rid':
        $orderby = 'a.id DESC';
        break;

      case 'alpha':
        $orderby = 'a.title';
        break;

      case 'ralpha':
        $orderby = 'a.title DESC';
        break;

      case 'order':
        $orderby = 'a.ordering';
        break;

      case 'rorder':
        $orderby = 'a.ordering DESC';
        break;

      default:
        $orderby = 'a.ordering';
        break;
    }
    $limit = $app->input->get('limit', $settings->categories_per_page, 'uint');
    $this->setState('list.limit', $limit);
    $limitstart = $app->input->get('limitstart', 0, 'uint');
    $this->setState('list.start', $limitstart);
    $this->setState('list.ordering', $orderby);
  }

  protected function getListQuery() {
    $app      = JFactory::getApplication();
    $user     = JFactory::getUser();
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    $db       = $this->getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $query    = $db->getQuery(true);
    $query->select($this->getState('list.select', 'a.id, a.title, a.description, a.created_by, a.created_time, a.image_id, u.name'));
    $query->from($db->qn('#__datsogallery_categories', 'a'));
    $query->join('LEFT', $db->qn('#__users', 'u') . ' ON ' . $db->qn('a.created_by') . ' = ' . $db->qn('u.id'));
    $query->where($db->qn('a.access') . ' IN (' . $groups . ')');
    $query->where($db->qn('a.published') . ' = 1');
    $query->where($db->qn('a.approved') . ' = 1');
    $query->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $query->where($db->qn('a.parent_id') . ' = 1');
    $query->order($db->escape($this->getState('list.ordering')));
    //var_dump((string) $query->__toString());
    return $query;
  }
}
