<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

require_once JPATH_COMPONENT . '/controller.php';

class DatsogalleryControllerImage extends DatsogalleryController
{

  public function originalupload()
  {
    $app = JFactory::getApplication();
    if ($app->isClient('site')) {
      JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
    }
    require_once JPATH_COMPONENT . '/helpers/uploader.php';
    $settings = dg::getConfig();
    $settings = array(
      'uploadFolder' => JPATH_SITE . $settings->path_to_originals,
      'maxFileSize' => dg::maxuploadsize(),
      'changeFile' => true
    );
    $uploader = new RealTimeUpload();
    $uploader->init($settings);
    $app->close();
  }

  public function updateoriginal()
  {
    $app = JFactory::getApplication();
    if ($app->isClient('site')) {
      JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
    }
    $settings = dg::getConfig();
    $id       = $app->input->getInt('id');
    $catid    = $app->input->getInt('catid');
    $original = $app->input->getString('original');
    $new      = $app->input->getString('newfile');
    $newfile  = JFile::stripExt($original) . '.' . JFile::getExt($new);
    $dir      = JPATH_SITE . $settings->path_to_originals . '/';
    JFile::delete($dir . $original);
    if (JFile::move($dir . $new, $dir . $newfile)) {
      $model = $this->getModel('Image', 'DatsogalleryModel');
      $model->updateOriginal($id, $newfile);
      echo resize($newfile,
        $settings->image_width_details,
        $settings->image_height_details,
        0,
        $settings->image_aspect_ratio_details,
        $settings->image_watermark,
        $catid,
        '',
        $settings->categories_image_quality
      );
    }
    $app->close();
  }

  public function sbox()
  {
      dg::sbox();
  }

  public function fancybox()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id = $app->input->getInt('id');
      if (!isset($id)) {
        return;
      }
      $data = dg::dgslider2($id);
      echo json_encode($data);
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function likes()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->updateLikes();
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function comments()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id         = $app->input->getInt('image_id');
      $user_name  = $app->input->getString('user_name', '');
      $user_email = $app->input->getString('user_email', '');
      $user_text  = $app->input->getString('user_text', '');
      $model      = $this->getModel('Image', 'DatsogalleryModel');
      $return     = $model->getComment($id, $user_name, $user_email, $user_text);
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function commentreply()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id         = $app->input->getInt('id');
      $parent_id  = $app->input->getInt('parent_id');
      $text       = $app->input->getString('user_reply', '');
      $returnlink = $app->input->getString('returnlink', '');
      $model      = $this->getModel('Image', 'DatsogalleryModel');
      $return     = $model->commentReply($id, $parent_id, $text, $returnlink);
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function commentreplycheck()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $user       = JFactory::getUser();
      $returnlink = $app->input->getString('returnlink', '');
      if (!$user->id) {
        echo JText::sprintf('COM_DATSOGALLERY_LEAVE_COMMENT_REPLY_MSG', '<a href="' . JRoute::_('index.php?option=com_users&amp;view=login&amp;return=' . $returnlink) . '">' . JText::_('COM_DATSOGALLERY_LOGIN') . '</a>');
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function commenttime()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id     = $app->input->getInt('comment_id');
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->getCommentTime($id);
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function likecomment()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id     = $app->input->getInt('id');
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->likeComment($id);
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function validatemail()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->validateMail();
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function validaterecaptcha()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $return = dg::recaptcha_response();
      if ($return) {
        //echo $return;
        var_dump($return);
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function dgcaptcha()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->dgCaptcha();
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function validatecaptcha()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->validateCaptcha();
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function dgcaptchar()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->dgCaptchar();
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function validatecaptchar()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->validateCaptchar();
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function report()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->sendReport();
      if ($return) {
        echo JText::_('COM_DATSOGALLERY_REPORT_IMAGE_THANKS');
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function edit()
  {
    $app   = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id    = $app->input->getInt('id');
      $catid = dg::imagecat($id);
      $result = array(
        'status' => 'success',
        'redirect' => JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $catid . '&id=' . $id . '&layout=edit' . dg::menuid($catid), false)
      );
      echo json_encode($result);
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function save()
  {
    JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
    $app    = JFactory::getApplication();
    $user   = JFactory::getUser();
    $config = dg::getConfig();
    $model  = $this->getModel('Image', 'DatsogalleryModel');

    $data  = $app->input->get('jform', array(), 'array');
    $id    = $data['id'];
    $catid = $data['catid'];
    if ($data === false) {
      $errors = $model->getErrors();
      for ($i = 0, $n = count($errors); $i < $n && $i < 3; $i++) {
        if ($errors[$i] instanceof Exception) {
          $app->enqueueMessage($errors[$i]->getMessage(), 'warning');
        } else {
          $app->enqueueMessage($errors[$i], 'warning');
        }
      }
      $app->setUserState('com_datsogallery.image.edit.data', $app->input->get('jform'), array());
      $id = (int) $app->getUserState('com_datsogallery.image.edit.id');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $catid . '&id=' . $id . '&layout=edit' . dg::menuid($catid), false));
      return false;
    }
    $date = JFactory::getDate();
    $tags = array();
    $tags = explode(',', $data['tag']);
    if (!empty($tags) && count($tags)) {
      $c = 0;
      foreach ($tags as $t) {
        $t = trim($t);
        if (JString::strlen($t) < $config->min_tag_chars) {
          continue;
        } elseif (++$c > $config->max_tags_per_image) {
          break;
        }
        $db    = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('id');
        $query->from('#__datsogallery_tags');
        $query->where('image_id = ' . $id);
        $query->where('tag = ' . $db->q($t));
        $db->setQuery($query);
        if (!$db->loadResult()) {
          $tag           = JTable::getInstance('Tag', 'DatsogalleryTable');
          $tag->image_id = $id;
          $tag->user_id  = $user->id;
          $tag->created  = $date->toSql();
          $tag->tag      = $t;
          if (!$tag->store()) {
            $this->setError($tag->getError());
            return false;
          }
        }
      }
    }
    $return = $model->save($data);
    /*if ($return === false) {
    $app->setUserState('com_datsogallery.image.edit.data', $data);
    $this->setMessage(JText::sprintf('Save failed', $model->getError()), 'warning');
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=image&layout=edit&id='.$id, false));
    return false;
    }*/
    if ($return) {
      $app->setUserState('com_datsogallery.edit.image.id', null);
    }
    /*$app->setUserState('com_datsogallery.image.edit.id', null);
    $app->setUserState('com_datsogallery.image.edit.data', null);*/

    $this->setRedirect(
      JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $catid . '&id=' . $id . dg::menuid($catid), false),
      JText::_('COM_DATSOGALLERY_ITEM_SAVED_SUCCESSFULLY')
    );

    return true;
  }

  public function cancel()
  {
    $app   = JFactory::getApplication();
    $id    = JFactory::getApplication()->getUserState('com_datsogallery.edit.image.id');
    $catid = dg::imagecat($id);
    $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $catid . '&id=' . $id . dg::menuid($catid), false));
    return true;
  }

  public function delete()
  {
    $app     = JFactory::getApplication();
    $user    = JFactory::getUser();
    $id      = $app->input->getInt('id');
    $catid   = dg::imagecat($id);
    $referer = $app->input->getInt('referer');
    if (JSession::checkToken('get')) {
      $model = $this->getModel('Image', 'DatsogalleryModel');
      if ($model->delete($id)) {
        $message = JText::_('COM_DATSOGALLERY_ITEM_DELETED_SUCCESSFULLY');
      } else {
        $message = $model->getError();
      }
    } else {
      $message = JText::_('JINVALID_TOKEN');
    }
    if (isset($referer) && ($referer == 'category' || $referer == 'image')) {
      $redirect = JRoute::_('index.php?option=com_datsogallery&view=category&catid=' . $catid . dg::menuid($catid), false);
    } else {
      $redirect = JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $user->id . dg::menuid('member'), false);
    }
    $result = array(
      'status' => 'success',
      'message' => $message,
      'redirect' => $redirect
    );
    echo json_encode($result);
    $app->close();
  }

  public function deleteajax()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id    = $app->input->getInt('id');
      $model = $this->getModel('Image', 'DatsogalleryModel');
      if ($model->delete($id)) {
        $result = array('status' => 'success', 'message' => JText::_('COM_DATSOGALLERY_ITEM_DELETED_SUCCESSFULLY'));
      } else {
        $result = array('status' => 'error', 'message' => $model->getError());
      }
    } else {
      $result = array('status' => 'error', 'message' => JText::_('JINVALID_TOKEN'));
    }
    echo json_encode($result);
    $app->close();
  }

  public function favoriteajax()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id     = $app->input->getInt('id');
      $model  = $this->getModel('Image', 'DatsogalleryModel');
      $return = $model->addtofavorite($id);
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function deletecommentajax()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id       = $app->input->getInt('id');
      $image_id = $app->input->getInt('image_id');
      $model    = $this->getModel('Image', 'DatsogalleryModel');
      $return   = $model->deletecomment($id, $image_id);
      if ($return) {
        echo $return;
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function updatecommentajax()
  {
    $app = JFactory::getApplication();
    if (JSession::checkToken('get')) {
      $id   = $app->input->getInt('id');
      $text = $app->input->getString('value', '');
      if (dg::canEditComment($id)) {
        $model  = $this->getModel('Image', 'DatsogalleryModel');
        $result = $model->updateComment($id, $text);
        if ($result) {
          echo $result;
        }
      } else {
        jexit(JText::_('JLIB_APPLICATION_ERROR_EDIT_ITEM_NOT_PERMITTED'));
      }
    } else {
      jexit(JText::_('JINVALID_TOKEN'));
    }
    $app->close();
  }

  public function download()
  {
    $app      = JFactory::getApplication();
    $id       = $app->input->getInt('id');
    $catid    = dg::imagecat($id);
    $user     = JFactory::getUser();
    $isroot   = $user->authorise('core.admin');
    $groups   = $user->getAuthorisedViewLevels();
    $settings = dg::getConfig();
    if ($settings->allow_downloads && in_array($settings->download_access, $groups)) {
      $model = $this->getModel('Image', 'DatsogalleryModel');
      $table = JTable::getInstance('Image', 'DatsogalleryTable');
      $table->load($id);
      $image = $model->download($id);
      if ($image && JFile::exists(JPath::clean(JPATH_SITE . $settings->path_to_originals . '/' . $image->original))) {
        if ($settings->download_with_watermark) {
          list($width, $height) = getimagesize(JPATH_SITE . $settings->path_to_originals . '/' . $image->original);
          $tmp_dir              = '/tmp/' . md5(microtime());
          JFolder::create(JPATH_SITE . $tmp_dir);
          JFile::copy(JPath::clean(JPATH_SITE . $settings->path_to_originals . '/' . $image->original), JPath::clean(JPATH_SITE . $tmp_dir . '/' . $image->original));
          resize($image->original, $width, $height, 0, 0, 1, $catid, $tmp_dir . '/', 100, false, $settings->global_watermark_position);
          $path = getTmpFile($image->original, $width, $height, $catid, '0', $tmp_dir . '/');
        } else {
          $path = JPath::clean(JPATH_SITE . $settings->path_to_originals . '/' . $image->original);
        }
        ob_clean();
        $filename = basename($path);
        $ext      = JFile::getExt($filename);
        $new      = $settings->download_filename ? $table->title . '.' . $ext : $image->original;
        header("Cache-Control: public, must-revalidate");
        header('Cache-Control: pre-check=0, post-check=0, max-age=0');
        header("Pragma: no-cache");
        header("Expires: 0");
        header("Content-Description: File Transfer");
        header("Expires: Sat, 01 Jan 2000 01:00:00 GMT");
        if (preg_match('#Opera#', $_SERVER['HTTP_USER_AGENT'])) {
          header("Content-Type: application/octetstream");
        } else {
          header("Content-Type: application/octet-stream");
        }
        header("Content-Length: " . (string) filesize($path));
        header('Content-Disposition: attachment; filename="' . $new . '"');
        header("Content-Transfer-Encoding: binary");
        flush();
        readfile($path);
        if ($settings->download_with_watermark && JFolder::exists(JPATH_SITE . $tmp_dir)) {
          JFolder::delete(JPATH_SITE . $tmp_dir);
        }
        $model->downloadRecord($id);
      } else {
        $this->setMessage(JText::_('FILE NOT EXISTS'), 'error');
      }
      $app->close();
    } else {
      $app->enqueueMessage(JText::_('COM_DATSOGALLERY_NO_ACCESS_DOWNLOAD_IMAGE'), 'error');
      $this->setRedirect(JRoute::_('index.php?option=com_datsogallery&view=image&catid=' . $catid . '&id=' . $id . dg::menuid($catid), false));
    }
  }
}
