<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.view');
jimport('joomla.filesystem.folder');

class DatsogalleryViewUpload extends JViewLegacy {
	protected $form;
	protected $item;
	protected $return_page;
	protected $state;

	public function display($tpl = null) {
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		$this->state = $this->get('State');
		$this->item = $this->get('Data');
		$this->form = $this->get('Form');
    $this->settings = dg::getConfig();
    $errors = $this->get('Errors');
    if (is_array($errors) && count($errors)) {
  		throw new Exception(implode("\n", $errors));
    }
		$authorised = $user->authorise('core.create', 'com_datsogallery');
		if ($authorised !== true) {
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
		}
		dg::addSubmenu('upload');
		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		$this->_prepareDocument();
		parent::display($tpl);
	}

	protected function _prepareDocument() {
		$app = JFactory::getApplication();
    $app->input->set('hidemainmenu', true);
		$user = JFactory::getUser();
    $lng = substr($this->document->language, 0, 2);
		$canDo = dg::getActions();
		//JHtml::stylesheet('components/com_datsogallery/assets/css/dg-ui.css');
    $this->document->addStyleSheet('components/com_datsogallery/assets/css/datsogallery.css');
    JHtml::script('components/com_datsogallery/assets/js/jquery.plugins.js', false);
		JHtml::script('components/com_datsogallery/assets/js/jquery.steps.js', false);
		JHtml::script('components/com_datsogallery/assets/js/jquery.validate.min.js', false);
		JHtml::script('components/com_datsogallery/assets/js/upload.min.js', false);
		JHtml::script('components/com_datsogallery/assets/js/datsogallery.min.js', false);
    if ($this->settings->allow_geotagging) {
      if ($this->settings->gm_api_key != '') {
      $this->document->addScript('//maps.googleapis.com/maps/api/js?key='.$this->settings->gm_api_key.'&amp;libraries=places&amp;language='.$lng);
      }
      else {
        $this->document->addScript('//maps.googleapis.com/maps/api/js?libraries=places&amp;language='.$lng);
      }
    }
		if (JFolder::exists(JPATH_SITE.$this->settings->path_to_tmp.'/'.$user->id)) {
			JFolder::delete(JPATH_SITE.$this->settings->path_to_tmp.'/'.$user->id);
		}
	}

	protected function addToolbar() {
		JToolBarHelper::title(JText::_('Upload Images'), 'upload.png');
    $canDo = dg::getActions();
		/*if ($canDo->get('core.admin')) {
			JToolBarHelper::preferences('com_datsogallery');
		}*/
    JToolBarHelper::back(JText::_('COM_DATSOGALLERY_BACK_TO_DASHBOARD'), 'index.php?option=com_datsogallery');
		JHtmlSidebar::setAction('index.php?option=com_datsogallery&view=upload');
	}

}