<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen');
$language = JFactory::getLanguage();
$language->load('com_datsogallery', JPATH_SITE, null, true);
dg::jslang('upload.min.js');
$x = explode(',', $this->settings->extensions);
$accept = '.'.implode(', .', $x);
?>
<script>
var siteurl = '<?php echo JUri::base(); ?>';

function alldone(element, position) {
  var allfinished = true;
  for (var i = 0, l = element.uploadList.length; i < l; i++) {
    if (element.uploadList[i].status != 'finished' && element.uploadList[i].status != 'canceled' && element.uploadList[i].status != 'rejected') {
      allfinished = false;
    }
  }
  if (allfinished) {
    jQuery('.dg-alert.upload-process').slideUp(function() {
      jQuery("#upForm .actions a[href='#next']").show();
      jQuery('html, body').animate({ scrollTop: jQuery(document).height()-jQuery(window).height() }, 1000);
    });
  }
}
window.onload = function() {
  var uploadSettings = {
    'text': '<?php echo JText::_("COM_DATSOGALLERY_UPLOAD_BUTTON_TEXT"); ?>',
    'action': siteurl + 'index.php?option=com_datsogallery&task=upload.process&<?= JSession::getFormToken() ?>=1',
    'maxFiles': 0,
    'callbackSuccess': alldone,
    'maxWidth': <?php echo $this->settings->upload_max_width; ?>,
    'maxHeight': <?php echo $this->settings->upload_max_height; ?>,
    'maxFileSize': <?php echo dg::mb2kb($this->settings->max_filesize, $this->settings->max_filesize_format); ?>,
    'sliceSize': <?php echo $this->settings->upload_slice_size; ?>
  };
  var uploader = document.getElementById('imagefile');
  var uploadForm = new RealTimeUpload(uploadSettings, uploader);
};
jQuery(function() {
  var form = jQuery("#upForm");
  form.steps({
    headerTag: "div.steps",
    bodyTag: "section",
    labels: {
      next: "<?php echo JText::_("COM_DATSOGALLERY_STEPS_NEXT"); ?>",
      previous: "<?php echo JText::_("COM_DATSOGALLERY_STEPS_PREVIOUS"); ?>",
      finish: "<?php echo JText::_("COM_DATSOGALLERY_STEPS_FINISH"); ?>"
    },
    transitionEffect: "slideLeft",
    onInit: function(event, currentIndex) {
      jQuery(".actions").prepend('<ul class="dg-allowed-ext"><li><i class="dgi-info"></i></li><li><?php echo JText::_("COM_DATSOGALLERY_ALLOWED_EXTENSIONS");?></li><li><?php echo $this->settings->extensions; ?></li></ul>');
      jQuery("#upForm .actions a[href='#next']").hide();
    },
    onStepChanging: function(event, currentIndex, newIndex) {
      if (currentIndex > newIndex) {
        return true;
      }
      if (currentIndex < newIndex) {
        form.find(".body:eq(" + newIndex + ") label.error").remove();
        form.find(".body:eq(" + newIndex + ") .error").removeClass("error");
      }
      form.validate().settings.ignore = ":disabled,:hidden";
      return form.valid();
    },
    onStepChanged: function(event, currentIndex, priorIndex) {
      if (currentIndex === 1) {
        showtmp();
      }
      if (currentIndex === 0) {
        jQuery(".actions").prepend('<ul class="dg-allowed-ext"><li><i class="dgi-info"></i></li><li><?php echo JText::_("COM_DATSOGALLERY_ALLOWED_EXTENSIONS");?></li><li><?php echo $this->settings->extensions; ?></li></ul>');
      }
      if (currentIndex > 0) {
        jQuery(".dg-allowed-ext").remove();
      }
      if (currentIndex === 2) {
        jQuery(".actions").prepend('<div class="dg-toogle-terms"><label class="checkbox"><input type="checkbox" name="terms" id="terms" /><i></i>I agree with the Terms and Conditions</label></div>');
      }
      if (currentIndex < 2) {
        jQuery(".dg-toogle-terms").remove();
      }
    },
    onFinishing: function(event, currentIndex) {
      form.validate().settings.ignore = ":disabled";
      return form.valid();
    },
    onFinished: function(event, currentIndex) {
      var form = jQuery('#upForm');
      form.submit();
    }
  }).validate({
    focusInvalid: false,
    invalidHandler: function(form, validator) {

      if (!validator.numberOfInvalids())
        return;

      jQuery('html, body').animate({
        scrollTop: jQuery(validator.errorList[0].element).offset().top
      }, 1000);

    },
    errorPlacement: function errorPlacement(error, element) {
      error.insertAfter(element.parent());
    },
    rules: {
      gcatid: {
        required: function() {
          return jQuery("select.catid").val() == '';
        }
      },
      terms: {
        required: true
      }
    },
    messages: {
      gcatid: {
        required: '<?php echo JText::_("COM_DATSOGALLERY_REQUIRED_CATEGORY_MSG"); ?>'
      },
      terms: {
        required: '<?php echo JText::_("COM_DATSOGALLERY_AGREE_TERMS_MSG"); ?>'
      }
    }
  });
});
jQuery(document).on('change', '.toggle input#accept-terms:checkbox', function() {
  if (jQuery(this).prop('checked')) {
    jQuery(this).attr('checked', false);
  } else {
    jQuery(this).attr('checked', true);
  }
});
function showtmp() {
  jQuery.ajax({
    url: siteurl + 'index.php?option=com_datsogallery&task=upload.tmpimg&<?= JSession::getFormToken() ?>=1',
    beforeSend: function(){
      jQuery(".dg-loading").fadeIn();
    },
    success: function(data) {
      jQuery('#tmpimgs').html(data);
    },
    complete: function(data){
      jQuery(".dg-loading").fadeOut();
    }
  });
}
jQuery(document).on('click', '#refresh-page', function() {
    location.reload();
});
</script>
<div class="dg-ui dg-select" style="margin-top:0">
  <div id="j-sidebar-container" class="col col-2">
      <div class="filling"><?php echo $this->sidebar; ?></div>
   </div>
   <div id="j-main-container" class="col col-10">
  <form id="upForm" name="upForm" method="post">
     <div class="steps"></div>
     <section>
        <div id="header">
           <h3 class="dg-title"><?php echo JText::_("COM_DATSOGALLERY_UPLOAD_STEP_ONE");?></h3>
           <div class="dg-alert upload-process dg-alert-warning" style="display:none">
               <p><?php echo JText::sprintf("COM_DATSOGALLERY_PROCESSING_WAIT_MSG", '<span id="refresh-page" title="'.JText::_('COM_DATSOGALLERY_REFRESH_PAGE').'">', '</span>');?></p>
            </div>
        </div>
        <div class="dg-alert" style="display:none">
           <div class="dg-alert-close dg-close"></div>
           <p></p>
        </div>
        <div style="margin-top: 10px;">
           <input class="dg-hiddenFile" name="imagefile[]" id="imagefile" accept="<?= $accept ?>" type="file" multiple>
        </div>
     </section>
     <div class="steps"></div>
     <section>
        <h3 class="dg-title"><?php echo JText::_("COM_DATSOGALLERY_UPLOAD_STEP_TWO");?></h3>
        <div id="tmpimgs"></div>
     </section>
     <?php if ($this->settings->show_terms && !dg::is_root()) : ?>
     <div class="steps"></div>
     <section>
        <h3 class="dg-title"><?php echo JText::_("COM_DATSOGALLERY_UPLOAD_STEP_THREE");?></h3>
        <div class="dg-alert terms" style="display:none">
           <div class="dg-alert-close dg-close"></div>
           <p></p>
        </div>
        <p><iframe src="<?php echo JURI::root(); ?>index.php?option=com_content&view=article&id=1&tmpl=component" class="dg-iframe"></iframe></p>
     </section>
     <?php endif; ?>
     <input type="hidden" name="option" value="com_datsogallery" />
     <input type="hidden" name="task" value="upload.save" />
     <?php echo JHtml::_('form.token'); ?>
  </form>
  </div>
</div>
<div class="dg-loading">
  <div class="dg-loading-wheel"></div>
  <div class="wait-msg">
    <?php echo JText::sprintf("COM_DATSOGALLERY_PROCESSING_WAIT_MSG", '<span id="refresh-page" title="'.JText::_('COM_DATSOGALLERY_REFRESH_PAGE').'">', '</span>'); ?>
  </div>
</div>