<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
?>
<style type="text/css">
.progress {
 height: 8px;
 border-radius: 2px;
 margin-top: 6px;
}
</style>
<div class="form-vertical">
  <legend><?php echo JText::_('COM_DATSOGALLERY_PG2DG_LEGEND'); ?></legend>

  <div class="alert alert-warnining">
      <h4><?php echo JText::_('WARNING'); ?></h4>
      <p><?php echo JText::_('COM_DATSOGALLERY_PG2DG_DESC'); ?></p>
      <p><button id="readytoprocess" class="btn" type="button"><?php echo JText::_('COM_DATSOGALLERY_PG2DG_READY_BTN'); ?></button></p>
  </div>

  <div id="ready" class="hide">
  <div id="togglealert" class="alert alert-info">
      <button type="button" class="close" data-dismiss="alert">×</button>
      <h4><?php echo JText::_('NOTICE'); ?></h4>
      <p><?php echo JText::_('COM_DATSOGALLERY_PG2DG_START_DESC'); ?></p>
  </div>

  <div class="alert alert-block hide progressmsg">
      <button type="button" class="close" data-dismiss="alert">×</button>
      <h4><?php echo JText::_('WARNING'); ?></h4>
      <?php echo JText::_('COM_DATSOGALLERY_PG2DG_PROGRESS_MSG'); ?>
  </div>

  <div id="progress-bars">
    <div id="categories" class="control-group" style="display:none">
      <div class="control-label"><label><span></span><?php echo JText::_("COM_DATSOGALLERY_PG2DG_CATEGORIES"); ?></label></div>
      <div class="controls">
        <div class="progress progress-striped active">
          <div class="bar bar-success" style="width: 0%;"></div>
        </div>
      </div>
    </div>

    <div id="images" class="control-group" style="display:none">
      <div class="control-label"><label><span></span><?php echo JText::_("COM_DATSOGALLERY_PG2DG_IMAGES"); ?></label></div>
      <div class="controls">
        <div class="progress progress-striped active">
          <div class="bar bar-success" style="width: 0%;"></div>
        </div>
      </div>
    </div>

    <div id="comments" class="control-group" style="display:none">
      <div class="control-label"><label><span></span><?php echo JText::_("COM_DATSOGALLERY_PG2DG_COMMENTS"); ?></label></div>
      <div class="controls">
        <div class="progress progress-striped active">
          <div class="bar bar-success" style="width: 0%;"></div>
        </div>
      </div>
    </div>

    <div id="votes" class="control-group" style="display:none">
      <div class="control-label"><label><span></span><?php echo JText::_("COM_DATSOGALLERY_PG2DG_VOTES"); ?></label></div>
      <div class="controls">
        <div class="progress progress-striped active">
          <div class="bar bar-success" style="width: 0%;"></div>
        </div>
      </div>
    </div>
  </div>

  <div id="startbtn">
    <button class="btn" onclick="migrate()" type="button"><?php echo JText::_('COM_DATSOGALLERY_PG2DG_START_BTN'); ?></button>
  </div>
  </div>

</div>
<script>
var finished = false;

function progress() {
    jQuery.ajax({
        type: 'get',
        url: '<?php echo JUri::base(); ?>components/com_datsogallery/progress.json',
        dataType: 'json',
        cache: false
    }).done(function(msg) {
        if (msg.action == 'categories') {
          jQuery('#categories').show();
          jQuery('#categories span').html('<?php echo JText::_("COM_DATSOGALLERY_PG2DG_MIGRATED"); ?> ' + msg.migrated + ' <?php echo JText::_("COM_DATSOGALLERY_PG2DG_OF"); ?> ' + msg.total + ' ');
        }
        if (msg.action == 'images') {
          jQuery('#images').show();
          jQuery('#images span').html('<?php echo JText::_("COM_DATSOGALLERY_PG2DG_MIGRATED"); ?> ' + msg.migrated + ' <?php echo JText::_("COM_DATSOGALLERY_PG2DG_OF"); ?> ' + msg.total + ' ');
        }
        if (msg.action == 'comments') {
          jQuery('#comments').show();
          jQuery('#comments span').html('<?php echo JText::_("COM_DATSOGALLERY_PG2DG_MIGRATED"); ?> ' + msg.migrated + ' <?php echo JText::_("COM_DATSOGALLERY_PG2DG_OF"); ?> ' + msg.total + ' ');
        }
        if (msg.action == 'votes') {
          jQuery('#votes').show();
          jQuery('#votes span').html('<?php echo JText::_("COM_DATSOGALLERY_PG2DG_MIGRATED"); ?> ' + msg.migrated + ' <?php echo JText::_("COM_DATSOGALLERY_PG2DG_OF"); ?> ' + msg.total + ' ');
        }
        if (msg.action == 'error' || msg.action == 'completed') {
          finished = true;
        }
        jQuery('#' + msg.action + ' .bar').css('width', msg.progress + '%');
        jQuery('#output').html(msg.progress + '%');
    });
    if (!(finished)) {
        setTimeout(function() {
            progress();
        }, 100);
    }
}

function currtime() {
var currentTime = new Date ( );
  var currentHours = currentTime.getHours ( );
  var currentMinutes = currentTime.getMinutes ( );
  var currentSeconds = currentTime.getSeconds ( );
  currentMinutes = ( currentMinutes < 10 ? "0" : "" ) + currentMinutes;
  currentSeconds = ( currentSeconds < 10 ? "0" : "" ) + currentSeconds;
  var currentTimeString = currentHours + ":" + currentMinutes + ":" + currentSeconds;
  return currentTimeString;
}

function nl2br(str, is_xhtml) {
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
    return (str + '').replace(/(,)/g, '$1'+ breakTag);
}

jQuery(document).on('click', '#readytoprocess', function(){
   jQuery('.alert-warnining').addClass('hide');
   jQuery('#ready').removeClass('hide');
});

function migrate() {
    jQuery('#startbtn').hide();
    jQuery('#togglealert').addClass('hide');
    jQuery('.progress').removeClass('hide');
    jQuery('.progressmsg').removeClass('hide');
    setTimeout(function() {
        progress();
    }, 100);
    finished = false;
    jQuery.ajax({
        type: 'get',
        url: '<?php echo JUri::base(); ?>index.php?option=com_datsogallery&task=settings.mphocatodg',
        dataType: 'json',
        cache: false,
        success: function(json) {
            jQuery('.progressmsg').hide();
            if (json.messages != null) {
                finished = true;
                jQuery('#progress-bars').hide();
                jQuery('#togglealert').removeClass('hide');
                jQuery('#togglealert').removeClass('alert alert-info').addClass('alert alert-error');
                jQuery('.alert-error').find('h4').text('<?php echo JText::_("ERROR"); ?>');
                jQuery('.alert-error').find('p').html(json.messages.error);
            } else {
                finished = true;
                jQuery('.progress').removeClass('active');
                jQuery('#togglealert').removeClass('hide');
                jQuery('#togglealert').removeClass('alert alert-info').addClass('alert alert-success');
                jQuery('.alert-success').find('h4').text('<?php echo JText::_("COM_DATSOGALLERY_PG2DG_CONGRATULATIONS_H4"); ?>');
                jQuery('.alert-success').find('p').text('<?php echo JText::_("COM_DATSOGALLERY_PG2DG_CONGRATULATIONS_P"); ?>');
            }
        }
    });
}
</script>