<?php
  /**
   * @package    com_datsogallery
   * @author     Andrey Datso <support@datso.fr>
   * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
   * @license    GNU General Public License version 2 or later; see LICENSE.txt
   */
  defined('_JEXEC') or die;

  JHtml::_('script', 'jui/cms.js', false, true);
  JHtml::_('bootstrap.tooltip');
  JHtml::_('behavior.formvalidator');
  JHtml::_('formbehavior.chosen', 'select');

  JText::script('ERROR');
  JText::script('WARNING');
  JText::script('NOTICE');
  JText::script('MESSAGE');
  JFactory::getDocument()->addScriptDeclaration('
  Joomla.submitbutton = function(task) {
    if (task === "settings.cancel" || document.formvalidator.isValid(document.getElementById("settings"))) {
      Joomla.submitform(task, document.getElementById("settings"));
    }
  };
');
  $app = JFactory::getApplication();
  $doc = JFactory::getDocument();
  $doc->addStyleSheet('components/com_datsogallery/assets/css/datsogallery.css');
  foreach ($this->data as $k => $v) {
    $data[$k] = $v;
  }
  $settings = dg::getConfig();
?>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery'); ?>" method="post" name="adminForm" class="dg-style form-validate form-horizontal" id="settings" enctype="multipart/form-data" autocomplete="off">
   <?php if (!empty($this->sidebar)): ?>
   <div id="j-sidebar-container" class="col col-2">
      <div class="filling"><?php echo $this->sidebar; ?></div>
   </div>
  <div id="j-main-container" class="col col-10">
  <?php else: ?>
  <div id="j-main-container">
  <?php endif;?>

  <div>
  <?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'views')); ?>

  <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'views', JText::_('COM_DATSOGALLERY_VIEWS', true)); ?>
  <div class="row-fluid">
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_CATEGORIES_VIEW'); ?></legend>
    <?php
      echo $this->form->renderField('categories_view_type');
      echo $this->form->renderField('categories_covers_ordering');
      echo $this->form->renderField('categories_image_resize_method');
      echo $this->form->renderField('categories_image_aspect_ratio');
      echo $this->form->renderField('categories_image_width');
      echo $this->form->renderField('categories_image_height');
      echo $this->form->renderField('categories_image_quality');
      echo $this->form->renderField('categories_image_watermark');
      echo $this->form->renderField('categories_image_watermark_position');
      echo $this->form->renderField('categories_container_breakpoints');
      echo $this->form->renderField('categories_breakpoint_xl');
      echo $this->form->renderField('categories_breakpoint_l');
      echo $this->form->renderField('categories_breakpoint_m');
      echo $this->form->renderField('categories_breakpoint_s');
      echo $this->form->renderField('categories_margin_y');
      echo $this->form->renderField('categories_margin_x');
      echo $this->form->renderField('categories_details');
      echo $this->form->renderField('categories_avatar');
      echo $this->form->renderField('categories_owner');
      echo $this->form->renderField('categories_date');
      echo $this->form->renderField('categories_date_format');
      echo $this->form->renderField('categories_stats');
      echo $this->form->renderField('categories_title');
      echo $this->form->renderField('categories_title_position');
      echo $this->form->renderField('categories_description');
      echo $this->form->renderField('categories_order');
      echo $this->form->renderField('categories_per_page');
    ?>
  </div>
  <div class="span6">
  <legend><?php echo JText::_('COM_DATSOGALLERY_CATEGORY_VIEW'); ?></legend>
    <?php
    echo $this->form->renderField('category_description');
    echo $this->form->renderField('category_description_triggering');
    echo $this->form->renderField('category_image_resize_method');
    echo $this->form->renderField('category_image_aspect_ratio');
    echo $this->form->renderField('category_image_width');
    echo $this->form->renderField('category_image_height');
    echo $this->form->renderField('category_image_quality');
    echo $this->form->renderField('category_image_watermark');
    echo $this->form->renderField('category_image_watermark_position');
    echo $this->form->renderField('category_container_breakpoints');
    echo $this->form->renderField('category_breakpoint_xl');
    echo $this->form->renderField('category_breakpoint_l');
    echo $this->form->renderField('category_breakpoint_m');
    echo $this->form->renderField('category_breakpoint_s');
    echo $this->form->renderField('category_margin_y');
    echo $this->form->renderField('category_margin_x');
    echo $this->form->renderField('category_details');
    echo $this->form->renderField('category_avatar');
    echo $this->form->renderField('category_owner');
    echo $this->form->renderField('category_date');
    echo $this->form->renderField('category_date_format');
    echo $this->form->renderField('category_stats');
    echo $this->form->renderField('category_featured');
    echo $this->form->renderField('category_hits');
    echo $this->form->renderField('category_downloads');
    echo $this->form->renderField('category_comments');
    echo $this->form->renderField('category_likes');
    echo $this->form->renderField('category_title');
    echo $this->form->renderField('category_title_position');
    echo $this->form->renderField('category_image_description');
    echo $this->form->renderField('category_order');
    echo $this->form->renderField('category_per_page');
    echo $this->form->renderField('category_fancybox');
    ?>
  </div>
  </div>
  <div class="row-fluid">
  <div class="span6">
  <legend><?php echo JText::_('COM_DATSOGALLERY_IMAGE_VIEW'); ?></legend>
    <?php /*echo $this->form->renderField('image_position_details');*/;?>
<?php echo $this->form->renderField('image_nav_type_details'); ?>
<?php echo $this->form->renderField('image_width_details'); ?>
<?php echo $this->form->renderField('image_height_details'); ?>
<?php echo $this->form->renderField('image_resize_method_details'); ?>
<?php echo $this->form->renderField('image_aspect_ratio_details'); ?>
<?php echo $this->form->renderField('image_quality_details'); ?>
<?php echo $this->form->renderField('image_watermark'); ?>
<?php echo $this->form->renderField('image_watermark_position'); ?>
<?php echo $this->form->renderField('image_title'); ?>
<?php echo $this->form->renderField('image_description'); ?>
<?php echo $this->form->renderField('image_description_html'); ?>
<?php echo $this->form->renderField('image_description_triggering'); ?>
<?php echo $this->form->renderField('image_details'); ?>
<?php echo $this->form->renderField('image_avatar'); ?>
<?php echo $this->form->renderField('image_owner'); ?>
<?php echo $this->form->renderField('image_date'); ?>
<?php echo $this->form->renderField('image_date_format'); ?>
<?php echo $this->form->renderField('addthis'); ?>
<?php echo $this->form->renderField('addthis_id'); ?>
<?php echo $this->form->renderField('image_geolocation'); ?>
<?php echo $this->form->renderField('image_downloads'); ?>
<?php echo $this->form->renderField('image_hits'); ?>
<?php echo $this->form->renderField('image_info_expanded'); ?>
<?php echo $this->form->renderField('image_copyrights'); ?>
<?php echo $this->form->renderField('image_info'); ?>
<?php echo $this->form->renderField('image_file_size'); ?>
<?php echo $this->form->renderField('image_dimensions'); ?>
<?php echo $this->form->renderField('image_file_type'); ?>
<?php echo $this->form->renderField('image_exif'); ?>
<?php echo $this->form->renderField('image_exif_flash_advanced'); ?>
<?php echo $this->form->renderField('image_comments'); ?>
<?php echo $this->form->renderField('image_tags'); ?>
<?php echo $this->form->renderField('image_related'); ?>
<?php
  echo $this->form->renderField('image_related_limit');
  /*echo $this->form->renderField('image_related_columns');
  echo $this->form->renderField('image_related_title');
  echo $this->form->renderField('image_related_category');*/
?>
  </div>
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_EDIT_VIEW'); ?></legend>
    <?php echo $this->form->renderField('image_edit_change_original'); ?>
<?php echo $this->form->renderField('image_edit_author'); ?>
<?php echo $this->form->renderField('image_edit_author_url'); ?>
<?php echo $this->form->renderField('image_edit_description'); ?>
<?php echo $this->form->renderField('image_edit_language'); ?>
<?php echo $this->form->renderField('image_edit_editor'); ?>
<?php echo $this->form->renderField('image_edit_geo'); ?>
<?php echo $this->form->renderField('image_edit_tags'); ?>
<?php echo $this->form->renderField('image_edit_notify'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_FOOTER_VIEW'); ?></legend>
    <?php echo $this->form->renderField('backlink'); ?>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>

  <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'upload', JText::_('COM_DATSOGALLERY_UPLOAD', true)); ?>
<?php
  $db    = JFactory::getDbo();
  $query = 'SELECT CONCAT( REPEAT(\'<span class="gi">|—</span>\', COUNT(parent.id) - 1), node.title) as text, node.id as value'
    . ' FROM #__usergroups AS node, #__usergroups AS parent'
    . ' WHERE node.lft BETWEEN parent.lft AND parent.rgt'
    . ' AND node.parent_id > 0'
    . ' AND node.id NOT IN (8,9)'
    . ' GROUP BY node.id';
  $db->setQuery($query);
  $groups = $db->loadObjectList();
?>
  <div class="row-fluid">
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_UPLOAD_SETTINGS'); ?></legend>
    <div class="control-group">
     <div class="control-label"><label class="hasPopover" title="<?php echo JText::_('COM_DATSOGALLERY_IMAGE_PROCESSING'); ?>" data-content="<?php echo JText::_('COM_DATSOGALLERY_IMAGE_PROCESSING_DESC'); ?>"><?php echo JText::_('COM_DATSOGALLERY_IMAGE_PROCESSING'); ?></label></div>
      <div class="controls">
      <select name="jform[image_processing]" id="jform_image_processing" required>
         <?php if(extension_loaded('gd')) { ?>
         <option value="gd"<?php echo (isset($data['image_processing']) && $data['image_processing'] == 'gd' ? ' selected' : ''); ?>><?php echo JText::_('COM_DATSOGALLERY_GD'); ?></option>
         <?php } ?>
         <?php if(extension_loaded('imagick')) { ?>
         <option value="im"<?php echo (isset($data['image_processing']) && $data['image_processing'] == 'im' ? ' selected' : ''); ?>><?php echo JText::_('COM_DATSOGALLERY_IM'); ?></option>
         <?php } ?>
      </select>
      </div>
    </div>
    <?php echo $this->form->renderField('path_to_tmp'); ?>
    <div class="control-group">
      <div class="control-label"><label class="hasPopover" title="<?php echo JText::_('COM_DATSOGALLERY_PATH_TO_ORIGINALS'); ?>" data-content="<?php echo JText::_('COM_DATSOGALLERY_PATH_TO_ORIGINALS_DESC'); ?>"><?php echo JText::_('COM_DATSOGALLERY_PATH_TO_ORIGINALS'); ?></label></div>

      <div class="controls">
          <input name="jform[path_to_originals]" id="jform_path_to_originals" value="<?php echo $data['path_to_originals']; ?>" type="text">&nbsp;
          <?php echo dg::check_org(); ?>
      </div>
    </div>
    <div style="clear:both"></div>
    <?php if (strpos($app->input->server->get('SERVER_SOFTWARE'), 'Apache') !== false): ?>
<?php echo $this->form->renderField('protect_originals'); ?>
<?php echo $this->form->renderField('protect_upload_dir'); ?>
<?php endif;?>
<?php
  if (function_exists('exif_read_data')) {
    echo $this->form->renderField('auto_rotate');
  }
?>
<?php echo $this->form->renderField('extensions'); ?>
<?php $path_to_images = !empty($data['path_to_images']) ? $data['path_to_images'] : '/images/dg_images'; ?>
<div class="control-group">
      <div class="control-label"><label class="hasPopover" title="<?php echo JText::_('COM_DATSOGALLERY_PATH_TO_IMAGES'); ?>" data-content="<?php echo JText::_('COM_DATSOGALLERY_PATH_TO_IMAGES_DESC'); ?>"><?php echo JText::_('COM_DATSOGALLERY_PATH_TO_IMAGES'); ?></label></div>
      <div class="controls">
          <input name="jform[path_to_images]" id="jform_path_to_originals" value="<?= $path_to_images ?>" type="text">&nbsp;
          <?php echo dg::check_org('images'); ?>
      </div>
</div>
<?php echo $this->form->renderField('imageinterlace'); ?>

<?php
    $path_to_webp = !empty($data['path_to_webp']) ? $data['path_to_webp'] : '/images/dg_images_webp';
    if (dg::webpsupport() == true) {
    echo $this->form->renderField('enable_webp');?>
<div class="control-group">
      <div class="control-label"><label class="hasPopover" title="<?php echo JText::_('COM_DATSOGALLERY_PATH_TO_WEBP'); ?>" data-content="<?php echo JText::_('COM_DATSOGALLERY_PATH_TO_WEBP_DESC'); ?>"><?php echo JText::_('COM_DATSOGALLERY_PATH_TO_WEBP'); ?></label></div>
      <div class="controls">
          <input name="jform[path_to_webp]" id="jform_path_to_originals" value="<?= $path_to_webp ?>" type="text">&nbsp;
          <?php echo dg::check_org('webp'); ?>
      </div>
</div>
<?php
  }
  //}
?>
    <div class="control-group">
     <div class="control-label"><label class="hasPopover" title="<?php echo JText::_('COM_DATSOGALLERY_MAX_FILESIZE'); ?>" data-content="<?php echo JText::_('COM_DATSOGALLERY_MAX_FILESIZE_DESC'); ?>"><?php echo JText::_('COM_DATSOGALLERY_MAX_FILESIZE'); ?></label></div>
      <div class="controls"><input name="jform[max_filesize]" id="jform_max_filesize" value="<?php echo $data['max_filesize']; ?>" type="text" size="6" style="max-width:55px;">&nbsp;
      <select name="jform[max_filesize_format]" id="jform_max_filesize_format" style="max-width:140px;">
         <option value="kb"<?php echo ($data['max_filesize_format'] == 'kb' ? ' selected' : ''); ?>><?php echo JText::_('COM_DATSOGALLERY_KB'); ?></option>
         <option value="mb"<?php echo ($data['max_filesize_format'] == 'mb' ? ' selected' : ''); ?>><?php echo JText::_('COM_DATSOGALLERY_MB'); ?></option>
      </select>
      </div>
    </div>
    <?php echo $this->form->renderField('upload_max_width'); ?>
<?php echo $this->form->renderField('upload_max_height'); ?>
<?php echo $this->form->renderField('upload_slice_size'); ?>
<?php
  if (count($groups)) {
    echo '<div class="control-group acl">';
    echo '<div class="control-label"><label id="jform_acl_7-lbl" class="hasPopover" title="' . JText::_('COM_DATSOGALLERY_MAX_IMAGES_PER_USER') . '" data-content="' . JText::_('COM_DATSOGALLERY_MAX_IMAGES_PER_USER_DESC') . '">' . JText::_('COM_DATSOGALLERY_MAX_IMAGES_PER_USER') . '</label></div>';
    foreach ($groups as $group) {
      echo '<br><div class="controls"><input name="jform[acl_' . @$group->value . ']" id="jform_acl_' . @$group->value . '" value="' . @$data['acl_' . $group->value] . '" type="text" size="6" style="max-width:55px;" required>&nbsp;';
      echo $group->text;
      echo '</div>';
    }
    echo '</div>';
  }
?>
<?php echo $this->form->renderField('show_terms'); ?>
<?php echo $this->form->renderField('terms_id'); ?>
<?php echo $this->form->renderField('upload_notify_admin'); ?>
<?php echo $this->form->renderField('upload_approval'); ?>
<?php echo $this->form->renderField('upload_approval_notify'); ?>
    </div>
    <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_CATEGORIES_SETTINGS'); ?></legend>
      <?php echo $this->form->renderField('users_categories'); ?>
<?php echo $this->form->renderField('allowed_categories'); ?>
<?php echo $this->form->renderField('members_category'); ?>
<?php echo $this->form->renderField('max_cats_per_member'); ?>
<?php echo $this->form->renderField('category_notify_admin'); ?>
<?php echo $this->form->renderField('category_approval'); ?>
      <legend><?php echo JText::_('COM_DATSOGALLERY_UPLOAD_GENERIC_FORM_SETTINGS'); ?></legend>
      <?php echo $this->form->renderField('generic_form'); ?>
<?php echo $this->form->renderField('generic_form_msg'); ?>
<?php echo $this->form->renderField('generic_form_category'); ?>
<?php echo $this->form->renderField('generic_form_title'); ?>
<?php echo $this->form->renderField('generic_form_author'); ?>
<?php echo $this->form->renderField('generic_form_author_url'); ?>
<?php echo $this->form->renderField('generic_form_geo'); ?>
<?php echo $this->form->renderField('generic_form_tags'); ?>
<?php echo $this->form->renderField('generic_form_description'); ?>
<?php echo $this->form->renderField('generic_form_language'); ?>
<?php echo $this->form->renderField('generic_form_apply_all'); ?>
      <legend><?php echo JText::_('COM_DATSOGALLERY_UPLOAD_INDIVIDUAL_FORM_SETTINGS'); ?></legend>
      <?php echo $this->form->renderField('individual_form_msg'); ?>
<?php echo $this->form->renderField('individual_form_author'); ?>
<?php echo $this->form->renderField('individual_form_author_url'); ?>
<?php echo $this->form->renderField('individual_form_tags'); ?>
<?php echo $this->form->renderField('individual_form_description'); ?>
<?php echo $this->form->renderField('individual_form_language'); ?>
    </div>
  </div>

  <?php echo JHtml::_('bootstrap.endTab'); ?>

    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'options', JText::_('COM_DATSOGALLERY_OPTIONS', true)); ?>
  <div class="row-fluid">
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_COMMENTS_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_comments'); ?>
<?php echo $this->form->renderField('comments_access'); ?>
<?php echo $this->form->renderField('comments_approval'); ?>
<?php echo $this->form->renderField('comment_notify'); ?>
<?php echo $this->form->renderField('comment_notify_words_limit'); ?>
<?php echo $this->form->renderField('comments_avatar'); ?>
<?php echo $this->form->renderField('sender_name'); ?>
<?php echo $this->form->renderField('comments_date_format'); ?>
<?php echo $this->form->renderField('comment_min_chars'); ?>
<?php echo $this->form->renderField('comments_captcha'); ?>
<?php echo $this->form->renderField('comments_captcha_type'); ?>
<?php echo $this->form->renderField('builtin_captcha_type'); ?>
<?php echo $this->form->renderField('recaptcha_public_key'); ?>
<?php echo $this->form->renderField('recaptcha_private_key'); ?>
<?php echo $this->form->renderField('recaptcha_badge'); ?>
<?php echo $this->form->renderField('recaptcha_theme'); ?>
<?php echo $this->form->renderField('recaptcha_size'); ?>
<?php echo $this->form->renderField('comments_dnsbl'); ?>
<?php echo $this->form->renderField('comments_dnsbl_servers'); ?>
<?php echo $this->form->renderField('comments_dnsbl_ratio'); ?>
<?php echo $this->form->renderField('comments_dnsbl_percentage'); ?>
<?php echo $this->form->renderField('comments_dnsbl_excluded'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_PAGINATION_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('category_pagination_type'); ?>
<?php echo $this->form->renderField('pagination_offset'); ?>
  </div>
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_HITS_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('hits_control'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_RATING_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_rating'); ?>
<?php echo $this->form->renderField('rating_access'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_FAVORITES_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_favorites'); ?>
<?php echo $this->form->renderField('download_favorites'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_AVATAR_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_avatar'); ?>
<?php echo $this->form->renderField('avatar_service'); ?>
<?php echo $this->form->renderField('js_activities'); ?>
<?php echo $this->form->renderField('js_limit'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_DOWNLOAD_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_downloads'); ?>
<?php echo $this->form->renderField('download_access'); ?>
<?php echo $this->form->renderField('download_filename'); ?>
<?php echo $this->form->renderField('download_with_watermark'); ?>
  </div>
  </div>
  <div class="row-fluid">
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_TAGS_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_tags'); ?>
<?php echo $this->form->renderField('tags_access'); ?>
<?php echo $this->form->renderField('max_tags_per_image'); ?>
<?php echo $this->form->renderField('min_tag_chars'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_SEARCH_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_search'); ?>
<?php echo $this->form->renderField('search_access'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_WATERMARK_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('watermarking'); ?>
<?php echo $this->form->renderField('global_watermark_size'); ?>
    <div class="control-group" data-showon='[{"field":"jform[watermarking]","values":["1"],"sign":"=","op":""}]' style="display: block;">
     <div class="control-label"><label class="hasPopover" title="<?php echo JText::_('COM_DATSOGALLERY_WATERMARK_FILE'); ?>" data-content="<?php echo JText::_('COM_DATSOGALLERY_WATERMARK_FILE_DESC'); ?>"><?php echo JText::_('COM_DATSOGALLERY_WATERMARK_FILE'); ?></label></div>
      <div class="controls"><iframe id="wm" src="index.php?option=com_datsogallery&task=settings.wmupload&tmpl=component" class="dg_wmframe" scrolling="no" seamless="seamless"></iframe></div>
     </div>
    <?php echo $this->form->renderField('global_watermark_position'); ?>
<?php echo $this->form->renderField('global_watermark_margin'); ?>
<?php echo $this->form->renderField('global_watermark_opacity'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_GEOTAGGING_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_geotagging'); ?>
<?php echo $this->form->renderField('gm_api_key'); ?>
<?php echo $this->form->renderField('ipgeo_api_key'); ?>
  </div>
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_MODAL_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_fancybox');
      echo $this->form->renderField('fancybox_access');
      echo $this->form->renderField('fancybox_image_width');
      echo $this->form->renderField('fancybox_image_height');
      echo $this->form->renderField('fancybox_image_watermark');
      echo $this->form->renderField('fancybox_watermark_position');

      echo $this->form->renderField('fancybox_slideshow');
      echo $this->form->renderField('fancybox_buttons_slideshow');
      echo $this->form->renderField('fancybox_autostart');
      echo $this->form->renderField('fancybox_autostart_speed');

      echo $this->form->renderField('fancybox_buttons_zoom');

      echo $this->form->renderField('fancybox_buttons_fullscreen');
      echo $this->form->renderField('fancybox_buttons_close');

      echo $this->form->renderField('fancybox_animationeffect');
      echo $this->form->renderField('fancybox_animationduration');
      echo $this->form->renderField('fancybox_transition');
      echo $this->form->renderField('fancybox_transitionduration');

      echo $this->form->renderField('fancybox_show_title');
    ?>

    <legend><?php echo JText::_('COM_DATSOGALLERY_REPORT_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('allow_report'); ?>
<?php echo $this->form->renderField('report_access'); ?>
<?php echo $this->form->renderField('report_captcha'); ?>
    <legend><?php echo JText::_('COM_DATSOGALLERY_COLOR_EXTRACT_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('extract_color'); ?>
<?php echo $this->form->renderField('color_number'); ?>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>

    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'seo', JText::_('COM_DATSOGALLERY_SEO', true)); ?>
  <div class="row-fluid">
  <div class="span6">
  <legend><?php echo JText::_('COM_DATSOGALLERY_SEO_SETTINGS'); ?></legend>
    <?php echo $this->form->renderField('sef_advanced'); ?>
<?php echo $this->form->renderField('transliterate_from'); ?>
<?php echo $this->form->renderField('transliterate_to'); ?>
<?php echo $this->form->renderField('meta_generator'); ?>
<?php echo $this->form->renderField('meta_characters_limit'); ?>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>

  <?php /*echo JHtml::_('bootstrap.addTab', 'myTab', 'paypal', JText::_('PayPal', true)); ?>
    <div class="row-fluid form-horizontal-desktop">
    <div class="form-vertical">
    <?php echo $this->form->renderField('metadesc'); ?>
    <?php echo $this->form->renderField('metakey'); ?>
    <?php echo $this->form->renderField('metadata'); ?>
    </div>
    </div>
  <?php echo JHtml::_('bootstrap.endTab');*/;?>

  <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'update', JText::_('COM_DATSOGALLERY_UPDATE', true)); ?>
  <div class="row-fluid form-horizontal-desktop">
  <div class="span6">
    <?php echo $this->form->renderField('license'); ?>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>

  <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'rules', JText::_('JCONFIG_PERMISSIONS_LABEL', true)); ?>
  <div class="row-fluid form-horizontal-desktop">
  <div class="form-vertical">
    <?php echo $this->form->renderField('rules'); ?>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>

  <?php if ($this->phoca): ?>
<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'migration', JText::_('COM_DATSOGALLERY_MIGRATION', true)); ?>
  <div class="row-fluid form-horizontal-desktop">
  <div class="form-vertical">
    <?php echo $this->loadTemplate('migration'); ?>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>
<?php endif;?>

  <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'maintenance', JText::_('COM_DATSOGALLERY_MAINTENANCE', true)); ?>
  <div class="row-fluid form-horizontal-desktop">
  <div class="span6">
    <legend><?php echo JText::_('COM_DATSOGALLERY_MAINTENANCE'); ?></legend>
    <?php echo $this->form->renderField('restoring'); ?>
    <div class="control-group">
        <div class="control-label"><label id="jform_clearallcolors-lbl" for="jform_clearallcolors" class="hasPopover" title="" data-content="<?php echo JText::_('COM_DATSOGALLERY_COLORS_CLEANING_DESC'); ?>" data-original-title="<?php echo JText::_('COM_DATSOGALLERY_COLORS_CLEANING'); ?>"><?php echo JText::_('COM_DATSOGALLERY_COLORS_CLEANING'); ?></label>
        </div>
        <?php $te = dg::dbtabledata('#__datsogallery_colors');?>
        <div class="controls">
          <span class="btn-wrapper">
            <a id="clearallcolors" class="btn btn-small btn-danger dg-cleaning-btn">
            <?php echo JText::_('COM_DATSOGALLERY_CLEAR'); ?></a>
          </span>
          <span id="clearcolorsresult" class="dg-cleaning-result"><?php echo JText::sprintf('COM_DATSOGALLERY_TABLE_ENTRIES', $te->rows, $te->rows == '0' ? '0' : $te->size); ?></span>
        </div>
    </div>
    <?php if (JFolder::exists(JPATH_SITE . $settings->path_to_webp)) {?>
    <div class="control-group">
        <div class="control-label"><label id="jform_cleandir-lbl" for="jform_cleandir" class="hasPopover" title="" data-content="<?php echo JText::_('COM_DATSOGALLERY_WEBP_DIRECTORY_CLEANING_DESC'); ?>" data-original-title="<?php echo JText::_('COM_DATSOGALLERY_WEBP_DIRECTORY_CLEANING'); ?>"><?php echo JText::_('COM_DATSOGALLERY_WEBP_DIRECTORY_CLEANING'); ?></label>
        </div>
        <div class="controls">
          <span class="btn-wrapper">
            <a id="cleandirwebp" class="btn btn-small btn-danger dg-cleaning-btn">
            <?php echo JText::_('COM_DATSOGALLERY_CLEAR'); ?></a>
          </span>
          <span id="cleandirwebpresult" class="dg-cleaning-result"><?php echo JText::sprintf('COM_DATSOGALLERY_DIRECTORY_SIZE', dg::dirsize($settings->path_to_webp)); ?></span>
        </div>
    </div>
    <?php }?>
    <div class="control-group">
        <div class="control-label"><label id="jform_cleandir-lbl" for="jform_cleandir" class="hasPopover" title="" data-content="<?php echo JText::_('COM_DATSOGALLERY_CACHE_DIRECTORY_CLEANING_DESC'); ?>" data-original-title="<?php echo JText::_('COM_DATSOGALLERY_CACHE_DIRECTORY_CLEANING'); ?>"><?php echo JText::_('COM_DATSOGALLERY_CACHE_DIRECTORY_CLEANING'); ?></label>
        </div>
        <div class="controls">
          <span class="btn-wrapper">
            <a id="cleandircache" class="btn btn-small btn-danger dg-cleaning-btn">
            <?php echo JText::_('COM_DATSOGALLERY_CLEAR'); ?></a>
          </span>
          <span id="cleandircacheresult" class="dg-cleaning-result"><?php echo JText::sprintf('COM_DATSOGALLERY_DIRECTORY_SIZE', dg::dirsize($settings->path_to_images)); ?></span>
        </div>
    </div>
    <legend><?php echo JText::_('COM_DATSOGALLERY_CUSTOM_CSS'); ?></legend>
    <div class="control-group">
        <div class="control-label"><label id="jform_custom_css-lbl" for="jform_custom_css" class="hasPopover" title="" data-content="<?php echo JText::_('COM_DATSOGALLERY_CUSTOM_CSS_DESC'); ?>" data-original-title="<?php echo JText::_('COM_DATSOGALLERY_CUSTOM_CSS'); ?>"><?php echo JText::_('COM_DATSOGALLERY_CUSTOM_CSS'); ?></label>
        </div>
        <div class="controls">
          <?php
            $editor     = JEditor::getInstance('codemirror');
            $params     = array('class' => 'html', 'codetype' => 'text/css');
            $custom_css = dg::read_custom_css();
            echo $editor->display('jform[custom_css]', $custom_css, '100%', '100', '', '', false, null, null, null, $params);
          ?>
        </div>
    </div>
  </div>
  </div>
  <?php echo JHtml::_('bootstrap.endTab'); ?>

  <?php echo JHtml::_('bootstrap.endTabSet'); ?>

</div>
<input type="hidden" name="option" value="com_datsogallery" />
<input type="hidden" name="task" value="" />
<input type="hidden" name="controller" value="settings" />
<?php echo JHtml::_('form.token'); ?>
</div>
</div>
</form>

<script>
jQuery(document).on('click', '#clearallcolors', function(){
    if (!confirm("<?php echo JText::_('COM_DATSOGALLERY_ARE_YOU_SURE'); ?>")){
      return false;
    }
    jQuery.get('index.php?option=com_datsogallery&task=settings.clearcolors&<?=JSession::getFormToken();?>=1', function(data){
      if (data) {
        var json = jQuery.parseJSON(data)
        jQuery('#clearcolorsresult').fadeIn().addClass('dg-text-'+json.status).text(json.message);
        setTimeout(function(){
          jQuery('#clearcolorsresult').fadeOut().removeClass('dg-text-'+json.status).text('');
        }, 4000);
      }
    });
});
jQuery(document).on('click', '#cleandirwebp', function(){
    if (!confirm("<?php echo JText::_('COM_DATSOGALLERY_ARE_YOU_SURE'); ?>")){
      return false;
    }
    jQuery.get('index.php?option=com_datsogallery&task=settings.cleandir&dir=webp&<?=JSession::getFormToken();?>=1', function(data){
      if (data) {
        var json = jQuery.parseJSON(data)
        jQuery('#cleandirwebpresult').fadeIn().addClass('dg-text-'+json.status).text(json.message);
        setTimeout(function(){
          jQuery('#cleandirwebpresult').fadeOut().removeClass('dg-text-'+json.status).text('');
        }, 4000);
      }
    });
});
jQuery(document).on('click', '#cleandircache', function(){
    if (!confirm("<?php echo JText::_('COM_DATSOGALLERY_ARE_YOU_SURE'); ?>")){
      return false;
    }
    jQuery.get('index.php?option=com_datsogallery&task=settings.cleandir&dir=cache&<?=JSession::getFormToken();?>=1', function(data){
      if (data) {
        var json = jQuery.parseJSON(data)
        jQuery('#cleandircacheresult').fadeIn().addClass('dg-text-'+json.status).text(json.message);
        setTimeout(function(){
          jQuery('#cleandircacheresult').fadeOut().removeClass('dg-text-'+json.status).text('');
        }, 4000);
      }
    });
});
jQuery(document).ready(function() {
  if (jQuery("#jform_users_categories0").is(":checked")) {
    jQuery("#jform_members_category").prop('required', true);
    jQuery("#jform_allowed_categories").prop("required", false);
  } else {
    jQuery("#jform_members_category").prop("required", false);
    jQuery("#jform_allowed_categories").prop('required', true);
  }
});
jQuery(document).on('click', '#jform_users_categories input', function() {
  if (jQuery(this).val() == 1) {
    jQuery("#jform_members_category").prop('required', true);
    jQuery("#jform_allowed_categories").prop("required", false);
  } else {
    jQuery("#jform_members_category").prop("required", false);
    jQuery("#jform_allowed_categories").prop('required', true);
  }
});
function getUrlParam(variable) {
  switch (variable)
  {
    default:
      return false;
    break;

    case 'option':
      return 'com_config';
    break;

    case 'view':
      return 'component';
    break;

    case 'component':
      return 'com_datsogallery';
    break;
  }
}
jQuery(function($) {
  var json, tabsState;
  $('a[data-toggle="pill"], a[data-toggle="tab"]').on('shown', function(e) {
    var href, json, parentId, tabsState;

    tabsState = localStorage.getItem("tabs-state");
    json = JSON.parse(tabsState || "{}");
    parentId = $(e.target).parents("ul.nav.nav-pills, ul.nav.nav-tabs").attr("id");
    href = $(e.target).attr('href');
    json[parentId] = href;

    return localStorage.setItem("tabs-state", JSON.stringify(json));
  });

  tabsState = localStorage.getItem("tabs-state");
  json = JSON.parse(tabsState || "{}");

  $.each(json, function(containerId, href) {
    return $("#" + containerId + " a[href=" + href + "]").tab('show');
  });

  $("ul.nav.nav-pills, ul.nav.nav-tabs").each(function() {
    var $this = $(this);
    if (!json[$this.attr("id")]) {
      return $this.find("a[data-toggle=tab]:first, a[data-toggle=pill]:first").tab("show");
    }
  });
  $('.control-group.acl input').each(function() {
    var default_value = 10;
    $(this).focus(function() {
      if(this.value == default_value) {
          this.value = '';
      }
    });
    $(this).blur(function() {
      if(this.value == '') {
          this.value = default_value;
      }
    });
  });
});
</script>


