<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class DatsogalleryViewImages extends JViewLegacy {

  protected $items;
  protected $pagination;
  protected $state;
  public $filterForm;
  public $activeFilters;

  public function display($tpl = null) {
    $this->state         = $this->get('State');
    $this->items         = $this->get('Items');
    $this->filterForm    = $this->get('FilterForm');
    $this->activeFilters = $this->get('ActiveFilters');
    $this->pagination    = $this->get('Pagination');
    $this->settings      = dg::getConfig();
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    dg::addSubmenu('images');
    $this->addToolbar();
    $this->sidebar = JHtmlSidebar::render();
    JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
    parent::display($tpl);
  }

  protected function addToolbar() {
    require_once JPATH_COMPONENT . '/helpers/datsogallery.php';
    $state = $this->get('State');
    $canDo = dg::getActions($state->get('filter.category_id'));
    $bar   = JToolbar::getInstance('toolbar');
    JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_IMAGES'), 'images.png');
    $formPath = JPATH_COMPONENT . '/views/image';
    if (file_exists($formPath)) {
      if ($canDo->get('core.edit') && isset($this->items[0])) {
        JToolBarHelper::editList('image.edit', 'JTOOLBAR_EDIT');
      }
    }
    if ($canDo->get('core.edit.state')) {
      if (isset($this->items[0]->state)) {
        JToolBarHelper::custom('images.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
        JToolBarHelper::custom('images.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
        JToolbarHelper::custom('images.approved', 'featured.png', 'featured_f2.png', 'COM_DATSOGALLERY_APPROVE', true);
        JToolbarHelper::custom('images.unapproved', 'unfeatured.png', 'featured_f2.png', 'COM_DATSOGALLERY_UNAPPROVE', true);
        JToolbarHelper::custom('images.featured', 'featured.png', 'featured_f2.png', 'COM_DATSOGALLERY_FEATURE_IT', true);
        JToolbarHelper::custom('images.unfeatured', 'unfeatured.png', 'featured_f2.png', 'COM_DATSOGALLERY_UNFEATURE_IT', true);
        JToolbarHelper::checkin('images.checkin');
        JToolBarHelper::deleteList('', 'images.delete', 'JTOOLBAR_DELETE');
        $title  = JText::_('JTOOLBAR_BATCH');
        $layout = new JLayoutFile('joomla.toolbar.batch');
        $dhtml  = $layout->render(array('title' => $title));
        $bar->appendButton('Custom', $dhtml, 'batch');
      }
    }
    JHtmlSidebar::setAction('index.php?option=com_datsogallery&view=images');
  }

  public function sortCategory() {
    jimport('joomla.form.form');
    $options = array();
    JForm::addFormPath(JPATH_COMPONENT . '/models/forms');
    $form      = JForm::getInstance('com_datsogallery.image', 'image');
    $field     = $form->getField('catid');
    $query     = $form->getFieldAttribute('catid', 'query');
    $translate = $form->getFieldAttribute('catid', 'translate');
    $key       = $form->getFieldAttribute('catid', 'key_field');
    $value     = $form->getFieldAttribute('catid', 'value_field');
    $db        = JFactory::getDBO();
    $db->setQuery($query);
    $items = $db->loadObjectlist();
    if (!empty($items)) {
      foreach ($items as $item) {
        if ($translate == true) {
          $options[] = JHtml::_('select.option', $item->$key, JText::_($item->$value));
        } else {
          $options[] = JHtml::_('select.option', $item->$key, $item->$value);
        }
      }
    }
    return $options;
  }
}
