<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
require_once (JPATH_COMPONENT.'/images.php');
JHtml::_('behavior.core');
JHtml::_('bootstrap.tooltip', '.hasTooltip', array('placement' => 'bottom'));
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('jquery.framework');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHTML::_('behavior.modal');
JHtml::_('formbehavior.chosen', 'select');
$app = JFactory::getApplication();
$doc = JFactory::getDocument();
$lang = $app->getUserStateFromRequest('datsogallery.button.language', 'language', '', 'string');
$catid = $app->getUserStateFromRequest('datsogallery.button.catid', 'catid', 0, 'int');
$sortCat = $this->state->get('filter.catid');
$sortCategory = $this->sortCategory();
$doc->addStyleSheet(JUri::root(true).'/media/jui/css/jquery.searchtools.css');
$doc->addStyleSheet(JUri::root(true).'/components/com_datsogallery/assets/css/dg-ui.css');
$doc->addStyleSheet(JUri::root(true).'/components/com_datsogallery/assets/css/icons.css');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
$editor = $app->input->get('editor', '', 'cmd');
$lang = $app->getUserStateFromRequest('datsogallery.button.language', 'language', '', 'string');
$doc->addScriptDeclaration("function insertDatsoPics() {
  for (var b = 0; b < document.getElementsByClassName('dgpic_select').length; b++) {
    if (document.getElementsByClassName('dgpic_select')[b].checked == true) {
      var align = document.getElementById('align').value;
      if (align) {
        align = ' ' + align;
      } else {
        align = '';
      }
      var id = document.getElementsByClassName('dgpic_select')[b].value;
      var tag = '{datsopic:' + id + align + '}';
      window.parent.jInsertEditorText(tag, '".$editor."')
    }
  }
  window.parent.SqueezeBox.close();
  return false
};
jQuery(document).ready(function() {
  jQuery('.check:checkbox').click(function() {
    var checked = !jQuery(this).data('checked');
    jQuery('input:checkbox').prop('checked', checked);
    jQuery(this).val(checked ? 'uncheckall' : 'checkall')
    jQuery(this).data('checked', checked);
  })
});");
?>
<style type="text/css">
body.contentpane {padding:0 !important;}
body.contentpane .icon-save::before {color: #fff;}
</style>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&view=images&layout=modal&tmpl=component&editor='.$editor); ?>" method="post" name="adminForm" id="adminForm">
<div class="js-stools clearfix">
  <div class="clearfix" style="display:flex">
    <div class="js-stools-container-bar">
      <label for="filter_search" class="element-invisible"><?php echo JText::_('JSEARCH_FILTER'); ?></label>
      <div class="btn-wrapper input-append">
        <input type="text" name="filter_search" id="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER'); ?>" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('JSEARCH_FILTER'); ?>" />
        <button type="submit" class="btn hasTooltip" title="<?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?>">
        <span class="icon-search"></span>
        </button>
      </div>
      <div class="btn-wrapper">
        <button type="button" class="btn hasTooltip js-stools-btn-clear" title="<?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.id('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
      </div>
    </div>
  </div>
  <div class="clearfix" style="display:flex">
    <div class="js-stools-container-filters clearfix js-stools-container-filters-visible shown" style="">
      <div class="js-stools-field-filter">
        <select name="filter_catid" class="dginput-small" onchange="this.form.submit()">
        <?php echo JHtml::_('select.options', $sortCategory, 'value', 'text', $sortCat); ?>
        </select>
      </div>
      <div class="js-stools-field-filter">
        <select name="language" onchange="this.form.submit()">
          <option value="" selected disabled><?php echo JText::_('JOPTION_SELECT_LANGUAGE'); ?></option>
          <?php echo JHtml::_('select.options', JHtml::_('contentlanguage.existing', true, true), 'value', 'text', $lang); ?>
        </select>
      </div>
      <div class="js-stools-field-filter">
        <select id="align">
          <option value="" selected disabled><?php echo JText::_('COM_DATSOGALLERY_ALIGN'); ?></option>
          <option value=""><?php echo JText::_('COM_DATSOGALLERY_NOT_SET'); ?></option>
          <option value="left"><?php echo JText::_('COM_DATSOGALLERY_ALIGN_LEFT'); ?></option>
          <option value="right"><?php echo JText::_('COM_DATSOGALLERY_ALIGN_RIGHT'); ?></option>
        </select>
      </div>
      <div class="js-stools-field-filter">
        <div class="btn-wrapper input-append">
          <input type="checkbox" class="check" value="checkall">
          <span class="dg-all"><?php echo JText::_('COM_DATSOGALLERY_ALL'); ?></span>
        </div>
      </div>
      <div class="js-stools-field-filter">
        <div id="dginsert" class="btn-wrapper" id="toolbar-apply">
          <button onclick="insertDatsoPics();" class="btn btn-success hasTooltip" title="<?php echo JText::_('COM_DATSOGALLERY_INSERT'); ?>">
          <span class="icon-save icon-white"></span></button>
        </div>
      </div>
    </div>
  </div>
</div>
<div>
  <div style="float:right;margin-right:10px;"><?php echo $this->pagination->getLimitBox(); ?></div>
  <?php echo $this->pagination->getListFooter(); ?>
</div>
<div class="clearfix"></div>
<?php if (empty($this->items)) : ?>
<div class="alert alert-no-items">
  <?php echo JText::_('COM_DATSOGALLERY_MSG_NO_IMAGES'); ?>
</div>
<?php
else :
  echo '<ul id="datsogallery_content_list">';
  foreach ($this->items as $i => $item) {
    $resized = resize($item->original, 120, 120, 1, '1:1', 0, $catid);
    echo '<li>';
    echo '<label class="checkbox"><input type="checkbox" value="'.$item->id.'" class="dgpic_select"><i></i></label>';
    echo '<img class=" hasTooltip" src="'.$resized.'" alt="'.$item->title.'" title="'.$item->title.'<br><em>'.$item->category_title.'</em>" />';
    echo '<div class="title"><span>'.dg::shortitle($item->title, 16).'</span></div>';
    echo '</li>';
  }
  echo '</ul>';
endif; ?>
<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0" />
<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
<?php echo JHtml::_('form.token'); ?>
</form>
