<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

$app = JFactory::getApplication();

if ($app->isClient('site'))
{
  JSession::checkToken('get') or die(JText::_('JINVALID_TOKEN'));
}

require_once (JPATH_COMPONENT.'/images.php');

JHtml::_('behavior.core');
JHtml::_('bootstrap.tooltip', '.hasTooltip', array('placement' => 'bottom'));
JHtml::_('formbehavior.chosen', 'select');

JHtml::_('jquery.framework');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHTML::_('behavior.modal');


$app = JFactory::getApplication();
$doc = JFactory::getDocument();
$lang = $app->getUserStateFromRequest('datsogallery.button.language', 'language', '', 'string');
$catid = $app->getUserStateFromRequest('datsogallery.button.catid', 'catid', 0, 'int');
$sortCat = $this->state->get('filter.catid');
$sortCategory = $this->sortCategory();
$doc->addStyleSheet(JUri::root(true).'/components/com_datsogallery/assets/css/dg-ui.css');
$doc->addStyleSheet(JUri::root(true).'/components/com_datsogallery/assets/css/icons.css');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
$editor    = JFactory::getApplication()->input->get('editor', '', 'cmd');
$lang = $app->getUserStateFromRequest('datsogallery.button.language', 'language', '', 'string');
$js = "function insertCatPicId(original,image_id) {
var pw = window.parent.document;
      jQuery(pw).find('#thumbview').html('<div><img src=\"'+original+'\" alt=\"preview\" /></div>');
      jQuery(pw).find('#jform_image_id').val(image_id);
      return false;
    }";
$doc->addScriptDeclaration($js);
?>

<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&view=images&layout=cover&tmpl=component&'.JSession::getFormToken().'=1'); ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
<?php
echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
echo $this->pagination->getListFooter();
if (empty($this->items)) : ?>
<div class="alert alert-no-items">
	<?php echo JText::_('COM_MODULES_MSG_MANAGE_NO_MODULES'); ?>
</div>
<?php
else :
  echo '<ul id="datsogallery_content_list">';
  foreach ($this->items as $i => $item) {
      $resized = resize($item->original, 220, 220, 1, '1:1', 0, $catid);
      echo '<li>';
      echo '<a onclick="insertCatPicId('.htmlspecialchars(json_encode($resized)).','.htmlspecialchars(json_encode($item->id)).');window.parent.jModalClose();return false;" data-dismiss="modal">';
      echo '<img class=" hasTooltip" src="'.$resized.'" alt="'.$item->title.'" title="'.$item->title.'" />';
      echo '<div class="title"><span>'.dg::shortitle($item->title, 20).'</span></div></a>';
      echo '</li>';
  }
  echo '</ul>';
endif;
?>
<input type="hidden" name="task" value="" />
<input type="hidden" name="boxchecked" value="0" />
<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
<?php echo JHtml::_('form.token'); ?>
</form>
