<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

JHtml::_('jquery.framework');
JHtml::_('formbehavior.chosen', 'select');

$app = JFactory::getApplication();
$editor = $app->input->get('editor', '', 'cmd');
$doc = JFactory::getDocument();
$js = "function insertAllvideos(editor) {
          window.parent.jInsertEditorText('{AllVideos}', editor);
        }";
$doc->addScriptDeclaration($js);
$files = glob(JPATH_SITE.'/images/videos/*.{avi,m4v,mkv,mp4,ogv,webm,flac,mp3,ogg,oga,wav,AVI,M4V,MKV,MP4,OGV,WEBM,FLAC,MP3,OGG,OGA,WAV}', GLOB_BRACE);
?>
<div style="display:flex;margin:0 -5px">
  <div class="control-group" style="flex:1;margin:0 5px">
    <div class="control-label">
      <label for="resource">Выбрать ресурс видеоматериала</label>
    </div>
    <div class="controls">
      <select id="resource" name="resource" size="1">
        <option value="mediaprovider" selected>Медиа провайдер</option>
        <option value="local">Локальный файл</option>
      </select>
    </div>
  </div>
  <div class="control-group" style="flex:1;margin:0 5px">
    <div class="mediaprovider">
      <div class="control-label">
        <label class="list">Медиа провайдер</label>
      </div>
      <div class="controls">
      <select id="provider" name="provider" size="1">
        <option value="dailymotion">dailymotion.com</option>
        <option value="facebook">facebook.com</option>
        <option value="flickr">flickr.com</option>
        <option value="soundcloud">soundcloud.com (audio)</option>
        <option value="twitch">twitch.tv</option>
        <option value="vimeo">vimeo.com</option>
        <option value="youtube" selected>youtube.com</option>
      </select>
      </div>
    </div>
    <div class="local hide">
      <div class="control-label">
        <label class="list">Локальные видеоматериалы</label>
      </div>
      <div class="controls">
      <select id="local" name="local" size="1">
        <option value="">Выбрать видеоматериал</option>
        <?php foreach ($files as $k => $v) { ?>
        <option value="<?= basename($v) ?>"><?= basename($v) ?></option>
        <?php } ?>
      </select>
      </div>
    </div>
  </div>
</div>

<div style="display:flex;margin:10px 0">
  <div id="mediaurl" class="control-group" style="width:100%">
    <div class="alert alert-info" style="margin-top:18px"><p>Чтобы вставить в статью видеоматериал через «Медиа провайдер», выберите из списка требуемый, затем, в поле «Ссылка или идентификатор» вставьте полную ссылку или просто идентификатор (пример: KvRVky0r7YM), после чего нажмите кнопку «Вставить тэг».</p></div>
    <div class="control-label">
      <label for="url">Ссылка или идентификатор</label>
    </div>
    <div class="controls">
      <input type="text" name="url" id="url" class="input-xxlarge" placeholder="Вставить полную ссылку или просто идентификатор (пример: KvRVky0r7YM)">
    </div>
  </div>
  <div id="localfile" class="control-group hide" style="width:100%">
    <div class="alert alert-info" style="margin-top:18px"><p>Чтобы вставить в статью локальный видеоматериал (видеофайл), прежде, его нужно загрузить в папку <strong>/images/videos</strong> через загрузчик <a href="index.php?option=com_media" target="_blank" title="Открыть Медиа-менеджер в новой вкладке">«Медиа-менеджер»</a> или с помощью клиента FTP. Затем, его можно будет выбрать из списка «Локальные видеоматериалы», а в поле «Локальный видеоматериал» автоматически будет сгенерирован специальный тэг для вставки в статью.</p><p>Поддерживаемые расширения: «avi, m4v, mkv, mp4, ogv, webm, flac, mp3, ogg, oga, wav».</p><p><em>Примечание: Расширения видеофайлов должны быть либо в верхнем, либо в нижнем регистре, то бишь, <strong style="color:#DC143C">Mp4</strong> - не правильно. Нужно <strong style="color:#3CB371">MP4</strong> или <strong style="color:#3CB371">mp4</strong></em></p></div>
    <div class="control-label">
      <label for="url">Локальный видеоматериал</label>
    </div>
    <div class="controls">
      <input type="text" name="localtag" id="localtag" class="input-xxlarge" placeholder="Тэг для локального видеоматериала">
    </div>
  </div>
</div>
<button type="button" class="btn btn-success" id="inserttag">Вставить тэг</button>
<style type="text/css">.chzn-container{width:100% !important}</style>
<script>
(function($) {
  var mediaurltext = '<p>Чтобы вставить в статью видеоматериал через «Медиа провайдер», выберите из списка требуемый, затем, в поле «Ссылка или идентификатор» вставьте полную ссылку или просто идентификатор (пример: KvRVky0r7YM), после чего нажмите кнопку «Вставить тэг».</p>',
      localfiletext = '<p>Чтобы вставить в статью локальный видеоматериал (видеофайл), прежде, его нужно загрузить в папку <strong>/images/videos</strong> через загрузчик <a href="index.php?option=com_media" target="_blank" title="Открыть Медиа-менеджер в новой вкладке">«Медиа-менеджер»</a> или с помощью клиента FTP. Затем, его можно будет выбрать из списка «Локальные видеоматериалы», а в поле «Локальный видеоматериал» автоматически будет сгенерирован специальный тэг для вставки в статью.</p><p>Поддерживаемые расширения: «avi, m4v, mkv, mp4, ogv, webm, flac, mp3, ogg, oga, wav».</p><p><em>Примечание: Расширения видеофайлов должны быть либо в верхнем, либо в нижнем регистре, то бишь, <strong style="color:#DC143C">Mp4</strong> - не правильно. Нужно <strong style="color:#3CB371">MP4</strong> или <strong style="color:#3CB371">mp4</strong></em></p>';
  $(document).on('change', '#resource', function() {
    var provider = $(this).val();
    if (provider == 'mediaprovider') {
      $('.local').hide();
      $('.mediaprovider').show();
      $('#mediaurl').show();
      $('#localfile').hide();
    }
    if (provider == 'local') {
      $('.mediaprovider').hide();
      $('#mediaurl').hide();
      $('.local').show();
      $('#localfile').show();
    }
  });
  $(document).on('change', '#local', function() {
    var videofile = $(this).val(),
        ext = videofile.split('.').pop().toLowerCase(),
        name = videofile.split('.').slice(0, -1).join('.');
    if (videofile.length !== 0) {
      $('#localtag').val(name);
    } else {
      $('#localtag').val('');
    }
  });
  $(document).on('click', '#inserttag', function() {
    var provider = $('#resource').val(),
        mediaprovider = $('#provider').val(),
        videofile = $('#local').val(),
        url = $('#url').val(),
        ext = provider == 'mediaprovider' ? mediaprovider : videofile.split('.').pop().toLowerCase(),
        name = provider == 'mediaprovider' ? url : videofile.split('.').slice(0, -1).join('.'),
        articletext = window.parent.tinymce.activeEditor.selection.getContent(),
        tag = '{'+ext+'}'+name+'{/'+ext+'}';
    if (provider == 'mediaprovider' && url.length === 0) {
      $('#mediaurl .alert').toggleClass('alert-info alert-error').text('Ссылка на видеоматериал или идентификатор обязательны');
      setTimeout(function() {
          $('#mediaurl .alert').toggleClass('alert-error alert-info').html(mediaurltext);
      }, 3000);
    } else if (provider == 'local' && videofile.length === 0) {
      $('#localfile .alert').toggleClass('alert-info alert-error').text('Выберите файл из списка «Локальные видеоматериалы»');
      setTimeout(function() {
          $('#localfile .alert').toggleClass('alert-error alert-info').html(localfiletext);
      }, 3000);
    } else {
      window.parent.jInsertEditorText(tag, '<?= $editor ?>');
    }
  });
})(jQuery);
</script>