<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class DatsogalleryViewComments extends JViewLegacy {
	protected $items;
	protected $pagination;
	protected $state;
  public $filterForm;
	public $activeFilters;

	public function display($tpl = null) {
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
    $this->filterForm = $this->get('FilterForm');
    $this->activeFilters = $this->get('ActiveFilters');
		$this->pagination = $this->get('Pagination');
		if (count($errors = $this->get('Errors'))) {
			throw new Exception(implode("\n", $errors));
		}
		dg::addSubmenu('comments');
		$this->addToolbar();
		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	protected function addToolbar() {
		require_once JPATH_COMPONENT.'/helpers/datsogallery.php';
		$state = $this->get('State');
		$canDo = dg::getActions($state->get('filter.category_id'));
		JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_COMMENTS'), 'comments.png');
		if ($canDo->get('core.edit.state')) {
			if (isset($this->items[0]->state)) {
				JToolBarHelper::divider();
				JToolBarHelper::custom('comments.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
				JToolBarHelper::custom('comments.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
			}
			else
				if (isset($this->items[0])) {
					JToolBarHelper::deleteList('', 'comments.delete', 'JTOOLBAR_DELETE');
				}
		}
		if ($canDo->get('core.delete') && isset($this->items[0]->state)) {
				JToolBarHelper::deleteList('', 'comments.delete', 'JTOOLBAR_DELETE');
		}
	}

}