<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

require_once (JPATH_COMPONENT.'/images.php');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');
$settings = dg::getConfig();
$doc = JFactory::getDocument();
$lng = substr($doc->language, 0, 2);
$doc->addScript(JUri::base(true).'/components/com_datsogallery/assets/js/jquery.map.js');
$user	= JFactory::getUser();
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
?>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&view=comments'); ?>" method="post" name="adminForm" id="adminForm" class="dg-style">
   <?php if(!empty($this->sidebar)): ?>
   <div id="j-sidebar-container" class="col col-2">
      <div class="filling">
        <?php echo $this->sidebar; ?>
      </div>
   </div>
   <div id="j-main-container" class="col col-10">
      <?php else : ?>
      <div id="j-main-container">
         <?php endif;?>
         <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
         <table class="table table-striped" id="commentList">
            <thead>
               <tr>
                  <th width="1%" class="hidden-phone">
                     <?php echo JHtml::_('grid.checkall'); ?>
                  </th>
                  <?php if (isset($this->items[0]->state)): ?>
                  <th width="1%" class="nowrap center">
                     <?php echo JHtml::_('searchtools.sort', 'COM_DATSOGALLERY_ACTIONS', 'a.state', $listDirn, $listOrder); ?>
                  </th>
                  <?php endif; ?>
                  <th class="left" style="width:200px;">
                     <?php echo JHtml::_("searchtools.sort",  "COM_DATSOGALLERY_COMMENTS_IMAGE_ID", "a.image_id", $listDirn, $listOrder); ?>
                  </th>
                  <th class="left">
                     <?php echo JHtml::_("searchtools.sort",  "COM_DATSOGALLERY_COMMENTS_TEXT", "a.text", $listDirn, $listOrder); ?>
                  </th>
                  <th style="width:80px" class="nowrap center hidden-phone">
                    <?php echo JText::_('COM_DATSOGALLERY_LAKES'); ?>
                  </th>
                  <th class="left">
                     <?php echo JHtml::_("searchtools.sort",  "COM_DATSOGALLERY_COMMENTS_USER_IP", "a.user_ip", $listDirn, $listOrder); ?>
                  </th>
                  <th class="left hidden-phone">
                     <?php echo JHtml::_("searchtools.sort",  "COM_DATSOGALLERY_COMMENTS_USER_NAME", "a.user_name", $listDirn, $listOrder); ?>
                  </th>
                  <th class="left hidden-phone">
                     <?php echo JHtml::_("searchtools.sort",  "COM_DATSOGALLERY_COMMENTS_USER_EMAIL", "a.user_email", $listDirn, $listOrder); ?>
                  </th>
                  <th class="left hidden-phone">
                     <?php echo JHtml::_("searchtools.sort",  "COM_DATSOGALLERY_COMMENTS_DATE", "a.date", $listDirn, $listOrder); ?>
                  </th>
                  <?php if (isset($this->items[0]->id)): ?>
                  <th width="1%" class="nowrap center hidden-phone">
                     <?php echo JHtml::_("searchtools.sort", "JGRID_HEADING_ID", "a.id", $listDirn, $listOrder); ?>
                  </th>
                  <?php endif; ?>
               </tr>
            </thead>
            <tfoot>
               <?php
                  if(isset($this->items[0])){
                      $colspan = count(get_object_vars($this->items[0]));
                  }
                  else{
                      $colspan = 10;
                  }
                  ?>
               <tr>
                  <td colspan="<?php echo $colspan ?>">
                     <?php echo $this->pagination->getListFooter(); ?>
                  </td>
               </tr>
            </tfoot>
            <tbody>
               <?php foreach ($this->items as $i => $item) :
                  $ordering   = ($listOrder == 'a.ordering');
                  $canCreate	= $user->authorise('core.create',		'com_datsogallery');
                  $canEdit  	= $user->authorise('core.edit',			'com_datsogallery');
                  $canCheckin	= $user->authorise('core.manage',		'com_datsogallery');
                  $canChange	= $user->authorise('core.edit.state',	'com_datsogallery');
                  ?>
               <tr class="row<?php echo $i % 2; ?>">
                  <td class="center hidden-phone">
                     <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                  </td>
                  <td class="center">
                     <div class="btn-group" style="display:flex">
                        <?php
                           $userid = $item->created_by != 0 ? $item->created_by : 0;
                           echo JHtml::_('datsogallery.published', $item->state, $i, $canChange, 'comments');
                           echo JHtml::_('datsogallery.edit', $item->id, $canChange, 'comment');
                           echo JHtml::_('datsogallery.block', $item->user_ip, $userid, $canChange, 'blacklist');
                           ?>
                     </div>
                  </td>
                  <td class="nowrap">
                    <div style="display:flex">
                    <div class="zoombox">
                      <a href="#" class="dg-image-modal" title="<?php echo JText::_('COM_DATSOGALLERY_OPEN_MODAL'); ?>" data-toggle="modal" data-target="#dg-modal" data-img-url="<?php echo JUri::base(); ?>index.php?option=com_datsogallery&task=image.sbox&catid=<?php echo $item->category_id; ?>&id=<?php echo $item->image_id; ?>">
                        <div class="crop showbox" style="background-image: url('<?php echo resize($item->original, 200, 200, 1, '1:1', 0, $item->category_id);?>');"></div>
                      </a>
                    </div>
                     <div class="hidden-phone dg-ellipsis" style="position:relative;top:4px;max-width:200px" title="<?php echo JText::_($this->escape($item->image_title)); ?>"><?php echo $this->escape($item->image_title); ?></div>
                    </div>
                  </td>
                  <td style="width:30%">
                     <span class="ellipsis" style="max-width:400px" title="<?php echo $this->escape($item->text); ?>"><?php echo $this->escape($item->text); ?></span>
                  </td>
                  <td class="nowrap center hidden-phone td-icon">
                    <?php $lcolor = dg::commentlikes($item->id) > 0 ? '#f36b6b' : '#999'; ?>
                      <i class="dgi-like" style="color:<?= $lcolor ?>"></i>
                      <span class="badge"><?php echo dg::commentlikes($item->id); ?></span>
                  </td>
                  <td class="nowrap">
                     <?php if (isset($item->checked_out) && $item->checked_out) : ?>
                     <?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'comments.', $canCheckin); ?>
                     <?php endif; ?>
                     <?php if ($canEdit) : ?>
                     <a href="#" class="dg-ip-modal" data-toggle="modal" data-target="#dg-modal"><i class="icon-screen"></i><?php echo $this->escape($item->user_ip); ?></a>
                     <?php else : ?>
                     <?php echo $this->escape($item->user_ip); ?>
                     <?php endif; ?>
                  </td>
                  <td class="hidden-phone nowrap">
                     <?php if ($item->created_by != 0) : ?>
                     <a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id=' . $item->created_by); ?>" title="Edit User <?= JFactory::getUser($item->created_by)->get('name') ?>">
                     <?= JFactory::getUser($item->created_by)->get('name') ?>
                     </a>
                     <?php else : ?>
                     <?= JFactory::getUser($item->created_by)->get('name') ?>
                     <?php endif; ?>
                  </td>
                  <td class="hidden-phone nowrap">
                     <?= $item->created_by != 0 ? JFactory::getUser($item->created_by)->get('email') : $item->user_email; ?>
                  </td>
                  <td class="hidden-phone" style="font-size: 10px; font-weight: 500;line-height: 15px;">
                     <?php echo JHtml::_('date', dg::timezone($item->date), JText::_('COM_DATSOGALLERY_DATE_FORMAT')); ?>
                     <div style="font-size: 10px; font-weight: 500; color: rgb(136, 136, 136);">
                        <i class="dgi-time" style="top: -1px; position: relative;"></i><?php echo strftime("%H:%M:%S", strtotime(dg::timezone($item->date))); ?>
                     </div>
                  </td>
                  <?php if (isset($this->items[0]->id)): ?>
                  <td class="center hidden-phone nowrap">
                     <?php echo (int) $item->id; ?>
                  </td>
                  <?php endif; ?>
               </tr>
               <?php endforeach; ?>
            </tbody>
         </table>
         <input type="hidden" name="task" value="" />
         <input type="hidden" name="boxchecked" value="0" />
         <?php echo JHtml::_('form.token'); ?>
      </div>
   </div>
</form>

<div class="modal fade" id="dg-modal" tabindex="-1" role="dialog" aria-hidden="true" style="width: 500px;left: calc(50% - 250px);margin: 0 auto;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div id="getipinfo" class="modal-body"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></button>
      </div>
    </div>
  </div>
</div>

<script>
jQuery(function($) {
    $(document).on('click', '.dg-ip-modal', function() {
        var iptext = $(this).text();
        $.getJSON('//api.ipgeolocation.io/ipgeo?apiKey=<?= $settings->ipgeo_api_key ?>&ip=' + iptext, function(response) {
            url = GMaps.staticMapURL({
                size: [500, 200],
                lat: response.latitude,
                lng: response.longitude,
                markers: [{
                    lat: response.latitude,
                    lng: response.longitude,
                    size: 'small'
                }],
                zoom: 7
            });
            $('<img/>').attr('src', url + '&key=<?php echo $settings->gm_api_key; ?>&language=<?= $lng ?>').appendTo('#getipinfo');
            $('#getipinfo').append('<ul></ul>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_IP_ADDRESS') ?>:</span> ' + response.ip + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_COUNTRY') ?>:</span> ' + response.country_name + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_COUNTRY_CODE') ?>:</span> ' + response.country_code2 + ' <span><img class="flag" src="' + response.country_flag + '" alt="' + response.country_code2 + '"></span></li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_ISP') ?>:</span> ' + response.isp + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_REGION') ?>:</span> ' + response.state_prov + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_CITY') ?>:</span> ' + response.city + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_ZIP') ?>:</span> ' + response.zipcode + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_TIME_ZONE') ?>:</span> ' + response.time_zone.name + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_LATITUDE_LONGITUDE') ?>:</span> ' + response.latitude + ', ' + response.longitude + '</li>');
        });
        return false;
    });
    $('#dg-modal').on('hidden.bs.modal', function (e) {
      $('#responseip, #getipinfo').empty();
    });
    $(document).on('click', '.dg-image-modal', function(e) {
      var preview = $(this).data('img-url');
      $('<img/>').attr('src', preview).appendTo('#getipinfo');
    });
});
</script>
