<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.modal');
?>
<script>
js = jQuery.noConflict();
js(document).ready(function() {
  js('input:hidden.parent_id').each(function() {
    var name = js(this).attr('name');
    if (name.indexOf('parent_idhidden')) {
      js('#jform_parent_id option[value="' + js(this).val() + '"]').attr('selected', true);
    }
  });
  js("#jform_parent_id").trigger("liszt:updated");
  js('input:hidden.cover').each(function() {
    var name = js(this).attr('name');
    if (name.indexOf('coverhidden')) {
      js('#jform_cover option[value="' + js(this).val() + '"]').attr('selected', true);
    }
  });
  js("#jform_cover").trigger("liszt:updated");
});
Joomla.submitbutton = function(task) {
  if (task == 'category.cancel') {
    Joomla.submitform(task, document.getElementById('category-form'));
  } else {
    if (task != 'category.cancel' && document.formvalidator.isValid(document.id('category-form'))) {
      Joomla.submitform(task, document.getElementById('category-form'));
    } else {
      alert('<?= $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED ')) ?>');
    }
  }
}
</script>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&layout=edit&id='. (int) $this->item->id); ?>" method="post" enctype="multipart/form-data" name="adminForm" id="category-form" class="form-validate">
  <?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>
  <div class="form-horizontal">
    <?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>
    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('JCATEGORY', true)); ?>
    <div class="row-fluid">
      <div class="span9">
        <?php echo $this->form->getLabel('description'); ?>
        <?php echo $this->form->getInput('description'); ?>
      </div>
      <div class="span3">
        <?php echo JLayoutHelper::render('joomla.edit.global', $this); ?>
        <div style="display:inline-block;">
          <?php echo $this->form->getLabel('image_id'); ?>
        </div>
        <?php echo $this->form->getInput('image_id'); ?>
      </div>
    </div>
    <?php echo JHtml::_('bootstrap.endTab'); ?>
    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'publishing', JText::_('COM_DATSOGALLERY_FIELDSET_PUBLISHING', true)); ?>
    <div class="row-fluid form-horizontal-desktop">
      <div class="span6">
        <?php echo JLayoutHelper::render('joomla.edit.publishingdata', $this); ?>
      </div>
    </div>
    <?php echo JHtml::_('bootstrap.endTab'); ?>
    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'metadata', JText::_('COM_DATSOGALLERY_FIELDSET_METADATA', true)); ?>
    <div class="row-fluid form-horizontal-desktop">
      <div class="span6">
        <?php echo JLayoutHelper::render('joomla.edit.metadata', $this); ?>
      </div>
    </div>
    <?php echo JHtml::_('bootstrap.endTab'); ?>
    <?php if (JFactory::getUser()->authorise('core.admin','datsogallery')): ?>
    <?php echo JHtml::_('bootstrap.addTab', 'myTab', 'rules', JText::_('COM_DATSOGALLERY_FIELDSET_RULES', true)); ?>
    <?php echo $this->form->getInput('rules'); ?>
    <?php echo JHtml::_('bootstrap.endTab'); ?>
    <?php endif; ?>
    <?php echo JHtml::_('bootstrap.endTabSet'); ?>
  </div>
  <input type="hidden" name="task" value="" />
  <?php echo JHtml::_('form.token'); ?>
</form>