<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class DatsogalleryViewCategories extends JViewLegacy {

  protected $items;
  protected $pagination;
  protected $state;
  public $filterForm;
  public $activeFilters;

  public function display($tpl = null) {
    $this->items         = $this->get('Items');
    $this->pagination    = $this->get('Pagination');
    $this->state         = $this->get('State');
    $this->filterForm    = $this->get('FilterForm');
    $this->activeFilters = $this->get('ActiveFilters');
    if (count($errors = $this->get('Errors'))) {
      throw new Exception(implode("\n", $errors));
    }
    foreach ($this->items as &$item) {
      $this->ordering[$item->parent_id][] = $item->id;
    }
    dg::addSubmenu('categories');
    $this->addToolbar();
    $this->sidebar = JHtmlSidebar::render();
    parent::display($tpl);
  }

  protected function addToolbar() {
    require_once JPATH_COMPONENT . '/helpers/datsogallery.php';
    $state = $this->get('State');
    $canDo = dg::getActions($state->get('filter.category_id'));
    $bar   = JToolbar::getInstance('toolbar');
    JToolBarHelper::title(JText::_('COM_DATSOGALLERY_TITLE_CATEGORIES'), 'folder categories');

    if ($canDo->get('core.create')) {
      JToolbarHelper::addNew('category.add');
    }
    if ($canDo->get('core.edit.state')) {
      if (isset($this->items[0]->published)) {
        JToolbarHelper::publish('categories.publish', 'JTOOLBAR_PUBLISH', true);
        JToolbarHelper::unpublish('categories.unpublish', 'JTOOLBAR_UNPUBLISH', true);
        JToolbarHelper::custom('categories.approved', 'featured.png', 'featured_f2.png', 'COM_DATSOGALLERY_APPROVE', true);
        JToolbarHelper::custom('categories.unapproved', 'unfeatured.png', 'featured_f2.png', 'COM_DATSOGALLERY_UNAPPROVE', true);
      } else
      if (isset($this->items[0]->checked_out)) {
        JToolBarHelper::custom('categories.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
      }
    }
    if ($canDo->get('core.create')
      && $canDo->get('core.edit')
      && $canDo->get('core.edit.state')) {
      $title  = JText::_('JTOOLBAR_BATCH');
      $layout = new JLayoutFile('joomla.toolbar.batch');
      $html   = $layout->render(array('title' => $title));
      $bar->appendButton('Custom', $html, 'batch');
    }
    if ($canDo->get('core.admin')) {
      JToolbarHelper::custom('categories.rebuild', 'refresh.png', 'refresh_f2.png', 'JTOOLBAR_REBUILD', false);
      JToolbarHelper::checkin('categories.checkin');
    }
    if ($canDo->get('core.delete')) {
      JToolBarHelper::deleteList(JText::_('COM_DATSOGALLERY_CATEGORIES_CONFIRM_DELETE'), 'categories.delete', 'JTOOLBAR_DELETE');
    }
    JHtmlSidebar::setAction('index.php?option=com_datsogallery&view=categories');
  }
}
