<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$settings = dg::getConfig();
$doc = JFactory::getDocument();
$lng = substr($doc->language, 0, 2);
$doc->addScript(JURI::base(true).'/components/com_datsogallery/assets/js/jquery.map.js');
$user	= JFactory::getUser();
$userId	= $user->get('id');
$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
?>
<form action="<?php echo JRoute::_('index.php?option=com_datsogallery&view=blacklists'); ?>" method="post" name="adminForm" id="adminForm" class="dg-style">
   <?php if(!empty($this->sidebar)): ?>
   <div id="j-sidebar-container" class="col col-2">
      <div class="filling"><?php echo $this->sidebar; ?></div>
   </div>
   <div id="j-main-container" class="col col-10">
      <?php else : ?>
      <div id="j-main-container">
         <?php endif;?>
         <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>
         <table class="table table-striped" id="blacklistList">
            <thead>
               <tr>
                  <th width="1%" class="hidden-phone">
                     <?php echo JHtml::_('grid.checkall'); ?>
                  </th>
                  <?php if (isset($this->items[0]->state)): ?>
                  <th width="1%" class="nowrap center">
                     <?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                  </th>
                  <?php endif; ?>
                  <th class="left">
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_BLACKLISTS_USER_NAME', 'a.created_by', $listDirn, $listOrder); ?>
                  </th>
                  <th class="left">
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_BLACKLISTS_IP', 'a.ip', $listDirn, $listOrder); ?>
                  </th>
                  <th class="left">
                     <?php echo JHtml::_('searchtools.sort',  'COM_DATSOGALLERY_BLACKLISTS_DATE', 'a.date', $listDirn, $listOrder); ?>
                  </th>
                  <?php if (isset($this->items[0]->id)): ?>
                  <th width="1%" class="nowrap center hidden-phone">
                     <?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                  </th>
                  <?php endif; ?>
               </tr>
            </thead>
            <tfoot>
               <?php
                  if(isset($this->items[0])){
                      $colspan = count(get_object_vars($this->items[0]));
                  }
                  else{
                      $colspan = 10;
                  }
                  ?>
               <tr>
                  <td colspan="<?php echo $colspan ?>">
                     <?php echo $this->pagination->getListFooter(); ?>
                  </td>
               </tr>
            </tfoot>
            <tbody>
               <?php foreach ($this->items as $i => $item) :
                  $canCreate	= $user->authorise('core.create',		  'com_datsogallery');
                  $canEdit	  = $user->authorise('core.edit',			  'com_datsogallery');
                  $canCheckin	= $user->authorise('core.manage',		  'com_datsogallery');
                  $canChange	= $user->authorise('core.edit.state',	'com_datsogallery');
                  ?>
               <tr class="row<?php echo $i % 2; ?>">
                  <td class="center hidden-phone">
                     <?php echo JHtml::_('grid.id', $i, $item->id); ?>
                  </td>
                  <?php if (isset($this->items[0]->state)): ?>
                  <td class="center">
                     <?php
                        echo JHtml::_('datsogallery.published', $item->state, $i, $canChange, 'blacklists');
                        ?>
                  </td>
                  <?php endif; ?>
                  <td>
                     <?php if ($canEdit) : ?>
                     <a href="<?php echo JRoute::_('index.php?option=com_datsogallery&task=blacklist.edit&id='.(int) $item->id); ?>">
                     <?php echo $item->created_by ? $item->created_by : 'Unknown'; ?>
                     </a>
                     <?php else : ?>
                     <?php echo $item->created_by ? $item->created_by : 'Unknown'; ?>
                     <?php endif; ?>
                  </td>
                  <td>
                     <a href="#" class="dg-ip-modal" data-toggle="modal" data-target="#dg-modal"><i class="icon-screen"></i><?php echo $this->escape($item->ip); ?></a>
                  </td>
                  <td class="hidden-phone" style="font-size: 10px; font-weight: 500;line-height: 15px;">
                     <?php echo JHtml::_('date', $item->date, JText::_('COM_DATSOGALLERY_DATE_FORMAT')); ?>
                     <div style="display:flex;font-size: 10px; font-weight: 500; color: rgb(136, 136, 136);">
                        <i class="dgi-time" style="top: -2px; position: relative;"></i>&nbsp;<?php echo strftime("%H:%M:%S", strtotime($item->date)); ?>
                     </div>
                  </td>
                  <?php if (isset($this->items[0]->id)): ?>
                  <td class="center hidden-phone">
                     <?php echo (int) $item->id; ?>
                  </td>
                  <?php endif; ?>
               </tr>
               <?php endforeach; ?>
            </tbody>
         </table>
         <input type="hidden" name="task" value="" />
         <input type="hidden" name="boxchecked" value="0" />
         <?php echo JHtml::_('form.token'); ?>
      </div>
   </div>
</form>

<div class="modal fade" id="dg-modal" tabindex="-1" role="dialog" aria-hidden="true" style="width: 500px;left: calc(50% - 250px);margin: 0 auto;">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div id="getipinfo" class="modal-body"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= JText::_('JLIB_HTML_BEHAVIOR_CLOSE') ?></button>
      </div>
    </div>
  </div>
</div>

<script>
jQuery(function($) {
    $(document).on('click', '.dg-ip-modal', function() {
        var iptext = $(this).text();
        $.getJSON('//api.ipgeolocation.io/ipgeo?apiKey=<?= $settings->ipgeo_api_key ?>&ip=' + iptext, function(response) {
            url = GMaps.staticMapURL({
                size: [500, 200],
                lat: response.latitude,
                lng: response.longitude,
                markers: [{
                    lat: response.latitude,
                    lng: response.longitude,
                    size: 'small'
                }],
                zoom: 7
            });
            $('<img/>').attr('src', url + '&key=<?php echo $settings->gm_api_key; ?>&language=<?= $lng ?>').appendTo('#getipinfo');
            $('#getipinfo').append('<ul></ul>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_IP_ADDRESS') ?>:</span> ' + response.ip + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_COUNTRY') ?>:</span> ' + response.country_name + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_COUNTRY_CODE') ?>:</span> ' + response.country_code2 + ' <span><img class="flag" src="' + response.country_flag + '" alt="' + response.country_code2 + '"></span></li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_ISP') ?>:</span> ' + response.isp + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_REGION') ?>:</span> ' + response.state_prov + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_CITY') ?>:</span> ' + response.city + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_ZIP') ?>:</span> ' + response.zipcode + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_TIME_ZONE') ?>:</span> ' + response.time_zone.name + '</li>');
            $('#getipinfo ul').append('<li><span><?= JText::_('COM_DATSOGALLERY_IPINFO_LATITUDE_LONGITUDE') ?>:</span> ' + response.latitude + ', ' + response.longitude + '</li>');
        });
        return false;
    });
    $('#dg-modal').on('hidden.bs.modal', function (e) {
      $('#responseip, #getipinfo').empty();
    });
});
</script>