<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\Registry\Registry;
use Joomla\String\StringHelper;

jimport('joomla.filesystem.file');

class DatsogalleryTableImage extends JTable
{

  protected $_jsonEncode = array('params', 'metadata');
  public $id             = null;

  public function __construct(&$db)
  {
    parent::__construct('#__datsogallery_images', 'id', $db);
  }

  public function check()
  {
    if (trim($this->title) == '') {
      $this->setError(JText::_('JLIB_DATABASE_ERROR_MUSTCONTAIN_A_TITLE_IMAGE'));
      return false;
    }
    if (property_exists($this, 'ordering') && $this->id == 0) {
      $this->ordering = self::getNextOrder();
    }
    $this->alias = (trim($this->alias) == '') ?
    strtolower(dg::sanitize($this->title)) :
    strtolower(str_replace(' ', '-', $this->alias));
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('id');
    $query->from($db->qn('#__datsogallery_images'));
    $query->where($db->qn('alias') . ' = ' . $db->q($this->alias));
    $query->where($db->qn('id') . ' != ' . (int) $this->id);
    $db->setQuery($query);
    $result = $db->loadResult();
    if ($result) {
      $nid         = ($this->id == 0) ? $this->getNextId($this->id) : $this->id;
      $this->alias = $nid . '-' . $this->alias;
    } else {
      $this->alias = $this->alias;
    }

    if ($this->id) {
      $user              = JFactory::getUser();
      $date              = JFactory::getDate();
      $this->modified    = $date->toSql();
      $this->modified_by = $user->id;
    }
    return true;
  }

  public function store($updateNulls = false)
  {
    $filter   = JFilterInput::getInstance();
    $settings = dg::getConfig();
    $app      = JFactory::getApplication();
    $data     = $app->input->get('jform', array(), 'array');
    $user     = JFactory::getUser();
    if (isset($data['catid'])) {
      if (is_array($data['catid'])) {
        $data['catid'] = implode(',', $data['catid']);
      } else
      if (strrpos($data['catid'], ',') != false) {
        $data['catid'] = explode(',', $data['catid']);
      } else
      if (empty($data['catid'])) {
        $data['catid'] = '';
      }
    }
    if ($app->input->get('task') == 'save2copy') {
      /*$origTable = clone $this->getTable();
      $origTable->load($input->getInt('id'));*/

      if ($data['title'] == $this->title) {
        $data['title']    = $this->title;
        $data['alias']    = $this->alias;
        $data['catid']    = $this->catid;
        $data['original'] = $this->original;
      } else {
        if ($data['alias'] == $this->alias) {
          $data['alias'] = '';
        }
      }

      $data['state'] = 0;
    }
    if (isset($data['params']) && is_array($data['params'])) {
      $registry = new JRegistry();
      $registry->loadArray($data['params']);
      $data['params'] = (string) $registry;
    }
    if (isset($data['metadata']) && isset($data['metadata']['author'])) {
      $registry = new JRegistry();
      $registry->loadArray($data['metadata']);
      $data['metadata'] = (string) $registry;
    }
    if ($this->id != 0) {
      $id    = (int) $this->id;
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->delete($db->qn('#__datsogallery_tags'));
      $query->where($db->qn('image_id') . ' = ' . $id);
      $db->setQuery($query);
      $db->execute();
      if (!empty($data['tag'])) {
        $date = JFactory::getDate();
        $tags = array();
        $tags = explode(',', $data['tag']);
        if (!empty($tags) && count($tags)) {
          $c = 0;
          foreach ($tags as $t) {
            $t = trim($t);
            if (JString::strlen($t) < $settings->min_tag_chars) {
              continue;
            } elseif (++$c > $settings->max_tags_per_image) {
              break;
            }
            $tag           = JTable::getInstance('Tag', 'DatsogalleryTable');
            $tag->image_id = $id;
            $tag->user_id  = $user->id;
            $tag->created  = $date->toSql();
            $tag->tag      = $t;
            if (!$tag->store()) {
              $this->setError($tag->getError());
              return false;
            }
          }
        }
      }
    }
    return parent::store($updateNulls);
  }

  private function JAccessRulestoArray($jaccessrules)
  {
    $rules = array();
    foreach ($jaccessrules as $action => $jaccess) {
      $actions = array();
      foreach ($jaccess->getData() as $group => $allow) {
        $actions[$group] = ((bool) $allow);
      }
      $rules[$action] = $actions;
    }
    return $rules;
  }

  public static function getNextId($where = '')
  {
    $db      = JFactory::getDbo();
    $jconfig = JFactory::getApplication();
    $name    = $jconfig->getCfg('db');
    $prefix  = $jconfig->getCfg('dbprefix');
    $query   = $db->getQuery(true);
    $query->select('AUTO_INCREMENT AS id');
    $query->from('information_schema.tables');
    $query->where('table_schema = ' . $db->q($name));
    $query->where('table_name = ' . $db->q($prefix . 'datsogallery_images'));
    if ($where) {
      $query->where($where);
    }
    $db->setQuery($query);
    $rows   = $db->loadObjectList();
    $nextid = $rows[0]->id;
    return $nextid;
  }

  public function publish($pks = null, $state = 1, $userId = 0)
  {
    $k = $this->_tbl_key;
    JArrayHelper::toInteger($pks);
    $userId = (int) $userId;
    $state  = (int) $state;
    if (empty($pks)) {
      if ($this->$k) {
        $pks = array($this->$k);
      } else {
        $this->setError(JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
        return false;
      }
    }
    $where = $k . '=' . implode(' OR ' . $k . '=', $pks);
    if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time')) {
      $checkin = '';
    } else {
      $checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
    }
    $this->_db->setQuery('UPDATE `' . $this->_tbl . '`' . ' SET `state` = ' . (int) $state . ' WHERE (' . $where . ')' . $checkin);
    $this->_db->query();
    if ($this->_db->getErrorNum()) {
      $this->setError($this->_db->getErrorMsg());
      return false;
    }
    if ($checkin && (count($pks) == $this->_db->getAffectedRows())) {
      foreach ($pks as $pk) {
        $this->checkin($pk);
      }
    }
    if (in_array($this->$k, $pks)) {
      $this->state = $state;
    }
    $this->setError('');
    return true;
  }

  public function delete($pk = null)
  {
    $app  = JFactory::getApplication();
    $conf = dg::getConfig();
    $pk   = (int) $pk;
    $db   = $this->getDbo();
    $q    = $db->getQuery(true);
    $q->select($db->qn('original'))
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('id') . ' = ' . $pk);
    $db->setQuery($q);
    $original = $db->loadResult();
    $q->clear()
      ->delete()
      ->from($db->qn('#__datsogallery_basket'))
      ->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    if (dg::falang_involved('admin')) {
      $q->clear()
        ->delete()
        ->from($db->qn('#__falang_content'))
        ->where($db->qn('reference_table') . ' = ' . $db->q('datsogallery_images'))
        ->where($db->qn('reference_id') . ' = ' . $pk);
      $db->setQuery($q)->execute();
      $q->clear()
        ->select('id')
        ->from($db->qn('#__datsogallery_tags'))
        ->where($db->qn('image_id') . ' = ' . $pk);
      $db->setQuery($q);
      $tag_ids = $db->loadColumn();
      if (!empty($tag_ids)) {
        $q->clear()
          ->delete()
          ->from($db->qn('#__falang_content'))
          ->where($db->qn('reference_table') . ' = ' . $db->q('datsogallery_tags'))
          ->where($db->qn('reference_id') . ' IN (' . implode(',', $tag_ids) . ')');
        $db->setQuery($q)->execute();
      }
    }
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_comments'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_downloads'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_favorites'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_hits'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_likes'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_purchases'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_reports'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_tags'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->delete();
    $q->from($db->qn('#__datsogallery_colors'));
    $q->where($db->qn('image_id') . ' = ' . $pk);
    $db->setQuery($q)->execute();
    $q->clear();
    $q->select($db->qn('original'));
    $q->from($db->qn('#__datsogallery_images'));
    $q->where($db->qn('original') . ' like ' . $db->q($original));
    $db->setQuery($q);
    $originals = $db->loadColumn();
    if (count($originals) < 2 && JFile::exists(JPATH_SITE . $conf->path_to_originals . '/' . $original)) {
      if (!JFile::delete(JPATH_SITE . $conf->path_to_originals . '/' . $original)) {
        $app->enqueueMessage(
          JText::sprintf('An error occurred while deleting %s file', $original), 'error'
        );
      }
    }
    $files = JFolder::files(JPATH_SITE . $conf->path_to_images, $original, true, true);
    foreach ($files as $file) {
      if (!JFile::delete($file)) {
        $app->enqueueMessage(
          JText::sprintf('An error occurred while deleting %s file', $file), 'error'
        );
      }
    }
    $q->clear()
      ->delete('#__datsogallery_images')
      ->where($db->qn('id') . '=' . $pk);
    $db->setQuery($q)->execute();
    return true;
  }

  public function approve($pks = null, $state = 1, $userId = 0)
  {
    $k = $this->_tbl_key;
    JArrayHelper::toInteger($pks);
    $userId = (int) $userId;
    $state  = (int) $state;
    if (empty($pks)) {
      if ($this->$k) {
        $pks = array($this->$k);
      } else {
        $this->setError(JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
        return false;
      }
    }
    $where = $k . '=' . implode(' OR ' . $k . '=', $pks);
    if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time')) {
      $checkin = '';
    } else {
      $checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
    }
    $this->_db->setQuery('UPDATE `' . $this->_tbl . '`' . ' SET `approved` = ' . (int) $state . ' WHERE (' . $where . ')' . $checkin);
    $this->_db->query();
    if ($this->_db->getErrorNum()) {
      $this->setError($this->_db->getErrorMsg());
      return false;
    }
    if ($checkin && (count($pks) == $this->_db->getAffectedRows())) {
      foreach ($pks as $pk) {
        $this->checkin($pk);
      }
    }
    if (in_array($this->$k, $pks)) {
      $this->approved = $state;
    }
    $this->setError('');
    return true;
  }
}
