<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.database.tablenested');
jimport('joomla.filesystem.file');

class DatsogalleryTableCategory extends JTableNested
{

  public $id = null;

  public function __construct($db)
  {
    parent::__construct('#__datsogallery_categories', 'id', $db);
  }

  public function check()
  {
    if (trim($this->title) == '') {
      $this->setError(JText::_('JLIB_DATABASE_ERROR_MUSTCONTAIN_A_TITLE_CATEGORY'));
      return false;
    }
    if (property_exists($this, 'ordering') && $this->id == 0) {
      $this->ordering = self::getNextOrder();
    }
    $this->alias = (trim($this->alias) == '') ?
    strtolower(dg::sanitize($this->title)) :
    strtolower(str_replace(' ', '-', $this->alias));
    return true;
  }

  public function getNextId($where = '')
  {
    $db      = JFactory::getDBO();
    $jconfig = JFactory::getConfig();
    $name    = $jconfig->get('db');
    $prefix  = $jconfig->get('dbprefix');
    $query   = $db->getQuery(true);
    $query->select('AUTO_INCREMENT AS id');
    $query->from('information_schema.tables');
    $query->where('table_schema = ' . $db->Quote($name));
    $query->where('table_name = ' . $db->Quote($prefix . 'datsogallery_categories'));
    if ($where) {
      $query->where($where);
    }
    $db->setQuery($query);
    $rows   = $db->loadObjectList();
    $nextid = $rows[0]->id;
    return $nextid;
  }

  public function store($updateNulls = false)
  {
    $settings = dg::getConfig();
    $db       = JFactory::getDbo();
    $query    = $db->getQuery(true);
    $query->select('id');
    $query->from($db->qn('#__datsogallery_categories'));
    $query->where($db->qn('alias') . ' = ' . $db->q($this->alias));
    $query->where($db->qn('id') . ' != ' . (int) $this->id);
    $db->setQuery($query);
    $result = $db->loadResult();
    if ($result) {
      $nid         = ($this->id == 0) ? $this->getNextId($this->id) : $this->id;
      $toc         = strtok($this->alias, '-');
      $alias       = is_numeric($toc) ? substr(strstr($this->alias, '-'), 1) : $this->alias;
      $this->alias = $nid . '-' . $alias;
    } else {
      $this->alias = $this->alias;
    }
    $user = JFactory::getUser();
    $date = JFactory::getDate();
    if ($this->id == 0) {
      $this->publish_up    = $date->toSql();
      $this->created_time  = $date->toSql();
      $this->modified_time = null;
    } else {
      $this->created_time  = null;
      $this->modified_by   = $user->id;
      $this->modified_time = $date->toSql();
    }
    if (!$this->id && empty($this->created_by)) {
      $this->created_by = $user->id;
    }
    if (empty($this->image_id)) {
      $this->image_id = 0;
    }
    $this->approved = (dg::is_root() || !$settings->category_approval) ? 1 : 0;
    $data           = JFactory::getApplication()->input->get('jform', array(), 'array');
    $access         = isset($data['access']) ? $data['access'] : '';
    if (empty($access)) {
      $this->access = JFactory::getConfig()->get('access');
    }
    if (is_array($access) && !empty($access)) {
      $this->access = implode(',', $access);
    }
    if ($this->id == 1) {
      $this->title = null;
      $this->alias = null;
    }
    return parent::store($updateNulls);
  }

  public function delete($pk = null, $children = true)
  {
    $pk  = (int) $pk;
    $db  = $this->getDbo();
    $app = JFactory::getApplication();
    if ($pk == 1) {
      $app->enqueueMessage(
        JText::sprintf(JText::_('COM_DATSOGALLERY_CANNOT_DELETE_ROOT_CATEGORY'),
          $ex->getMessage()), 'warning'
      );
      return false;
    }
    $path  = dg::getConfig('path_to_originals');
    $q = $db->getQuery(true);
    $q->select('*')
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('catid') . ' = ' . $pk);
    $db->setQuery($q);
    $images = $db->loadObjectList();
    if (dg::falang_involved('admin')) {
      $q->clear()
        ->delete()
        ->from($db->qn('#__falang_content'))
        ->where($db->qn('reference_table') . ' = ' . $db->q('datsogallery_categories'))
        ->where($db->qn('reference_id') . ' = ' . $pk);
      $db->setQuery($q)->execute();
    }
    if (count($images) > 0) {
      $table = JTable::getInstance('Image', 'DatsogalleryTable');
      foreach ($images as $image) {
        if ($table->load($image->id)) {
          $q->clear()
            ->delete()
            ->from($db->qn('#__datsogallery_basket'))
            ->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          if (dg::falang_involved('admin')) {
            $q->clear()
              ->delete()
              ->from($db->qn('#__falang_content'))
              ->where($db->qn('reference_table') . ' = ' . $db->q('datsogallery_images'))
              ->where($db->qn('reference_id') . ' = ' . $image->id);
            $db->setQuery($q)->execute();
            $q->clear()
              ->select('id')
              ->from($db->qn('#__datsogallery_tags'))
              ->where($db->qn('image_id') . ' = ' . $image->id);
            $db->setQuery($q);
            $tag_ids = $db->loadColumn();
            if (!empty($tag_ids)) {
              $q->clear()
                ->delete()
                ->from($db->qn('#__falang_content'))
                ->where($db->qn('reference_table') . ' = ' . $db->q('datsogallery_tags'))
                ->where($db->qn('reference_id') . ' IN (' . implode(',', $tag_ids) . ')');
              $db->setQuery($q)->execute();
            }
          }
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_comments'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_downloads'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_favorites'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_hits'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_likes'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_purchases'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_reports'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_tags'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->delete();
          $q->from($db->qn('#__datsogallery_colors'));
          $q->where($db->qn('image_id') . ' = ' . $image->id);
          $db->setQuery($q)->execute();
          $q->clear();
          $q->select($db->qn('original'));
          $q->from($db->qn('#__datsogallery_images'));
          $q->where($db->qn('original') . ' like ' . $db->q($image->original));
          $db->setQuery($q);
          $originals = $db->loadColumn();
          if (count($originals) < 2 && JFile::exists(JPATH_SITE . $path . '/' . $image->original)) {
            if (!JFile::delete(JPATH_SITE . $path . '/' . $image->original)) {
              $app->enqueueMessage(
                JText::sprintf('An error occurred while deleting %s file',
                  $image->original), 'error'
              );
            }
          }
        } else {
          $this->setError($table->getError());
          return false;
        }
      }
    }
    $q->clear()
      ->delete()
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('catid') . ' = ' . $pk);
    $db->setQuery($q);
    try {
      $db->execute();
    } catch (Exception $ex) {
      $app->enqueueMessage(
        JText::sprintf('There was an error deleting the table %s. Error: %s',
          $db->qn('#__datsogallery_images'), $ex->getMessage()), 'error'
      );
    }
    $q->clear()
      ->delete()
      ->from($db->qn('#__datsogallery_categories'))
      ->where($db->qn('id') . ' = ' . $pk);
    $db->setQuery($q);
    try {
      $db->execute();
    } catch (Exception $ex) {
      $app->enqueueMessage(
        JText::sprintf('There was an error deleting the table %s. Error: %s',
          $db->qn('#__datsogallery_categories'), $ex->getMessage()), 'error'
      );
    }
    return true;
  }
}
