<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryTableBlacklist extends JTable {

	public function __construct(&$db) {
		parent::__construct('#__datsogallery_blacklist', 'id', $db);
	}

	public function bind($array, $ignore = '') {
		$input = JFactory::getApplication()->input;
		$task = $input->getString('task', '');
		if (($task == 'save' || $task == 'apply') && (!JFactory::getUser()->authorise('core.edit.state', 'com_datsogallery') && $array ['state'] == 1)) {
			$array ['state'] = 0;
		}
		if (isset($array ['params']) && is_array($array ['params'])) {
			$registry = new JRegistry();
			$registry->loadArray($array ['params']);
			$array ['params'] = (string) $registry;
		}
		if (isset($array ['metadata']) && is_array($array ['metadata'])) {
			$registry = new JRegistry();
			$registry->loadArray($array ['metadata']);
			$array ['metadata'] = (string) $registry;
		}
		if (!JFactory::getUser()->authorise('core.admin', 'com_datsogallery.blacklist.'.$array ['id'])) {
			$actions = JFactory::getACL()->getActions('com_datsogallery', 'blacklist');
			$default_actions = JFactory::getACL()->getAssetRules('com_datsogallery.blacklist.'.$array ['id'])->getData();
			$array_jaccess = array();
			foreach ($actions as $action) {
				$array_jaccess[$action->name] = $default_actions[$action->name];
			}
			$array ['rules'] = $this->JAccessRulestoArray($array_jaccess);
		}
		if (isset($array ['rules']) && is_array($array ['rules'])) {
			$this->setRules($array ['rules']);
		}
		return parent::bind($array, $ignore);
	}

	private function JAccessRulestoArray($jaccessrules) {
		$rules = array();
		foreach ($jaccessrules as $action => $jaccess) {
			$actions = array();
			foreach ($jaccess->getData() as $group => $allow) {
				$actions[$group] = ((bool) $allow);
			}
			$rules[$action] = $actions;
		}
		return $rules;
	}

	public function check() {
		if (property_exists($this, 'ordering') && $this->id == 0) {
			$this->ordering = self::getNextOrder();
		}
		return parent::check();
	}

	public function publish($pks = null, $state = 1, $userId = 0) {
		$k = $this->_tbl_key;
		JArrayHelper::toInteger($pks);
		$userId = (int) $userId;
		$state = (int) $state;
		if (empty($pks)) {
			if ($this->$k) {
				$pks = array($this->$k);
			}
			else {
				$this->setError(JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
				return false;
			}
		}
		$where = $k.'='.implode(' OR '.$k.'=', $pks);
		if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time')) {
			$checkin = '';
		}
		else {
			$checkin = ' AND (checked_out = 0 OR checked_out = '.(int) $userId.')';
		}
		$this->_db->setQuery('UPDATE `#__datsogallery_blacklist`'.' SET `state` = '.(int) $state.' WHERE ('.$where.')');
		$this->_db->query();
		if ($this->_db->getErrorNum()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		if ($checkin && (count($pks) == $this->_db->getAffectedRows())) {
			foreach ($pks as $pk) {
				$this->checkin($pk);
			}
		}
		if (in_array($this->$k, $pks)) {
			$this->state = $state;
		}
		$this->setError('');
		return true;
	}

}