<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

class DatsogalleryModelImages extends JModelList {

  public function __construct($config = array()) {
    if (empty($config['filter_fields'])) {
        $config['filter_fields'] = array(
            'id', 'a.id',
            'catid', 'a.catid',
            'title', 'a.title',
            'alias', 'a.alias',
            'original', 'a.original',
            'description', 'a.description',
            'hits', 'a.hits',
            'downloads', 'a.downloads',
            'state', 'a.state',
            'ordering', 'a.ordering',
            'access', 'a.access',
            'params', 'a.params',
            'language', 'a.language',
            'created_by', 'a.created_by',
            'created_by_alias', 'a.created_by_alias',
            'created', 'a.created',
            'modified_by', 'a.modified_by',
            'modified', 'a.modified',
            'metakey', 'a.metakey',
            'metadesc', 'a.metadesc',
            'metadata', 'a.metadata',
            'featured', 'a.featured',
            'publish_up', 'a.publish_up',
            'publish_down', 'a.publish_down',
            'author_id',

        );
    }
    parent::__construct($config);
  }

  protected function populateState($ordering = 'a.id', $direction = 'desc') {
    $app = JFactory::getApplication();
    $search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
    $this->setState('filter.search', $search);
    $published = $this->getUserStateFromRequest($this->context.'.filter.state', 'filter_published', '', 'string');
    $this->setState('filter.state', $published);
    $authorId = $this->getUserStateFromRequest($this->context.'.filter.author_id', 'filter_author_id');
    $this->setState('filter.author_id', $authorId);
    $access = $this->getUserStateFromRequest($this->context.'.filter.access', 'filter_access');
    $this->setState('filter.access', $access);
    $catid = $this->getUserStateFromRequest($this->context.'.filter.catid', 'filter_catid', '', 'int');
    $this->setState('filter.catid', $catid);
    $language = $this->getUserStateFromRequest($this->context.'.filter.language', 'filter_language', '');
    $this->setState('filter.language', $language);
    $params = JComponentHelper::getParams('com_datsogallery');
    $this->setState('params', $params);
    parent::populateState($ordering, $direction);
  }

  protected function getStoreId($id = '') {
    $id .= ':'.$this->getState('filter.search');
    $id .= ':'.$this->getState('filter.access');
    $id .= ':'.$this->getState('filter.state');
    $id .= ':'.$this->getState('filter.catid');
    $id .= ':'.$this->getState('filter.author_id');
    $id .= ':'.$this->getState('filter.language');
    return parent::getStoreId($id);
  }

  protected function getListQuery() {
    $db = $this->getDbo();
    $query = $db->getQuery(true);
    $query->select($this->getState('list.select', 'a.*'));
    $query->from('`#__datsogallery_images` AS a');
    $query->select('uc.name AS editor');
    $query->join('LEFT', '#__users AS uc ON uc.id = a.checked_out');
    $query->select('c.title AS category_title');
    $query->join('LEFT', '#__datsogallery_categories AS c ON c.id = a.catid');
    $query->select('checked_out.name AS checked_out');
    $query->join('LEFT', '#__users AS checked_out ON checked_out.id = a.checked_out');
    $query->select('created_by.name AS author_name');
    $query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');
    $query->select('modified_by.name AS modified_by');
    $query->join('LEFT', '#__users AS modified_by ON modified_by.id = a.modified_by');
    $query->select('l.title AS language_title');
    $query->join('LEFT', $db->qn('#__languages').' AS l ON l.lang_code = a.language');
    $query->select('ag.title AS access_level');
    $query->join('LEFT', '#__viewlevels AS ag ON ag.id = a.access');
    if ($access = $this->getState('filter.access')) {
      $query->where('a.access = '.(int) $access);
    }
    $published = $this->getState('filter.state');
    if (is_numeric($published)) {
      $query->where('a.state = '.(int) $published);
    }
    else {
      if ($published === '') {
        $query->where('(a.state IN (0, 1))');
      }
    }
    $search = $this->getState('filter.search');
    if (!empty($search)) {
      if (stripos($search, 'id:') === 0) {
        $query->where('a.id = '.(int) substr($search, 3));
      }
      else {
        $search = $db->quote('%'.str_replace(' ', '%', $db->escape(trim($search), true).'%'));
        $query->where('(a.title LIKE '.$search.' OR a.alias LIKE '.$search.')');
      }
    }
    $authorId = $this->getState('filter.author_id');
    if (is_numeric($authorId)) {
      $query->where('a.created_by = '.(int) $authorId);
    }
    $filter_catid = $this->getState('filter.catid');
    if ($filter_catid) {
      $query->where('a.catid = '.$db->escape($filter_catid));
    }
    if ($language = $this->getState('filter.language')) {
      $query->where('a.language = '.$db->q($language));
    }
    $orderCol  = $this->state->get('list.ordering', 'a.id');
    $orderDirn = $this->state->get('list.direction', 'DESC');
    $query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));
    //echo nl2br(str_replace('#__', 'jos_', $query));
    return $query;
  }

  public function getItems() {
    $items = parent::getItems();
    return $items;
  }

}