<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

require_once (JPATH_COMPONENT.'/images.php');

jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

class JFormFieldCover extends JFormFieldList {

  protected $type = 'cover';

  public function getInput() {
    $app = JFactory::getApplication();
    $id = $app->input->getInt('id', 0);
    $db = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('a.id, a.original')
          ->from('#__datsogallery_images as a')
          ->join('LEFT', '#__datsogallery_categories AS c ON c.image_id = a.id')
          ->where('a.state = 1')
          ->where('a.approved = 1')
          ->where('c.published = 1')
          ->where('c.approved = 1')
          ->where('c.id = '.$id);
    $db->setQuery($query);
    $obj = $db->loadObject();
    $image = isset($obj->id) ? '<div><img src="'.resize($obj->original, 220, 220, 1, '1:1', 0, $id).'" alt="preview" /></div>' : '';
    $image_id = isset($obj->id) ? $obj->id : '';
    $out = '';
    $out .= '<div class="field-media-wrapper">
        <div class="input-prepend input-append">
          <input name="jform[image_id]" id="jform_image_id" value="'.$image_id.'" class="input-small field-media-input" type="text">
          <a rel="{handler:\'iframe\',size:{x:1200,y:600}}" href="'.JUri::base().'index.php?option=com_datsogallery&amp;view=images&amp;layout=cover&amp;tmpl=component&amp;ismoo=1&amp;id='.$id.'" class="modal btn add-on button-select">'.JText::_('JSELECT').'</a>
          <a class="btn icon-remove hasTooltip add-on button-clear" title="'.JText::_('JCLEAR').'"></a>
        </div>
      </div>
      <div id="thumbview" style="margin-top: 20px;">'.$image.'</div>
      <script>jQuery(document).on("click", ".button-clear", function(event) {
            jQuery("#jform_image_id").val("");
            jQuery("#thumbview").empty();
        });
      </script>';
    return $out;
  }

}