<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class DatsogalleryModelComments extends JModelList {

	public function __construct($config = array()) {
    if (empty($config['filter_fields'])) {
        $config['filter_fields'] = array(
            'id', 'a.id',
            'image_id', 'a.image_id',
            'user_ip', 'a.user_ip',
            'user_name', 'a.user_name',
            'user_email', 'a.user_email',
            'text', 'a.text',
            'date', 'a.date',
            'state', 'a.state',
            'created_by', 'a.created_by',
        );
    }
		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.id', $direction = 'desc') {
		$app = JFactory::getApplication();

		$this->setState('filter.search', $app->getUserStateFromRequest($this->context.'.filter.search', 'filter_search'));
		$this->setState('filter.state', $app->getUserStateFromRequest($this->context.'.filter.state', 'filter_published', '', 'string'));
    $this->setState('filter.created_by', $this->getUserStateFromRequest($this->context.'.filter.created_by', 'filter_created_by'));

		$this->setState('params', JComponentHelper::getParams('com_datsogallery'));
		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '') {
		$id .= ':'.$this->getState('filter.search');
		$id .= ':'.$this->getState('filter.state');
    $id .= ':'.$this->getState('filter.created_by');
		return parent::getStoreId($id);
	}

	protected function getListQuery() {
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select($this->getState('list.select', 'a.*'));
		$query->from('`#__datsogallery_comments` AS a');
		$query->select('i.title AS image_title, i.original AS original, i.catid AS category_id');
		$query->join('LEFT', '#__datsogallery_images AS i ON i.id = a.image_id');
		$published = $this->getState('filter.state');
    if ($created_by = $this->getState('filter.created_by')) {
      $query->where('a.created_by = '.(int) $created_by);
    }
		if (is_numeric($published)) {
			$query->where('a.state = '.(int) $published);
		}
		else
			if ($published === '') {
				$query->where('(a.state IN (0, 1))');
			}
    $search = $this->getState('filter.search');
    if (!empty($search)) {
      if (stripos($search, 'id:') === 0) {
        $query->where('a.id = '.(int) substr($search, 3));
      }
      else {
        $search = $db->quote('%'.str_replace(' ', '%', $db->escape(trim($search), true).'%'));
        $query->where('(a.text LIKE '.$search.' OR a.user_ip LIKE '.$search.' OR a.user_name LIKE '.$search.' OR a.user_email LIKE '.$search.')');
      }
    }
		$orderCol = $this->state->get('list.ordering');
		$orderDirn = $this->state->get('list.direction');
		if ($orderCol && $orderDirn) {
			$query->order($db->escape($orderCol.' '.$orderDirn));
		}
		return $query;
	}

	public function getItems() {
		return parent::getItems();;
	}

}