<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.modellist');

class DatsogalleryModelblacklists extends JModelList {

	public function __construct($config = array()) {
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
      'id', 'a.id',
      'ip', 'a.ip',
      'date', 'a.date',
      'state', 'a.state',
      'created_by', 'a.created_by'
      );
		}
		parent::__construct($config);
	}

	protected function populateState($ordering = 'a.id', $direction = 'asc') {
		$app = JFactory::getApplication();

		$this->setState('filter.search', $app->getUserStateFromRequest($this->context.'.filter.search', 'filter_search'));
		$this->setState('filter.state', $app->getUserStateFromRequest($this->context.'.filter.state', 'filter_published', '', 'string'));
    $this->setState('filter.created_by', $this->getUserStateFromRequest($this->context.'.filter.created_by', 'filter_created_by'));

		$this->setState('params', JComponentHelper::getParams('com_datsogallery'));
		parent::populateState($ordering, $direction);
	}

	protected function getStoreId($id = '') {
		$id .= ':'.$this->getState('filter.search');
		$id .= ':'.$this->getState('filter.state');
    $id .= ':'.$this->getState('filter.created_by');
		return parent::getStoreId($id);
	}

	protected function getListQuery() {
		$db = $this->getDbo();
		$query = $db->getQuery(true);
		$query->select($this->getState('list.select', 'a.*'));
		$query->from('`#__datsogallery_blacklist` AS a');
		$query->select('created_by.name AS created_by');
		$query->join('LEFT', '#__users AS created_by ON created_by.id = a.created_by');
    if ($created_by = $this->getState('filter.created_by')) {
      $query->where('a.created_by = '.(int) $created_by);
    }
		$published = $this->getState('filter.state');
		if (is_numeric($published)) {
			$query->where('a.state = '.(int) $published);
		}
		else
			if ($published === '') {
				$query->where('(a.state IN (0, 1))');
			}
			$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			}
			else {
				$search = $db->q('%' . $db->escape($search, true) . '%');
        $query->where('(a.ip LIKE '.$search.')');
			}
		}
		$orderCol = $this->state->get('list.ordering');
		$orderDirn = $this->state->get('list.direction');
		if ($orderCol && $orderDirn) {
			$query->order($db->escape($orderCol.' '.$orderDirn));
		}
		return $query;
	}

	public function getItems() {
		return parent::getItems();
	}

}