<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_ADMINISTRATOR . '/components/com_datsogallery/helpers/datsogallery.php';

jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');

function is_ani($filename)
{
  $ext = strtolower(strrchr($filename, "."));
  if ($ext == '.mp4') {
    return 1;
  } else {
    if (!($fh = @fopen($filename, 'rb'))) {
      return false;
    }
    $count = 0;
    while (!feof($fh) && $count < 2) {
      $chunk = fread($fh, 1024 * 100);
      $count += preg_match_all('#\x00\x21\xF9\x04.{4}\x00[\x2C\x21]#s', $chunk, $matches);
    }
    fclose($fh);
    return $count > 1;
  }
}

function is_image($filename)
{
  $ext = strtolower(strrchr($filename, "."));
  if ($ext == ".jpg" || $ext == ".jpeg" || $ext == ".png" || $ext == ".gif") {
    return true;
  } else {
    return false;
  }
}

function is_zip($filename)
{
  $ext = strtolower(strrchr($filename, "."));
  if ($ext == ".zip") {
    return true;
  } else {
    return false;
  }
}

function dgFileCheck($file)
{
  if (($imginfo = @getimagesize($file)) === false) {
    return false;
  }
  return true;
}

function resize($original, $w, $h, $crop, $cropratio = 0, $wm = 0, $catid = '', $tmpath = '', $quality = 80, $ag = false, $wm_pos = 'c', $force_format = false)
{
  $app       = JFactory::getApplication();
  $settings  = dg::getConfig();
  $originals = $settings->path_to_originals;
  $cro       = str_replace(':', 'x', $cropratio);
  $dirname   = "{$catid}_{$w}x{$h}_{$cro}";
  $dg_images = (!empty($tmpath)) ? $tmpath : ((dg::webpsupport() && $settings->enable_webp && !$force_format) ? $settings->path_to_webp . '/' : $settings->path_to_images . '/');
  $types     = array(1 => 'gif', 'jpeg', 'png');
  if (!JFolder::exists(JPATH_SITE . $settings->path_to_images)) {
    JFolder::create(JPATH_SITE . $settings->path_to_images);
    $content = '<!DOCTYPE html><title></title>';
    JFile::write(JPATH_SITE . $settings->path_to_images . '/index.html', $content);
  }
  if (dg::webpsupport() && $settings->enable_webp && !JFolder::exists(JPATH_SITE . $settings->path_to_webp)) {
    JFolder::create(JPATH_SITE . $settings->path_to_webp);
    $content = '<!DOCTYPE html><title></title>';
    JFile::write(JPATH_SITE . $settings->path_to_webp . '/index.html', $content);
  }
  if (!JFolder::exists(JPATH_SITE . $originals)) {
    JFolder::create(JPATH_SITE . $originals);
    $content = '<!DOCTYPE html><title></title>';
    JFile::write(JPATH_SITE . $originals . '/index.html', $content);
  }
  if (!JFolder::exists(JPATH_SITE . $dg_images . $dirname)) {
    JFolder::create(JPATH_SITE . $dg_images . $dirname);
    $content = '<!DOCTYPE html><title></title>';
    JFile::write(JPATH_SITE . $dg_images . $dirname . '/index.html', $content);
  }
  if (!JFile::exists(JPATH_SITE . $originals . '/no_image.png')) {
    JFile::copy(
      JPATH_COMPONENT_SITE . '/assets/images/no_image.png',
      JPATH_SITE . $originals . '/no_image.png'
    );
  }
  if (!JFile::exists(JPATH_SITE . $originals . '/image_warning.png')) {
    JFile::copy(
      JPATH_COMPONENT_SITE . '/assets/images/image_warning.png',
      JPATH_SITE . $originals . '/image_warning.png'
    );
  }
  $originals = (!empty($tmpath)) ? $tmpath : $originals;
  $path      = JPath::clean(JPATH_SITE . $originals . '/' . $original);
  if (dg::checkmem($path, $w, $h) === false) {
    if (empty($tmpath)) {
      $app->enqueueMessage(
        JText::_('COM_DATSOGALLERY_RESIZE_MEMORY_LIMIT_ERROR'), 'error'
      );
      return JUri::root(true) . '/components/com_datsogallery/assets/images/image_warning.png';
    } else {
      return false;
    }
  } else {
    if (dgFileCheck($path) === false) {
      $path = JPath::clean(JPATH_SITE . $originals . '/image_warning.png');
    }
    if (!file_exists($path) || is_dir($path) || !($size = @getimagesize($path))) {
      return;
    }
    $orgfile       = JUri::root(true) . $originals . '/' . basename($original);
    $relfile       = JUri::root(true) . $dg_images . $dirname . '/' . basename($original);
    $dg_imagesfile = JPath::clean(JPATH_SITE . $dg_images . $dirname . '/' . basename($original));
    if ($settings->auto_rotate && (!file_exists($dg_imagesfile)) || (filemtime($dg_imagesfile) < filemtime($path))) {
      if (extension_loaded('imagick') && $settings->image_processing == 'im') {
        imrotate($path);
      } else {
        gdrotate($path);
      }
    }
    $width  = $size[0];
    $height = $size[1];
    $mw     = $w;
    $mh     = $h;
    $x      = 0;
    $y      = 0;
    if ($crop == '1') {
      $cr = explode(':', $cropratio);
      if (count($cr) == 2) {
        $rc  = $width / $height;
        $crc = (float) $cr[0] / (float) $cr[1];
        if ($rc < $crc) {
          $oh     = $height;
          $height = $width / $crc;
          $y      = ($oh - $height) / 2;
        } else
        if ($rc > $crc) {
          $ow    = $width;
          $width = $height * $crc;
          $x     = ($ow - $width) / 2;
        }
      }
    }
    $xr = $mw / $width;
    $yr = $mh / $height;
    if ($xr * $height < $mh) {
      $th = ceil(round($xr * $height));
      $tw = $mw;
    } else {
      $tw = ceil(round($yr * $width));
      $th = $mh;
    }
    if (file_exists($dg_imagesfile)) {
      $cachesize = @getimagesize($dg_imagesfile);
      $cached    = ($cachesize[0] == $tw && $cachesize[1] == $th);
      if (filemtime($dg_imagesfile) < filemtime($path)) {
        $cached = false;
        clearstatcache();
      }
    } else {
      $cached = false;
    }
    if (!$cached && ($size[0] >= $w || $size[1] >= $h)) {
      $resize = true;
    } elseif (!$cached && ($size[0] <= $w || $size[1] <= $h)) {
      $resize = true;
    } else {
      $resize = false;
    }
    if (!is_ani($path) || (is_ani($path) && $ag == false)) {
      if ($resize) {
        if ($settings->image_processing == 'im') {
          $quality = max(min($quality, 100), 0);
          $im      = new Imagick($path);
          if (is_callable(array($im, 'setIteratorIndex'))) {
            $im->setIteratorIndex(0);
          }
          $format = $im->getImageFormat();
          switch ($format) {
            case 'GIF':
              $im->setImageFormat('gif');
              $im->setImageCompression(Imagick::COMPRESSION_LZW);
              break;
            case 'JPEG':
            case 'JPG':
              $im->setImageFormat('jpeg');
              $im->setSamplingFactors(array('2x2', '1x1', '1x1'));
              $profiles = $im->getImageProfiles("icc", true);
              if (!empty($profiles)) {
                $im->profileImage('icc', $profiles['icc']);
              }
              $im->setImageCompression(Imagick::COMPRESSION_JPEG);
              $im->setImageCompressionQuality($quality);
              if ($settings->imageinterlace) {
                $im->setInterlaceScheme(Imagick::INTERLACE_PLANE);
              }
              $im->setColorspace(Imagick::COLORSPACE_SRGB);
              break;
            case 'PNG':
              $im->setImageFormat('png');
              $im->setImageCompression(Imagick::COMPRESSION_ZIP);
              break;
            case 'BMP':
              $im->setImageFormat('bmp');
              $im->setImageCompression(Imagick::COMPRESSION_UNDEFINED);
              break;
          }
          if ($crop == '1') {
            $im->cropThumbnailImage($tw, $th);
          } else {
            if ($size[0] <= $w && $size[1] <= $h) {
              $im->resizeImage($size[0], $size[1], Imagick::FILTER_LANCZOS, 0.9, true);
            } else {
              $im->resizeImage($tw, $th, Imagick::FILTER_LANCZOS, 0.9, true);
            }
          }
          $im->stripImage();
          $im->writeImage($dg_imagesfile);
          if ($wm) {
            $watermarkPNGFile = JPATH_SITE . '/components/com_datsogallery/assets/images/watermark.png';
            $position         = $wm_pos ? $wm_pos : $settings->global_watermark_position;
            watermark($dg_imagesfile, $watermarkPNGFile, $position);
          }
          $im->destroy();
        } else {
          $image = @call_user_func('imagecreatefrom' . $types[$size[2]], $path);
          if ($size[0] >= $w && $size[1] <= $h || $size[0] <= $w && $size[1] >= $h || $size[0] >= $w && $size[1] >= $h) {
            $temp = imagecreatetruecolor($tw, $th);
          } else {
            $temp = imagecreatetruecolor($width, $height);
          }
          if (function_exists('imagecreatetruecolor') && ($temp)) {
            if (in_array($types[$size[2]], array('gif', 'png'))) {
              imagealphablending($temp, false);
              imagesavealpha($temp, true);
              $transparent = imagecolorallocatealpha($temp, 255, 255, 255, 127);
              imagefilledrectangle($temp, 0, 0, $tw, $th, $transparent);
            }
            if ($resize && ($size[0] <= $w && $size[1] <= $h)) {
              imagecopyresampled($temp, $image, 0, 0, 0, 0, $size[0], $size[1], $width, $height);
            } else {
              fastimagecopyresampled($temp, $image, 0, 0, $x, $y, $tw, $th, $width, $height);
            }
            @imagedestroy($image);
            if ($w <= 200) {
              $sharpness     = findsharp($width, $tw);
              $sharpenMatrix = array(array(-1, -2, -1), array(-2, $sharpness + 12, -2), array(-1, -2, -1));
              $divisor       = array_sum(array_map('array_sum', $sharpenMatrix));
              imageconvolution($temp, $sharpenMatrix, $divisor, 0);
            }
            if ($wm) {
              $watermarkPNGFile = JPATH_SITE . '/components/com_datsogallery/assets/images/watermark.png';
              $watermarkMargin  = $settings->global_watermark_margin;
              $imageWidth       = imagesx($temp);
              $imageHeight      = imagesy($temp);
              $watermark        = resizewm($watermarkPNGFile, $imageWidth, $imageHeight, $settings->global_watermark_size);
              $watermarkWidth   = imagesx($watermark);
              $watermarkHeight  = imagesy($watermark);
              $position         = $wm_pos ? $wm_pos : $settings->global_watermark_position;
              switch ($position) {
                case 'tl':
                  $placeWatermarkX = $watermarkMargin;
                  $placeWatermarkY = $watermarkMargin;
                  break;

                case 'tr':
                  $placeWatermarkX = $imageWidth - $watermarkWidth - $watermarkMargin;
                  $placeWatermarkY = $watermarkMargin;
                  break;

                case 'bl':
                  $placeWatermarkX = $watermarkMargin;
                  $placeWatermarkY = $imageHeight - $watermarkHeight - $watermarkMargin;
                  break;

                case 'br':
                  $placeWatermarkX = $imageWidth - $watermarkWidth - $watermarkMargin;
                  $placeWatermarkY = $imageHeight - $watermarkHeight - $watermarkMargin;
                  break;

                case 'c':
                  $placeWatermarkX = ($imageWidth - $watermarkWidth) / 2;
                  $placeWatermarkY = ($imageHeight - $watermarkHeight) / 2;
                  break;
              }
              imagecopymerge_alpha(
                $temp,
                $watermark,
                $placeWatermarkX,
                $placeWatermarkY,
                0,
                0,
                $watermarkWidth,
                $watermarkHeight,
                $settings->global_watermark_opacity
              );
              imagedestroy($watermark);
            }
          }
          imageinterlace($temp, $settings->imageinterlace);
          if ((dg::webpsupport() && $settings->enable_webp && !$force_format)) {
            call_user_func('imagewebp', $temp, $dg_imagesfile, $quality);
          } else if ($types[$size[2]] == 'jpeg') {
            call_user_func('image' . $types[$size[2]], $temp, $dg_imagesfile, $quality);
          } else {
            call_user_func('image' . $types[$size[2]], $temp, $dg_imagesfile);
          }
          imagedestroy($temp);
        }
      }
      return $relfile;
    } else {
      return $orgfile;
    }
  }
  exit;
}

function watermark($file, $wm, $position = 'c')
{
  $settings        = dg::getConfig();
  $image           = new Imagick($file);
  $imageWidth      = $image->getImageWidth();
  $imageHeight     = $image->getImageHeight();
  $factor          = $settings->global_watermark_size == 100 ? 1 : str_pad($settings->global_watermark_size, 4, '0.', STR_PAD_LEFT);
  $watermarkMargin = $position == 'c' ? 0 : $settings->global_watermark_margin;
  $watermark       = new Imagick($wm);
  $watermarkW      = $watermark->getImageWidth();
  $watermarkH      = $watermark->getImageHeight();
  $new_width       = $imageWidth * $factor;
  $new_height      = $watermarkH * $new_width / $watermarkW;
  $watermark->scaleImage($new_width, $new_height);
  $watermarkW = $watermark->getImageWidth();
  $watermarkH = $watermark->getImageHeight();
  if ($settings->global_watermark_opacity < 100) {
    $watermark->evaluateImage(Imagick::EVALUATE_MULTIPLY, $settings->global_watermark_opacity / 100, Imagick::CHANNEL_ALPHA);
  }
  switch ($position) {
    case 'tl':
      $x = $watermarkMargin;
      $y = $watermarkMargin;
      break;

    case 'tr':
      $x = $imageWidth - $watermarkW - $watermarkMargin;
      $y = $watermarkMargin;
      break;

    case 'bl':
      $x = $watermarkMargin;
      $y = $imageHeight - $watermarkH - $watermarkMargin;
      break;

    case 'br':
      $x = $imageWidth - $watermarkW - $watermarkMargin;
      $y = $imageHeight - $watermarkH - $watermarkMargin;
      break;

    case 'c':
      $x = ($imageWidth - $watermarkW) / 2;
      $y = ($imageHeight - $watermarkH) / 2;
      break;
  }
  $image->compositeImage($watermark, Imagick::COMPOSITE_OVER, $x, $y);
  $image->writeImage($file);
  $image->destroy();
  $watermark->destroy();
}

function resizewm($wm, $dst_width, $dst_height, $wm_size)
{
  $percent              = $wm_size == 100 ? 1 : str_pad($wm_size, 4, '0.', STR_PAD_LEFT);
  list($width, $height) = @getimagesize($wm);
  $new_width            = $dst_width * $percent;
  $new_height           = $height * $new_width / $width;
  $new_wm               = imagecreatetruecolor($new_width, $new_height);
  imagealphablending($new_wm, false);
  imagesavealpha($new_wm, true);
  $org_wm = imagecreatefrompng($wm);
  imagecopyresampled($new_wm, $org_wm, 0, 0, 0, 0, $new_width, $new_height, $width, $height);
  return $new_wm;
}

function get_width_height($original, $w, $h, $catid, $cropratio = '0', $force_format = false)
{
  $settings      = dg::getConfig();
  $cro           = str_replace(':', 'x', $cropratio);
  $dir           = "{$catid}_{$w}x{$h}_{$cro}";
  $dg_imagesfile = JPATH_SITE . ((dg::webpsupport() && $settings->enable_webp && !$force_format) ? $settings->path_to_webp . '/' : $settings->path_to_images . '/') . $dir . '/' . basename($original);
  $wh            = @getimagesize($dg_imagesfile);
  return $wh[3];
}

function getCacheFile($original, $w, $h, $catid, $cropratio = '0', $force_format = false, $jpath = true)
{
  $settings      = dg::getConfig();
  $cro           = str_replace(':', 'x', $cropratio);
  $dir           = "{$catid}_{$w}x{$h}_{$cro}";
  $dg_imagesfile = ($jpath ? JPATH_SITE : '') . ((dg::webpsupport() && $settings->enable_webp && !$force_format) ? $settings->path_to_webp . '/' : $settings->path_to_images . '/') . $dir . '/' . basename($original);
  return $dg_imagesfile;
}

function getTmpFile($original, $w, $h, $catid, $cropratio = '0', $tmp = '')
{
  $cro           = str_replace(':', 'x', $cropratio);
  $dir           = "{$catid}_{$w}x{$h}_{$cro}";
  $dg_imagesfile = JPATH_SITE . $tmp . $dir . '/' . basename($original);
  return $dg_imagesfile;
}

function getCacheFileSize($original, $w, $h, $catid, $cropratio = '0', $force_format = false)
{
  $settings          = dg::getConfig();
  $cro               = str_replace(':', 'x', $cropratio);
  $dir               = "{$catid}_{$w}x{$h}_{$cro}/";
  $dg_imagesfilesize = @getimagesize(JPATH_SITE . ((dg::webpsupport() && $settings->enable_webp && !$force_format) ? $settings->path_to_webp . '/' : $settings->path_to_images . '/') . $dir . basename($original));
  return $dg_imagesfilesize[3];
}

function findsharp($orig, $final)
{
  $final  = $final * (750.0 / $orig);
  $a      = 52;
  $b      = -0.27810650887573124;
  $c      = .00047337278106508946;
  $d      = 21882;
  $result = $a + $b * $final + $c * $final * $final;
  return max(round($result), 0);
}

function imagecopymerge_alpha($dst_im, $src_im, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $pct)
{
  $opacity = $pct;
  $w       = imagesx($src_im);
  $h       = imagesy($src_im);
  $cut     = imagecreatetruecolor($src_w, $src_h);
  imagecopy($cut, $dst_im, 0, 0, $dst_x, $dst_y, $src_w, $src_h);
  $opacity = 100 - $opacity;
  imagecopy($cut, $src_im, 0, 0, $src_x, $src_y, $src_w, $src_h);
  imagecopymerge($dst_im, $cut, $dst_x, $dst_y, $src_x, $src_y, $src_w, $src_h, $opacity);
}

if (!function_exists('imageconvolution')) {
  function imageconvolution($src, $filter, $filter_div, $offset)
  {
    if ($src == null) {
      return 0;
    }
    $sx      = imagesx($src);
    $sy      = imagesy($src);
    $srcback = imagecreatetruecolor($sx, $sy);
    imagecopy($srcback, $src, 0, 0, 0, 0, $sx, $sy);
    if ($srcback == null) {
      return 0;
    }
    $pxl = array(1, 1);
    for ($y = 0; $y < $sy; ++$y) {
      for ($x = 0; $x < $sx; ++$x) {
        $new_r = $new_g = $new_b = 0;
        $alpha = imagecolorat($srcback, $pxl[0], $pxl[1]);
        $new_a = $alpha >> 24;
        for ($j = 0; $j < 3; ++$j) {
          $yv = min(max($y - 1 + $j, 0), $sy - 1);
          for ($i = 0; $i < 3; ++$i) {
            $pxl = array(min(max($x - 1 + $i, 0), $sx - 1), $yv);
            $rgb = imagecolorat($srcback, $pxl[0], $pxl[1]);
            $new_r += (($rgb >> 16) & 0xFF) * $filter[$j][$i];
            $new_g += (($rgb >> 8) & 0xFF) * $filter[$j][$i];
            $new_b += ($rgb & 0xFF) * $filter[$j][$i];
          }
        }
        $new_r   = ($new_r / $filter_div) + $offset;
        $new_g   = ($new_g / $filter_div) + $offset;
        $new_b   = ($new_b / $filter_div) + $offset;
        $new_r   = ($new_r > 255) ? 255 : (($new_r < 0) ? 0 : $new_r);
        $new_g   = ($new_g > 255) ? 255 : (($new_g < 0) ? 0 : $new_g);
        $new_b   = ($new_b > 255) ? 255 : (($new_b < 0) ? 0 : $new_b);
        $new_pxl = ImageColorAllocateAlpha($src, (int) $new_r, (int) $new_g, (int) $new_b, $new_a);
        if ($new_pxl == -1) {
          $new_pxl = ImageColorClosestAlpha($src, (int) $new_r, (int) $new_g, (int) $new_b, $new_a);
        }
        if (($y >= 0) && ($y < $sy)) {
          imagesetpixel($src, $x, $y, $new_pxl);
        }
      }
    }
    imagedestroy($srcback);
    return 1;
  }
}

function imagefillalpha($image, $color)
{
  imagefilledrectangle($image, 0, 0, imagesx($image), imagesy($image), $color);
}

function gdrotate($image)
{
  $size = @getimagesize($image, $image_info);
  if (function_exists('exif_read_data')) {
    $exif        = @exif_read_data($image);
    $exif_orient = isset($exif['Orientation']) ? $exif['Orientation'] : 0;
    $rotateImage = 0;
    if (6 == $exif_orient) {
      $rotateImage      = 90;
      $imageOrientation = 1;
    } elseif (3 == $exif_orient) {
      $rotateImage      = 180;
      $imageOrientation = 1;
    } elseif (8 == $exif_orient) {
      $rotateImage      = 270;
      $imageOrientation = 1;
    }
    if ($rotateImage) {
      $rotateImage = -$rotateImage;
      switch ($size['mime']) {
        case 'image/jpeg':
          $source = @imagecreatefromjpeg($image);
          $rotate = @imagerotate($source, $rotateImage, 0);
          @imagejpeg($rotate, $image, 100);
          break;

        case 'image/png':
          $source = @imagecreatefrompng($image);
          $rotate = @imagerotate($source, $rotateImage, 0);
          @imagepng($rotate, $image);
          break;

        case 'image/gif':
          $source = @imagecreatefromgif($image);
          $rotate = @imagerotate($source, $rotateImage, 0);
          @imagegif($rotate, $image);
          break;

        default:
          break;
      }
    }
  }
  return $image;
}

function imrotate($image)
{
  $imagick = new Imagick();
  $imagick->readImage($image);
  $format = strtolower($imagick->getImageFormat());
  if ($format === 'jpeg') {
    $orientation = $imagick->getImageOrientation();
    $isRotated   = false;
    if ($orientation === Imagick::ORIENTATION_RIGHTTOP) {
      $imagick->rotateImage('none', 90);
      $isRotated = true;
    } elseif ($orientation === Imagick::ORIENTATION_BOTTOMRIGHT) {
      $imagick->rotateImage('none', 180);
      $isRotated = true;
    } elseif ($orientation === Imagick::ORIENTATION_LEFTBOTTOM) {
      $imagick->rotateImage('none', 270);
      $isRotated = true;
    }
    if ($isRotated) {
      $imagick->setImageOrientation(Imagick::ORIENTATION_TOPLEFT);
      $imagick->writeImage($image);
      $imagick->clear();
      $imagick->destroy();
    }
  }
}

function fastimagecopyresampled(&$dst_image, $src_image, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h, $quality = 3)
{

  /**
   * Plug-and-Play fastImageCopyResampled function replaces much slower imagecopyresampled.
   * Just include this function and change all "imagecopyresampled" references to "fastImageCopyResampled".
   * Typically from 30 to 60 times faster when reducing high resolution images down to thumbnail size using the default quality setting.
   * Author: Tim Eckel - Date: 09/07/07 - Version: 1.1 - Project: FreeRingers.net - Freely distributable - These comments must remain.
   *
   * Optional "quality" parameter (defaults is 3). Fractional values are allowed, for example 1.5. Must be greater than zero.
   * Between 0 and 1 = Fast, but mosaic results, closer to 0 increases the mosaic effect.
   * 1 = Up to 350 times faster. Poor results, looks very similar to imagecopyresized.
   * 2 = Up to 95 times faster.  Images appear a little sharp, some prefer this over a quality of 3.
   * 3 = Up to 60 times faster.  Will give high quality smooth results very close to imagecopyresampled, just faster.
   * 4 = Up to 25 times faster.  Almost identical to imagecopyresampled for most images.
   * 5 = No speedup. Just uses imagecopyresampled, no advantage over imagecopyresampled.
   */

  if (empty($src_image) || empty($dst_image) || $quality <= 0) {return false;}

  if ($quality < 5 && (($dst_w * $quality) < $src_w || ($dst_h * $quality) < $src_h)) {
    $temp = imagecreatetruecolor($dst_w * $quality + 1, $dst_h * $quality + 1);
    imagecopyresized($temp, $src_image, 0, 0, $src_x, $src_y, $dst_w * $quality + 1, $dst_h * $quality + 1, $src_w, $src_h);
    imagecopyresampled($dst_image, $temp, $dst_x, $dst_y, 0, 0, $dst_w, $dst_h, $dst_w * $quality, $dst_h * $quality);
    imagedestroy($temp);
  } else {
    imagecopyresampled($dst_image, $src_image, $dst_x, $dst_y, $src_x, $src_y, $dst_w, $dst_h, $src_w, $src_h);
  }

  return true;
}