<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

jimport('joomla.filesystem.file');
include_once (JPATH_COMPONENT.'/helpers/wmresize.php');

$user = JFactory::getUser();
if (!$user->id)
	exit;
$settings = dg::getConfig();
$document = JFactory::getDocument();
$uri = JFactory::getURI();
$error = null;
$success = null;
$output = null;
$dest = JPATH_COMPONENT_SITE.'/assets/images/watermark.png';
$app = JFactory::getApplication();
$file = $app->input->files->get('file_upload');
if ($file) {
	$filename = JFile::makeSafe($file['name']);
	$src = $file['tmp_name'];
	$size = getimagesize($src);
	if ($size['mime'] == 'image/png') {
		if ($size[1] < $settings->image_width_details)
			$height = $size[1];
		else
			$height = $settings->image_width_details;
		if ($size[1] > $settings->image_width_details || $size['mime'] != 'image/png') {
			$dgwm = new waterMark();
			$dgwm->resize($src, 0, $height, IMAGETYPE_PNG);
		}
		if (JFile::upload($src, $dest)) {
			$success = JText::_('COM_DATSOGALLERY_WM_SUCCESS');
			dgclean();
      if (JFolder::exists(JPATH_SITE . $settings->path_to_webp)) {
        dgcleanwebp();
      }
		}
		else {
			$error = JText::_('COM_DATSOGALLERY_WM_ERROR_COPY');
		}
	}
	else {
		$error = JText::_('COM_DATSOGALLERY_WM_ERROR_MIME');
	}
	if ($error) {
		$output = '<div class="dg_uploaderror">'.$error.'</div>';
	}
	else {
		$output = '<div class="dg_uploadsuccess">'.$success.'</div>';
	}
}
$wm_url = $uri->root().'components/com_datsogallery/assets/images/watermark.png';
$wm_url .= '?'.intval(microtime(true));
JHtml::_('jquery.framework');
function dgclean($ids = array()) {
  $conf = JFactory::getConfig();
  $options = array(
    'defaultgroup' => '',
    'storage' => $conf->get('cache_handler', ''),
    'caching' => true,
    'cachebase' => $conf->get('cache_path', JPATH_SITE.'/cache')
  );
  $cache = JCache::getInstance('', $options);
  $dg_caches = array_keys($cache->getAll());
  foreach ($dg_caches as $key => $group) {
    $cache->clean($group);
  }
}
function dgcleanwebp($ids = array()) {
  $settings = dg::getConfig();
  $conf = JFactory::getConfig();
  $options = array(
    'defaultgroup' => '',
    'storage' => $conf->get('cache_handler', ''),
    'caching' => true,
    'cachebase' => $conf->get('cache_path', JPATH_SITE.$settings->path_to_webp)
  );
  $cache = JCache::getInstance('', $options);
  $dg_caches = array_keys($cache->getAll());
  foreach ($dg_caches as $key => $group) {
    $cache->clean($group);
  }
}
?>
<html>
   <head>
      <style>
         body{font:11px "Ubuntu",sans-serif;margin:0;padding:0;background: #EFEFEF;}
         #frame{display:block;}
         .dg_wmbg{margin-bottom:5px;padding:10px 0;display:block;background:transparent url(./components/com_datsogallery/assets/images/transparent.gif)}
         img.dg_wm{outline:0;max-width:100%;height:auto;max-height:100px;}
         .dg_wm{vertical-align:middle}
         .dg_output{padding-bottom:5px;font-style: italic; font-weight: 500;}
         .dg_uploaderror{color:#CD5C5C;}
         .dg_uploadsuccess{color:#76AD71;}
         #frame {
           text-align: center;
         }

         form{position:absolute;left:-99999px}
      </style>
      <script>
         jQuery(document).ready(function () {
              jQuery('.dgbrowse').bind('click', function () {
                  jQuery('input[type="file"]').trigger('click');
              });
          });
          function upload(e) {
              var target = jQuery.event.fix(e).target;
              jQuery(target).closest('form').submit();
          }
      </script>
   </head>
   <body>
   <div id="frame">
      <div class="dg_wmbg"><img src="<?php echo $wm_url; ?>" alt="wm" class="dg_wm" /></div>
      <div class="dg_output"><?php echo $output; ?></div>
      <form method="post" action="" enctype="multipart/form-data" onSubmit="if(file_upload.value=='') {alert('Select a file!');return false;}">
         <input style="margin-left: 0" type="file" name="file_upload" onChange="upload(event)" />
         <?php echo JHTML::_('form.token'); ?>
      </form>
      <div><button class="dgbrowse btn btn-small"><?php echo JText::_('COM_DATSOGALLERY_SELECT_WATERMARK'); ?></button></div>
   </div>
   </body>
</html>

