<?php
/**
 * @package    com_datsogallery
 * @author     Andrey Datso <support@datso.fr>
 * @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\Utilities\IpHelper;

require_once dirname(__FILE__) . '/config.php';

abstract class dg
{

  public static function addSubmenu($vName = '')
  {
    JHtmlSidebar::addEntry('<span><i class="dgi-dashboard"></i><span>' .
      JText::_('Dashboard') . '</span></span>',
      'index.php?option=com_datsogallery',
      $vName == 'datsogallery'
    );
    JHtmlSidebar::addEntry('<span><i class="dgi-album"></i><span>' .
      JText::_('COM_DATSOGALLERY_TITLE_CATEGORIES') . '</span></span>',
      'index.php?option=com_datsogallery&view=categories',
      $vName == 'categories'
    );
    JHtmlSidebar::addEntry('<span><i class="dgi-image"></i><span>' .
      JText::_('COM_DATSOGALLERY_TITLE_IMAGES') . '</span></span>',
      'index.php?option=com_datsogallery&view=images',
      $vName == 'images'
    );
    JHtmlSidebar::addEntry('<span><i class="dgi-add-image"></i><span>' .
      JText::_('COM_DATSOGALLERY_TITLE_UPLOAD') . '</span></span>',
      'index.php?option=com_datsogallery&view=upload',
      $vName == 'upload'
    );
    JHtmlSidebar::addEntry('<span><i class="dgi-comments"></i><span>' .
      JText::_('COM_DATSOGALLERY_TITLE_COMMENTS') . '</span></span>',
      'index.php?option=com_datsogallery&view=comments',
      $vName == 'comments'
    );
    JHtmlSidebar::addEntry('<span><i class="dgi-block"></i><span>' .
      JText::_('COM_DATSOGALLERY_TITLE_BLACKLISTS') . '</span></span>',
      'index.php?option=com_datsogallery&view=blacklists',
      $vName == 'blacklists'
    );
    JHtmlSidebar::addEntry('<span><i class="dgi-settings"></i><span>' .
      JText::_('COM_DATSOGALLERY_TITLE_SETTINGS') . '</span></span>',
      'index.php?option=com_datsogallery&view=settings',
      $vName == 'settings'
    );
  }

  public static function getActions()
  {
    $user      = JFactory::getUser();
    $result    = new JObject;
    $assetName = 'com_datsogallery';
    $actions   = array(
      'core.admin',
      'core.manage',
      'core.create',
      'core.edit',
      'core.edit.own',
      'core.edit.state',
      'core.delete'
    );
    foreach ($actions as $action) {
      $result->set($action, $user->authorise($action, $assetName));
    }
    return $result;
  }

  public static function imagerefresh($original, $catid)
  {
    require_once JPATH_COMPONENT . '/images.php';
    $current = getCacheFile($original, 400, 500, $catid, '1:1');
    if (JFile::exists($current)) {
      JFile::delete($current);
    }
  }

  public static function readConfig($force = false)
  {
    $config = DatsogalleryConfig::getInstance();
    if ($force) {
      $config->reload();
    }
    return $config->getData();
  }

  public static function getConfig($name = null, $default = false)
  {
    $config = DatsogalleryConfig::getInstance();
    if (is_null($name)) {
      return $config->getData();
    } else {
      return $config->get($name, $default);
    }
  }

  public static function protect_dir()
  {
    $settings = self::getConfig();
    jimport('joomla.filesystem.folder');
    jimport('joomla.filesystem.file');
    $htaccess = "order deny,allow\ndeny from all";
    if (!empty($settings->path_to_originals)
      && JFolder::exists(JPATH_SITE . $settings->path_to_originals)) {
      JFile::write(JPATH_SITE . $settings->path_to_originals . '/.htaccess', $htaccess);
    }
  }

  public static function unprotect_dir()
  {
    $settings = self::getConfig();
    jimport('joomla.filesystem.folder');
    jimport('joomla.filesystem.file');
    if (!empty($settings->path_to_originals)
      && JFolder::exists(JPATH_SITE . $settings->path_to_originals)) {
      if (JFile::exists(JPATH_SITE . $settings->path_to_originals . '/.htaccess')) {
        JFile::delete(JPATH_SITE . $settings->path_to_originals . '/.htaccess');
      }
    }
  }

  public static function write_custom_css($css = '')
  {
    jimport('joomla.filesystem.file');
    JFile::write(JPATH_COMPONENT_SITE . '/assets/css/custom.css', $css);
  }

  public static function read_custom_css()
  {
    jimport('joomla.filesystem.file');
    if (!JFile::exists(JPATH_COMPONENT_SITE . '/assets/css/custom.css')) {
      JFile::write(JPATH_COMPONENT_SITE . '/assets/css/custom.css', '');
    }
    $css = JFile::read(JPATH_COMPONENT_SITE . '/assets/css/custom.css');
    return $css;
  }

  public static function sbox()
  {
    $app      = JFactory::getApplication();
    $settings = self::getConfig();
    $id       = $app->input->getInt('id');
    $catid    = $app->input->getInt('catid');
    $user     = JFactory::getUser();
    $isroot   = $user->authorise('core.admin');
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    if ($id) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select($db->qn('a.original'));
      $query->from($db->qn('#__datsogallery_images', 'a'));
      $query->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON c.id = a.catid');
      $query->join('LEFT', $db->qn('#__users', 'u') . ' ON u.id = a.created_by');
      $query->where($db->qn('a.id') . ' = ' . (int) $id);
      $query->where($db->qn('a.catid') . ' = ' . (int) $catid);
      if ($app->isClient('site')) {
        $query->where($db->qn('a.state') . ' = 1');
        $query->where($db->qn('a.approved') . ' = 1');
        $query->where($db->qn('a.access') . ' IN (' . $groups . ')');
        $query->where($db->qn('c.published') . ' = 1');
        $query->where($db->qn('c.approved') . ' = 1');
        $query->where($db->qn('c.access') . ' IN (' . $groups . ')');
      }
      $db->setQuery($query);
      $image = $db->loadResult();
      if ($app->isClient('site')) {
        $model = JModelLegacy::getInstance('Image', 'DatsogalleryModel');
        $model->hit($id);
      }
      require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';
      if (is_ani(JPath::clean(JPATH_SITE . $settings->path_to_originals . '/' . $image))) {
        $image = JPath::clean($settings->path_to_originals . '/' . $image);
      } else {
        $image = resize($image, $settings->fancybox_image_width, $settings->fancybox_image_height,
          0, 0, $settings->fancybox_image_watermark, $catid, '', 100, false,
          $settings->fancybox_watermark_position);
      }
      if ($image) {
        $imagesize = @getimagesize(JPath::clean(JPATH_SITE . $image));
        $expires   = 60 * 60 * 24 * 14;
        header('Pragma: public');
        header('Cache-Control: maxage=' . $expires);
        header('Expires: ' . gmdate('D, d M Y H:i:s', time() + $expires) . ' GMT');
        header('Last-Modified: ' . date('r'));
        header('Accept-Ranges: bytes');
        header('Content-Length: ' . (filesize(JPath::clean(JPATH_SITE . $image))));
        header('Content-Type: ' . $imagesize['mime']);
        ob_clean();
        readfile(JPath::clean(JPATH_SITE . $image));
      }
    }
    $app->close();
  }

  public static function is_root()
  {
    $user   = JFactory::getUser();
    $isroot = $user->authorise('core.admin');
    return $isroot;
  }

  public static function human_filesize($bytes, $decimals = 2)
  {
    $sz     = 'BKMGTP';
    $factor = floor((strlen($bytes) - 1) / 3);
    return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
  }

  public static function human_number($num, $places = 1, $type = 'metric')
  {
    if ($type == 'metric') {
      $k = 'K';
      $m = 'M';
    } else {
      $k = ' thousand';
      $m = ' million';
    }
    if ($num < 1000) {
      $num_format = number_format($num);
    } else
    if ($num < 1000000) {
      $num_format = number_format($num / 1000, $places) . $k;
    } else {
      $num_format = number_format($num / 1000000, $places) . $m;
    }
    return $num_format;
  }

  public static function human_views($num)
  {
    if (($num == 1) || (strlen($num) > 1 && substr($num, -1, 1) == 1) && $num != 11) {
      $result = 1;
    } elseif (strlen($num) > 1 && in_array(substr($num, -1, 1), array(2, 3, 4))
      && !in_array($num, array(12, 13, 14))) {
      $result = 2;
    } elseif (strlen($num) == 1 && in_array(substr($num, -1, 1), array(2, 3, 4))) {
      $result = 2;
    } else {
      $result = 3;
    }
    return $result;
  }

  public static function percent($num_amount, $num_total)
  {
    @$result = (int) (($num_amount / $num_total) * 100 + .49);
    return $result;
  }

  public static function get_dpi($filename)
  {
    $a      = fopen($filename, 'r');
    $string = fread($a, 20);
    fclose($a);
    $data = bin2hex(substr($string, 14, 4));
    $x    = substr($data, 0, 4);
    $y    = substr($data, 0, 4);
    return hexdec($x);
  }

  public static function addhttp($url)
  {
    if (preg_match("#https?://#", $url) === 0) {
      $url = 'http://' . $url;
    }
    return $url;
  }

  public static function checkdesc($text)
  {
    return strip_tags(trim(html_entity_decode($text, ENT_QUOTES, 'UTF-8'), "\xc2\xa0"));
  }

  public static function removetags($text)
  {
    return preg_replace('/[\[{\(].*[\]}\)]/U', '', $text);
  }

  public static function image_data($file)
  {
    $config                             = self::getConfig();
    $path                               = JPATH_SITE . $config->path_to_originals . '/' . $file;
    $filesize                           = filesize($path);
    list($width, $height, $type, $attr) = @getimagesize($path);
    $out                                = '';
    $out .= '<ul class="dg-flex-margin-5 dg-flex-nowrap">';
    $out .= $config->image_file_size ? ' <li>' . self::human_filesize($filesize) . ' </li>' : '';
    $out .= $config->image_dimensions ? ' <li>' . $width . ' x ' . $height . ' </li>' : '';
    $out .= $config->image_file_type ? ' <li>' . strtoupper(ltrim(image_type_to_extension($type), '.')) . '</li>' : '';
    $out .= '</ul>';
    return $out;
  }

  public static function exif_data($file)
  {
    if (function_exists('exif_read_data')) {
      $config = self::getConfig();
      if ($config->image_exif) {
        $ext = strtolower(substr(strrchr(JPATH_SITE . $config->path_to_originals . '/' . $file, '.'), 1));
        if ($ext == 'jpg' || $ext == 'jpeg') {
          $exif_data = @exif_read_data(JPATH_SITE . $config->path_to_originals . '/' . $file, 'IFD0');
          $dg_exif   = '';
          if (isset($exif_data['Make']) != '') {
            $dg_exif .= '<ul class="dg-image-info">';
            $dg_exif .= '<li>';
            /*if ($exif_data['Make']) {
            $dg_exif .= '<ul class="exif-flex"><li><strong>' . $exif_data['Make'] . '</strong></li></ul>';
            }*/
            if (isset($exif_data['Model']) != '') {
              $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-camera"></i></li><li>' . $exif_data['Make'] . '</li><li>' . $exif_data['Model'] . '</li></ul>';
            }
            if (isset($exif_data['ExposureTime']) != '') {
              $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-exposure"></i></li><li>' . JText::_('COM_DATSOGALLERY_EXIF_EXPOSURE') . ':</li><li>' . sprintf('%s (%01.3f sec)', self::simplifyFraction($exif_data['ExposureTime']), self::evalRational($exif_data['ExposureTime'])) . '</li></ul>';
            }
            if (isset($exif_data['FNumber']) != '') {
              $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-aperture"></i></li><li>' . JText::_('COM_DATSOGALLERY_EXIF_APERTURE') . ':</li><li>' . sprintf('f/%01.1f', self::evalRational($exif_data['FNumber'])) . '</li></ul>';
            }
            if (isset($exif_data['FocalLength']) != '') {
              $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-focal-length"></i></li><li>' . JText::_('COM_DATSOGALLERY_EXIF_FOCALLENGTH') . ':</li><li>' . sprintf('%01.1f mm', self::evalRational($exif_data['FocalLength'])) . '</li></ul>';
            }
            if (isset($exif_data['ISOSpeedRatings']) != '') {
              $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-iso"></i></li><li>' . JText::_('COM_DATSOGALLERY_EXIF_ISO') . ':</li><li>' . $exif_data['ISOSpeedRatings'] . '</li></ul>';
            }
            if (isset($exif_data['Flash'])) {
              switch ($exif_data['Flash']) {
                case 0:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH0');
                  break;
                case 1:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH1');
                  break;
                case 5:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH5');
                  break;
                case 7:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH7');
                  break;
                case 9:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH9');
                  break;
                case 13:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH13');
                  break;
                case 15:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH15');
                  break;
                case 16:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH16');
                  break;
                case 24:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH24');
                  break;
                case 25:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH25');
                  break;
                case 29:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH29');
                  break;
                case 31:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH31');
                  break;
                case 32:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH32');
                  break;
                case 65:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH65');
                  break;
                case 69:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH69');
                  break;
                case 71:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH71');
                  break;
                case 73:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH73');
                  break;
                case 77:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH77');
                  break;
                case 79:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH79');
                  break;
                case 89:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH89');
                  break;
                case 93:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH93');
                  break;
                case 95:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH95');
                  break;
                default:
                  $flash = JText::_('COM_DATSOGALLERY_EXIF_FLASH0');
                  break;
              }
              $flashed    = array(1, 9, 13, 15, 25, 29, 31, 65, 69, 71, 73, 77, 79, 89, 93, 95);
              $notflashed = array(0, 5, 7, 16, 24);
              if ($config->image_exif_flash_advanced) {
                $flash_result = $flash;
              } else {
                if (in_array($exif_data['Flash'], $flashed)) {
                  $flash_result = JText::_('COM_DATSOGALLERY_EXIF_FLASH1');
                } elseif (in_array($exif_data['Flash'], $notflashed)) {
                  $flash_result = JText::_('COM_DATSOGALLERY_EXIF_FLASH0');
                } else {
                  $flash_result = JText::_('COM_DATSOGALLERY_EXIF_FLASH32');
                }
              }
              $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-flash"></i></li><li>' . $flash_result . '</li></ul>';
              if (isset($exif_data['DateTimeOriginal']) != '') {
                $dg_exif .= '<ul class="dg-flex-margin-5 dg-flex-nowrap"><li><i class="dgi-time"></i></li><li>' . JHtml::_('date', $exif_data['DateTimeOriginal'], JText::_('M d, Y')) . '</li></ul>';
              }
            }
            $dg_exif .= '</li>';
            $dg_exif .= '</ul>';
            if (!empty($exif_data['Model'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . $exif_data['Make'] . '">';
              $dg_exif .= '<meta itemprop="value" content="' . $exif_data['Model'] . '">';
              $dg_exif .= '</div>';
            }
            if (!empty($exif_data['ExposureTime'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . JText::_('COM_DATSOGALLERY_EXIF_EXPOSURE') . '">';
              $dg_exif .= '<meta itemprop="value" content="' . sprintf('%s (%01.3f sec)', self::simplifyFraction($exif_data['ExposureTime']), self::evalRational($exif_data['ExposureTime'])) . '">';
              $dg_exif .= '</div>';
            }
            if (!empty($exif_data['FNumber'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . JText::_('COM_DATSOGALLERY_EXIF_APERTURE') . '">';
              $dg_exif .= '<meta itemprop="value" content="' . sprintf('f/%01.1f', self::evalRational($exif_data['FNumber'])) . '">';
              $dg_exif .= '</div>';
            }
            if (!empty($exif_data['FocalLength'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . JText::_('COM_DATSOGALLERY_EXIF_FOCALLENGTH') . '">';
              $dg_exif .= '<meta itemprop="value" content="' . sprintf('%01.1f mm', self::evalRational($exif_data['FocalLength'])) . '">';
              $dg_exif .= '</div>';
            }
            if (!empty($exif_data['ISOSpeedRatings'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . JText::_('COM_DATSOGALLERY_EXIF_ISO') . '">';
              $dg_exif .= '<meta itemprop="value" content="' . $exif_data['ISOSpeedRatings'] . '">';
              $dg_exif .= '</div>';
            }
            if (!empty($exif_data['DateTimeOriginal'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . JText::_('COM_DATSOGALLERY_EXIF_DATETIME') . '">';
              $dg_exif .= '<meta itemprop="value" content="' . $exif_data['DateTimeOriginal'] . '">';
              $dg_exif .= '</div>';
            }
            if (!empty($exif_data['Flash'])) {
              $dg_exif .= '<div itemprop="exifData" itemscope itemtype="http://schema.org/PropertyValue">';
              $dg_exif .= '<meta itemprop="name" content="' . JText::_('COM_DATSOGALLERY_EXIF_FLASH') . '">';
              $dg_exif .= '<meta itemprop="value" content="' . $flash . '">';
              $dg_exif .= '</div>';
            }
            //var_dump($exif_data);
            return $dg_exif;
          }
        }
      }
    }
  }

  public static function getaddress($lat, $lng)
  {
    $settings = self::getConfig();
    if ($settings->gm_api_key != '') {
      $url = 'https://maps.googleapis.com/maps/api/geocode/json?latlng=' . trim($lat) . ',' . trim($lng) . '&key=' . $settings->gm_api_key;
      if (JLanguageMultilang::isEnabled()) {
        $language = JFactory::getLanguage();
        $code     = substr($language->get('tag'), 0, 2);
        $url .= '&language=' . $code;
      }
      $json   = @file_get_contents($url);
      $data   = json_decode($json);
      $status = $data->status;
      if ($status == "OK") {
        return '<meta itemprop="contentLocation" content="' . addslashes($data->results[2]->formatted_address) . '">';
      } else {
        return false;
      }
    } else {
      return false;
    }
  }

  public static function read_gps_location($file)
  {
    if (function_exists('exif_read_data')) {
      $config = self::getConfig();
      if (is_file(JPATH_SITE . $config->path_to_originals . '/' . $file)) {
        $info = @exif_read_data(JPATH_SITE . $config->path_to_originals . '/' . $file, 'IFD0');
        if (isset($info['GPSLatitude'])
          && isset($info['GPSLongitude'])
          && isset($info['GPSLatitudeRef'])
          && isset($info['GPSLongitudeRef'])
          && in_array($info['GPSLatitudeRef'], array('E', 'W', 'N', 'S'))
          && in_array($info['GPSLongitudeRef'], array('E', 'W', 'N', 'S'))) {
          $GPSLatitudeRef  = strtolower(trim($info['GPSLatitudeRef']));
          $GPSLongitudeRef = strtolower(trim($info['GPSLongitudeRef']));
          $lat_degrees_a   = explode('/', $info['GPSLatitude'][0]);
          $lat_minutes_a   = explode('/', $info['GPSLatitude'][1]);
          $lat_seconds_a   = explode('/', $info['GPSLatitude'][2]);
          $lng_degrees_a   = explode('/', $info['GPSLongitude'][0]);
          $lng_minutes_a   = explode('/', $info['GPSLongitude'][1]);
          $lng_seconds_a   = explode('/', $info['GPSLongitude'][2]);
          $lat_degrees     = $lat_degrees_a[0] / $lat_degrees_a[1];
          $lat_minutes     = $lat_minutes_a[0] / $lat_minutes_a[1];
          $lat_seconds     = $lat_seconds_a[0] / $lat_seconds_a[1];
          $lng_degrees     = $lng_degrees_a[0] / $lng_degrees_a[1];
          $lng_minutes     = $lng_minutes_a[0] / $lng_minutes_a[1];
          $lng_seconds     = $lng_seconds_a[0] / $lng_seconds_a[1];
          $lat             = (float) $lat_degrees + ((($lat_minutes * 60) + ($lat_seconds)) / 3600);
          $lng             = (float) $lng_degrees + ((($lng_minutes * 60) + ($lng_seconds)) / 3600);
          $GPSLatitudeRef == 's' ? $lat *= -1 : '';
          $GPSLongitudeRef == 'w' ? $lng *= -1 : '';
          return array('lat' => $lat, 'lng' => $lng);
        }
      }
    }
    return false;
  }

  public static function greatCommonDivisor($int1, $int2)
  {
    if (0 == $int1) {
      return 0 == $int2 ? 1 : $int2;
    }
    if (0 == $int2) {
      return 1;
    }
    if ($int1 == $int2) {
      return $int1;
    }
    if (0 == $int1 % 2 && 0 == $int2 % 2) {
      return 2 * self::greatCommonDivisor((integer) ($int1 / 2), (integer) ($int2 / 2));
    }
    if (0 == $int1 % 2) {
      return self::greatCommonDivisor((integer) ($int1 / 2), $int2);
    }
    if (0 == $int2 % 2) {
      return self::greatCommonDivisor((integer) ($int2 / 2), $int1);
    }
    return self::greatCommonDivisor($int1, abs($int2 - $int1));
  }

  public static function simplifyFraction($fraction)
  {
    if (preg_match('/^(\d+)\/(\d+)$/', $fraction, $matches)) {
      $numerator   = $matches[1];
      $denominator = isset($matches[2]) && $matches[2] ? $matches[2] : 1;
      $gcd         = self::greatCommonDivisor($numerator, $denominator);
      return sprintf('%d/%d', $numerator / $gcd, $denominator / $gcd);
    }
    return $fraction;
  }

  public static function is_favorited($id)
  {
    $user  = JFactory::getUser();
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('id')
      ->from($db->qn('#__datsogallery_favorites'))
      ->where($db->qn('image_id') . ' = ' . (int) $id)
      ->where($db->qn('user_id') . ' = ' . $user->id);
    $db->setQuery($query);
    if ($db->loadResult()) {
      return 1;
    } else {
      return 0;
    }
  }

  public static function evalRational($value)
  {
    if (preg_match('/^(\d+)\/(\d+)$/', $value, $matches)) {
      $value = $matches[2] ? ($matches[1] / $matches[2]) : 0;
    }
    return (float) $value;
  }

  public static function getIpAddress()
  {
    return (empty($_SERVER['HTTP_CLIENT_IP']) ? (empty($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['REMOTE_ADDR'] : $_SERVER['HTTP_X_FORWARDED_FOR']) : $_SERVER['HTTP_CLIENT_IP']);
  }

  public static function ismail($email)
  {
    return (boolean) filter_var($email, FILTER_VALIDATE_EMAIL);
  }

  public static function profile($id)
  {
    if ($id) {
      $db = JFactory::getDbo();
      $db->setQuery('SELECT member_key, member_value FROM #__datsogallery_members' . ' WHERE user_id = ' . (int) $id . ' ORDER BY ordering');
      try {
        $results = $db->loadRowList();
      } catch (RuntimeException $e) {
        $this->_subject->setError($e->getMessage());
        return false;
      }
      /*if (!is_object(@$data)) {
      $data = new stdClass;
      }*/
      $data = array();
      foreach ($results as $v) {
        $k        = $v[0];
        $data[$k] = json_decode($v[1], true);
        if ($data[$k] === null) {
          $data[$k] = $v[1];
        }
      }
      foreach ($data as $k => $v) {
        $data[$k] = $v;
      }
    }
    return $data;
  }

  public static function timezone($time)
  {
    $tz     = JFactory::getUser()->getTimezone();
    $tztime = JFactory::getDate($time, 'UTC')->setTimeZone($tz);
    return $tztime;
  }

  public static function timelapse($date, $lapse = 1)
  {
    if ($lapse) {
      $language = JFactory::getLanguage();
      $language->load('com_datsogallery', JPATH_SITE, $language->getTag(), true);
      $now  = self::timezone(JFactory::getDate()->toSql());
      $ago  = self::timezone($date);
      $diff = $now->diff($ago);

      $diff->w = floor($diff->d / 7);
      $diff->d -= $diff->w * 7;

      $string = array(
        'y' => 'COM_DATSOGALLERY_LAPSED_YEAR',
        'm' => 'COM_DATSOGALLERY_LAPSED_MONTH',
        'w' => 'COM_DATSOGALLERY_LAPSED_WEEK',
        'd' => 'COM_DATSOGALLERY_LAPSED_DAY',
        'h' => 'COM_DATSOGALLERY_LAPSED_HOUR',
        'i' => 'COM_DATSOGALLERY_LAPSED_MINUTE',
        's' => 'COM_DATSOGALLERY_LAPSED_SECOND',
      );
      foreach ($string as $k => &$v) {
        if ($diff->$k) {
          $v = JText::plural($v, $diff->$k);
        } else {
          unset($string[$k]);
        }
      }

      $string = array_slice($string, 0, 1);
      return $string ? implode(', ', $string) : JText::_('COM_DATSOGALLERY_LAPSED_LESS_THAN_A_MINUTE');
    } else {
      return JHtml::_('date', self::timezone($date), JText::_('COM_DATSOGALLERY_DATE_FORMAT'));
    }
  }

  public static function birthday($birthday)
  {
    $age = date_create($birthday)->diff(date_create('today'))->y;
    return $age;
  }

  public static function imagecat($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->qn('catid'));
    $query->from($db->qn('#__datsogallery_images'));
    $query->where($db->qn('id') . ' = ' . $id);
    $db->setQuery($query);
    $catid = $db->loadResult();
    return $catid;
  }

  public static function imagetitle($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->qn('title'));
    $query->from($db->qn('#__datsogallery_images'));
    $query->where($db->qn('id') . ' = ' . $id);
    $db->setQuery($query);
    $title = $db->loadResult();
    return $title;
  }

  public static function catbyid($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($db->qn('title'));
    $query->from($db->qn('#__datsogallery_categories'));
    $query->where($db->qn('id') . ' = ' . (int) $id);
    $db->setQuery($query);
    $title = $db->loadResult();
    return $title;
  }

  public static function totalimages($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('count(id)');
    $query->from($db->qn('#__datsogallery_images'));
    $query->where($db->qn('created_by') . ' = ' . $id);
    $db->setQuery($query);
    $total = $db->loadResult();
    return $total;
  }

  public static function totalcategories($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('count(id)');
    $query->from($db->qn('#__datsogallery_categories'));
    $query->where($db->qn('created_by') . ' = ' . $id);
    $db->setQuery($query);
    $total = $db->loadResult();
    return $total;
  }

  public static function geo_single_gps($crd, $dir)
  {
    $degrees = count($crd) > 0 ? self::geo_gps($crd[0]) : 0;
    $minutes = count($crd) > 1 ? self::geo_gps($crd[1]) : 0;
    $seconds = count($crd) > 2 ? self::geo_gps($crd[2]) : 0;
    $flip    = ($dir == 'W' or $dir == 'S') ? -1 : 1;
    return floatval($flip * ($degrees + ($minutes / 60) + ($seconds / 3600)));
  }

  public static function geo_gps($crd)
  {
    $prt = explode('/', $crd);
    if (count($prt) <= 0) {
      return 0;
    }

    if (count($prt) == 1) {
      return $prt[0];
    }

    return floatval($prt[0]) / floatval($prt[1]);
  }

  public static function client_ip()
  {
    $ip = getenv('HTTP_CLIENT_IP') ?:
    getenv('HTTP_X_FORWARDED_FOR') ?:
    getenv('HTTP_X_FORWARDED') ?:
    getenv('HTTP_FORWARDED_FOR') ?:
    getenv('HTTP_FORWARDED') ?:
    getenv('REMOTE_ADDR');
    return $ip;
  }

  public static function check_org($type = 'originals')
  {
    jimport('joomla.filesystem.file');
    jimport('joomla.filesystem.folder');
    $app      = JFactory::getApplication();
    $settings = self::getConfig();
    switch ($type) {
      case 'originals':
        $path = $settings->path_to_originals;
        break;
      case 'images':
        $path = $settings->path_to_images;
        break;
      case 'webp':
        $path = $settings->path_to_webp;
        break;
    }
    if (!empty($path)) {
      if (!JFolder::exists(JPATH_SITE . $path)) {
        JFolder::create(JPATH_SITE . $path);
        $content = '<!DOCTYPE html><title></title>';
        JFile::write(JPATH_SITE . $path . '/index.html', $content);
        echo '<span class="btn-state hasTooltip checkorg" title="' . JText::_('COM_DATSOGALLERY_DIR_NOT_EXISTS') . '"><i class="dgi-delete"></i></span>';
      } elseif (!is_writable(JPATH_SITE . $path)) {
        echo '<span class="btn-state hasTooltip checkorg" title="' . JText::_('COM_DATSOGALLERY_DIR_UNWRITABLE') . '"><i class="dgi-delete"></i></span>';
      } else {
        echo '<span class="btn-state hasTooltip active checkorg" title="' . JText::_('COM_DATSOGALLERY_DIR_EXISTS') . '"><i class="dgi-check-circle"></i></span>';
      }
      if (!JFile::exists(JPATH_SITE . $path) . '/index.html') {
        $content = '<!DOCTYPE html><title></title>';
        JFile::write(JPATH_SITE . $path . '/index.html', $content);
      }
      if ($type == 'originals' && JFolder::exists(JPATH_SITE . $settings->path_to_originals) && strpos($app->input->server->get('SERVER_SOFTWARE'), 'Apache') !== false) {
        if ($files = glob(JPATH_SITE . $settings->path_to_originals . "/.*") and $files = preg_grep('/\.htaccess$/', $files)) {
          echo '<span class="btn-state hasTooltip active checkorg" title="' . JText::_('COM_DATSOGALLERY_DIR_PROTECTED') . '"><i class="dgi-lock"></i></span>';
        } else {
          echo '<span class="btn-state hasTooltip checkorg" title="' . JText::_('COM_DATSOGALLERY_DIR_UNPROTECTED') . '"><i class="dgi-lock-open"></i></span>';
        }
      }
    }
  }

  public static function dgpagenav($id = null)
  {
    $user         = JFactory::getUser();
    $groups       = implode(',', $user->getAuthorisedViewLevels());
    $settings     = self::getConfig();
    $order_method = $settings->category_order;
    switch ($order_method) {
      case 'id':
        $orderby = 'a.id';
        break;

      case 'rid':
        $orderby = 'a.id DESC';
        break;

      case 'alpha':
        $orderby = 'a.title';
        break;

      case 'ralpha':
        $orderby = 'a.title DESC';
        break;

      case 'rhits':
        $orderby = 'a.hits';
        break;

      case 'hits':
        $orderby = 'a.hits DESC';
        break;

      case 'order':
        $orderby = 'a.ordering';
        break;

      case 'rorder':
        $orderby = 'a.ordering DESC';
        break;

      default:
        $orderby = 'a.ordering';
        break;
    }
    $catid    = self::imagecat($id);
    $db       = JFactory::getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $query    = $db->getQuery(true);
    $query->select('a.id');
    $query->from($db->qn('#__datsogallery_images', 'a'));
    $query->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON c.id = a.catid');
    $query->join('LEFT', $db->qn('#__users', 'u') . ' ON u.id = a.created_by');
    $query->where($db->qn('a.catid') . ' = ' . $catid);
    $query->where($db->qn('a.state') . ' = 1');
    $query->where($db->qn('a.approved') . ' = 1');
    $query->where($db->qn('a.access') . ' IN (' . $groups . ')');
    $query->where($db->qn('c.published') . ' = 1');
    $query->where($db->qn('c.approved') . ' = 1');
    $query->where($db->qn('c.access') . ' IN (' . $groups . ')');
    $query->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $query->order($orderby);
    $db->setQuery($query);
    $list = $db->loadObjectList('id');
    if (!is_array($list)) {
      $list = array();
    }
    reset($list);
    $location   = array_search($id, array_keys($list));
    $rows       = array_values($list);
    @$row->prev = null;
    @$row->next = null;
    $nav        = '';
    if ($location - 1 >= 0) {
      $row->prev = $rows[$location - 1];
    }
    if (($location + 1) < count($rows)) {
      $row->next = $rows[$location + 1];
    }
    if ($row->prev) {
      $prev = $settings->image_nav_type_details ? '<i class="dgi-arrow-prev"></i><img class="dg-thumb" src="' . resize(self::imagefromid($row->prev->id), 40, 40, 1, '1:1', 0, $catid) . '" alt="" style="margin-right:-1px">' : '<i class="dgi-arrow-prev"></i>';
      $nav .= '<a class="prev" href="' . JRoute::_('index.php?option=com_datsogallery&amp;view=image&amp;catid=' . $catid . '&amp;id=' . $row->prev->id . self::itemId()) . '" title="' . JText::_('JPREV') . '"><div class="position-left flex flex-middle">' . $prev . '</div></a>';
    }
    if ($row->next) {
      $next = $settings->image_nav_type_details ? '<img class="dg-thumb" src="' . resize(self::imagefromid($row->next->id), 40, 40, 1, '1:1', 0, $catid) . '" alt=""><i class="dgi-arrow-next"></i>' : '<i class="dgi-arrow-next"></i>';
      $nav .= '<a class="next" href="' . JRoute::_('index.php?option=com_datsogallery&amp;view=image&amp;catid=' . $catid . '&amp;id=' . $row->next->id . self::itemId()) . '" title="' . JText::_('JNEXT') . '"><div class="position-right flex flex-middle">' . $next . '</div></a>';
    }
    return $nav;
  }

  public static function getfirstimg($catid = null)
  {
    $settings     = self::getConfig();
    $order_method = $settings->category_order;
    switch ($order_method) {
      case 'id':
        $orderby = 'id';
        $dir     = '';
        break;

      case 'rid':
        $orderby = 'id';
        $dir     = ' DESC';
        break;

      case 'alpha':
        $orderby = 'title';
        $dir     = '';
        break;

      case 'ralpha':
        $orderby = 'title';
        $dir     = ' DESC';
        break;

      case 'rhits':
        $orderby = 'hits';
        $dir     = '';
        break;

      case 'hits':
        $orderby = 'hits';
        $dir     = ' DESC';
        break;

      case 'order':
        $orderby = 'ordering';
        $dir     = '';
        break;

      case 'rorder':
        $orderby = 'ordering';
        $dir     = ' DESC';
        break;

      default:
        $orderby = 'ordering';
        $dir     = '';
        break;
    }
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select(array('id', 'catid', 'title'))
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('catid') . ' = ' . (int) $catid)
      ->order($orderby . $dir);
    $obj = $db->setQuery($query)->loadObject();
    return $obj;
  }

  public static function dgslider($id = null)
  {
    $settings = self::getConfig();
    /*if (!$settings->fancybox_slideshow) {
    return;
    }*/
    $lang         = JFactory::getLanguage();
    $langtag      = JLanguageMultilang::isEnabled() ? '&lang=' . substr($lang->getTag(), 0, 2) : '';
    $catid        = self::imagecat($id);
    $title        = self::imagetitle($id);
    $user         = JFactory::getUser();
    $groups       = implode(',', $user->getAuthorisedViewLevels());
    $order_method = $settings->category_order;
    switch ($order_method) {
      case 'id':
        $orderby = 'a.id';
        $dir     = '';
        break;

      case 'rid':
        $orderby = 'a.id';
        $dir     = ' DESC';
        break;

      case 'alpha':
        $orderby = 'a.title';
        $dir     = '';
        break;

      case 'ralpha':
        $orderby = 'a.title';
        $dir     = ' DESC';
        break;

      case 'rhits':
        $orderby = 'a.hits';
        $dir     = '';
        break;

      case 'hits':
        $orderby = 'a.hits';
        $dir     = ' DESC';
        break;

      case 'order':
        $orderby = 'a.ordering';
        $dir     = '';
        break;

      case 'rorder':
        $orderby = 'a.ordering';
        $dir     = ' DESC';
        break;

      default:
        $orderby = 'a.ordering';
        $dir     = '';
        break;
    }
    $db       = JFactory::getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $q1       = $db->getQuery(true);
    $q1->select(array('a.id', 'a.catid', 'a.title', 'a.description'));
    $q1->from($db->qn('#__datsogallery_images', 'a'));
    $q1->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON c.id = a.catid');
    $q1->join('LEFT', $db->qn('#__users', 'u') . ' ON u.id = a.created_by');
    if (empty($dir)) {
      $q1->where($db->qn($orderby) . ' < ' . $db->q(self::dgorder($id, $orderby)));
    } else {
      $q1->where($db->qn($orderby) . ' > ' . $db->q(self::dgorder($id, $orderby)));
    }
    $q1->where($db->qn('a.catid') . ' = ' . $catid);
    $q1->where($db->qn('a.state') . ' = 1');
    $q1->where($db->qn('a.approved') . ' = 1');
    $q1->where($db->qn('a.access') . ' IN (' . $groups . ')');
    $q1->where($db->qn('c.published') . ' = 1');
    $q1->where($db->qn('c.approved') . ' = 1');
    $q1->where($db->qn('c.access') . ' IN (' . $groups . ')');
    $q1->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $q1->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    $q1->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
    $q1->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    if (JLanguageMultilang::isEnabled()) {
      $q1->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $q1->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $q1->order($orderby . $dir);
    $l1 = $db->setQuery($q1)->loadObjectList();

    $q2 = $db->getQuery(true);
    $q2->select(array('a.id', 'a.catid', 'a.title', 'a.description'));
    $q2->from($db->qn('#__datsogallery_images', 'a'));
    $q2->join('LEFT', $db->qn('#__datsogallery_categories', 'c') . ' ON c.id = a.catid');
    $q2->join('LEFT', $db->qn('#__users', 'u') . ' ON u.id = a.created_by');
    if (empty($dir)) {
      $q2->where($db->qn($orderby) . ' > ' . $db->q(self::dgorder($id, $orderby)));
    } else {
      $q2->where($db->qn($orderby) . ' < ' . $db->q(self::dgorder($id, $orderby)));
    }
    $q2->where($db->qn('a.catid') . ' = ' . $catid);
    $q2->where($db->qn('a.state') . ' = 1');
    $q2->where($db->qn('a.approved') . ' = 1');
    $q2->where($db->qn('a.access') . ' IN (' . $groups . ')');
    $q2->where($db->qn('c.published') . ' = 1');
    $q2->where($db->qn('c.approved') . ' = 1');
    $q2->where($db->qn('c.access') . ' IN (' . $groups . ')');
    $q2->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $q2->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    $q2->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
    $q2->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    if (JLanguageMultilang::isEnabled()) {
      $q2->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $q2->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $q2->order($orderby . $dir);
    $l2    = $db->setQuery($q2)->loadObjectList();
    $array = array();
    $c     = array();
    $p     = array();
    $n     = array();
    $c[]   = array(
      'src' => JUri::root() . 'index.php?option=com_datsogallery' . $langtag . '&task=image.sbox&catid=' . $catid . '&id=' . $id . '&' . JSession::getFormToken() . '=1',
      'opts' => array('caption' => ($settings->fancybox_show_title ? $title : ''))
    );
    if (count($l2) > 0) {
      foreach ($l2 as $image) {
        $p[] = array(
          'src' => JUri::root() . 'index.php?option=com_datsogallery' . $langtag . '&task=image.sbox&catid=' . $image->catid . '&id=' . $image->id . '&' . JSession::getFormToken() . '=1',
          'opts' => array('caption' => ($settings->fancybox_show_title ? $image->title : ''))
        );
      }
    }
    if (count($l1) > 0) {
      foreach ($l1 as $image) {
        $n[] = array(
          'src' => JUri::root() . 'index.php?option=com_datsogallery' . $langtag . '&task=image.sbox&catid=' . $image->catid . '&id=' . $image->id . '&' . JSession::getFormToken() . '=1',
          'opts' => array('caption' => ($settings->fancybox_show_title ? $image->title : ''))
        );
      }
    }
    $array = array_merge($c, $p, $n);
    return json_encode($array);
  }

  public static function dgorder($id, $order = '')
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select($order)
      ->from($db->qn('#__datsogallery_images', 'a'))
      ->where($db->qn('a.id') . ' = ' . (int) $id);
    $foo = $db->setQuery($query)->loadResult();
    return $foo;
  }

  public static function dgmoreless($text, $limit = 0)
  {
    $settings = self::getConfig();
    if ($settings->image_description_html) {
      $dgmoreless = $text;
    } else {
      $text       = strip_tags(trim(html_entity_decode($text, ENT_QUOTES, 'UTF-8'), "\xc2\xa0"));
      $dgmoreless = explode(' ', $text . '</span>');
      $rm         = array();
      foreach ($dgmoreless as $k => $v) {
        $rm[] = $v . ' ';
        if ($limit == $k) {
          $rm[] = '<span class="read-more-content">';
        }
      }
      $dgmoreless = trim(implode('', $rm));
      $dgmoreless = nl2br($dgmoreless);
    }
    return $dgmoreless;
  }

  public static function dgwordlimiter($text, $limit = 0)
  {
    $explode = explode(' ', $text);
    $string  = '';
    $dots    = '...';
    if ($limit != 0) {
      if (count($explode) <= $limit) {
        $dots = '';
      }
      for ($i = 0; $i < $limit; $i++) {
        $string .= @$explode[$i] . ' ';
      }
      return stripslashes(strip_tags($string)) . $dots;
    } else {
      return stripslashes(strip_tags($text));
    }
  }

  public static function dgtitlelimit($str, $chars)
  {
    jimport('joomla.utilities.string');
    if ($chars < 3) {
      $chars = 3;
    }
    if (strlen($str) > $chars) {
      return JString::substr($str, 0, $chars - 3) . '...';
    } else {
      return $str;
    }
  }

  public static function dgwordwrap($str, $width = 100, $break = "\r\n")
  {
    jimport('joomla.utilities.string');
    if (empty($str) || JString::strlen($str) <= $width) {
      return $str;
    }

    $br_width   = JString::strlen($break);
    $str_width  = JString::strlen($str);
    $return     = '';
    $last_space = false;
    for ($i = 0, $count = 0; $i < $str_width; $i++, $count++) {
      if (JString::substr($str, $i, $br_width) == $break) {
        $count = 0;
        $return .= JString::substr($str, $i, $br_width);
        $i += $br_width - 1;
        continue;
      }
      if (JString::substr($str, $i, 1) == " ") {
        $last_space = $i;
      }
      if ($count > $width) {
        if (!$last_space) {
          $return .= $break;
          $count = 0;
        } else {
          $drop = $i - $last_space;
          if ($drop > 0) {
            $return = JString::substr($return, 0, -$drop);
          }
          $return .= $break;
          $i          = $last_space + ($br_width - 1);
          $last_space = false;
          $count      = 0;
        }
      }
      $return .= JString::substr($str, $i, 1);
    }
    return $return;
  }

  public static function br2nl($string)
  {
    return preg_replace('/\<br(\s*)?\/?\>/i', "\n", $string);
  }

  public static function countusercats($user_id)
  {
    $db = JFactory::getDbo();
    $db->setQuery('SELECT COUNT(id) FROM #__datsogallery_categories WHERE created_by = ' . (int) $user_id);
    return $db->loadResult();
  }

  public static function countuserpics($user_id)
  {
    $db = JFactory::getDbo();
    $db->setQuery('SELECT COUNT(id) FROM #__datsogallery_images WHERE created_by = ' . (int) $user_id);
    return $db->loadResult();
  }

  public static function getOptions($cat, $cname, $extras = '', $individual = null)
  {
    $app      = JFactory::getApplication();
    $layout   = $app->input->getCmd('layout');
    $settings = self::getConfig();
    $user     = JFactory::getUser();
    $db       = JFactory::getDbo();
    $query    = $db->getQuery(true);
    //$query->select('node.title as text, node.id as value');
    $query->select('concat(repeat(\'&nbsp;|&ndash; \', count(parent.id) - 2), node.title) as text, node.id as value');
    $query->from('#__datsogallery_categories as node, #__datsogallery_categories as parent');
    $query->where('node.lft between parent.lft and parent.rgt');
    $query->where('node.parent_id > 0');
    $query->where('NOT node.id = 1');
    if ($app->isSite() && $settings->users_categories && !self::is_root()) {
      $query->where('node.created_by = ' . $user->id);
    }
    if ($app->isSite() && !$settings->users_categories && !self::is_root()) {
      $query->where('node.id IN (' . $settings->allowed_categories . ')');
    }
    $query->group('node.id');
    $query->order('node.lft');
    $db->setQuery($query);
    $categories = $db->loadObjectList();
    $options    = array();
    if (count($categories) > 1 || $settings->users_categories) {
      $options[] = JHtml::_('select.option', '', JText::_('COM_DATSOGALLERY_SELECT_CATEGORY'));
      if ($settings->users_categories && $user->id && (self::countusercats($user->id) < ($settings->max_cats_per_member + 1)) && ($layout != 'edit') && $app->isSite() && !$individual) {
        $options[] = JHtml::_('select.option', 'usercat', ' + ' . JText::_('COM_DATSOGALLERY_CREATE_NEW_CATEGORY'));
      }
      foreach ($categories as $category) {
        $options[] = JHtml::_('select.option', $category->value, $category->text, 'value', 'text');
      }
    }
    if (count($categories) == 1 && !$settings->users_categories) {
      foreach ($categories as $category) {
        $options[] = JHtml::_('select.option', $category->value, $category->text, 'value', 'text', 'selected');
      }
    }
    $parlist = self::selectlist($options, $cname, $extras, 'value', 'text', $cat);
    return $parlist;
  }

  public static function categoriestree($cat, $cname, $extras = '', $levellimit = 10)
  {
    $app          = JFactory::getApplication();
    $user         = JFactory::getUser();
    $view         = $app->input->getCmd('view');
    $settings     = self::getConfig();
    $canCreateTop = $user->authorise('core.create.top', 'com_datsogallery');
    $db           = JFactory::getDbo();
    $query        = $db->getQuery(true);
    $query->select('count(*)');
    $query->from($db->quoteName('#__datsogallery_categories'));
    $query->where($db->quoteName('created_by') . ' = ' . $user->id);
    $db->setQuery($query);
    $count = $db->loadResult();
    /*if ($settings->user_categories && $user->id) {
    $where = ' WHERE created_by = '.$user->id;
    }
    else {
    $where = ' WHERE id IN ( '.$ad_category.' )';
    }*/
    //$where1 = (!is_admin() && !$canCreateTop) ? $where : '';
    $query->clear();
    $query->select(array('id, parent_id, title'));
    $query->from($db->quoteName('#__datsogallery_categories'));
    $query->where('not id = 1');
    $query->order($db->quoteName('title'));
    $db->setQuery($query);
    /*$query = 'SELECT id, parent_id, title'.' FROM #__datsogallery_categories WHERE NOT id = 1 ORDER BY title';
    $db->setQuery($query);*/
    $rows     = $db->loadObjectList();
    $children = array();
    asort($children);
    if (count($rows)) {
      foreach ($rows as $row) {
        $parent = $row->parent_id;
        $list   = @$children[$parent] ? $children[$parent] : array();
        array_push($list, $row);
        $children[$parent] = $list;
      }
    }
    /*if ($settings->users_categories) {
    //$root = ($user->id && !is_admin() && !$canCreateTop) ? $ad_category : 0;
    $root = ($user->id && !$canCreateTop) ? $settings->members_category : 0;
    }
    else {*/
    $root = 0;
    //}
    $list      = JHtml::_('menu.treerecurse', $root, '', array(), $children, max(0, $levellimit - 1));
    $items     = array();
    $items[]   = JHtml::_('select.option', '', JText::_('COM_DATSOGALLERY_SELECT_CATEGORY'));
    $canCreate = $user->authorise('core.create', 'com_datsogallery');
    /*if ($settings->users_categories && $user->id && $count < $settings->max_cats_per_member) {
    if ($view != 'editpic') {*/
    $items[] = JHtml::_('select.option', 'usercat', ' + ' . JText::_('COM_DATSOGALLERY_CREATE_NEW_CATEGORY'));
    /*}
    }*/
    foreach ($list as $item) {
      $items[] = JHtml::_('select.option', $item->id, $item->treename);
    }
    $parlist = self::selectlist($items, $cname, $extras, 'value', 'text', $cat);
    return $parlist;
  }

  public static function createalbum()
  {
    $app      = JFactory::getApplication('site');
    $settings = self::getConfig();
    $user     = JFactory::getUser();
    $dtz      = new DateTimeZone(JFactory::getApplication()->getCfg('offset'));
    $date     = new JDate();
    $date->setTimezone($dtz);
    if ($settings->users_categories) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select($db->quoteName('id'));
      $query->from($db->quoteName('#__datsogallery_categories'));
      $query->where($db->quoteName('parent_id') . ' = ' . $settings->members_category);
      $query->where($db->quoteName('created_by') . ' = ' . $user->id);
      $db->setQuery($query);
      if (!$db->loadResult()) {
        $table               = JTable::getInstance('Category', 'DatsogalleryTable');
        $table->parent_id    = $settings->members_category;
        $table->title        = $user->name;
        $table->alias        = self::sanitize($user->name);
        $table->description  = JText::sprintf('COM_DATSOGALLERY_NEW_ALBUM_DESC', $user->name);
        $table->created_by   = $user->id;
        $table->created_time = $date->toSql(true);
        $table->state        = 1;
        if (!$table->check()) {
          $this->setError($table->getError());
          return false;
        }
        if (!$table->store()) {
          $this->setError($table->getError());
          return false;
        }
      }
    }
  }

  public static function selectlist(&$arr, $tag_name, $tag_attribs, $key, $text, $selected)
  {
    reset($arr);
    $html = '<select name="' . $tag_name . '" ' . $tag_attribs . '>';
    for ($i = 0, $n = count($arr); $i < $n; $i++) {
      $k     = $arr[$i]->$key;
      $t     = $arr[$i]->$text;
      $id    = @$arr[$i]->id;
      $extra = '';
      $extra .= $id ? ' id="' . $arr[$i]->id . '"' : '';
      if (is_array($selected)) {
        foreach ($selected as $obj) {
          if ($k == $obj) {
            $extra .= ' selected';
            break;
          }
        }
      } else {
        $extra .= ($k == $selected ? ' selected' : '');
      }
      $html .= '<option value="' . $k . '" ' . $extra . '>' . $t . '</option>';
    }
    $html .= '</select>';
    return $html;
  }

  public static function sanitize($str, $file = false)
  {
    $settings           = self::getConfig();
    $transliterate_from = explode('|', $settings->transliterate_from);
    $transliterate_to   = explode('|', $settings->transliterate_to);
    $transliterate_from = array_map(function ($transliterate_from) {
      return '/' . $transliterate_from . '/';
    }, $transliterate_from);
    $transliterated = preg_replace($transliterate_from, $transliterate_to, $str);
    if ($file) {
      if (in_array($transliterate_from, $transliterate_to, $str)) {
        return strtolower(str_replace(' ', '_', $transliterated));
      } else {
        return false;
      }
    } else {
      $transliterated = JApplication::stringURLSafe($transliterated);
      return $transliterated;
    }
  }

  public static function categoryimage($catid, $order = 'id', $dir = 'ASC')
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('original');
    $query->from('#__datsogallery_images');
    $query->where('catid = ' . (int) $catid);
    $query->where('state = 1');
    $query->order($order . ' ' . $dir);
    $db->setQuery($query);
    $result = $db->loadResult() ? $db->loadResult() : 'no_image.png';
    return $result;
  }

  public static function imagefromid($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('original');
    $query->from('#__datsogallery_images');
    $query->where('id = ' . (int) $id);
    $db->setQuery($query);
    $result = $db->loadResult() ? $db->loadResult() : 'no_image.png';
    return $result;
  }

  public static function catnamebyid($catid)
  {
    $table = JTable::getInstance('Category', 'DatsogalleryTable');
    $table->load($catid);
    $obj        = new stdClass();
    $obj->title = $table->title;
    return $obj->title;
  }

  public static function numimages($catid)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)');
    $query->from('#__datsogallery_images');
    $query->where('catid = ' . (int) $catid);
    $query->where('state = 1');
    $db->setQuery($query);
    $result = $db->loadResult();
    return $result;
  }

  public static function numcomments($id, $num = false)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)');
    $query->from('#__datsogallery_comments');
    $query->where('image_id = ' . (int) $id);
    $query->where('state = 1');
    $db->setQuery($query);
    $result = $db->loadResult();
    return $num ? $result : self::human_number($result);
  }

  public static function numlikes($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('rate = 1')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    $result = $db->loadResult();
    return self::human_number($result);
  }

  public static function numdislikes2($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('rate = 2')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    $result = $db->loadResult();
    return self::human_number($result);
  }

  public static function numdislikes($id)
  {
    $user_ip = self::client_ip();
    $id      = $this->getState('image.id');
    $db      = JFactory::getDbo();
    $query   = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('ip = ' . $db->q($user_ip))
      ->where('rate = 2')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    $result = $db->loadResult();
    return self::human_number($result);
  }

  public static function numlikes2($id)
  {
    $user_ip = self::client_ip();
    $id      = $this->getState('image.id');
    $db      = JFactory::getDbo();
    $query   = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('ip = ' . $db->q($user_ip))
      ->where('rate = 1')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    return $db->loadResult();
  }

  public static function rateall($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    return $db->loadResult();
  }

  public static function likes($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('rate = 1')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    return $db->loadResult();
  }

  public static function dislikes($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')
      ->from('#__datsogallery_likes')
      ->where('rate = 2')
      ->where('image_id = ' . $id);
    $db->setQuery($query);
    return $db->loadResult();
  }

  public static function getparents($catid)
  {
    $app      = JFactory::getApplication();
    $user     = JFactory::getUser();
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    $db       = JFactory::getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $query    = $db->getQuery(true);
    $query->select('c.id');
    $query->from('#__datsogallery_categories AS c');
    $query->join('LEFT', '#__datsogallery_categories AS p ON p.id = ' . (int) $catid);
    //$query->where('c.parent_id > 0');
    if ($app->isSite()) {
      $query->where('c.access IN (' . ($groups) . ')');
      $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
      $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
      $query->where('c.published = 1');
      $query->where('c.approved = 1');
      if (JLanguageMultilang::isEnabled()) {
        $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      }
    }
    $query->where('c.lft BETWEEN p.lft AND p.rgt');
    $query->group('c.id');
    $query->order('c.lft');
    $db->setQuery($query);
    $column = $db->loadColumn();
    return $column;
  }

  public static function category_image($image_id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('original');
    $query->from('#__datsogallery_images');
    $query->where($db->qn('id') . ' = ' . (int) $image_id);
    $db->setQuery($query);
    $image = $db->loadResult();
    return $image;
  }

  public static function numimagesCat($catid)
  {
    $ids      = self::getparents($catid) ? self::getparents($catid) : $catid;
    $app      = JFactory::getApplication();
    $user     = JFactory::getUser();
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    $db       = JFactory::getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $query    = $db->getQuery(true);
    $query->select('a.id');
    $query->from('#__datsogallery_images AS a');
    $query->join('LEFT', '#__datsogallery_categories AS c ON c.id = a.catid');
    if (is_array($ids)) {
      $query->where('a.catid IN (' . implode(',', $ids) . ')');
    } else {
      $query->where('a.catid = ' . $catid);
    }
    if ($app->isSite()) {
      $query->where('a.access IN (' . ($groups) . ')');
      $query->where('a.state = 1');
      $query->where('a.approved = 1');
      $query->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
      $query->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
      if (JLanguageMultilang::isEnabled()) {
        $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
        $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      }
      $query->where('c.access IN (' . ($groups) . ')');
      $query->where('c.published = 1');
      $query->where('c.approved = 1');
      $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
      $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    }
    $db->setQuery($query);
    $result = $db->loadColumn();
    $result = count($result);
    return $result;
  }

  public static function sendmail($recipient = '', $subject = '', $body = '', $mode = 0)
  {
    $mailer = JFactory::getMailer();
    $config = JFactory::getConfig();
    $sender = array(
      $config->get('mailfrom'),
      $config->get('fromname')
    );
    $mailer->setSender($sender);
    $recipient = !empty($recipient) ? $recipient : $config->get('mailfrom');
    $mailer->addRecipient($recipient);
    if ($mode) {
      $mailer->isHTML(true);
    }
    $mailer->setSubject($subject);
    $mailer->setBody($body);
    $mailer->Send();
    return true;
  }

  public function backendRoute($link)
  {
    $app = JFactory::getApplication();
    if ($app->isAdmin()) {
      $site  = rtrim(JUri::root(), '/');
      $route = $site . JRoute::link('site', $link);
      return $route;
    }
  }

  public static function catcover($catid)
  {
    $settings = dg::getConfig();
    $type     = (int) $settings->categories_view_type;
    $order    = $settings->categories_covers_ordering;
    switch ($order) {
      case 'id':
        $orderby = 'a.id ASC';
        break;

      case 'rid':
        $orderby = 'a.id DESC';
        break;

      case 'alpha':
        $orderby = 'a.title ASC';
        break;

      case 'ralpha':
        $orderby = 'a.title DESC';
        break;

      case 'order':
        $orderby = 'a.ordering ASC';
        break;

      case 'rorder':
        $orderby = 'a.ordering DESC';
        break;

      case 'random':
        $orderby = 'RAND()';
        break;

      default:
        $orderby = 'a.ordering ASC';
        break;
    }
    $limit    = in_array($type, array(1,2)) ? ($type == 1 ? 4 : 3) : 1;
    $ids      = self::getparents($catid) ? self::getparents($catid) : $catid;
    $user     = JFactory::getUser();
    $groups   = implode(',', $user->getAuthorisedViewLevels());
    $db       = JFactory::getDbo();
    $nullDate = $db->q($db->getNullDate());
    $date     = JFactory::getDate();
    $nowDate  = $db->q($date->toSql());
    $query    = $db->getQuery(true);
    $query->select('a.original');
    $query->from('#__datsogallery_images AS a');
    $query->join('LEFT', '#__datsogallery_categories AS c ON c.id = a.catid');
    if (is_array($ids)) {
      $query->where('a.catid IN (' . implode(',', $ids) . ')');
    } else {
      $query->where('a.catid = ' . $catid);
    }
    $query->where('a.access IN (' . ($groups) . ')');
    $query->where('a.state = 1');
    $query->where('a.approved = 1');
    $query->where('(' . $db->qn('a.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('a.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('a.publish_down') . ' >= ' . $nowDate . ')');
    $query->where('c.access IN (' . ($groups) . ')');
    $query->where('c.published = 1');
    $query->where('c.approved = 1');
    $query->where('(' . $db->qn('c.publish_up') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_up') . ' <= ' . $nowDate . ')');
    $query->where('(' . $db->qn('c.publish_down') . ' = ' . $nullDate . ' OR ' . $db->qn('c.publish_down') . ' >= ' . $nowDate . ')');
    if (JLanguageMultilang::isEnabled()) {
      $query->where($db->qn('a.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      $query->where($db->qn('c.language') . ' IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
    }
    $query->order($orderby);
    $query->setLimit($limit);
    $db->setQuery($query);
    $result = $db->loadObjectList('original');
    return $result;
  }

  public static function is_disliked($image_id)
  {
    $db      = JFactory::getDbo();
    $user    = JFactory::getUser();
    $user_id = $user->id ? ' OR ' . $db->qn('user_id') . ' = ' . $user->id : '';
    $user_ip = self::client_ip();
    $query   = $db->getQuery(true);
    $query->select('id')
      ->from($db->qn('#__datsogallery_likes'))
      ->where('(' . $db->qn('ip') . ' = ' . $db->q($user_ip) . $user_id . ')')
      ->where($db->qn('rate') . ' = 2')
      ->where($db->qn('image_id') . ' = ' . (int) $image_id);
    $db->setQuery($query);
    $result = $db->loadResult() ? 1 : 0;
    return $result;
  }

  public static function is_liked($image_id)
  {
    $db      = JFactory::getDbo();
    $user    = JFactory::getUser();
    $user_id = $user->id ? ' OR ' . $db->qn('user_id') . ' = ' . $user->id : '';
    $user_ip = self::client_ip();
    $query   = $db->getQuery(true);
    $query->select('id')
      ->from($db->qn('#__datsogallery_likes'))
      ->where('(' . $db->qn('ip') . ' = ' . $db->q($user_ip) . $user_id . ')')
      ->where($db->qn('rate') . ' = 1')
      ->where($db->qn('image_id') . ' = ' . (int) $image_id);
    $db->setQuery($query);
    $result = $db->loadResult() ? 1 : 0;
    return $result;
  }

  public static function userimages()
  {
    $db    = JFactory::getDbo();
    $user  = JFactory::getUser();
    $query = $db->getQuery(true);
    $query->select('COUNT(*)')->from('#__datsogallery_images')->where('created_by = ' . $user->id);
    $db->setQuery($query);
    return $db->loadResult();
  }

  public static function dbtabledata($table)
  {
    $app     = JFactory::getApplication();
    $db_name = $app->get('db');
    $db      = JFactory::getDbo();
    $table   = str_replace('#__', $db->getPrefix(), (string) $table);
    $query   = $db->getQuery(true)
      ->select($db->qn('table_rows') . ' AS `rows`, round(((data_length + index_length) / 1024 / 1024), 2) `size`,' . $db->qn('table_collation') . ' AS `collation`')
      ->from($db->qn('information_schema.tables'))
      ->where($db->qn('table_schema') . ' = ' . $db->q($db_name))
      ->where($db->qn('table_name') . ' = ' . $db->q($table));
    $db->setQuery($query);
    $db->execute();
    return $db->loadObject();
  }

  public static function dg_convert_to_utf8mb4($table)
  {
    $db          = JFactory::getDbo();
    $table       = str_replace('#__', $db->getPrefix(), (string) $table);
    $quotedtable = $db->qn($table);
    $sql         = "SHOW FULL COLUMNS FROM $quotedtable";
    $db->setQuery($sql);
    $columns = $db->loadAssocList();
    if (!$columns) {
      return false;
    }
    foreach ($columns as $column) {
      if ($column->Collation) {
        list($charset) = explode('_', $column->Collation);
        $charset       = strtolower($charset);
        if ('utf8' !== $charset && 'utf8mb4' !== $charset) {
          return false;
        }
      }
    }
    $sql1 = "SHOW TABLE STATUS LIKE '$quotedtable'";
    $db->setQuery($sql1);
    $table_details = $db->loadResult();
    if (!$table_details) {
      return false;
    }
    list($table_charset) = explode('_', $table_details->Collation);
    $table_charset       = strtolower($table_charset);
    if ('utf8mb4' === $table_charset) {
      return true;
    }
    $db->setQuery('ALTER TABLE $quotedtable CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');
    return $db->execute();
  }

  public static function maxuploadsize()
  {
    return min(self::tobytes(ini_get('post_max_size')), self::tobytes(ini_get('upload_max_filesize')));
  }

  public static function mb2kb($size, $unit = 'kb')
  {
    if ($unit == 'mb') {
      $res = $size * 1024;
    } else {
      $res = $size;
    }
    return $res;
  }

  public static function shortitle($str, $chars)
  {
    jimport('joomla.utilities.string');
    if ($chars < 3) {
      $chars = 3;
    }
    if (strlen($str) > $chars) {
      return JString::substr($str, 0, $chars - 3) . ' &hellip;';
    } else {
      return $str;
    }
  }

  public static function jslang($jsFile)
  {
    JHtml::script('media/system/js/core.js', false, true);
    if (isset($jsFile)) {
      $jsFile = JPATH_COMPONENT_SITE . '/assets/js/' . $jsFile;
    } else {
      return false;
    }
    if ($jsContents = file_get_contents($jsFile)) {
      $languageKeys = array();
      preg_match_all('/Joomla\.JText\._\(\"(.*?)\"\)\)?/', $jsContents, $languageKeys);
      $languageKeys = $languageKeys[1];
      foreach ($languageKeys as $lkey) {
        JText::script($lkey, false, false);
      }
    }
  }

  public static function userisonline($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true)
      ->select('*')
      ->from('#__session')
      ->where('client_id = 0')
      ->where('guest = 0')
      ->where('userid = ' . (int) $id);
    $db->setQuery($query);
    if ($db->loadResult()) {
      return '<span class="dg-badge dg-badge-online" title="Online"></span>';
    }

    /*else
  return '<span class="dg-badge dg-badge-offline" title="Offline"></span>';*/
  }

  public static function is_alpha_png($fn)
  {
    $settings = self::getConfig();
    return (ord(@file_get_contents(JPATH_SITE . $settings->path_to_originals . '/' . $fn, null, null, 25, 1)) == 6);
  }

  public static function webpsupport()
  {
    $settings = self::getConfig();
    if (extension_loaded('imagick') && $settings->image_processing == 'im') {
      $im           = new Imagick();
      $webp_support = in_array('WEBP', $im->queryFormats());
    } else {
      $info         = gd_info();
      $webp_support = $info["WebP Support"];
    }
    $browser = self::getBrowserAgentName($_SERVER['HTTP_USER_AGENT']);
    if (($browser == 'Chrome' || $browser == 'Opera' || $browser == 'Firefox' || $browser == 'Edge') && $webp_support) {
      return true;
    }
  }

  public static function is_animated($file, $org = false)
  {
    require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';
    $path = self::getConfig('path_to_originals');
    if (is_ani(JPATH_SITE . $path . '/' . $file)) {
      if ($org) {
        return '<span class="dgi-gif"></span>';
      } else {
        return '<li class="box hint--top-right" data-hint="' . JText::_("COM_DATSOGALLERY_ANIMATED_GIF") . '"><span class="dgi-gif"></span></li>';
      }
    }
  }

  public static function is_anim($file, $catid)
  {
    require_once JPATH_COMPONENT_ADMINISTRATOR . '/images.php';
    $config = self::getConfig();
    if (is_ani(JPATH_SITE . $config->path_to_originals . '/' . $file)) {
      return ' class="dgimg anigif" data-gif-src="' . resize($file,
        $config->image_width_details,
        $config->image_height_details,
        0,
        $config->image_aspect_ratio_details,
        $config->image_watermark,
        $catid,
        '',
        $config->categories_image_quality,
        true
      ) . '"';
    } elseif (self::is_alpha_png($file)) {
      return ' class="dgimg dg-has-alpha"';
    } else {
      return ' class="dgimg"';
    }
  }

  public static function recaptcha($id = 'recaptcha_comments')
  {
    $config = self::getConfig();
    $html   = '';
    if ($config->comments_captcha && in_array($config->comments_captcha_type, array(1,2,3))) {
      $size = in_array((int) $config->comments_captcha_type, array(2,3)) ? 'invisible' : $config->recaptcha_size;
      $doc  = JFactory::getDocument();
      $doc->addScript('//www.google.com/recaptcha/api.js?onload=recaptchaCallback&amp;render=explicit&amp;hl=' . JFactory::getLanguage()->getTag(), 'text/javascript', true, true);
      $execute = in_array((int) $config->comments_captcha_type, array(2,3)) ? 'grecaptcha.execute();' : '';
      $doc->addScriptDeclaration('var recaptchaCallback = function () {
        grecaptcha.render("' . $id . '", {
            sitekey: "' . $config->recaptcha_public_key . '",
            badge: "' . $config->recaptcha_badge . '",
            theme: "' . $config->recaptcha_theme . '",
            size: "' . $size . '"
        });
        ' . $execute . '
      }');
      $html .= '<div id="' . $id . '" data-turbolinks-permanent></div>';
      return $html;
    }
  }

  public static function recaptcha_response()
  {
    $input = JFactory::getApplication()->input;

    $captcha     = $input->getString('g-recaptcha-response', '');
    $private_key = self::getConfig('recaptcha_private_key');
    $remoteip    = IpHelper::getIp();

    $content  = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=" . $private_key . "&response=" . $captcha . "&remoteip=" . $remoteip);
    $response = json_decode($content, true);
    if ($response['success'] == false) {
      return json_encode(implode(',', $response['error-codes']));
    } else {
      return true;
    }
  }

  public static function comment_approval_notify($comment_id)
  {
    $app = JFactory::getApplication();
    $db  = JFactory::getDbo();
    /*$url    = JUri::getInstance();
    $root = $url->toString(array('scheme', 'host', 'port'));*/
    $itemId = self::itemId(true, true);
    $query  = $db->getQuery(true)
      ->select('image_id, user_name, user_email, text')
      ->from($db->qn('#__datsogallery_comments'))
      ->where($db->qn('id') . ' = ' . (int) $comment_id);
    $db->setQuery($query);
    $data = $db->loadObject();

    $db->setQuery('SELECT a.catid, a.title, u.name, u.email' . ' FROM #__datsogallery_images AS a,' . ' #__users AS u' . ' WHERE a.id = ' . $data->image_id . ' AND a.created_by = u.id');
    $row = $db->loadObject();

    $url  = 'index.php?option=com_datsogallery&amp;view=image&amp;catid=' . $row->catid . '&amp;id=' . $data->image_id . $itemId;
    $site = rtrim(JUri::root(), '/');
    $link = $site . JRoute::link('site', $url) . '#comment' . $comment_id;

    $text = sprintf(JText::_('COM_DATSOGALLERY_COMMENT_APPROVAL_NOTIFY_HELLO'), $data->user_name) . "\r\n\r\n";
    $text .= JText::_('COM_DATSOGALLERY_COMMENT_APPROVAL_NOTIFY_TEXT') . "\r\n\r\n---\r\n" . $data->text . "\r\n---\r\n\r\n";
    $text .= $link . "\r\n\r\n";
    $text .= JText::_('COM_DATSOGALLERY_MAIL_MSG');
    $subject = sprintf(JText::_('COM_DATSOGALLERY_COMMENT_APPROVAL_NOTIFY_SUBJECT'), $app->getCfg('sitename'));
    self::sendmail($data->user_email, $subject, self::dgwordwrap($text));
  }

  public static function comment_notify($id, $name, $email, $comment)
  {
    $app    = JFactory::getApplication();
    $db     = JFactory::getDbo();
    $url    = JUri::getInstance();
    $itemId = self::itemId();
    $db->setQuery('SELECT a.catid, a.title, u.name, u.email' . ' FROM #__datsogallery_images AS a,' . ' #__users AS u' . ' WHERE a.id = ' . (int) $id . ' AND a.created_by = u.id');
    $row  = $db->loadObject();
    $root = $url->toString(array('scheme', 'host', 'port'));
    $link = $root . JRoute::_('index.php?option=com_datsogallery&amp;view=image&amp;catid=' . $row->catid . '&amp;id=' . $id . $itemId);
    $text = sprintf(JText::_('COM_DATSOGALLERY_COMMENT_NOTIFY_HELLO'), $row->name) . "\r\n\r\n";
    $text .= sprintf(JText::_('COM_DATSOGALLERY_COMMENT_NOTIFY_USER'), $name, $email, $row->title) . "\r\n\r\n---\r\n" . $comment . "\r\n---\r\n\r\n";
    $text .= $link . "\r\n\r\n";
    $text .= JText::_('COM_DATSOGALLERY_MAIL_MSG');
    $subject = sprintf(JText::_('COM_DATSOGALLERY_COMMENT_NOTIFY_SUBJECT'), $app->getCfg('sitename'));
    self::sendmail($row->email, $subject, self::dgwordwrap($text));
  }

  public static function gravatar($user_id = null, $comment_id = null, $profile = false, $badge = true, $backend = false, $view = '')
  {
    $db = JFactory::getDbo();
    if ($user_id) {
      $query = $db->getQuery(true);
      $query->select($db->qn('email'));
      $query->from($db->qn('#__users'));
      $query->where($db->qn('id') . ' = ' . (int) $user_id);
      $db->setQuery($query);
      $email  = $db->loadResult();
      $avatar = $user_id . '-avatar';
      $img    = self::resolve($avatar);
      $online = $badge ? self::userisonline($user_id) : '';
    }
    if ($comment_id) {
      $query = $db->getQuery(true);
      $query->select($db->qn('user_email'));
      $query->from($db->qn('#__datsogallery_comments'));
      $query->where($db->qn('id') . ' = ' . (int) $comment_id);
      $db->setQuery($query);
      $email = $db->loadResult();
    }
    $position = '';
    if ($view = 'search') {
      $position = '-right';
    }
    $html = '';
    $size = $profile ? 400 : 100;
    if ($user_id && !$profile && !$backend) {
      $html .= '<a href="' . JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $user_id . self::itemId())
      . '" class="hint--bottom' . $position . '" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
    }
    if ($user_id && $img) {
      $html .= '<div style="position:relative">';
      $html .= '<img src="//secure.gravatar.com/avatar/' . md5(strtolower(trim($email))) . '?s=' . $size . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
    } else {
      $html .= '<img src="//secure.gravatar.com/avatar/' . md5(strtolower(trim($email))) . '?s=' . $size . '" class="dg-avatar" alt="" />';
    }
    if ($user_id && !$profile && !$backend) {
      $html .= '</a>';
    }
    return $html;
  }

  public static function resolve($name)
  {
    $info = pathinfo(JPATH_ROOT . '/images/dg_avatars/' . $name);
    if (!empty($info['extension'])) {
      return $name;
    }
    $filename = $info['filename'];
    $len      = strlen($filename);
    $dh       = opendir($info['dirname']);
    if (!$dh) {
      return false;
    }
    while (($file = readdir($dh)) !== false) {
      if (strncmp($file, $filename, $len) === 0) {
        if (strlen($name) > $len) {
          $name = substr($name, 0, strlen($name) - $len) . $file;
        } else {
          $name = $file;
        }
        closedir($dh);
        return $name;
      }
    }
    closedir($dh);
    return false;
  }

  public static function local_avatar($user_id = null, $comment_id = null, $profile = false, $badge = true, $backend = false, $view = '')
  {
    $db = JFactory::getDbo();
    if ($user_id) {
      $query = $db->getQuery(true);
      $query->select($db->qn('email'));
      $query->from($db->qn('#__users'));
      $query->where($db->qn('id') . ' = ' . (int) $user_id);
      $db->setQuery($query);
      $email  = $db->loadResult();
      $avatar = $user_id . '-avatar';
      $img    = self::resolve($avatar);
      $online = $badge ? self::userisonline($user_id) : '';
    }
    if ($comment_id) {
      $query = $db->getQuery(true);
      $query->select($db->qn('user_email'));
      $query->from($db->qn('#__datsogallery_comments'));
      $query->where($db->qn('id') . ' = ' . (int) $comment_id);
      $db->setQuery($query);
      $email = $db->loadResult();
    }
    $position = '';
    if ($view == 'search') {
      $position = 'top-left';
    } else if ($view == 'category') {
      $position = 'bottom-right';
    } else if ($view == 'comments') {
      $position = 'top-right';
    } else {
      $position = 'bottom';
    }
    $html = '';
    if ($user_id && !$profile && !$backend) {
      $html .= '<a href="' . JRoute::_('index.php?option=com_datsogallery&view=member&id=' . $user_id . self::menuid('member'))
      . '" class="hint--' . $position . '" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
    }
    if ($user_id && $img) {
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . 'images/dg_avatars/' . $img . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
    } else {
      $html .= '<img src="' . JUri::root() . 'components/com_datsogallery/assets/images/no_avatar.png" class="dg-avatar" alt="" />';
    }
    if ($user_id && !$profile && !$backend) {
      $html .= '</a>';
    }
    return $html;
  }

  public static function js_avatar($user_id = null, $comment_id = null, $profile = false, $badge = true, $backend = false, $view = '')
  {
    $db     = JFactory::getDbo();
    $app    = JFactory::getApplication('site');
    $menu   = $app->getMenu();
    $ids    = $menu->getItems('link', 'index.php?option=com_community&view=frontpage');
    $itemid = isset($ids[0]) ? '&amp;Itemid=' . (int) $ids[0]->id : '';
    $html   = '';
    $query  = $db->getQuery(true);
    $query->select($db->qn('thumb'));
    $query->from($db->qn('#__community_users'));
    $query->where($db->qn('userid') . ' = ' . (int) $user_id);
    $db->setQuery($query);
    $thumb  = $db->loadResult();
    $online = $badge ? self::userisonline($user_id) : '';
    if ($user_id && $thumb) {
      if (!$backend) {
        $html .= '<a href="' . JRoute::_('index.php?option=com_community&amp;view=profile&amp;userid=' . (int) $user_id . $itemid)
        . '" class="hint--bottom" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
      }
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . $thumb . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
      if (!$backend) {
        $html .= '</a>';
      }
    } elseif ($user_id && !$thumb) {
      $default_thumb = 'components/com_community/assets/user-Male-thumb.png';
      if (!$backend) {
        $html .= '<a href="' . JRoute::_('index.php?option=com_community&amp;view=profile&amp;userid=' . (int) $user_id . $itemid)
        . '" class="hint--bottom" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
      }
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . $default_thumb . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
      if (!$backend) {
        $html .= '</a>';
      }
    } else {
      $default_thumb = 'components/com_community/assets/user-Male-thumb.png';
      $html .= '<img src="' . JUri::root() . $default_thumb . '" class="dg-avatar" alt="" />';
    }
    return $html;
  }

  public static function cb_avatar($user_id = null, $comment_id = null, $profile = false, $badge = true, $backend = false, $view = '')
  {
    $db     = JFactory::getDbo();
    $app    = JFactory::getApplication('site');
    $menu   = $app->getMenu();
    $ids    = $menu->getItems('link', 'index.php?option=com_comprofiler');
    $itemid = isset($ids[0]) ? '&amp;Itemid=' . (int) $ids[0]->id : '';
    $html   = '';
    $query  = $db->getQuery(true);
    $query->select($db->qn('avatar'));
    $query->from($db->qn('#__comprofiler'));
    $query->where($db->qn('user_id') . ' = ' . (int) $user_id);
    $db->setQuery($query);
    $cb_avatar  = $db->loadResult();
    $online     = $badge ? self::userisonline($user_id) : '';
    $default_cb = 'components/com_comprofiler/plugin/templates/default/images/avatar/tnnophoto_n.png';
    if ($user_id && $cb_avatar) {
      if (!$backend) {
        $html .= '<a href="' . JRoute::_('index.php?option=com_comprofiler&amp;view=userprofile&amp;user=' . (int) $user_id . $itemid)
        . '" class="hint--bottom" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
      }
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . 'images/comprofiler/' . $cb_avatar . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
      if (!$backend) {
        $html .= '</a>';
      }
    } elseif ($user_id && !$cb_avatar) {
      if (!$backend) {
        $html .= '<a href="' . JRoute::_('index.php?option=com_comprofiler&amp;view=userprofile&amp;user=' . (int) $user_id . $itemid)
        . '" class="hint--bottom" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
      }
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . $default_cb . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
      if (!$backend) {
        $html .= '</a>';
      }
    } else {
      $html .= '<img src="' . JUri::root() . $default_cb . '" class="dg-avatar" alt="" />';
    }
    return $html;
  }

  public static function kn_avatar($user_id = null, $comment_id = null, $profile = false, $badge = true, $backend = false, $view = '')
  {
    $db     = JFactory::getDbo();
    $app    = JFactory::getApplication('site');
    $menu   = $app->getMenu();
    $ids    = $menu->getItems('link', 'index.php?option=com_comprofiler');
    $itemid = isset($ids[0]) ? '&amp;Itemid=' . (int) $ids[0]->id : '';
    $html   = '';
    $query  = $db->getQuery(true);
    $query->select($db->qn('avatar'));
    $query->from($db->qn('#__kunena_users'));
    $query->where($db->qn('userid') . ' = ' . (int) $user_id);
    $db->setQuery($query);
    $kn_avatar  = $db->loadResult();
    $online     = $badge ? self::userisonline($user_id) : '';
    $default_kn = 'media/kunena/avatars/nophoto.png';
    if ($user_id && $kn_avatar) {
      if (!$backend) {
        $html .= '<a href="' . JRoute::_('index.php?option=com_kunena&amp;view=user&amp;userid=' . (int) $user_id . $itemid)
        . '" class="hint--bottom" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
      }
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . 'media/kunena/avatars/resized/size144/' . $kn_avatar . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
      if (!$backend) {
        $html .= '</a>';
      }
    } elseif ($user_id && !$kn_avatar) {
      if (!$backend) {
        $html .= '<a href="' . JRoute::_('index.php?option=com_kunena&amp;view=user&amp;userid=' . (int) $user_id . $itemid)
        . '" class="hint--bottom" data-hint="' . JText::_("COM_DATSOGALLERY_VISIT_PROFILE") . '">';
      }
      $html .= '<div style="position:relative">';
      $html .= '<img src="' . JUri::root() . $default_kn . '" class="dg-avatar" alt="" />';
      $html .= $online;
      $html .= '</div>';
      if (!$backend) {
        $html .= '</a>';
      }
    } else {
      $html .= '<img src="' . JUri::root() . $default_kn . '" class="dg-avatar" alt="" />';
    }
    return $html;
  }

  public static function avatar($id = null, $comment_id = null, $profile = false, $badge = true, $backend = false, $view = '')
  {
    $config = self::getConfig();
    $app    = JFactory::getApplication('site');
    $menu   = $app->getMenu();
    $db     = JFactory::getDbo();
    $avatar = '';
    // GRAVATAR
    if ($config->avatar_service == 2) {
      $avatar .= self::gravatar($id, $comment_id, $profile, $badge, $backend, $view);
    }
    // JOMSOCIAL
    elseif ($config->avatar_service == 3) {
      $avatar .= self::js_avatar($id, $comment_id, $profile, $badge, $backend, $view);
    }
    // COMMUNITY BUILDER
    elseif ($config->avatar_service == 4) {
      $avatar .= self::cb_avatar($id, $comment_id, $profile, $badge, $backend, $view);
    }
    // KUNENA FORUM
    elseif ($config->avatar_service == 5) {
      $avatar .= self::kn_avatar($id, $comment_id, $profile, $badge, $backend, $view);
    } else {
      $avatar .= self::local_avatar($id, $comment_id, $profile, $badge, $backend, $view);
    }
    return $avatar;
  }

  public static function js_remove_activity($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->delete($db->qn('#__community_activities'));
    $query->where($db->qn('id') . ' = ' . (int) $id);
    $db->setQuery($query);
    $db->execute();
  }

  public static function js_activities($user, $catid, $num)
  {
    $config = self::getConfig();
    if ($config->avatar_service == 3 && $config->js_activities):
      $limit    = ($num < $config->js_limit) ? $num : $config->js_limit;
      $usr      = JFactory::getUser();
      $groups   = implode(',', $usr->getAuthorisedViewLevels());
      $app      = JFactory::getApplication();
      $db       = JFactory::getDbo();
      $nullDate = $db->q($db->getNullDate());
      $date     = new JDate();
      $nowDate  = $db->q($date->toSql());
      $query    = $db->getQuery(true);
      $query->select('a.*, c.title as category_title');
      $query->from('#__datsogallery_images AS a');
      $query->join('LEFT', '#__datsogallery_categories AS c ON c.id = a.catid');
      $query->where('a.catid = ' . (int) $catid);
      $query->where('a.created_by = ' . (int) $user);
      $query->where('a.access IN (' . ($groups) . ')');
      $query->where('a.state = 1');
      $query->where('a.approved = 1');
      if (JLanguageMultilang::isEnabled()) {
        $query->where('a.language IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      }
      $query->where('c.access IN (' . ($groups) . ')');
      $query->where('c.published = 1');
      $query->where('c.approved = 1');
      if (JLanguageMultilang::isEnabled()) {
        $query->where('c.language IN (' . $db->q(JFactory::getLanguage()->getTag()) . ',' . $db->q('*') . ')');
      }
      $query->where('(c.publish_up = ' . $nullDate . ' OR c.publish_up <= ' . $nowDate . ')');
      $query->where('(c.publish_down = ' . $nullDate . ' OR c.publish_down >= ' . $nowDate . ')');
      $query->order('a.id DESC');
      $query->setLimit($limit);
      $db->setQuery($query);
      $rows = $db->loadObjectList();
      if ($rows):
        $count = (count($rows) > 1) ? JText::_('COM_DATSOGALLERY_JSAS_IMAGES') : JText::_('COM_DATSOGALLERY_JSAS_IMAGE');
        foreach ($rows as $row):
          $content[] = $row->id;
        endforeach;
        require_once JPATH_ROOT . '/components/com_community/libraries/core.php';
        $catlink      = '<a href="' . JRoute::_('index.php?option=com_datsogallery&amp;view=category&amp;catid=' . $rows[0]->catid . self::itemId()) . '">' . $rows[0]->category_title . '</a>';
        $act          = new stdClass();
        $act->cmd     = 'datsogallery.upload';
        $act->actor   = (int) $user;
        $act->target  = 0;
        $act->title   = JText::sprintf('COM_DATSOGALLERY_JSAS_ADDED', '{actor}', $count, $catlink);
        $act->content = (string) implode(',', $content);
        $act->app     = 'datsogallery';
        $act->access  = 10; // 10 = Public; 20 = Site members; 30 = Friends Only; 40 = Only Me
        $act->cid     = 0;
        $act->params  = '';
        CFactory::load('libraries', 'activities');
        if (defined('CActivities::COMMENT_SELF')) {
          $act->comment_id   = CActivities::COMMENT_SELF;
          $act->comment_type = 'datsogallery.comment';
        }
        if (defined('CActivities::LIKE_SELF')) {
          $act->like_id   = CActivities::LIKE_SELF;
          $act->like_type = 'datsogallery.like';
        }
        CActivityStream::add($act);
        include_once JPATH_ROOT . '/components/com_community/libraries/userpoints.php';
        CuserPoints::assignPoint('com_datsogallery.upload', (int) $user);
      endif;
    endif;
    return true;
  }

  public static function create_zip($files, $destination = '')
  {
    $config = self::getConfig();
    $dir    = JPATH_SITE . $config->path_to_originals . '/';
    $tmp    = JPATH_SITE . '/tmp/' . JFile::stripExt($destination);
    if (!JFolder::exists($tmp)) {
      JFolder::create($tmp);
    }
    $db  = JFactory::getDbo();
    $zip = new ZipArchive();
    if ($zip->open($tmp . '/' . $destination, ZipArchive::CREATE) === true) {
      foreach ($files as $file) {
        $query = $db->getQuery(true);
        $query->select('title')
          ->from('#__datsogallery_images')
          ->where('original = ' . $db->q($file));
        $db->setQuery($query);
        $title = $db->loadResult();
        $ext   = JFile::getExt($file);
        copy($dir . $file, $tmp . '/' . $title . '.' . $ext);
        $zip->addFile($tmp . '/' . $title . '.' . $ext, $title . '.' . $ext);
        $zip->setCompressionName($title . '.' . $ext, ZipArchive::CM_STORE);
      }
      $zip->close();
      if (file_exists($tmp . '/' . $destination)) {
        $filesize = filesize($tmp . '/' . $destination);
        header('Content-type: application/zip');
        header('Content-Disposition: attachment; filename="' . $destination . '"');
        header('Content-Length: ' . $filesize);
        header('Pragma: no-cache');
        header('Expires: 0');
        ob_clean();
        flush();
        readfile($tmp . '/' . $destination);
        JFolder::delete($tmp);
      }
    } else {
      die('Could not open archive');
    }
  }

  public static function download_zip()
  {
    $app    = JFactory::getApplication();
    $config = self::getConfig();
    $user   = JFactory::getUser();
    if ($user->id && $config->download_favorites):
      $dir = JPATH_SITE . $config->path_to_originals . '/';
      $db  = JFactory::getDbo();
      $db->setQuery('SELECT i.original'
        . ' FROM #__datsogallery_images AS i'
        . ' LEFT JOIN #__datsogallery_favorites AS f ON f.image_id = i.id'
        . ' WHERE f.user_id = ' . (int) $user->id
      );
      $images = $db->loadColumn();
      echo self::create_zip($images, $user->username . '-' . time() . '.zip');
    else:
      $app->enqueueMessage(JText::_('JERROR_LAYOUT_YOU_HAVE_NO_ACCESS_TO_THIS_PAGE'), 'error');
      $app->redirect('index.php', true);
    endif;
  }

  public static function backlink()
  {
    return JText::sprintf('COM_DATSOGALLERY_BACKLINK', '&nbsp;<a class="hint--top hint--small" href="https://www.datso.fr/" data-hint="' . JText::_('COM_DATSOGALLERY_MADE_WITH') . '">Datso<span class="dgi-like"></span>Gallery</a>');
  }

  public static function itemId($main = false, $backend = false)
  {
    if ($backend) {
      $db    = JFactory::getDbo();
      $query = $db->getQuery(true);
      $query->select('id');
      $query->from('#__menu');
      $query->where('link = ' . $db->q('index.php?option=com_datsogallery&view=categories'));
      $db->setQuery($query);
      $itemid = '&Itemid=' . (int) $db->loadResult();
    } else {
      $app    = JFactory::getApplication();
      $menu   = $app->getMenu();
      $active = $menu->getActive();
      if ($active && $app->input->get('option', '', 'cmd') == 'com_datsogallery' && $main == false) {
        $itemid = '&Itemid=' . (int) $active->id;
      } else {
        $ids    = $menu->getItems('link', 'index.php?option=com_datsogallery&view=categories');
        $itemid = isset($ids[0]) ? '&Itemid=' . (int) $ids[0]->id : '';
      }
    }
    return $itemid;
  }

  public static function menuid($element)
  {
    $app    = JFactory::getApplication();
    $menu   = $app->getMenu();
    $languages   = array(JFactory::getLanguage()->getTag(), '*');
    if ((int) $element) {
      if (JLanguageMultilang::isEnabled()) {
        foreach ($languages as $lang) {
          $childs = $menu->getItems(array('link', 'language'), array('index.php?option=com_datsogallery&view=category&catid=' . (int) $element, $lang), false);
        }
      } else {
        $childs = $menu->getItems('link', 'index.php?option=com_datsogallery&view=category&catid=' . (int) $element, true);
      }
      if (isset($childs)) {
        foreach ($childs as $v) {
          $menuid[]    = isset($v->id) ? $v->id : null;
          $menucatid[] = isset($v->query['catid']) ? $v->query['catid'] : null;
        }
      }
    }
    else {
      $item = $menu->getItems('link', 'index.php?option=com_datsogallery&view='.$element, true);
    }
    if (isset($menuid) && isset($menucatid)) {
      $index  = array_search($element, $menucatid);
      $itemid = '&Itemid=' . $menuid[$index];
    } elseif (isset($item->id)) {
      $itemid = '&Itemid=' . $item->id;
    } else {
      $main    = $menu->getItems('link', 'index.php?option=com_datsogallery&view=categories', true);
      $itemid = isset($main->id) ? '&Itemid=' . $main->id : '';
    }
    return $itemid;
  }

  public static function convert($size)
  {
    $unit = array(
      JText::_('COM_DATSOGALLERY_SIZES_BYTES'),
      JText::_('COM_DATSOGALLERY_SIZES_KB'),
      JText::_('COM_DATSOGALLERY_SIZES_MB'),
      JText::_('COM_DATSOGALLERY_SIZES_GB'),
      JText::_('COM_DATSOGALLERY_SIZES_TB')
    );
    return @round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . ' ' . $unit[$i];
  }

  public static function bytesto($size)
  {
    $unit = array('B', 'K', 'M', 'G', 'T');
    return @round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . $unit[$i];
  }

  public static function tobytes($val)
  {
    $val  = trim($val);
    $last = strtolower($val[strlen($val) - 1]);
    $val  = substr($val, 0, -1);
    switch ($last) {
      case 'g':
        $val *= 1024;
      case 'm':
        $val *= 1024;
      case 'k':
        $val *= 1024;
    }
    return $val;
  }

  public static function dirsize($dir)
  {
    $dir = JPATH_SITE . $dir;
    if (JFolder::exists($dir)) {
      $size = 0;
      foreach (new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir)) as $file) {
        $size += $file->getSize();
      }
      return dg::convert($size);
    }
  }

  public static function checkmem($fn, $tx, $ty, $rm = false, $gd = 2)
  {
    list($width, $height) = @getimagesize($fn);
    $ml                   = (int) self::tobytes(ini_get('memory_limit'));
    $sb                   = ceil((($width * $height) * 3) * $gd);
    $tb                   = ceil((($tx * $ty) * 3) * $gd);
    $tr                   = $sb + $tb + memory_get_usage(false);
    if ($rm) {
      return '<strong>' . self::convert($sb + $tb + (50 * 1024) * 1024) . '</strong>';
    }
    if ($tr > $ml) {
      $pt = $tr + (50 * 1024) * 1024;
      ini_set('memory_limit', self::bytesto($pt));
      $nl = (int) self::tobytes(ini_get('memory_limit'));
      $ok = $nl > $tr ? true : false;
      if ($ok) {
        return true;
      } else {
        return false;
      }
    }
  }

  public static function imageobject($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('id, catid, original')
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('id') . ' = ' . (int) $id);
    $db->setQuery($query);
    return $db->loadObject();
  }

  public static function savepalette($file, $id, $catid)
  {
    $config = self::getConfig();
    $db     = JFactory::getDbo();
    $query  = $db->getQuery(true);
    $query->select('hex')
      ->from($db->qn('#__datsogallery_colors'))
      ->where($db->qn('image_id') . ' = ' . (int) $id);
    $db->setQuery($query)->execute();
    $num_rows = $db->getNumRows();
    if ($num_rows != $config->color_number) {
      $query->clear()
        ->delete($db->qn('#__datsogallery_colors'))
        ->where($db->qn('image_id') . ' = ' . (int) $id);
      $db->setQuery($query)->execute();
    } elseif ($db->loadResult()) {
      return false;
    }
    resize($file,
      $config->image_width_details,
      $config->image_height_details,
      $config->image_resize_method_details,
      $config->image_aspect_ratio_details,
      $config->image_watermark,
      $catid,
      '',
      $config->image_quality_details,
      false,
      $config->image_watermark_position,
      true);
    $colors = array();
    $colors = self::palette(
      getCacheFile($file,
        $config->image_width_details,
        $config->image_height_details,
        $catid,
        $config->image_aspect_ratio_details, true), $config->color_number, 10);
    foreach ($colors as $hex) {
      $table           = JTable::getInstance('Color', 'DatsogalleryTable');
      $table->image_id = $id;
      $table->hex      = $hex;
      if (!$table->store()) {
        $this->setError($table->getError());
        return false;
      }
    }
    return true;
  }

  public static function palette($file, $number, $granularity = 5)
  {
    $size = @getimagesize($file);
    if ($size === false) {
      throw new Exception('Unable to get image size data');
    }
    $settings = self::getConfig();
    if ($settings->image_processing == 'im') {
      $image = new Imagick($file);
      $image->thumbnailImage($number, 0);
      $image->posterizeImage(16, true);
      $pixels  = $image->getImageHistogram();
      $palette = array();
      foreach ($pixels as $p) {
        $colors = $p->getColor();
        $rgba   = 'rgba(' . implode(',', $colors) . ')';
        $hex    = self::rgb_to_hex($rgba);
        $alpha  = array_pop($colors);
        if ($alpha > 0) {
          $palette[$hex] = $p->getColorCount();
        }
      }
      arsort($palette);
      return array_slice(array_keys($palette), 0, $number);
    } else {
      $granularity = max(1, abs((int) $granularity));
      $colors      = array();
      $types       = array(1 => 'gif', 'jpeg', 'png', 'webp', 'bmp');
      $image       = @call_user_func('imagecreatefrom' . $types[$size[2]], $file);
      for ($x = 0; $x < $size[0]; $x += $granularity) {
        for ($y = 0; $y < $size[1]; $y += $granularity) {
          $color = imagecolorat($image, $x, $y);
          $rgb   = imagecolorsforindex($image, @$color);
          $red   = round(round(($rgb['red'] / 0x33)) * 0x33);
          $green = round(round(($rgb['green'] / 0x33)) * 0x33);
          $blue  = round(round(($rgb['blue'] / 0x33)) * 0x33);
          $rgb   = sprintf('%02X%02X%02X', $red, $green, $blue);
          if (array_key_exists($rgb, $colors)) {
            $colors[$rgb]++;
          } else {
            $colors[$rgb] = 1;
          }
        }
      }
      arsort($colors);
      return array_slice(array_keys($colors), 0, $number);
    }
  }

  public static function rgb_to_hex(string $rgba)
  {
    if (strpos($rgba, '#') === 0) {
      return $rgba;
    }
    preg_match('/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i', $rgba, $by_color);
    return sprintf('%02x%02x%02x', @$by_color[1], @$by_color[2], @$by_color[3]);
  }

  public static function sort_hex_colors($colors)
  {
    $map = array(
      '0' => 0,
      '1' => 1,
      '2' => 2,
      '3' => 3,
      '4' => 4,
      '5' => 5,
      '6' => 6,
      '7' => 7,
      '8' => 8,
      '9' => 9,
      'a' => 10,
      'b' => 11,
      'c' => 12,
      'd' => 13,
      'e' => 14,
      'f' => 15,
    );
    $c      = 0;
    $sorted = array();
    foreach ($colors as $color) {
      $color = strtolower($color);
      if (strlen($color) == 6) {
        $condensed = '';
        $i         = 0;
        foreach (preg_split('//', $color, -1, PREG_SPLIT_NO_EMPTY) as $char) {
          if ($i % 2 == 0) {
            $condensed .= $char;
          }
          $i++;
        }
        $color_str = $condensed;
      }
      $value = 0;
      foreach (preg_split('//', $color_str, -1, PREG_SPLIT_NO_EMPTY) as $char) {
        $value += intval($map[$char]);
      }
      $value                     = str_pad($value, 5, '0', STR_PAD_LEFT);
      $sorted['_' . $value . $c] = strtoupper($color);
      $c++;
    }
    ksort($sorted);
    return $sorted;
  }

  public static function canEditComment($id)
  {
    $user     = JFactory::getUser();
    $settings = self::getConfig();
    $ip       = self::getIpAddress();
    $db       = JFactory::getDbo();
    $query    = $db->getQuery(true);
    $query->select('id');
    $query->from($db->qn('#__datsogallery_comments'));
    $query->where($db->qn('id') . ' = ' . (int) $id);
    if ($user->id) {
      $query->where($db->qn('created_by') . ' = ' . (int) $user->id);
    } else {
      $query->where($db->qn('user_ip') . ' = ' . $db->q($ip));
    }
    $db->setQuery($query);
    if ($db->loadResult()) {
      return true;
    }
  }

  public static function candeletecomment($id)
  {
    $user     = JFactory::getUser();
    $settings = self::getConfig();
    $ip       = self::getIpAddress();
    $db       = JFactory::getDbo();
    $query    = $db->getQuery(true);
    $query->select('id');
    $query->from($db->qn('#__datsogallery_comments'));
    $query->where($db->qn('id') . ' = ' . (int) $id);
    if ($user->id) {
      $query->where($db->qn('created_by') . ' = ' . (int) $user->id);
    } else {
      $query->where($db->qn('user_ip') . ' = ' . $db->q($ip));
    }
    $db->setQuery($query);
    if ($db->loadResult()) {
      return true;
    }
  }

  public static function getBrowserAgentName($user_agent)
  {
    if (strpos($user_agent, 'Opera') || strpos($user_agent, 'OPR/')) {
      return 'Opera';
    } elseif (strpos($user_agent, 'Edge')) {
      return 'Edge';
    } elseif (strpos($user_agent, 'Chrome')) {
      return 'Chrome';
    } elseif (strpos($user_agent, 'Safari')) {
      return 'Safari';
    } elseif (strpos($user_agent, 'Firefox')) {
      return 'Firefox';
    } elseif (strpos($user_agent, 'MSIE') || strpos($user_agent, 'Trident/7')) {
      return 'Internet Explorer';
    }

    return 'Other';
  }

  public static function username($id)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('user_name, created_by');
    $query->from($db->qn('#__datsogallery_comments'));
    $query->where($db->qn('id') . ' = ' . (int) $id);
    $db->setQuery($query);
    $obj = $db->loadObject();
    return $obj->created_by ? JFactory::getUser($obj->created_by)->get('name') : $obj->user_name;
  }

  public static function nestedcomments($parent, $comments, $image_owner = 0, $is_rtl = 0, $created_by = 0, $return = '')
  {
    $user     = JFactory::getUser();
    $settings = self::getConfig();
    $html     = '';
    foreach ($comments as $nested) {
      if ($parent == $nested->parent_id) {
        $can_edit   = self::canEditComment($nested->id);
        $can_delete = self::candeletecomment($nested->id);
        $liked      = self::is_likedcomment($nested->id);
        $likes      = self::commentlikes($nested->id);
        $is_liked   = $liked ? ' liked' : '';
        $liked_icon = $is_liked ? 'like' : 'likes';
        $like_hint  = $liked ? JText::_("COM_DATSOGALLERY_ALREADY_LIKED") : JText::_("COM_DATSOGALLERY_LIKE");
        $html .= '<li id="' . $nested->id . '" class="dg-comment-container">';
        $html .= '  <ul>';
        if ($settings->allow_avatar && $settings->comments_avatar) {
          $html .= '    <li class="dg-comment-avatar">';
          $html .= self::avatar($nested->created_by, $nested->id, false, true, false, 'comments');
          $html .= '    </li>';
        }
        $html .= '    <li>';
        $html .= '      <ul class="dg-comment-top">';
        $html .= '        <li>';
        $html .= '          <ul class="dg-comment-user-data">';
        $html .= '            <li class="dg-comment-user-name">';
        $html .= ($nested->created_by ? JFactory::getUser($nested->created_by)->get('name') : $nested->user_name);
        $html .= $nested->created_by == (int) $image_owner ? ' <span title="' . JText::_('COM_DATSOGALLERY_IMAGE_DATA_AUTHOR') . '"></span>' : '';
        $html .= '            </li>';
        $html .= '            <li>&bull;</li>';
        $html .= '            <li class="dg-comment-date">';
        $html .= self::timelapse($nested->date, $settings->comments_date_format);
        $html .= '            </li>';
        $html .= '          </ul>';
        $html .= '        </li>';
        $html .= '        <li>';
        $html .= '          <ul class="dg-comment-user-actions">';
        $html .= '            <li>';
        $html .= '              <ul class="dg-comment-action-like">';
        $html .= '                <li class="hint--top hint--small" data-hint="' . $like_hint . '">';
        $html .= '                  <i class="dgi-' . $liked_icon . '"></i>';
        $html .= '                </li>';
        $html .= '                <li>';
        $html .= $likes;
        $html .= '                </li>';
        $html .= '              </ul>';
        $html .= '            </li>';
        if (self::canreply($nested->id)) {
          $html .= '            <li id="' . $nested->id . '" class="dg-comment-reply' . (!$user->id ? ' is_guest' : '') . ' hint--top-left" data-hint="' . JText::_('COM_DATSOGALLERY_REPLY') . '">';
          $html .= '              <ul class="dg-comment-action-reply">';
          $html .= '                <li>';
          $html .= '                  <i class="dgi-reply"></i>';
          $html .= '                </li>';
          $html .= '                <li>';
          $html .= JText::_('COM_DATSOGALLERY_REPLY');
          $html .= '                </li>';
          $html .= '              </ul>';
          $html .= '            </li>';
        }
        $html .= '            <li>';
        $html .= '              <ul class="dg-comment-action-copy">';
        $html .= '                <li class="hint--top-left hint--small copylink" data-hint="' . JText::_('COM_DATSOGALLERY_COPYLINK') . '">';
        $html .= '                  <i class="dgi-link"></i>';
        $html .= '                  <input class="linktocopy" type="text" value="' . $return . '#comment' . $nested->id . '" />';
        $html .= '                </li>';
        $html .= '              </ul>';
        $html .= '            </li>';
        if (in_array(1, array($can_edit, $can_delete))) {
          $html .= '            <li class="dg-drop-menu">';
          $html .= '              <ul>';
          if ($can_edit) {
            $html .= '                <li id="dgcomment' . $nested->id . '" class="dg-comment-edit">';
            $html .= '                  <ul>';
            $html .= '                    <li>';
            $html .= '                      <i class="dgi-edit"></i>';
            $html .= '                    </li>';
            $html .= '                    <li>';
            $html .= JText::_('JACTION_EDIT');
            $html .= '                    </li>';
            $html .= '                  </ul>';
            $html .= '                </li>';
          }
          if ($can_delete) {
            $html .= '                <li id="' . $nested->id . '" class="dg-comment-delete">';
            $html .= '                  <ul>';
            $html .= '                    <li>';
            $html .= '                      <i class="dgi-delete"></i>';
            $html .= '                    </li>';
            $html .= '                    <li>';
            $html .= JText::_('JACTION_DELETE');
            $html .= '                    </li>';
            $html .= '                  </ul>';
            $html .= '                </li>';
          }
          $html .= '              </ul>';
          $html .= '              <a class="dg-toggle-menu">';
          $html .= '                <i class="dgi-more-horiz"></i>';
          $html .= '              </a>';
          $html .= '            </li>';
        }
        $html .= '          </ul>';
        $html .= '        </li>';
        $html .= '      </ul>';
        $html .= '      <ul>';
        $html .= '        <li class="dg-comment-box id-' . $nested->id . '' . ($nested->created_by == (int) $image_owner ? ' dg-is-author' : '') . '">';
        $html .= '          <span class="reply-to-name">@' . self::username($nested->parent_id) . '</span>';
        $html .= '          <span id="' . $nested->id . '" class="editable" data-activator="#dgcomment' . $nested->id . '">';
        $html .= nl2br($nested->text);
        $html .= '          </span>';
        $html .= '        </li>';
        $html .= '        <li class="dg-insert"></li>';
        $html .= '      </ul>';
        $html .= '    </li>';
        $html .= '  </ul>';
        $html .= '</li>';
        $html .= self::nestedcomments($nested->id, $comments, $image_owner, $is_rtl);
      }
    }
    return $html;
  }

  public static function commentlikes($comment_id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('count(*)')
      ->from('#__datsogallery_comment_likes')
      ->where('comment_id = ' . (int) $comment_id);
    $db->setQuery($query);
    $result = $db->loadResult();
    if (!$result) {
      return '0';
    } else {
      return $result;
    }
  }

  public static function is_likedcomment($comment_id = null)
  {
    $user    = JFactory::getUser();
    $user_ip = dg::client_ip();
    $db      = JFactory::getDbo();
    $query   = $db->getQuery(true);
    $query->select('id');
    $query->from('#__datsogallery_comment_likes');
    if ($user->id) {
      $query->where('user_id = ' . $user->id);
    } else {
      $query->where('ip = ' . $db->q($user_ip));
    }
    $query->where('comment_id = ' . (int) $comment_id);
    $db->setQuery($query);
    if (!$db->loadResult()) {
      return false;
    }
    return true;
  }

  public static function userstats($id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('count(distinct i.id) as ci, count(distinct c.id) as cc, count(distinct m.id) as cm, count(distinct l.id) as cl, sum(i.hits) as ch, sum(i.downloads) as cd')
      ->from($db->qn('#__users') . ' as u')
      ->join('LEFT OUTER', $db->qn('#__datsogallery_images') . ' i on i.created_by = u.id')
      ->join('LEFT OUTER', $db->qn('#__datsogallery_categories') . ' c on c.created_by = u.id')
      ->join('LEFT OUTER', $db->qn('#__datsogallery_comments') . ' m on m.created_by = u.id')
      ->join('LEFT OUTER', $db->qn('#__datsogallery_likes') . ' l on l.user_id = u.id')
      ->where('u.id = ' . (int) $id);
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  public static function userimageslikes($id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('count(l.id)')
      ->from($db->qn('#__datsogallery_likes', 'l'))
      ->join('LEFT OUTER', $db->qn('#__datsogallery_images', 'i') . ' on i.id = l.image_id')
      ->where($db->qn('i.created_by') . ' = ' . (int) $id);
    $db->setQuery($query);
    return self::human_number($db->loadResult());
  }

  public static function userimagescomments($id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('count(c.id)')
      ->from($db->qn('#__datsogallery_comments', 'c'))
      ->join('LEFT OUTER', $db->qn('#__datsogallery_images', 'i') . ' on i.id = c.image_id')
      ->where($db->qn('i.created_by') . ' = ' . (int) $id);
    $db->setQuery($query);
    return self::human_number($db->loadResult());
  }

  public static function userimagesdownloads($id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('sum(downloads)')
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('created_by') . ' = ' . (int) $id);
    $db->setQuery($query);
    return self::human_number($db->loadResult());
  }

  public static function userimagesviews($id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query->select('sum(hits)')
      ->from($db->qn('#__datsogallery_images'))
      ->where($db->qn('created_by') . ' = ' . (int) $id);
    $db->setQuery($query);
    return self::human_number($db->loadResult());
  }

  public static function useruploadactivities($user_id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($db->qn('created')),
            $query->q('-'),
            $query->month($db->qn('created')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_images'));
    if ($user_id) {
      $query->where($db->qn('created_by') . ' = ' . (int) $user_id);
    }
    $query->group($db->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  public static function usercategoriesactivities($user_id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($db->qn('created_time')),
            $query->q('-'),
            $query->month($db->qn('created_time')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_categories'));
    if ($user_id) {
      $query->where($db->qn('created_by') . ' = ' . (int) $user_id);
    }
    $query->group($db->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  public static function usercommentsactivities($user_id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($db->qn('date')),
            $query->q('-'),
            $query->month($db->qn('date')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_comments'));
    if ($user_id) {
      $query->where($db->qn('created_by') . ' = ' . (int) $user_id);
    }
    $query->group($db->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  public static function userlikesactivities($user_id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($db->qn('rated_on')),
            $query->q('-'),
            $query->month($db->qn('rated_on')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_likes'));
    if ($user_id) {
      $query->where($db->qn('user_id') . ' = ' . (int) $user_id);
    }
    $query->group($db->qn('m'))
      ->order($db->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  public static function usertagsactivities($user_id = null)
  {
    $db    = JFactory::getDbo();
    $query = $db->getQuery(true);
    $query
      ->select('MONTH(' .
        $query->concatenate(
          array(
            $query->year($db->qn('created')),
            $query->q('-'),
            $query->month($db->qn('created')),
            $query->q('-01')
          )
        ) . ') as m'
      )
      ->select('COUNT(*) as c')
      ->from($query->qn('#__datsogallery_tags'));
    if ($user_id) {
      $query->where($db->qn('user_id') . ' = ' . (int) $user_id);
    }
    $query->group($query->qn('m'))
      ->order($query->qn('m') . ' desc');
    $db->setQuery($query);
    //echo '<pre>'.$db->replacePrefix((string) $query).'</pre>';
    return $db->loadObjectList();
  }

  public static function combomonths($array)
  {
    $n = date('n');
    for ($i = $n; $i > ($n - 12); $i--) {
      if ($i < 1) {
        $cmn          = $i + 12;
        $months[$cmn] = '0';
      } else {
        $months[$i] = '0';
      }
    }
    foreach ($array as $a) {
      if ($a->m == 0) {
        continue;
      }

      $months[$a->m] = $a->c;
    }
    return json_encode(array_reverse($months), JSON_NUMERIC_CHECK);
  }

  public static function months()
  {
    for ($i = 0; $i <= 11; $i++) {
      $months[$i] = JText::_('COM_DATSOGALLERY_' . strtoupper(date('F', strtotime(date('Y-m-01') . " -$i months")))) . ' ' . date('Y', strtotime(date('Y-m-01') . " -$i months"));
    }
    return json_encode(array_reverse($months));
  }

  public static function is_blocked()
  {
    $db      = JFactory::getDbo();
    $ip      = self::getIpAddress();
    $user    = JFactory::getUser();
    $user_id = $user->id ? ' OR ' . $db->qn('created_by') . ' = ' . $user->id : '';
    $query   = $db->getQuery(true);
    $query->select('id')
      ->from($db->qn('#__datsogallery_blacklist'))
      ->where('(' . $db->qn('ip') . ' = ' . $db->q($ip) . $user_id . ')')
      ->where($db->qn('state') . ' = 1');
    $db->setQuery($query);
    return $db->loadResult();
  }

  public static function canreply($id = null)
  {
    $user    = JFactory::getUser();
    $user_ip = IpHelper::getIp();
    $db      = JFactory::getDbo();
    $query   = $db->getQuery(true);
    $query->select('id');
    $query->from('#__datsogallery_comments');
    if ($user->id) {
      $query->where($query->qn('created_by') . ' = ' . $user->id);
    } else {
      $query->where($query->qn('user_ip') . ' = ' . $db->q($user_ip));
    }
    $query->where($query->qn('id') . ' = ' . (int) $id);
    $db->setQuery($query);
    if (!$db->loadResult() && !self::is_blocked()) {
      return true;
    }
    return false;
  }

  public static function version()
  {
    $xml = simplexml_load_file(JPATH_COMPONENT_ADMINISTRATOR . '/datsogallery.xml');
    return (string) $xml->version;
  }

  public static function falang_involved($location = '')
  {
    if ($location == 'admin') {
      if (file_exists(JPATH_ADMINISTRATOR . '/components/com_falang/version.php')) {
        return true;
      }
    } else {
      $db = JFactory::getDbo();
      return is_a($db, 'JFalangDatabase');
    }
  }
}
