<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryConfig {
  
	protected $config;
	protected $db;

	public function __construct() {
		$this->db = JFactory::getDbo();
		$this->load();
	}

	public function get($key, $default = false, $explode = false ) {
			if (isset($this->config->$key)) {
				return $explode ? $this->explode($this->config->$key) : $this->config->$key;
			}
			return $default;
	}

	public function getKeys() {
		return array_keys((array) $this->config);
	}

	public function getData() {
		return $this->config;
	}

	public function reload() {
		$this->load();
	}

	protected function load() {
		$this->config = new stdClass();
		$query = $this->db->getQuery(true);
		$query->select('*')->from('#__datsogallery_settings');
		$this->db->setQuery($query);
		if ($results = $this->db->loadObjectList()) {
			foreach ($results as $result) {
				$this->config->{$result->name} = $result->value;
			}
		}
	}

	protected function explode($string) {
		$string = str_replace(array("\r\n", "\r"), "\n", $string);
		return explode("\n", $string);
	}

	protected function implode($string) {
		return implode("\n", $string);
	}

	protected function convert($key, &$value) {
		if (is_array($value)) {
			$value = implode(",", $value);
		}
	}

	public function set($key, $value) {
		if (isset($this->config->$key)) {
			$this->convert($key, $value);
			$this->config->$key = $value;
			$query = $this->db->getQuery(true);
			$query->update('#__datsogallery_settings')
            ->set($this->db->qn('value').'='.$this->db->q($value))
            ->where($this->db->qn('name').'='.$this->db->q($key));
			$this->db->setQuery($query);
			return $this->db->execute();
		}
		else {
			$new_record = new stdClass();
			$new_record->name = $key;
			$new_record->value = $value;
			$this->db->insertObject('#__datsogallery_settings', $new_record);
		}
		return false;
	}

	public static function getInstance() {
		static $inst;
		if (!$inst)
			$inst = new DatsogalleryConfig;
		return $inst;
	}

}