<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;

class DatsogalleryControllerDatsogallery extends JControllerAdmin {

	public function __construct($config = array()) {
		parent::__construct($config);
	}

	public function getImageModel($name = 'Image', $prefix = 'DatsogalleryModel', $config = array('ignore_request' => true)) {
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}

	public function puplishAjax() {
		$app = JFactory::getApplication();
		$input = $app->input;
		$pks = $input->post->get('id', array(), 'array');
		JArrayHelper::toInteger($pks);
		$model = $this->getImageModel();
		$return = $model->publish($pks, 1);
		if ($return) {
			$app->enqueueMessage('Image published', 'success');
			$data = 1;
		}
		else {
			$app->enqueueMessage('Error', 'error');
			$data = 0;
		}
		echo new JResponseJson($data);
		JFactory::getApplication()->close();
	}

}