<?php
/**
* @package    com_datsogallery
* @author     Andrey Datso <support@datso.fr>
* @copyright  (c) 2006 - 2020 Andrey Datso. All rights reserved.
* @license    GNU General Public License version 2 or later; see LICENSE.txt
*/
defined('_JEXEC') or die;
jimport('joomla.application.component.controllerform');

class DatsogalleryControllerBlacklist extends JControllerForm {

	function __construct() {
		$this->view_list = 'blacklists';
		parent::__construct();
	}

	public function block() {
	  $app = JFactory::getApplication();
		$input = $app->input;
		$ip = $input->getString('ip', '');
		$user_id = $input->getInt('user_id', 0);
		$model = $this->getModel();
    if (!$model->blockuser($ip, $user_id)) {
      $this->setMessage($model->getError(), 'error');
    }
		$this->setRedirect('index.php?option=com_datsogallery&view=comments', JText::_('COM_DATSOGALLERY_COMMENTS_USER_BLOCKED'));
	}

}